/*
 * Decompiled with CFR 0.152.
 */
package fr.esrf.tango.pogo.generator;

import com.google.inject.Provides;
import fr.esrf.tango.pogo.generator.PogoDslGenerator;
import fr.esrf.tango.pogo.generator.common.StringUtils;
import fr.esrf.tango.pogo.generator.pr.PogoPR;
import java.net.URI;
import java.util.ArrayList;
import net.danieldietrich.protectedregions.core.IRegionParser;
import net.danieldietrich.protectedregions.core.RegionParserBuilder;
import net.danieldietrich.protectedregions.core.RegionParserFactory;
import net.danieldietrich.protectedregions.support.IPathFilter;
import net.danieldietrich.protectedregions.support.ProtectedRegionSupport;
import net.danieldietrich.protectedregions.xtext.BidiJavaIoFileSystemAccess;
import org.eclipse.xtext.generator.IGenerator;
import org.eclipse.xtext.generator.JavaIoFileSystemAccess;
import org.eclipse.xtext.service.AbstractGenericModule;

public class PogoGeneratorModule
extends AbstractGenericModule {
    public Class<? extends IGenerator> bindIGenerator() {
        return PogoDslGenerator.class;
    }

    @Provides
    public JavaIoFileSystemAccess createJavaIoFileSystemAccess(ProtectedRegionSupport support) {
        support.addParser(RegionParserFactory.createJavaParser(new PogoPR(), false), ".java", ".cpp", ".h", ".html");
        support.addParser(RegionParserFactory.createXmlParser(), ".xml", ".xsd");
        support.addParser(this.createPythonParser(), ".py");
        BidiJavaIoFileSystemAccess fsa = new BidiJavaIoFileSystemAccess(support);
        if (System.getProperty("targetDir") != null) {
            fsa.setFilter(new pogoPathFilter());
        }
        return fsa;
    }

    private IRegionParser createPythonParser() {
        IRegionParser parser = new RegionParserBuilder().name("python").addComment("#").ignoreCData('\"', '\\').ignoreCData('\'', '\\').setInverse(false).useOracle(new PogoPR()).build();
        return parser;
    }

    private class pogoPathFilter
    implements IPathFilter {
        private ArrayList<String> generatedFiles = new ArrayList();
        private boolean isWindows;

        pogoPathFilter() {
            String os = System.getProperty("os.name");
            this.isWindows = os.toLowerCase().startsWith("windows");
            String targetDir = System.getProperty("targetDir");
            String className = System.getProperty("className");
            String language = System.getProperty("targetLanguage");
            if (this.isWindows) {
                int end;
                StringBuffer sb = new StringBuffer();
                int start = 0;
                while ((end = targetDir.indexOf(92, start)) >= 0) {
                    sb.append(targetDir.substring(start, end)).append('/');
                    start = end + 1;
                }
                sb.append(targetDir.substring(start));
                targetDir = sb.toString();
                int p = targetDir.indexOf(58);
                if (p > 0) {
                    targetDir = targetDir.substring(p + 1);
                }
            }
            StringUtils.printTrace(String.valueOf(targetDir) + "/" + className + " : " + language);
            this.generatedFiles.clear();
            if (language.toLowerCase().equals("Multicpp")) {
                this.fillGeneratedFilesListForMultiClasesCpp(targetDir, className);
            } else if (language.toLowerCase().equals("cpp")) {
                this.fillGeneratedFilesListForCpp(targetDir, className);
            } else if (language.toLowerCase().equals("java")) {
                this.fillGeneratedFilesListForJava(targetDir, className);
            } else if (language.toLowerCase().equals("python")) {
                this.fillGeneratedFilesListForPython(targetDir, className);
            } else if (language.toLowerCase().equals("pythonhl")) {
                this.fillGeneratedFilesListForPythonHL(targetDir, className);
            }
            this.generatedFiles.add(String.valueOf(targetDir) + "/doc_html/ClassDescription.html");
        }

        @Override
        public boolean accept(URI uri) {
            int p;
            String fileName = uri.getPath();
            if (this.isWindows && (p = fileName.indexOf(58)) > 0) {
                fileName = fileName.substring(p + 1);
            }
            for (String generateFile : this.generatedFiles) {
                if (generateFile.contains("*")) {
                    int pos = generateFile.indexOf(42);
                    String head = generateFile.substring(0, pos);
                    String end = generateFile.substring(pos + 1);
                    if (fileName.indexOf("/", pos + 1) > 0) {
                        return false;
                    }
                    if (!fileName.startsWith(head) || !fileName.endsWith(end)) continue;
                    return true;
                }
                if (!generateFile.equals(fileName)) continue;
                return true;
            }
            return false;
        }

        private void fillGeneratedFilesListForMultiClasesCpp(String targetDir, String className) {
            this.generatedFiles.add(String.valueOf(targetDir) + "/MultiClassFactory.cpp");
            this.generatedFiles.add(String.valueOf(targetDir) + "/Makefile.multi");
        }

        private void fillGeneratedFilesListForCpp(String targetDir, String className) {
            this.generatedFiles.add(String.valueOf(targetDir) + "/" + className + ".h");
            this.generatedFiles.add(String.valueOf(targetDir) + "/" + className + ".cpp");
            this.generatedFiles.add(String.valueOf(targetDir) + "/" + className + "Class.h");
            this.generatedFiles.add(String.valueOf(targetDir) + "/" + className + "Class.cpp");
            this.generatedFiles.add(String.valueOf(targetDir) + "/" + className + "StateMachine.cpp");
            this.generatedFiles.add(String.valueOf(targetDir) + "/" + className + "DynAttrUtils.cpp");
            this.generatedFiles.add(String.valueOf(targetDir) + "/ClassFactory.cpp");
            this.generatedFiles.add(String.valueOf(targetDir) + "/main.cpp");
            this.generatedFiles.add(String.valueOf(targetDir) + "/Makefile");
            this.generatedFiles.add(String.valueOf(targetDir) + "/CMakeLists.txt");
        }

        private void fillGeneratedFilesListForJava(String targetDir, String className) {
            this.generatedFiles.add(String.valueOf(targetDir) + "/org/tango/" + className.toLowerCase() + "/*.java");
            this.generatedFiles.add(String.valueOf(targetDir) + "/Makefile");
        }

        private void fillGeneratedFilesListForPython(String targetDir, String className) {
            this.generatedFiles.add(String.valueOf(targetDir) + "/" + className + ".py");
        }

        private void fillGeneratedFilesListForPythonHL(String targetDir, String className) {
            String pr_py = System.getProperty("python package");
            if (pr_py.equals("true")) {
                this.generatedFiles.add(String.valueOf(targetDir) + "/test/" + className + "_test.py");
                this.generatedFiles.add(String.valueOf(targetDir) + "/" + className + "/" + className + ".py");
            } else {
                this.generatedFiles.add(String.valueOf(targetDir) + "/" + className + ".py");
            }
        }
    }
}

