/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.okhttp.internal.http;

import com.squareup.okhttp.Handshake;
import com.squareup.okhttp.MediaType;
import com.squareup.okhttp.OkResponseCache;
import com.squareup.okhttp.ResponseSource;
import com.squareup.okhttp.internal.http.DelegatingHttpsURLConnection;
import com.squareup.okhttp.internal.http.Headers;
import com.squareup.okhttp.internal.http.OkHeaders;
import com.squareup.okhttp.internal.http.Request;
import com.squareup.okhttp.internal.http.Response;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.CacheRequest;
import java.net.CacheResponse;
import java.net.HttpURLConnection;
import java.net.ProtocolException;
import java.net.ResponseCache;
import java.net.SecureCacheResponse;
import java.net.URI;
import java.security.cert.Certificate;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLPeerUnverifiedException;
import javax.net.ssl.SSLSocketFactory;

public class ResponseCacheAdapter
implements OkResponseCache {
    private final ResponseCache delegate;

    public ResponseCacheAdapter(ResponseCache delegate) {
        this.delegate = delegate;
    }

    public ResponseCache getDelegate() {
        return this.delegate;
    }

    @Override
    public Response get(Request request) throws IOException {
        CacheResponse javaResponse = this.getJavaCachedResponse(request);
        if (javaResponse == null) {
            return null;
        }
        Response.Builder okResponseBuilder = new Response.Builder();
        okResponseBuilder.request(request);
        okResponseBuilder.statusLine(ResponseCacheAdapter.extractStatusLine(javaResponse));
        Headers okHeaders = ResponseCacheAdapter.extractOkHeaders(javaResponse);
        okResponseBuilder.headers(okHeaders);
        okResponseBuilder.setResponseSource(ResponseSource.CACHE);
        Response.Body okBody = ResponseCacheAdapter.createOkBody(okHeaders, javaResponse.getBody());
        okResponseBuilder.body(okBody);
        if (javaResponse instanceof SecureCacheResponse) {
            List<Certificate> peerCertificates;
            SecureCacheResponse javaSecureCacheResponse = (SecureCacheResponse)javaResponse;
            try {
                peerCertificates = javaSecureCacheResponse.getServerCertificateChain();
            }
            catch (SSLPeerUnverifiedException e) {
                peerCertificates = Collections.emptyList();
            }
            List<Certificate> localCertificates = javaSecureCacheResponse.getLocalCertificateChain();
            if (localCertificates == null) {
                localCertificates = Collections.emptyList();
            }
            Handshake handshake = Handshake.get(javaSecureCacheResponse.getCipherSuite(), peerCertificates, localCertificates);
            okResponseBuilder.handshake(handshake);
        }
        return okResponseBuilder.build();
    }

    @Override
    public CacheRequest put(Response response) throws IOException {
        URI uri = response.request().uri();
        HttpURLConnection connection = ResponseCacheAdapter.createJavaUrlConnection(response);
        return this.delegate.put(uri, connection);
    }

    @Override
    public boolean maybeRemove(Request request) throws IOException {
        return false;
    }

    @Override
    public void update(Response cached, Response network) throws IOException {
    }

    @Override
    public void trackConditionalCacheHit() {
    }

    @Override
    public void trackResponse(ResponseSource source) {
    }

    private CacheResponse getJavaCachedResponse(Request request) throws IOException {
        Map<String, List<String>> headers = ResponseCacheAdapter.extractJavaHeaders(request);
        return this.delegate.get(request.uri(), request.method(), headers);
    }

    private static HttpURLConnection createJavaUrlConnection(Response okResponse) {
        Request request = okResponse.request();
        if (request.isHttps()) {
            return new CacheHttpsURLConnection(new CacheHttpURLConnection(okResponse));
        }
        return new CacheHttpURLConnection(okResponse);
    }

    private static Headers extractOkHeaders(CacheResponse javaResponse) throws IOException {
        Map<String, List<String>> cachedHeaders = javaResponse.getHeaders();
        Headers.Builder okHeadersBuilder = new Headers.Builder();
        for (Map.Entry<String, List<String>> cachedHeader : cachedHeaders.entrySet()) {
            String name = cachedHeader.getKey();
            if (name == null) continue;
            for (String value : cachedHeader.getValue()) {
                okHeadersBuilder.add(name, value);
            }
        }
        return okHeadersBuilder.build();
    }

    private static String extractStatusLine(CacheResponse javaResponse) throws IOException {
        List<String> values = javaResponse.getHeaders().get(null);
        if (values == null || values.size() == 0) {
            return null;
        }
        return values.get(0);
    }

    private static Map<String, List<String>> extractJavaHeaders(Request request) {
        return OkHeaders.toMultimap(request.headers(), null);
    }

    private static Response.Body createOkBody(final Headers okHeaders, final InputStream body) {
        return new Response.Body(){

            @Override
            public boolean ready() throws IOException {
                return true;
            }

            @Override
            public MediaType contentType() {
                String contentTypeHeader = okHeaders.get("Content-Type");
                return contentTypeHeader == null ? null : MediaType.parse(contentTypeHeader);
            }

            @Override
            public long contentLength() {
                return OkHeaders.contentLength(okHeaders);
            }

            @Override
            public InputStream byteStream() {
                return body;
            }
        };
    }

    private static RuntimeException throwRequestModificationException() {
        throw new UnsupportedOperationException("ResponseCache cannot modify the request.");
    }

    private static RuntimeException throwRequestHeaderAccessException() {
        throw new UnsupportedOperationException("ResponseCache cannot access request headers");
    }

    private static RuntimeException throwRequestSslAccessException() {
        throw new UnsupportedOperationException("ResponseCache cannot access SSL internals");
    }

    private static RuntimeException throwResponseBodyAccessException() {
        throw new UnsupportedOperationException("ResponseCache cannot access the response body.");
    }

    private static final class CacheHttpsURLConnection
    extends DelegatingHttpsURLConnection {
        private final CacheHttpURLConnection delegate;

        public CacheHttpsURLConnection(CacheHttpURLConnection delegate) {
            super(delegate);
            this.delegate = delegate;
        }

        @Override
        protected Handshake handshake() {
            return this.delegate.response.handshake();
        }

        @Override
        public void setHostnameVerifier(HostnameVerifier hostnameVerifier) {
            throw ResponseCacheAdapter.throwRequestModificationException();
        }

        @Override
        public HostnameVerifier getHostnameVerifier() {
            throw ResponseCacheAdapter.throwRequestSslAccessException();
        }

        @Override
        public void setSSLSocketFactory(SSLSocketFactory socketFactory) {
            throw ResponseCacheAdapter.throwRequestModificationException();
        }

        @Override
        public SSLSocketFactory getSSLSocketFactory() {
            throw ResponseCacheAdapter.throwRequestSslAccessException();
        }

        @Override
        public long getContentLengthLong() {
            return this.delegate.getContentLengthLong();
        }

        @Override
        public void setFixedLengthStreamingMode(long contentLength) {
            this.delegate.setFixedLengthStreamingMode(contentLength);
        }

        @Override
        public long getHeaderFieldLong(String field, long defaultValue) {
            return this.delegate.getHeaderFieldLong(field, defaultValue);
        }
    }

    private static final class CacheHttpURLConnection
    extends HttpURLConnection {
        private final Request request;
        private final Response response;

        public CacheHttpURLConnection(Response response) {
            super(response.request().url());
            this.request = response.request();
            this.response = response;
            this.connected = true;
            this.doOutput = response.body() == null;
            this.method = this.request.method();
        }

        @Override
        public void connect() throws IOException {
            throw ResponseCacheAdapter.throwRequestModificationException();
        }

        @Override
        public void disconnect() {
            throw ResponseCacheAdapter.throwRequestModificationException();
        }

        @Override
        public void setRequestProperty(String key, String value) {
            throw ResponseCacheAdapter.throwRequestModificationException();
        }

        @Override
        public void addRequestProperty(String key, String value) {
            throw ResponseCacheAdapter.throwRequestModificationException();
        }

        @Override
        public String getRequestProperty(String key) {
            return this.request.header(key);
        }

        @Override
        public Map<String, List<String>> getRequestProperties() {
            throw ResponseCacheAdapter.throwRequestHeaderAccessException();
        }

        @Override
        public void setFixedLengthStreamingMode(int contentLength) {
            throw ResponseCacheAdapter.throwRequestModificationException();
        }

        @Override
        public void setFixedLengthStreamingMode(long contentLength) {
            throw ResponseCacheAdapter.throwRequestModificationException();
        }

        @Override
        public void setChunkedStreamingMode(int chunklen) {
            throw ResponseCacheAdapter.throwRequestModificationException();
        }

        @Override
        public void setInstanceFollowRedirects(boolean followRedirects) {
            throw ResponseCacheAdapter.throwRequestModificationException();
        }

        @Override
        public boolean getInstanceFollowRedirects() {
            return super.getInstanceFollowRedirects();
        }

        @Override
        public void setRequestMethod(String method) throws ProtocolException {
            throw ResponseCacheAdapter.throwRequestModificationException();
        }

        @Override
        public String getRequestMethod() {
            return this.request.method();
        }

        @Override
        public String getHeaderFieldKey(int position) {
            if (position < 0) {
                throw new IllegalArgumentException("Invalid header index: " + position);
            }
            if (position == 0) {
                return null;
            }
            return this.response.headers().name(position - 1);
        }

        @Override
        public String getHeaderField(int position) {
            if (position < 0) {
                throw new IllegalArgumentException("Invalid header index: " + position);
            }
            if (position == 0) {
                return this.response.statusLine();
            }
            return this.response.headers().value(position - 1);
        }

        @Override
        public String getHeaderField(String fieldName) {
            return fieldName == null ? this.response.statusLine() : this.response.headers().get(fieldName);
        }

        @Override
        public Map<String, List<String>> getHeaderFields() {
            return OkHeaders.toMultimap(this.response.headers(), this.response.statusLine());
        }

        @Override
        public int getResponseCode() throws IOException {
            return this.response.code();
        }

        @Override
        public String getResponseMessage() throws IOException {
            return this.response.statusMessage();
        }

        @Override
        public InputStream getErrorStream() {
            return null;
        }

        @Override
        public boolean usingProxy() {
            return false;
        }

        @Override
        public void setConnectTimeout(int timeout) {
            throw ResponseCacheAdapter.throwRequestModificationException();
        }

        @Override
        public int getConnectTimeout() {
            return 0;
        }

        @Override
        public void setReadTimeout(int timeout) {
            throw ResponseCacheAdapter.throwRequestModificationException();
        }

        @Override
        public int getReadTimeout() {
            return 0;
        }

        @Override
        public Object getContent() throws IOException {
            throw ResponseCacheAdapter.throwResponseBodyAccessException();
        }

        public Object getContent(Class[] classes) throws IOException {
            throw ResponseCacheAdapter.throwResponseBodyAccessException();
        }

        @Override
        public InputStream getInputStream() throws IOException {
            throw ResponseCacheAdapter.throwResponseBodyAccessException();
        }

        @Override
        public OutputStream getOutputStream() throws IOException {
            throw ResponseCacheAdapter.throwRequestModificationException();
        }

        @Override
        public void setDoInput(boolean doInput) {
            throw ResponseCacheAdapter.throwRequestModificationException();
        }

        @Override
        public boolean getDoInput() {
            return true;
        }

        @Override
        public void setDoOutput(boolean doOutput) {
            throw ResponseCacheAdapter.throwRequestModificationException();
        }

        @Override
        public boolean getDoOutput() {
            return this.request.body() != null;
        }

        @Override
        public void setAllowUserInteraction(boolean allowUserInteraction) {
            throw ResponseCacheAdapter.throwRequestModificationException();
        }

        @Override
        public boolean getAllowUserInteraction() {
            return false;
        }

        @Override
        public void setUseCaches(boolean useCaches) {
            throw ResponseCacheAdapter.throwRequestModificationException();
        }

        @Override
        public boolean getUseCaches() {
            return super.getUseCaches();
        }

        @Override
        public void setIfModifiedSince(long ifModifiedSince) {
            throw ResponseCacheAdapter.throwRequestModificationException();
        }

        @Override
        public long getIfModifiedSince() {
            return 0L;
        }

        @Override
        public boolean getDefaultUseCaches() {
            return super.getDefaultUseCaches();
        }

        @Override
        public void setDefaultUseCaches(boolean defaultUseCaches) {
            super.setDefaultUseCaches(defaultUseCaches);
        }
    }
}

