/*
 * Decompiled with CFR 0.152.
 */
package tool_panels.spectrum_histo;

import fr.esrf.Tango.AttrDataFormat;
import fr.esrf.Tango.DevFailed;
import fr.esrf.TangoApi.ApiUtil;
import fr.esrf.TangoApi.AttributeInfo;
import fr.esrf.TangoApi.AttributeProxy;
import fr.esrf.TangoApi.Database;
import fr.esrf.TangoApi.DeviceData;
import fr.esrf.TangoApi.DeviceInfo;
import fr.esrf.TangoApi.DeviceProxy;
import fr.esrf.TangoDs.Except;
import fr.esrf.TangoDs.TangoConst;
import fr.esrf.tangoatk.widget.util.ErrorPane;
import java.awt.Component;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JTree;
import javax.swing.ToolTipManager;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeExpansionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreePath;
import tool_panels.spectrum_histo.AttributeBrowser;
import tool_panels.spectrum_histo.SpectrumHisto;
import tool_panels.tools.Utils;

public class AttributeBrowserTree
extends JTree
implements TangoConst {
    private static final int INSTANCE = 3;
    private static final int CLASS = 4;
    private static final int DEVICE = 5;
    private static final int ATTRIB = 6;
    private static final int DOMAIN = 3;
    private static final int FAMILY = 4;
    private static final int MEMBER = 5;
    private DefaultTreeModel treeModel;
    private AttributeBrowser browser;
    private AttributeMenu menu;

    public AttributeBrowserTree(AttributeBrowser parent) throws DevFailed {
        this.browser = parent;
        String tango_host = ApiUtil.get_db_obj().get_tango_host();
        this.initComponent(tango_host);
        this.menu = new AttributeMenu(this);
    }

    private void initComponent(String title) throws DevFailed {
        DefaultMutableTreeNode root = new DefaultMutableTreeNode(title);
        this.createServerNodes(root);
        this.createDeviceNodes(root);
        this.createAliasNodes(root);
        this.getSelectionModel().setSelectionMode(1);
        this.treeModel = new DefaultTreeModel(root);
        this.setModel(this.treeModel);
        ToolTipManager.sharedInstance().registerComponent(this);
        this.setCellRenderer(new TangoRenderer());
        this.addTreeExpansionListener(new TreeExpansionListener(){

            @Override
            public void treeCollapsed(TreeExpansionEvent e) {
            }

            @Override
            public void treeExpanded(TreeExpansionEvent e) {
                AttributeBrowserTree.this.expandedPerfomed(e);
            }
        });
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                AttributeBrowserTree.this.treeMouseClicked(evt);
            }
        });
    }

    private boolean createChildNodes(DefaultMutableTreeNode node, String[] str) {
        boolean create = false;
        if (node.getChildCount() != str.length) {
            create = true;
        } else {
            for (int i = 0; i < str.length; ++i) {
                if (node.getChildAt(i).toString().equals(str[i])) continue;
                create = true;
            }
        }
        return create;
    }

    private void createAliasNodes(DefaultMutableTreeNode root) throws DevFailed {
        String[] aliases;
        DefaultMutableTreeNode c_node = new DefaultMutableTreeNode("Aliases");
        root.add(c_node);
        Database db = ApiUtil.get_db_obj();
        for (String alias : aliases = db.get_device_alias_list("*")) {
            try {
                String devname = ApiUtil.get_db_obj().get_alias_device(alias);
                DefaultMutableTreeNode al_node = new DefaultMutableTreeNode((Object)new BrowserDevice(devname, alias));
                al_node.add(new DefaultMutableTreeNode("dummy"));
                c_node.add(al_node);
            }
            catch (DevFailed e) {
                // empty catch block
            }
        }
    }

    private void createServerNodes(DefaultMutableTreeNode root) throws DevFailed {
        String[] servers;
        DefaultMutableTreeNode c_node = new DefaultMutableTreeNode("Servers");
        root.add(c_node);
        Database db = ApiUtil.get_db_obj();
        for (String server : servers = db.get_server_name_list()) {
            DefaultMutableTreeNode d_node = new DefaultMutableTreeNode(server);
            d_node.add(new DefaultMutableTreeNode("dummy"));
            c_node.add(d_node);
        }
    }

    private void createInstanceNodes(DefaultMutableTreeNode node) {
        try {
            String binfile = (String)node.getUserObject();
            String[] instancies = ApiUtil.get_db_obj().get_instance_name_list(binfile);
            if (!this.createChildNodes(node, instancies)) {
                return;
            }
            for (int i = 0; i < instancies.length; ++i) {
                DefaultMutableTreeNode s_node = new DefaultMutableTreeNode(new BrowserServer(binfile, instancies[i]));
                s_node.add(new DefaultMutableTreeNode("Dummy"));
                this.treeModel.insertNodeInto(s_node, node, i);
            }
            this.removePreviousNode(node, instancies.length);
        }
        catch (DevFailed e) {
            this.displayException((Exception)((Object)e));
        }
    }

    private void createClassNodes(DefaultMutableTreeNode node) {
        try {
            BrowserServer server = (BrowserServer)node.getUserObject();
            String[] classes = ApiUtil.get_db_obj().get_server_class_list(server.name);
            if (!this.createChildNodes(node, classes)) {
                return;
            }
            for (int i = 0; i < classes.length; ++i) {
                DefaultMutableTreeNode i_node = new DefaultMutableTreeNode(classes[i]);
                i_node.add(new DefaultMutableTreeNode("Dummy"));
                this.treeModel.insertNodeInto(i_node, node, i);
            }
            this.removePreviousNode(node, classes.length);
        }
        catch (DevFailed e) {
            this.displayException((Exception)((Object)e));
        }
    }

    private void createDeviceNodesFromServer(DefaultMutableTreeNode node) {
        try {
            DefaultMutableTreeNode s_node = (DefaultMutableTreeNode)node.getParent();
            BrowserServer server = (BrowserServer)s_node.getUserObject();
            String servname = server.name;
            String classname = (String)node.getUserObject();
            String[] devices = ApiUtil.get_db_obj().get_device_name(servname, classname);
            if (!this.createChildNodes(node, devices)) {
                return;
            }
            for (int i = 0; i < devices.length; ++i) {
                DefaultMutableTreeNode d_node = new DefaultMutableTreeNode((Object)new BrowserDevice_2(devices[i]));
                d_node.add(new DefaultMutableTreeNode("dummy"));
                this.treeModel.insertNodeInto(d_node, node, i);
            }
            this.removePreviousNode(node, devices.length);
        }
        catch (DevFailed e) {
            this.displayException((Exception)((Object)e));
        }
    }

    private void createDeviceNodes(DefaultMutableTreeNode root) throws DevFailed {
        String[] domains;
        DefaultMutableTreeNode c_node = new DefaultMutableTreeNode("Devices");
        root.add(c_node);
        Database db = ApiUtil.get_db_obj();
        for (String domain : domains = db.get_device_domain("*")) {
            DefaultMutableTreeNode d_node = new DefaultMutableTreeNode(domain);
            d_node.add(new DefaultMutableTreeNode("dummy"));
            c_node.add(d_node);
        }
    }

    private void createFamilyNodes(DefaultMutableTreeNode node) {
        try {
            String domain = (String)node.getUserObject();
            String[] families = ApiUtil.get_db_obj().get_device_family(domain + "/*");
            if (!this.createChildNodes(node, families)) {
                return;
            }
            for (int f = 0; f < families.length; ++f) {
                DefaultMutableTreeNode f_node = new DefaultMutableTreeNode(families[f]);
                f_node.add(new DefaultMutableTreeNode("Dummy"));
                this.treeModel.insertNodeInto(f_node, node, f);
            }
            this.removePreviousNode(node, families.length);
        }
        catch (DevFailed e) {
            this.displayException((Exception)((Object)e));
        }
    }

    private void createMemberNodes(String tango_path, DefaultMutableTreeNode node) {
        try {
            tango_path = tango_path + (String)node.getUserObject();
            String[] members = ApiUtil.get_db_obj().get_device_member(tango_path + "/*");
            if (!this.createChildNodes(node, members)) {
                return;
            }
            for (int m = 0; m < members.length; ++m) {
                DefaultMutableTreeNode m_node = new DefaultMutableTreeNode((Object)new BrowserDevice(tango_path + "/" + members[m]));
                m_node.add(new DefaultMutableTreeNode("Dummy"));
                this.treeModel.insertNodeInto(m_node, node, m);
            }
            this.removePreviousNode(node, members.length);
        }
        catch (DevFailed e) {
            this.displayException((Exception)((Object)e));
        }
    }

    private void createAttributeNodes(DefaultMutableTreeNode node) {
        try {
            BrowserDevice dev = (BrowserDevice)((Object)node.getUserObject());
            AttributeInfo[] info = dev.get_attribute_info();
            Vector<String> v = new Vector<String>();
            for (AttributeInfo anInfo : info) {
                if (anInfo.data_format != AttrDataFormat.SPECTRUM || !SpectrumHisto.supportedType(anInfo.data_type)) continue;
                v.add(anInfo.name);
            }
            String[] attnames = new String[v.size()];
            for (int i = 0; i < v.size(); ++i) {
                attnames[i] = (String)v.get(i);
            }
            if (!this.createChildNodes(node, attnames)) {
                return;
            }
            for (int a = 0; a < attnames.length; ++a) {
                BrowserAttribute attr = new BrowserAttribute(attnames[a], dev);
                DefaultMutableTreeNode a_node = new DefaultMutableTreeNode(attr);
                this.treeModel.insertNodeInto(a_node, node, a);
            }
            this.removePreviousNode(node, attnames.length);
        }
        catch (DevFailed e) {
            this.removePreviousNode(node, 0);
            this.displayException((Exception)((Object)e));
        }
    }

    private void removePreviousNode(DefaultMutableTreeNode node, int offset) {
        while (node.getChildCount() > offset) {
            DefaultMutableTreeNode leaf = (DefaultMutableTreeNode)node.getChildAt(offset);
            this.treeModel.removeNodeFromParent(leaf);
        }
    }

    private String tangoPath(TreePath path, int nb) {
        String p = "";
        for (int i = 3; i < 3 + nb; ++i) {
            p = p + path.getPathComponent(i - 1).toString();
            p = p + "/";
        }
        return p;
    }

    public void expandedPerfomed(TreeExpansionEvent evt) {
        TreePath tp = evt.getPath();
        Object[] path = tp.getPath();
        if (path.length < 2) {
            return;
        }
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)tp.getPathComponent(path.length - 1);
        if (path[1].toString().equals("Servers")) {
            switch (path.length) {
                case 3: {
                    this.createInstanceNodes(node);
                    break;
                }
                case 4: {
                    this.createClassNodes(node);
                    break;
                }
                case 5: {
                    this.createDeviceNodesFromServer(node);
                    break;
                }
                case 6: {
                    this.createAttributeNodes(node);
                }
            }
        } else if (path[1].toString().equals("Devices")) {
            switch (path.length) {
                case 3: {
                    this.createFamilyNodes(node);
                    break;
                }
                case 4: {
                    String tango_path = this.tangoPath(tp, 1);
                    this.createMemberNodes(tango_path, node);
                    break;
                }
                case 5: {
                    this.createAttributeNodes(node);
                }
            }
        } else if (path[1].toString().equals("Aliases") && path.length == 3) {
            this.createAttributeNodes(node);
        }
    }

    private void treeMouseClicked(MouseEvent evt) {
        if (this.getRowForLocation(evt.getX(), evt.getY()) < 1) {
            return;
        }
        TreePath selectedPath = this.getPathForLocation(evt.getX(), evt.getY());
        if (selectedPath == null) {
            return;
        }
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)selectedPath.getPathComponent(selectedPath.getPathCount() - 1);
        Object o = node.getUserObject();
        int mask = evt.getModifiers();
        this.setSelectionPath(selectedPath);
        this.clearDisplay();
        if (evt.getClickCount() == 2 && node.isLeaf()) {
            if (o instanceof BrowserDevice) {
                this.createAttributeNodes(node);
                for (int i = 0; i < node.getChildCount(); ++i) {
                    DefaultMutableTreeNode child = (DefaultMutableTreeNode)node.getChildAt(i);
                    this.expandPath(new TreePath(child.getPath()));
                }
            } else if (o instanceof BrowserAttribute) {
                this.displaySpectrumHisto();
            }
        } else if ((mask & 4) != 0) {
            if (o instanceof BrowserAttribute) {
                BrowserAttribute attr = (BrowserAttribute)o;
                this.menu.showMenu(evt, attr);
                this.displayPollingProperties(attr);
            }
        } else if ((mask & 0x10) != 0) {
            if (o instanceof BrowserServer) {
                this.displayDeviceInfo(((BrowserServer)o).dev);
            } else if (o instanceof BrowserDevice) {
                this.displayDeviceInfo((BrowserDevice)((Object)o));
            } else if (o instanceof BrowserAttribute) {
                this.displayPollingProperties((BrowserAttribute)o);
            }
        }
    }

    private void displaySpectrumHisto() {
        Object o = this.getSelectedNode().getUserObject();
        if (o instanceof BrowserAttribute) {
            try {
                String attname = ((BrowserAttribute)o).attname;
                SpectrumHisto panel = new SpectrumHisto(this.browser, attname, false);
                panel.setVisible(true);
            }
            catch (DevFailed e) {
                ErrorPane.showErrorMessage((Component)this, null, (DevFailed)e);
            }
        }
    }

    private void clearDisplay() {
        this.browser.setText("");
    }

    private boolean displayDeviceInfo(BrowserDevice dev) {
        String message;
        try {
            DeviceInfo info = dev.get_info();
            message = info + "\n\n";
        }
        catch (DevFailed e) {
            this.browser.setText(e.toString());
            return false;
        }
        boolean ok = false;
        try {
            String str = "\n=======================================\n";
            str = str + "           Polling Status:\n\n";
            if (dev.name().startsWith("dserver/")) {
                String[] devlist;
                DeviceData argout = dev.command_inout("QueryDevice");
                for (String devstr : devlist = argout.extractStringArray()) {
                    String devname = devstr.substring(devstr.indexOf("::") + 2);
                    DeviceData argin = new DeviceData();
                    argin.insert(devname);
                    argout = dev.command_inout("DevPollStatus", argin);
                    String[] s = argout.extractStringArray();
                    str = str + "----------------- " + devname + " ------------------\n";
                    for (String line : s) {
                        str = str + line + "\n\n";
                    }
                }
                ok = true;
            } else {
                String[] poll_st;
                for (String st : poll_st = dev.polling_status()) {
                    str = str + st + "\n\n";
                }
                ok = true;
            }
            message = message + str;
        }
        catch (DevFailed e) {
            try {
                dev.ping();
                ok = true;
            }
            catch (DevFailed ex) {
                message = message + "\n=======================================\n";
                message = message + Except.str_exception((Exception)((Object)ex));
            }
        }
        this.browser.setText(message);
        return ok;
    }

    private String getAttPollingInfo() {
        Object o = this.getSelectedNode().getUserObject();
        if (o instanceof BrowserAttribute) {
            try {
                String[] poll_status;
                BrowserAttribute att = (BrowserAttribute)o;
                String header = "Polled attribute name = ";
                for (String poll_st : poll_status = att.dev.polling_status()) {
                    String s = poll_st.substring(header.length(), poll_st.indexOf(10));
                    if (!s.toLowerCase().equals(att.name.toLowerCase())) continue;
                    return poll_st;
                }
            }
            catch (DevFailed e) {
                return e.toString();
            }
        }
        return "";
    }

    private void displayPollingProperties(BrowserAttribute attr) {
        this.displayPollingProperties(attr.attname);
    }

    void displayPollingProperties(String attname) {
        try {
            AttributeProxy ap = new AttributeProxy(attname);
            int att_idl_version = ap.get_idl_version();
            if (att_idl_version < 3) {
                this.browser.setText("Device_" + att_idl_version + "Impl not supported.");
                return;
            }
            String str = this.getAttPollingInfo();
            this.browser.setText(str);
        }
        catch (DevFailed e) {
            this.displayException((Exception)((Object)e));
        }
    }

    private void displayException(Exception e) {
        this.browser.setText(Except.str_exception((Exception)e));
    }

    DefaultMutableTreeNode getSelectedNode() {
        return (DefaultMutableTreeNode)this.getLastSelectedPathComponent();
    }

    class AttributeMenu
    extends JPopupMenu {
        private JTree tree;
        private String[] labels = new String[]{"3D history"};
        private static final int OFFSET = 2;
        private static final int HISTORY = 0;

        public AttributeMenu(JTree tree) {
            this.tree = tree;
            JLabel title = new JLabel("History :");
            title.setFont(new Font("Dialog", 1, 16));
            this.add(title);
            this.add(new JPopupMenu.Separator());
            for (String label : this.labels) {
                JMenuItem btn = new JMenuItem(label);
                btn.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent evt) {
                        AttributeMenu.this.histoActionPerformed(evt);
                    }
                });
                this.add(btn);
            }
        }

        public void showMenu(MouseEvent evt, BrowserAttribute attr) {
            ((JLabel)this.getComponent(0)).setText(attr.attname);
            this.show(this.tree, evt.getX(), evt.getY());
        }

        private void histoActionPerformed(ActionEvent evt) {
            Object obj = evt.getSource();
            int idx = -1;
            for (int i = 0; i < this.labels.length; ++i) {
                if (this.getComponent(2 + i) != obj) continue;
                idx = i;
            }
            switch (idx) {
                case 0: {
                    AttributeBrowserTree.this.displaySpectrumHisto();
                }
            }
        }
    }

    private class TangoRenderer
    extends DefaultTreeCellRenderer {
        private ImageIcon tangoIcon = Utils.getInstance().getIcon("network5.gif");
        private ImageIcon serv_icon = Utils.getInstance().getIcon("server.gif");
        private ImageIcon dev_icon = Utils.getInstance().getIcon("device.gif");
        private ImageIcon attr_icon = Utils.getInstance().getIcon("leaf.gif");
        private ImageIcon class_icon = Utils.getInstance().getIcon("class.gif");
        private Font[] fonts = new Font[3];
        private final int TITLE = 0;
        private final int DEVICE = 1;
        private final int ATTR = 2;

        public TangoRenderer() {
            this.fonts[0] = new Font("courrier", 1, 18);
            this.fonts[1] = new Font("Monospaced", 1, 12);
            this.fonts[2] = new Font("Monospaced", 0, 12);
        }

        @Override
        public Component getTreeCellRendererComponent(JTree tree, Object obj, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            super.getTreeCellRendererComponent(tree, obj, sel, expanded, leaf, row, hasFocus);
            if (row == 0) {
                this.setFont(this.fonts[0]);
                this.setIcon(this.tangoIcon);
            } else {
                DefaultMutableTreeNode node = (DefaultMutableTreeNode)obj;
                if (node.getUserObject() instanceof String) {
                    this.setFont(this.fonts[0]);
                    if (obj.toString().equals("Servers")) {
                        this.setIcon(this.serv_icon);
                    } else if (obj.toString().equals("Devices")) {
                        this.setIcon(this.dev_icon);
                    } else if (obj.toString().equals("Aliases")) {
                        this.setIcon(this.dev_icon);
                    } else {
                        this.setFont(this.fonts[1]);
                        this.setIcon(this.class_icon);
                    }
                } else if (node.getUserObject() instanceof BrowserAttribute) {
                    this.setFont(this.fonts[2]);
                    this.setIcon(this.attr_icon);
                } else if (node.getUserObject() instanceof BrowserDevice) {
                    this.setFont(this.fonts[1]);
                    this.setIcon(this.dev_icon);
                } else if (node.getUserObject() instanceof BrowserServer) {
                    this.setFont(this.fonts[1]);
                    this.setIcon(this.serv_icon);
                }
            }
            return this;
        }
    }

    private class BrowserAttribute {
        BrowserDevice dev;
        String name;
        String attname;

        BrowserAttribute(String name, BrowserDevice dev) {
            this.name = name;
            this.dev = dev;
            this.attname = dev.name + "/" + name;
        }

        public String toString() {
            return this.name;
        }
    }

    private class BrowserDevice_2
    extends BrowserDevice {
        BrowserDevice_2(String name) throws DevFailed {
            super(name);
        }

        @Override
        public String toString() {
            return this.name;
        }
    }

    private class BrowserDevice
    extends DeviceProxy {
        String name;
        String member;

        BrowserDevice(String name) throws DevFailed {
            super(name);
            this.name = name;
            int idx = name.lastIndexOf(47);
            this.member = idx < 0 ? name : name.substring(idx + 1);
        }

        BrowserDevice(String name, String aliasname) throws DevFailed {
            super(name);
            this.name = name;
            this.member = aliasname;
        }

        public String toString() {
            return this.member;
        }
    }

    private class BrowserServer {
        String name;
        String instance;
        BrowserDevice_2 dev;

        BrowserServer(String binfile, String instance) {
            this.name = binfile + "/" + instance;
            this.instance = instance;
            try {
                this.dev = new BrowserDevice_2("dserver/" + this.name);
            }
            catch (DevFailed e) {
                // empty catch block
            }
        }

        public String toString() {
            return this.instance;
        }
    }
}

