/*
 * Decompiled with CFR 0.152.
 */
package tool_panels.atktable;

import fr.esrf.Tango.DevFailed;
import fr.esrf.tangoatk.widget.util.ATKGraphicsUtils;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.KeyStroke;
import tool_panels.atktable.DevBrowserTree;
import tool_panels.atktable.TableScalarViewer;
import tool_panels.tools.Utils;

public class DevBrowser
extends JFrame {
    private DevBrowserTree tree;
    private TableScalarViewer parent;
    TargetPosition target_position;
    private JMenuItem exitBtn;
    private JMenu fileMenu;
    private JMenuBar jMenuBar1;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JTextArea textArea;
    private JScrollPane textScrollPane;
    private JLabel titleLabel;
    private JScrollPane treeScrollPane;

    public DevBrowser(TableScalarViewer parent) {
        this.parent = parent;
        this.initComponents();
        try {
            this.tree = new DevBrowserTree(this);
            this.treeScrollPane.setViewportView(this.tree);
        }
        catch (DevFailed e) {
            Utils.popupError(this, null, (Exception)((Object)e));
        }
        this.customizeMenu();
        this.pack();
        ATKGraphicsUtils.centerFrameOnScreen((Frame)this);
    }

    void addAttribute(String name) {
        this.parent.changeAttributeAt(this.target_position.row, this.target_position.col, name);
        this.doClose();
    }

    private void customizeMenu() {
        this.fileMenu.setMnemonic('F');
        this.exitBtn.setMnemonic('D');
        this.exitBtn.setAccelerator(KeyStroke.getKeyStroke(68, 2));
    }

    void displayEventProperties(String attname) {
        this.tree.displayEventProperties(attname);
    }

    private void initComponents() {
        this.jPanel1 = new JPanel();
        this.textScrollPane = new JScrollPane();
        this.textArea = new JTextArea();
        this.treeScrollPane = new JScrollPane();
        this.jPanel2 = new JPanel();
        this.titleLabel = new JLabel();
        this.jMenuBar1 = new JMenuBar();
        this.fileMenu = new JMenu();
        this.exitBtn = new JMenuItem();
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                DevBrowser.this.exitForm(evt);
            }
        });
        this.jPanel1.setLayout(new BorderLayout());
        this.textScrollPane.setPreferredSize(new Dimension(400, 400));
        this.textArea.setEditable(false);
        this.textArea.setFont(new Font("Courier New", 1, 12));
        this.textScrollPane.setViewportView(this.textArea);
        this.jPanel1.add((Component)this.textScrollPane, "Center");
        this.treeScrollPane.setPreferredSize(new Dimension(300, 400));
        this.jPanel1.add((Component)this.treeScrollPane, "West");
        this.getContentPane().add((Component)this.jPanel1, "Center");
        this.titleLabel.setFont(new Font("Dialog", 1, 18));
        this.titleLabel.setText("Select an attribute");
        this.jPanel2.add(this.titleLabel);
        this.getContentPane().add((Component)this.jPanel2, "North");
        this.fileMenu.setText("File");
        this.exitBtn.setText("Dismiss");
        this.exitBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DevBrowser.this.exitBtnActionPerformed(evt);
            }
        });
        this.fileMenu.add(this.exitBtn);
        this.jMenuBar1.add(this.fileMenu);
        this.setJMenuBar(this.jMenuBar1);
        this.pack();
    }

    private void exitBtnActionPerformed(ActionEvent evt) {
        this.doClose();
    }

    private void exitForm(WindowEvent evt) {
        this.doClose();
    }

    private void doClose() {
        this.setVisible(false);
        this.dispose();
    }

    void setText(String str) {
        this.textArea.setText(str);
        this.textArea.setCaretPosition(0);
    }

    void setPosition(int row, int col, String rowname, String colname) {
        this.target_position = new TargetPosition(row, col, rowname, colname);
        this.titleLabel.setText("Select an attribute for [" + rowname + "][" + colname + "]");
    }

    public static void main(String[] args) {
        DevBrowser db = new DevBrowser(new TableScalarViewer());
        db.setVisible(true);
    }

    class TargetPosition {
        int row;
        int col;
        String rowname;
        String colname;

        TargetPosition(int row, int col, String rowname, String colname) {
            this.row = row;
            this.col = col;
            this.rowname = rowname;
            this.colname = colname;
        }
    }
}

