/*
 * Decompiled with CFR 0.152.
 */
package explorer;

import explorer.ColumnListener;
import explorer.DeviceList;
import explorer.EntityAdapter;
import explorer.MyCellRenderer;
import explorer.Preferences;
import explorer.Status;
import explorer.ui.Clearable;
import explorer.ui.Refresher;
import fr.esrf.tangoatk.core.AEntityList;
import fr.esrf.tangoatk.core.ConnectionException;
import fr.esrf.tangoatk.core.IDevice;
import fr.esrf.tangoatk.core.IEntity;
import fr.esrf.tangoatk.core.IErrorListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableColumnModel;

public abstract class EntityTableModel
extends AbstractTableModel
implements Refresher,
Clearable {
    protected List<ColumnListener> listenerList = new ArrayList<ColumnListener>();
    protected List<String> columnIdentifiers;
    protected List<String> columnNames;
    protected List<EntityAdapter> adapters;
    protected AEntityList entities;
    protected TableColumnModel columnModel;
    protected Status status;
    protected Preferences preferences;
    protected DeviceList deviceList;
    boolean disregardPreference = false;
    public static String DEVICE = "Device";
    public static String NAME = "Name";
    public static String LEVEL = "Level";
    protected boolean refresherStarted = false;

    public void addColumnListener(ColumnListener l) {
        this.listenerList.add(l);
    }

    public void removeColumnListener(ColumnListener l) {
        this.listenerList.remove(l);
    }

    public void setPreferences(Preferences preferences) {
        this.preferences = preferences;
    }

    public String getEntityAlias(IEntity entity) {
        String tmp = entity.getAlias();
        return tmp != null ? tmp : entity.getName();
    }

    public String getDeviceAlias(IDevice device) {
        return device.getName();
    }

    public void setColumnModel(TableColumnModel model) {
        this.columnModel = model;
        this.initColumns();
    }

    public void storePreferences() {
        for (int i = 0; i < this.columnNames.size(); ++i) {
            String name = this.columnNames.get(i);
            int index = -1;
            try {
                index = this.columnModel.getColumnIndex(name);
            }
            catch (IllegalArgumentException e) {
                // empty catch block
            }
            this.putIndex(name, index);
        }
    }

    EntityAdapter getAdapterAt(int row) {
        return this.adapters.get(row);
    }

    @Override
    public int getRowCount() {
        if (this.adapters == null) {
            return 0;
        }
        return this.adapters.size();
    }

    @Override
    public int getColumnCount() {
        return this.columnIdentifiers.size();
    }

    @Override
    public String getColumnName(int column) {
        if (column >= this.columnIdentifiers.size()) {
            return "URK";
        }
        return this.columnIdentifiers.get(column);
    }

    public boolean exists(IEntity entity) {
        for (int i = 0; i < this.adapters.size(); ++i) {
            if (!this.getEntityAt(i).getName().equals(entity.getName())) continue;
            return true;
        }
        return false;
    }

    public void addColumn(String name) {
        boolean found = false;
        int i = 0;
        while (!found && i < this.getColumnCount()) {
            found = name.equalsIgnoreCase(this.columnIdentifiers.get(i));
            if (found) continue;
            ++i;
        }
        if (found) {
            return;
        }
        this.columnIdentifiers.add(name);
        this.putIndex(name, this.columnIdentifiers.size() - 1);
    }

    public void removeColumn(String name) {
        boolean found = false;
        int i = 0;
        while (!found && i < this.getColumnCount()) {
            found = name.equalsIgnoreCase(this.columnIdentifiers.get(i));
            if (found) continue;
            ++i;
        }
        if (found) {
            this.columnIdentifiers.remove(i);
        }
        this.putIndex(name, -1);
    }

    public void reorderColumns() {
        if (this.columnNames == null) {
            return;
        }
        for (int i = 0; i < this.columnNames.size(); ++i) {
            String name = this.columnNames.get(i);
            int index = this.getIndex(name, -1);
            if (index == -1) {
                this.removeColumn(name);
                continue;
            }
            this.addColumn(name);
        }
        this.publishColumnChange();
    }

    void publishColumnChange() {
        for (int i = 0; i < this.listenerList.size(); ++i) {
            this.listenerList.get(i).columnsChanged();
        }
    }

    public boolean isVisible(String name) {
        boolean found = false;
        int i = 0;
        while (!found && i < this.getColumnCount()) {
            found = name.equalsIgnoreCase(this.columnIdentifiers.get(i));
            if (found) continue;
            ++i;
        }
        return found;
    }

    public void setVisible(String[] names, boolean[] visible) {
        for (int i = 0; i < names.length; ++i) {
            if (visible[i]) {
                this.addColumn(names[i]);
            } else {
                this.removeColumn(names[i]);
            }
            this.disregardPreference = true;
            this.fireTableStructureChanged();
            this.disregardPreference = false;
        }
    }

    public boolean containsEntity(IEntity e) {
        return this.entities.contains((Object)e);
    }

    public void addEntities(AEntityList entityList) {
        for (int i = 0; i < entityList.size(); ++i) {
            this.addEntity((IEntity)entityList.get(i));
        }
        this.reorderColumns();
        this.fireTableStructureChanged();
    }

    public void removeEntityAt(int row) {
        this.adapters.get(row).remove();
        try {
            IEntity entity = this.getEntityAt(row);
            if (this.deviceList != null) {
                this.deviceList.remove(entity.getDevice());
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.adapters.remove(row);
        this.entities.remove(row);
        this.fireTableRowsDeleted(row, row);
    }

    public AEntityList getList() {
        return this.entities;
    }

    @Override
    public void setRefreshInterval(int milliseconds) {
        this.preferences.putInt("refreshInterval", milliseconds);
        this.entities.setRefreshInterval(milliseconds);
        if (this.deviceList != null) {
            this.deviceList.setRefreshInterval(milliseconds);
        }
    }

    @Override
    public void startRefresher() {
        if (!this.refresherStarted) {
            this.entities.startRefresher();
            this.refresherStarted = true;
        }
        if (this.deviceList != null) {
            this.deviceList.start();
        }
    }

    @Override
    public void stopRefresher() {
        this.refresherStarted = false;
        this.entities.stopRefresher();
        if (this.deviceList != null) {
            this.deviceList.stop();
        }
    }

    @Override
    public void refresh() {
        this.entities.refresh();
        if (this.deviceList != null) {
            this.deviceList.refresh();
        }
    }

    public void addErrorListener(IErrorListener listener) {
        this.entities.addErrorListener(listener);
    }

    @Override
    public int getRefreshInterval() {
        return this.entities.getRefreshInterval();
    }

    @Override
    public void clear() {
        int size = this.adapters.size();
        for (int i = 0; i < size; ++i) {
            EntityAdapter adapter = this.adapters.get(i);
            adapter.remove();
        }
        this.adapters.clear();
        this.entities.clear();
        this.fireTableRowsDeleted(0, size);
    }

    public List<String> getAllColumnNames() {
        return this.columnNames;
    }

    public IEntity getEntityAt(int row) {
        return this.adapters.get(row).getEntity();
    }

    int getIndex(String name, int def) {
        if (this.disregardPreference) {
            return def;
        }
        String pref = this.getPreferencePrefix().append(name).append("Index").toString();
        return this.preferences.getInt(pref, def);
    }

    void putIndex(String name, int val) {
        String pref = this.getPreferencePrefix().append(name).append("Index").toString();
        this.preferences.putInt(pref, val);
    }

    JComponent getRenderer(Object o, String column) {
        try {
            int index = this.columnModel.getColumnIndex(column);
            return ((MyCellRenderer)this.columnModel.getColumn(index).getCellRenderer()).getRenderer(o);
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
            return null;
        }
    }

    JComponent getDeviceRenderer(String deviceName) {
        return this.getRenderer(deviceName, DEVICE);
    }

    protected abstract StringBuffer getPreferencePrefix();

    protected abstract boolean isExecuteColumn(int var1);

    protected abstract void initColumns();

    protected abstract void addEntity(IEntity var1);

    public void load(String name) throws ConnectionException {
        this.load(name, null, null);
    }

    public abstract void load(String var1, String var2, String var3) throws ConnectionException;

    public DeviceList getDeviceList() {
        return this.deviceList;
    }

    public void setDeviceList(DeviceList deviceList) {
        this.deviceList = deviceList;
    }

    public boolean isRefresherStarted() {
        return this.refresherStarted;
    }

    public void setSynchronizedPeriod(boolean synchro) {
        this.entities.setSynchronizedPeriod(synchro);
    }
}

