/*
 * Decompiled with CFR 0.152.
 */
package jive3;

import fr.esrf.Tango.DevFailed;
import fr.esrf.TangoApi.CommandInfo;
import fr.esrf.TangoApi.Database;
import fr.esrf.TangoApi.DbDatum;
import fr.esrf.TangoApi.DeviceProxy;
import java.util.Vector;
import javax.swing.ImageIcon;
import jive.JiveUtils;
import jive3.TangoNode;
import jive3.TangoNodeRenderer;

public class TaskPollingNode
extends TangoNode {
    private Database db;
    private String devName;
    private Vector attPollingInfo;
    private Vector cmdPollingInfo;

    TaskPollingNode(Database db, String devName) {
        this.db = db;
        this.devName = devName;
        this.attPollingInfo = null;
        this.cmdPollingInfo = null;
    }

    @Override
    void populateNode() throws DevFailed {
    }

    @Override
    ImageIcon getIcon() {
        return TangoNodeRenderer.leafcfgicon;
    }

    @Override
    public String toString() {
        return "Polling";
    }

    @Override
    String getTitle() {
        return "Device polling";
    }

    String getName() {
        return this.devName;
    }

    @Override
    public boolean isLeaf() {
        return true;
    }

    @Override
    void execAction(int number) {
    }

    int getCommandNumber() {
        if (this.attPollingInfo == null || this.cmdPollingInfo == null) {
            this.browsePollingStatus();
        }
        return this.cmdPollingInfo.size();
    }

    String getCommandName(int idx) {
        if (this.attPollingInfo == null || this.cmdPollingInfo == null) {
            this.browsePollingStatus();
        }
        return ((PInfo)this.cmdPollingInfo.get((int)idx)).name;
    }

    boolean isCommandPolled(int idx) {
        if (this.attPollingInfo == null || this.cmdPollingInfo == null) {
            this.browsePollingStatus();
        }
        return ((PInfo)this.cmdPollingInfo.get((int)idx)).period != "";
    }

    String getCommandPollingPeriod(int idx) {
        if (this.attPollingInfo == null || this.cmdPollingInfo == null) {
            this.browsePollingStatus();
        }
        return ((PInfo)this.cmdPollingInfo.get((int)idx)).period;
    }

    void updateCommandPolling(String cmdName, boolean isPolled, String period) {
        int polling_period = 3000;
        if (isPolled) {
            if (period != "") {
                try {
                    polling_period = Integer.parseInt(period);
                }
                catch (NumberFormatException e) {
                    JiveUtils.showJiveError("Invalid period value for command " + cmdName + "\n" + e.getMessage());
                }
            }
            try {
                DeviceProxy ds = new DeviceProxy(this.devName);
                ds.poll_command(cmdName, polling_period);
            }
            catch (DevFailed ex) {
                JiveUtils.showTangoError(ex);
            }
        } else {
            try {
                DeviceProxy ds = new DeviceProxy(this.devName);
                ds.stop_poll_command(cmdName);
            }
            catch (DevFailed ex) {
                JiveUtils.showTangoError(ex);
            }
        }
    }

    int getAttributeNumber() {
        if (this.attPollingInfo == null || this.cmdPollingInfo == null) {
            this.browsePollingStatus();
        }
        return this.attPollingInfo.size();
    }

    String getAttributeName(int idx) {
        if (this.attPollingInfo == null || this.cmdPollingInfo == null) {
            this.browsePollingStatus();
        }
        return ((PInfo)this.attPollingInfo.get((int)idx)).name;
    }

    boolean isAttributePolled(int idx) {
        if (this.attPollingInfo == null || this.cmdPollingInfo == null) {
            this.browsePollingStatus();
        }
        return ((PInfo)this.attPollingInfo.get((int)idx)).period != "";
    }

    String getAttributePollingPeriod(int idx) {
        if (this.attPollingInfo == null || this.cmdPollingInfo == null) {
            this.browsePollingStatus();
        }
        return ((PInfo)this.attPollingInfo.get((int)idx)).period;
    }

    void updateAttributePolling(String attName, boolean isPolled, String period) {
        int polling_period = 3000;
        if (isPolled) {
            if (period != "") {
                try {
                    polling_period = Integer.parseInt(period);
                }
                catch (NumberFormatException e) {
                    JiveUtils.showJiveError("Invalid period value for attribute " + attName + "\n" + e.getMessage());
                }
            }
            try {
                DeviceProxy ds = new DeviceProxy(this.devName);
                ds.poll_attribute(attName, polling_period);
            }
            catch (DevFailed ex) {
                JiveUtils.showTangoError(ex);
            }
        } else {
            try {
                DeviceProxy ds = new DeviceProxy(this.devName);
                ds.stop_poll_attribute(attName);
            }
            catch (DevFailed ex) {
                JiveUtils.showTangoError(ex);
            }
        }
    }

    String getPollOldFactor() {
        String ret = "4";
        try {
            DbDatum data = this.db.get_device_property(this.devName, "poll_old_factor");
            if (!data.is_empty()) {
                ret = data.extractString();
            }
        }
        catch (DevFailed e) {
            JiveUtils.showTangoError(e);
        }
        return ret;
    }

    void setPollOldFactor(String value) {
        try {
            this.db.put_device_property(this.devName, JiveUtils.makeDbDatum("poll_old_factor", value));
        }
        catch (DevFailed e) {
            JiveUtils.showTangoError(e);
        }
    }

    String getPollRingDepth() {
        String ret = "10";
        try {
            DbDatum data = this.db.get_device_property(this.devName, "poll_ring_depth");
            if (!data.is_empty()) {
                ret = data.extractString();
            }
        }
        catch (DevFailed e) {
            JiveUtils.showTangoError(e);
        }
        return ret;
    }

    void setPollRingDepth(String value) {
        try {
            this.db.put_device_property(this.devName, JiveUtils.makeDbDatum("poll_ring_depth", value));
        }
        catch (DevFailed e) {
            JiveUtils.showTangoError(e);
        }
    }

    void resetConfig() {
        try {
            this.db.delete_device_property(this.devName, "polled_attr");
            this.db.delete_device_property(this.devName, "polled_cmd");
            this.db.delete_device_property(this.devName, "non_auto_polled_cmd");
            this.db.delete_device_property(this.devName, "non_auto_polled_attr");
        }
        catch (DevFailed e) {
            JiveUtils.showTangoError(e);
        }
    }

    private String[] getCommandList(DeviceProxy ds) throws DevFailed {
        int i;
        Vector<String> cmds = new Vector<String>();
        CommandInfo[] ci = ds.command_list_query();
        for (i = 0; i < ci.length; ++i) {
            if (ci[i].in_type != 0) continue;
            cmds.add(ci[i].cmd_name);
        }
        String[] ret = new String[cmds.size()];
        for (i = 0; i < cmds.size(); ++i) {
            ret[i] = (String)cmds.get(i);
        }
        return ret;
    }

    private void update(String[] ps, PInfo pi) {
        boolean found = false;
        String[] pinfo = null;
        int i = 0;
        while (i < ps.length && !found) {
            pinfo = JiveUtils.extractPollingInfo(ps[i]);
            found = pinfo[0].equalsIgnoreCase(pi.type) && pinfo[1].equalsIgnoreCase(pi.name);
            if (found) continue;
            ++i;
        }
        pi.period = found ? pinfo[2] : "";
    }

    void browsePollingStatus() {
        this.cmdPollingInfo = new Vector();
        this.attPollingInfo = new Vector();
        try {
            int i;
            DeviceProxy ds = new DeviceProxy(this.devName);
            String[] ps = ds.polling_status();
            String[] cmdList = this.getCommandList(ds);
            for (i = 0; i < cmdList.length; ++i) {
                PInfo pi = new PInfo();
                pi.name = cmdList[i];
                pi.type = "command";
                this.update(ps, pi);
                this.cmdPollingInfo.add(pi);
            }
            String[] attList = ds.get_attribute_list();
            JiveUtils.sortList(attList);
            for (i = 0; i < attList.length; ++i) {
                PInfo pi = new PInfo();
                pi.name = attList[i];
                pi.type = "attribute";
                this.update(ps, pi);
                this.attPollingInfo.add(pi);
            }
        }
        catch (DevFailed e) {
            JiveUtils.showTangoError(e);
        }
    }

    class PInfo {
        String name;
        String type;
        String period;

        PInfo() {
        }
    }
}

