/*
 * Decompiled with CFR 0.152.
 */
package jive3;

import fr.esrf.Tango.DevFailed;
import fr.esrf.TangoApi.Database;
import java.util.Vector;
import javax.swing.ImageIcon;
import jive.JiveUtils;
import jive3.PropertyNode;
import jive3.TangoNodeRenderer;
import jive3.TaskSubDevicePropertyNode;
import jive3.TreePanel;

class TaskDevicePropertyNode
extends PropertyNode {
    private Database db;
    private String devName;

    TaskDevicePropertyNode(TreePanel parent, Database db, String devName) {
        this.db = db;
        this.devName = devName;
        this.parentPanel = parent;
    }

    @Override
    void populateNode() throws DevFailed {
        int i;
        Vector nameList = new Vector();
        String[] plist = this.db.get_device_property_list(this.devName, "*");
        for (i = 0; i < plist.length; ++i) {
            int slash = plist[i].indexOf(47);
            if (slash < 0) continue;
            String subName = plist[i].substring(0, slash);
            this.addToList(nameList, subName);
        }
        for (i = 0; i < nameList.size(); ++i) {
            this.add(new TaskSubDevicePropertyNode(this.parentPanel, this.db, this.devName, (String)nameList.get(i)));
        }
    }

    @Override
    public void viewHistory() {
        this.parentPanel.invoker.historyDlg.viewDevicePropertyHistory(this.devName, "*");
        this.parentPanel.invoker.showHistory();
    }

    @Override
    ImageIcon getIcon() {
        return TangoNodeRenderer.leaficon;
    }

    @Override
    public String toString() {
        return "Properties";
    }

    @Override
    String getTitle() {
        return "Device properties";
    }

    @Override
    String getName() {
        return this.devName;
    }

    @Override
    public boolean isLeaf() {
        return false;
    }

    private void addToList(Vector v, String s) {
        int found = -1;
        int i = 0;
        while (i < v.size() && found < 0) {
            found = ((String)v.get(i)).compareToIgnoreCase(s);
            if (found >= 0) continue;
            ++i;
        }
        if (found < 0) {
            v.add(s);
        } else if (found > 0) {
            v.add(i, s);
        }
    }

    private boolean acceptProperty(String name) {
        int slash = name.indexOf(47);
        return !JiveUtils.IsPollCfgItem(name) && !JiveUtils.IsLogCfgItem(name) && !JiveUtils.IsHdbCfgItem(name) && !JiveUtils.IsSystemItem(name) && slash < 0;
    }

    private boolean acceptPropertyForCopy(String name) {
        return !JiveUtils.IsPollCfgItem(name) && !JiveUtils.IsLogCfgItem(name) && !JiveUtils.IsHdbCfgItem(name) && !JiveUtils.IsSystemItem(name);
    }

    @Override
    public void execAction(int number) {
        switch (number) {
            case 0: {
                JiveUtils.the_clipboard.clear();
                String[][] props = this.getPropertiesForCopy();
                for (int i = 0; i < props.length; ++i) {
                    JiveUtils.the_clipboard.add(props[i][0], props[i][1]);
                }
                break;
            }
            case 1: {
                JiveUtils.the_clipboard.parse();
                for (int i = 0; i < JiveUtils.the_clipboard.getObjectPropertyLength(); ++i) {
                    this.setProperty(JiveUtils.the_clipboard.getObjectPropertyName(i), JiveUtils.the_clipboard.getObjectPropertyValue(i));
                }
                this.parentPanel.refreshValues();
                break;
            }
            case 28: {
                this.viewHistory();
            }
        }
    }

    @Override
    String[][] getProperties() {
        String[][] ret = new String[0][0];
        try {
            int i;
            String[] plist = this.db.get_device_property_list(this.devName, "*");
            Vector<String> pvec = new Vector<String>();
            for (i = 0; i < plist.length; ++i) {
                if (!this.acceptProperty(plist[i])) continue;
                pvec.add(plist[i]);
                String[] res = this.db.get_device_property(this.devName, plist[i]).extractStringArray();
                pvec.add(JiveUtils.stringArrayToString(res));
            }
            ret = new String[pvec.size() / 2][2];
            for (i = 0; i < ret.length; ++i) {
                ret[i][0] = (String)pvec.get(2 * i);
                ret[i][1] = (String)pvec.get(2 * i + 1);
            }
        }
        catch (DevFailed e) {
            JiveUtils.showTangoError(e);
        }
        return ret;
    }

    String[][] getPropertiesForCopy() {
        String[][] ret = new String[0][0];
        try {
            int i;
            String[] plist = this.db.get_device_property_list(this.devName, "*");
            Vector<String> pvec = new Vector<String>();
            for (i = 0; i < plist.length; ++i) {
                if (!this.acceptPropertyForCopy(plist[i])) continue;
                pvec.add(plist[i]);
                String[] res = this.db.get_device_property(this.devName, plist[i]).extractStringArray();
                pvec.add(JiveUtils.stringArrayToString(res));
            }
            ret = new String[pvec.size() / 2][2];
            for (i = 0; i < ret.length; ++i) {
                ret[i][0] = (String)pvec.get(2 * i);
                ret[i][1] = (String)pvec.get(2 * i + 1);
            }
        }
        catch (DevFailed e) {
            JiveUtils.showTangoError(e);
        }
        return ret;
    }

    @Override
    void setProperty(String propName, String value) {
        try {
            this.db.put_device_property(this.devName, JiveUtils.makeDbDatum(propName, value));
        }
        catch (DevFailed e) {
            JiveUtils.showTangoError(e);
        }
        int slash = propName.indexOf(47);
        if (slash >= 0) {
            String subName = propName.substring(0, slash);
            this.parentPanel.refreshNode(this, subName);
        }
    }

    @Override
    void deleteProperty(String propName) {
        try {
            this.db.delete_device_property(this.devName, JiveUtils.makeDbDatum(propName, ""));
        }
        catch (DevFailed e) {
            JiveUtils.showTangoError(e);
        }
    }
}

