/*
 * Decompiled with CFR 0.152.
 */
package jive3;

import fr.esrf.Tango.DevFailed;
import fr.esrf.TangoApi.Database;
import fr.esrf.TangoApi.DbAttribute;
import javax.swing.ImageIcon;
import jive.JiveUtils;
import jive3.PropertyNode;
import jive3.TangoNodeRenderer;
import jive3.TreePanel;

class TaskClassAttributePropertyNode
extends PropertyNode {
    private Database db;
    private String className;
    private String attributeName;

    TaskClassAttributePropertyNode(TreePanel parent, Database db, String className, String attributeName) {
        this.db = db;
        this.className = className;
        this.attributeName = attributeName;
        this.parentPanel = parent;
    }

    @Override
    void populateNode() throws DevFailed {
    }

    @Override
    ImageIcon getIcon() {
        return TangoNodeRenderer.leaficon;
    }

    @Override
    public String toString() {
        return this.attributeName;
    }

    @Override
    String getTitle() {
        return "Class attribute properties";
    }

    @Override
    String getName() {
        return this.className;
    }

    String getAttributeName() {
        return this.attributeName;
    }

    @Override
    public boolean isLeaf() {
        return true;
    }

    @Override
    public void viewHistory() {
        this.parentPanel.invoker.historyDlg.viewClassAttPropertyHistory(this.className, this.attributeName, "*");
        this.parentPanel.invoker.showHistory();
    }

    @Override
    String[][] getProperties() {
        String[][] ret = new String[0][0];
        try {
            DbAttribute lst = this.db.get_class_attribute_property(this.className, this.attributeName);
            String[] plist = lst.get_property_list();
            ret = new String[plist.length][2];
            for (int i = 0; i < plist.length; ++i) {
                ret[i][0] = plist[i];
                ret[i][1] = lst.get_string_value(plist[i]);
            }
        }
        catch (DevFailed e) {
            JiveUtils.showTangoError(e);
        }
        return ret;
    }

    @Override
    void setProperty(String propName, String value) {
        try {
            DbAttribute att = new DbAttribute(this.attributeName);
            att.add(propName, JiveUtils.makeStringArray(value));
            this.db.put_class_attribute_property(this.className, att);
        }
        catch (DevFailed e) {
            JiveUtils.showTangoError(e);
        }
    }

    @Override
    void deleteProperty(String propName) {
        try {
            this.db.delete_class_attribute_property(this.className, this.attributeName, propName);
        }
        catch (DevFailed e) {
            JiveUtils.showTangoError(e);
        }
    }

    @Override
    public void execAction(int number) {
        switch (number) {
            case 0: {
                JiveUtils.the_clipboard.clear();
                String[][] props = this.getProperties();
                for (int i = 0; i < props.length; ++i) {
                    JiveUtils.the_clipboard.add(props[i][0], this.attributeName, props[i][1]);
                }
                break;
            }
            case 1: {
                JiveUtils.the_clipboard.parse();
                for (int i = 0; i < JiveUtils.the_clipboard.getAttPropertyLength(); ++i) {
                    this.setProperty(JiveUtils.the_clipboard.getAttPropertyName(i), JiveUtils.the_clipboard.getAttPropertyValue(i));
                }
                this.parentPanel.refreshValues();
                break;
            }
            case 28: {
                this.viewHistory();
            }
        }
    }
}

