/*
 * Decompiled with CFR 0.152.
 */
package jive3;

import fr.esrf.Tango.DevFailed;
import fr.esrf.TangoApi.AttributeInfoEx;
import fr.esrf.TangoApi.CommandInfo;
import fr.esrf.TangoApi.Database;
import fr.esrf.TangoApi.DbDevImportInfo;
import fr.esrf.TangoApi.DeviceData;
import fr.esrf.TangoApi.DeviceProxy;
import java.util.Vector;
import javax.swing.ImageIcon;
import jive.JiveUtils;
import jive3.TangoNode;
import jive3.TangoNodeRenderer;

public class TaskAttributeNode
extends TangoNode {
    private Database db;
    private String devName;
    private Vector attInfo;

    TaskAttributeNode(Database db, String devName) {
        this.db = db;
        this.devName = devName;
        this.attInfo = null;
    }

    @Override
    void populateNode() throws DevFailed {
    }

    @Override
    void execAction(int number) {
    }

    @Override
    ImageIcon getIcon() {
        return TangoNodeRenderer.atticon;
    }

    @Override
    public String toString() {
        return "Attribute config";
    }

    @Override
    String getTitle() {
        return "Attribute configuration";
    }

    String getName() {
        return this.devName;
    }

    @Override
    public boolean isLeaf() {
        return true;
    }

    int getAttributeNumber() {
        if (this.attInfo == null) {
            this.browseAttributeInfo();
        }
        return this.attInfo.size();
    }

    String getAttName(int idx) {
        if (this.attInfo == null) {
            this.browseAttributeInfo();
        }
        return ((AttInfo)this.attInfo.get((int)idx)).name;
    }

    String getMinAlarm(int idx) {
        if (this.attInfo == null) {
            this.browseAttributeInfo();
        }
        return ((AttInfo)this.attInfo.get((int)idx)).min_alarm;
    }

    String getMaxAlarm(int idx) {
        if (this.attInfo == null) {
            this.browseAttributeInfo();
        }
        return ((AttInfo)this.attInfo.get((int)idx)).max_alarm;
    }

    String getMinWarning(int idx) {
        if (this.attInfo == null) {
            this.browseAttributeInfo();
        }
        return ((AttInfo)this.attInfo.get((int)idx)).min_warning;
    }

    String getMaxWarning(int idx) {
        if (this.attInfo == null) {
            this.browseAttributeInfo();
        }
        return ((AttInfo)this.attInfo.get((int)idx)).max_warning;
    }

    String getDeltaT(int idx) {
        if (this.attInfo == null) {
            this.browseAttributeInfo();
        }
        return ((AttInfo)this.attInfo.get((int)idx)).delta_t;
    }

    String getDeltaVal(int idx) {
        if (this.attInfo == null) {
            this.browseAttributeInfo();
        }
        return ((AttInfo)this.attInfo.get((int)idx)).delta_val;
    }

    void setMinAlarm(int idx, String value) {
        try {
            DeviceProxy ds = new DeviceProxy(this.devName);
            AttributeInfoEx ai = ds.get_attribute_info_ex(this.getAttName(idx));
            if (ai.alarms != null) {
                ai.alarms.min_alarm = value;
            } else {
                ai.min_alarm = value;
            }
            ds.set_attribute_info(new AttributeInfoEx[]{ai});
        }
        catch (DevFailed e) {
            JiveUtils.showTangoError(e);
        }
    }

    void setMaxAlarm(int idx, String value) {
        try {
            DeviceProxy ds = new DeviceProxy(this.devName);
            AttributeInfoEx ai = ds.get_attribute_info_ex(this.getAttName(idx));
            if (ai.alarms != null) {
                ai.alarms.max_alarm = value;
            } else {
                ai.max_alarm = value;
            }
            ds.set_attribute_info(new AttributeInfoEx[]{ai});
        }
        catch (DevFailed e) {
            JiveUtils.showTangoError(e);
        }
    }

    void setMinWarning(int idx, String value) {
        try {
            DeviceProxy ds = new DeviceProxy(this.devName);
            AttributeInfoEx ai = ds.get_attribute_info_ex(this.getAttName(idx));
            if (ai.alarms != null) {
                ai.alarms.min_warning = value;
            }
            ds.set_attribute_info(new AttributeInfoEx[]{ai});
        }
        catch (DevFailed e) {
            JiveUtils.showTangoError(e);
        }
    }

    void setMaxWarning(int idx, String value) {
        try {
            DeviceProxy ds = new DeviceProxy(this.devName);
            AttributeInfoEx ai = ds.get_attribute_info_ex(this.getAttName(idx));
            if (ai.alarms != null) {
                ai.alarms.max_warning = value;
            }
            ds.set_attribute_info(new AttributeInfoEx[]{ai});
        }
        catch (DevFailed e) {
            JiveUtils.showTangoError(e);
        }
    }

    void setDeltaT(int idx, String value) {
        try {
            DeviceProxy ds = new DeviceProxy(this.devName);
            AttributeInfoEx ai = ds.get_attribute_info_ex(this.getAttName(idx));
            if (ai.alarms != null) {
                ai.alarms.delta_t = value;
            }
            ds.set_attribute_info(new AttributeInfoEx[]{ai});
        }
        catch (DevFailed e) {
            JiveUtils.showTangoError(e);
        }
    }

    void setDeltaVal(int idx, String value) {
        try {
            DeviceProxy ds = new DeviceProxy(this.devName);
            AttributeInfoEx ai = ds.get_attribute_info_ex(this.getAttName(idx));
            if (ai.alarms != null) {
                ai.alarms.delta_val = value;
            }
            ds.set_attribute_info(new AttributeInfoEx[]{ai});
        }
        catch (DevFailed e) {
            JiveUtils.showTangoError(e);
        }
    }

    void resetAlarms(int idx) {
        try {
            String[] pNames = new String[]{"min_alarm", "max_alarm", "min_warning", "max_warning", "delta_t", "delta_val"};
            this.db.delete_device_attribute_property(this.devName, this.getAttName(idx), pNames);
        }
        catch (DevFailed e) {
            JiveUtils.showTangoError(e);
        }
    }

    void resetLAlarms(int idx) {
        try {
            DeviceProxy ds = new DeviceProxy(this.devName);
            AttributeInfoEx ai = ds.get_attribute_info_ex(this.getAttName(idx));
            if (ai.alarms != null) {
                ai.alarms.min_alarm = "Not specified";
                ai.alarms.max_alarm = "Not specified";
                ai.alarms.min_warning = "Not specified";
                ai.alarms.max_warning = "Not specified";
                ai.alarms.delta_t = "Not specified";
                ai.alarms.delta_val = "Not specified";
            }
            ds.set_attribute_info(new AttributeInfoEx[]{ai});
        }
        catch (DevFailed e) {
            JiveUtils.showTangoError(e);
        }
    }

    void resetULAlarms(int idx) {
        try {
            DeviceProxy ds = new DeviceProxy(this.devName);
            AttributeInfoEx ai = ds.get_attribute_info_ex(this.getAttName(idx));
            if (ai.alarms != null) {
                ai.alarms.min_alarm = "";
                ai.alarms.max_alarm = "";
                ai.alarms.min_warning = "";
                ai.alarms.max_warning = "";
                ai.alarms.delta_t = "";
                ai.alarms.delta_val = "";
            }
            ds.set_attribute_info(new AttributeInfoEx[]{ai});
        }
        catch (DevFailed e) {
            JiveUtils.showTangoError(e);
        }
    }

    void resetCULAlarms(int idx) {
        try {
            DeviceProxy ds = new DeviceProxy(this.devName);
            AttributeInfoEx ai = ds.get_attribute_info_ex(this.getAttName(idx));
            if (ai.alarms != null) {
                ai.alarms.min_alarm = "NaN";
                ai.alarms.max_alarm = "NaN";
                ai.alarms.min_warning = "NaN";
                ai.alarms.max_warning = "NaN";
                ai.alarms.delta_t = "NaN";
                ai.alarms.delta_val = "NaN";
            }
            ds.set_attribute_info(new AttributeInfoEx[]{ai});
        }
        catch (DevFailed e) {
            JiveUtils.showTangoError(e);
        }
    }

    String getUnit(int idx) {
        if (this.attInfo == null) {
            this.browseAttributeInfo();
        }
        return ((AttInfo)this.attInfo.get((int)idx)).unit;
    }

    String getDisplayUnit(int idx) {
        if (this.attInfo == null) {
            this.browseAttributeInfo();
        }
        return ((AttInfo)this.attInfo.get((int)idx)).display_unit;
    }

    String getStandardUnit(int idx) {
        if (this.attInfo == null) {
            this.browseAttributeInfo();
        }
        return ((AttInfo)this.attInfo.get((int)idx)).standard_unit;
    }

    void setUnit(int idx, String value) {
        try {
            DeviceProxy ds = new DeviceProxy(this.devName);
            AttributeInfoEx ai = ds.get_attribute_info_ex(this.getAttName(idx));
            ai.unit = value;
            ds.set_attribute_info(new AttributeInfoEx[]{ai});
        }
        catch (DevFailed e) {
            JiveUtils.showTangoError(e);
        }
    }

    void setDisplayUnit(int idx, String value) {
        try {
            DeviceProxy ds = new DeviceProxy(this.devName);
            AttributeInfoEx ai = ds.get_attribute_info_ex(this.getAttName(idx));
            ai.display_unit = value;
            ds.set_attribute_info(new AttributeInfoEx[]{ai});
        }
        catch (DevFailed e) {
            JiveUtils.showTangoError(e);
        }
    }

    void setStandardUnit(int idx, String value) {
        try {
            DeviceProxy ds = new DeviceProxy(this.devName);
            AttributeInfoEx ai = ds.get_attribute_info_ex(this.getAttName(idx));
            ai.standard_unit = value;
            ds.set_attribute_info(new AttributeInfoEx[]{ai});
        }
        catch (DevFailed e) {
            JiveUtils.showTangoError(e);
        }
    }

    void resetUnit(int idx) {
        try {
            String[] pNames = new String[]{"unit", "display_unit", "standard_unit"};
            this.db.delete_device_attribute_property(this.devName, this.getAttName(idx), pNames);
        }
        catch (DevFailed e) {
            JiveUtils.showTangoError(e);
        }
    }

    void resetLUnit(int idx) {
        try {
            DeviceProxy ds = new DeviceProxy(this.devName);
            AttributeInfoEx ai = ds.get_attribute_info_ex(this.getAttName(idx));
            ai.unit = "Not specified";
            ai.display_unit = "Not specified";
            ai.standard_unit = "Not specified";
            ds.set_attribute_info(new AttributeInfoEx[]{ai});
        }
        catch (DevFailed e) {
            JiveUtils.showTangoError(e);
        }
    }

    void resetULUnit(int idx) {
        try {
            DeviceProxy ds = new DeviceProxy(this.devName);
            AttributeInfoEx ai = ds.get_attribute_info_ex(this.getAttName(idx));
            ai.unit = "";
            ai.display_unit = "";
            ai.standard_unit = "";
            ds.set_attribute_info(new AttributeInfoEx[]{ai});
        }
        catch (DevFailed e) {
            JiveUtils.showTangoError(e);
        }
    }

    void resetCULUnit(int idx) {
        try {
            DeviceProxy ds = new DeviceProxy(this.devName);
            AttributeInfoEx ai = ds.get_attribute_info_ex(this.getAttName(idx));
            ai.unit = "NaN";
            ai.display_unit = "NaN";
            ai.standard_unit = "NaN";
            ds.set_attribute_info(new AttributeInfoEx[]{ai});
        }
        catch (DevFailed e) {
            JiveUtils.showTangoError(e);
        }
    }

    String getMin(int idx) {
        if (this.attInfo == null) {
            this.browseAttributeInfo();
        }
        return ((AttInfo)this.attInfo.get((int)idx)).min;
    }

    String getMax(int idx) {
        if (this.attInfo == null) {
            this.browseAttributeInfo();
        }
        return ((AttInfo)this.attInfo.get((int)idx)).max;
    }

    void setMin(int idx, String value) {
        try {
            DeviceProxy ds = new DeviceProxy(this.devName);
            AttributeInfoEx ai = ds.get_attribute_info_ex(this.getAttName(idx));
            ai.min_value = value;
            ds.set_attribute_info(new AttributeInfoEx[]{ai});
        }
        catch (DevFailed e) {
            JiveUtils.showTangoError(e);
        }
    }

    void setMax(int idx, String value) {
        try {
            DeviceProxy ds = new DeviceProxy(this.devName);
            AttributeInfoEx ai = ds.get_attribute_info_ex(this.getAttName(idx));
            ai.max_value = value;
            ds.set_attribute_info(new AttributeInfoEx[]{ai});
        }
        catch (DevFailed e) {
            JiveUtils.showTangoError(e);
        }
    }

    void resetRange(int idx) {
        try {
            String[] pNames = new String[]{"min_value", "max_value"};
            this.db.delete_device_attribute_property(this.devName, this.getAttName(idx), pNames);
        }
        catch (DevFailed e) {
            JiveUtils.showTangoError(e);
        }
    }

    void resetLRange(int idx) {
        try {
            DeviceProxy ds = new DeviceProxy(this.devName);
            AttributeInfoEx ai = ds.get_attribute_info_ex(this.getAttName(idx));
            ai.min_value = "Not specified";
            ai.max_value = "Not specified";
            ds.set_attribute_info(new AttributeInfoEx[]{ai});
        }
        catch (DevFailed e) {
            JiveUtils.showTangoError(e);
        }
    }

    void resetULRange(int idx) {
        try {
            DeviceProxy ds = new DeviceProxy(this.devName);
            AttributeInfoEx ai = ds.get_attribute_info_ex(this.getAttName(idx));
            ai.min_value = "";
            ai.max_value = "";
            ds.set_attribute_info(new AttributeInfoEx[]{ai});
        }
        catch (DevFailed e) {
            JiveUtils.showTangoError(e);
        }
    }

    void resetCULRange(int idx) {
        try {
            DeviceProxy ds = new DeviceProxy(this.devName);
            AttributeInfoEx ai = ds.get_attribute_info_ex(this.getAttName(idx));
            ai.min_value = "NaN";
            ai.max_value = "NaN";
            ds.set_attribute_info(new AttributeInfoEx[]{ai});
        }
        catch (DevFailed e) {
            JiveUtils.showTangoError(e);
        }
    }

    String getLabel(int idx) {
        if (this.attInfo == null) {
            this.browseAttributeInfo();
        }
        return ((AttInfo)this.attInfo.get((int)idx)).label;
    }

    String getFormat(int idx) {
        if (this.attInfo == null) {
            this.browseAttributeInfo();
        }
        return ((AttInfo)this.attInfo.get((int)idx)).format;
    }

    void setLabel(int idx, String value) {
        try {
            DeviceProxy ds = new DeviceProxy(this.devName);
            AttributeInfoEx ai = ds.get_attribute_info_ex(this.getAttName(idx));
            ai.label = value;
            ds.set_attribute_info(new AttributeInfoEx[]{ai});
        }
        catch (DevFailed e) {
            JiveUtils.showTangoError(e);
        }
    }

    void setFormat(int idx, String value) {
        try {
            DeviceProxy ds = new DeviceProxy(this.devName);
            AttributeInfoEx ai = ds.get_attribute_info_ex(this.getAttName(idx));
            ai.format = value;
            ds.set_attribute_info(new AttributeInfoEx[]{ai});
        }
        catch (DevFailed e) {
            JiveUtils.showTangoError(e);
        }
    }

    void resetDisplay(int idx) {
        try {
            String[] pNames = new String[]{"label", "format"};
            this.db.delete_device_attribute_property(this.devName, this.getAttName(idx), pNames);
        }
        catch (DevFailed e) {
            JiveUtils.showTangoError(e);
        }
    }

    void resetLDisplay(int idx) {
        try {
            DeviceProxy ds = new DeviceProxy(this.devName);
            AttributeInfoEx ai = ds.get_attribute_info_ex(this.getAttName(idx));
            ai.label = "Not specified";
            ai.format = "Not specified";
            ds.set_attribute_info(new AttributeInfoEx[]{ai});
        }
        catch (DevFailed e) {
            JiveUtils.showTangoError(e);
        }
    }

    void resetULDisplay(int idx) {
        try {
            DeviceProxy ds = new DeviceProxy(this.devName);
            AttributeInfoEx ai = ds.get_attribute_info_ex(this.getAttName(idx));
            ai.label = "";
            ai.format = "";
            ds.set_attribute_info(new AttributeInfoEx[]{ai});
        }
        catch (DevFailed e) {
            JiveUtils.showTangoError(e);
        }
    }

    void resetCULDisplay(int idx) {
        try {
            DeviceProxy ds = new DeviceProxy(this.devName);
            AttributeInfoEx ai = ds.get_attribute_info_ex(this.getAttName(idx));
            ai.label = "NaN";
            ai.format = "NaN";
            ds.set_attribute_info(new AttributeInfoEx[]{ai});
        }
        catch (DevFailed e) {
            JiveUtils.showTangoError(e);
        }
    }

    String getDescription(int idx) {
        if (this.attInfo == null) {
            this.browseAttributeInfo();
        }
        return ((AttInfo)this.attInfo.get((int)idx)).descr;
    }

    void setDescription(int idx, String value) {
        try {
            DeviceProxy ds = new DeviceProxy(this.devName);
            AttributeInfoEx ai = ds.get_attribute_info_ex(this.getAttName(idx));
            ai.description = value;
            ds.set_attribute_info(new AttributeInfoEx[]{ai});
        }
        catch (DevFailed e) {
            JiveUtils.showTangoError(e);
        }
    }

    void resetDescription(int idx) {
        try {
            String[] pNames = new String[]{"description"};
            this.db.delete_device_attribute_property(this.devName, this.getAttName(idx), pNames);
        }
        catch (DevFailed e) {
            JiveUtils.showTangoError(e);
        }
    }

    void resetLDescription(int idx) {
        try {
            DeviceProxy ds = new DeviceProxy(this.devName);
            AttributeInfoEx ai = ds.get_attribute_info_ex(this.getAttName(idx));
            ai.description = "Not specified";
            ds.set_attribute_info(new AttributeInfoEx[]{ai});
        }
        catch (DevFailed e) {
            JiveUtils.showTangoError(e);
        }
    }

    void resetULDescription(int idx) {
        try {
            DeviceProxy ds = new DeviceProxy(this.devName);
            AttributeInfoEx ai = ds.get_attribute_info_ex(this.getAttName(idx));
            ai.description = "";
            ds.set_attribute_info(new AttributeInfoEx[]{ai});
        }
        catch (DevFailed e) {
            JiveUtils.showTangoError(e);
        }
    }

    void resetCULDescription(int idx) {
        try {
            DeviceProxy ds = new DeviceProxy(this.devName);
            AttributeInfoEx ai = ds.get_attribute_info_ex(this.getAttName(idx));
            ai.description = "";
            ds.set_attribute_info(new AttributeInfoEx[]{ai});
        }
        catch (DevFailed e) {
            JiveUtils.showTangoError(e);
        }
    }

    void setAlias(int idx, String value) {
        try {
            String fullAttName = this.devName + "/" + this.getAttName(idx);
            if (value.equalsIgnoreCase("none") || value.length() == 0) {
                String currentAlias = this.db.get_alias_from_attribute(fullAttName);
                this.db.delete_attribute_alias(currentAlias);
            } else {
                this.db.put_attribute_alias(fullAttName, value);
            }
        }
        catch (DevFailed e) {
            JiveUtils.showTangoError(e);
        }
    }

    String getAlias(int idx) {
        try {
            String fullAttName = this.devName + "/" + this.getAttName(idx);
            return this.db.get_alias_from_attribute(fullAttName);
        }
        catch (DevFailed devFailed) {
            return "None";
        }
    }

    void browseAttributeInfo() {
        try {
            DeviceProxy ds = new DeviceProxy(this.devName);
            this.attInfo = new Vector();
            String[] attList = ds.get_attribute_list();
            JiveUtils.sortList(attList);
            for (int i = 0; i < attList.length; ++i) {
                AttributeInfoEx ai = ds.get_attribute_info_ex(attList[i]);
                AttInfo ei = new AttInfo();
                ei.name = attList[i];
                if (ai.alarms != null) {
                    ei.min_alarm = this.reformat(ai.alarms.min_alarm);
                    ei.max_alarm = this.reformat(ai.alarms.max_alarm);
                    ei.min_warning = this.reformat(ai.alarms.min_warning);
                    ei.max_warning = this.reformat(ai.alarms.max_warning);
                    ei.delta_t = this.reformat(ai.alarms.delta_t);
                    ei.delta_val = this.reformat(ai.alarms.delta_val);
                } else {
                    ei.min_alarm = this.reformat(ai.min_alarm);
                    ei.max_alarm = this.reformat(ai.max_alarm);
                    ei.min_warning = "None";
                    ei.max_warning = "None";
                    ei.delta_t = "None";
                    ei.delta_val = "None";
                }
                ei.unit = this.reformat(ai.unit);
                ei.display_unit = this.reformat(ai.display_unit);
                ei.standard_unit = this.reformat(ai.standard_unit);
                ei.min = this.reformat(ai.min_value);
                ei.max = this.reformat(ai.max_value);
                ei.format = this.reformat(ai.format);
                ei.label = this.reformat(ai.label);
                ei.descr = this.reformat(ai.description);
                this.attInfo.add(ei);
            }
        }
        catch (DevFailed e) {
            JiveUtils.showTangoError(e);
        }
    }

    public boolean isTango8() {
        try {
            DbDevImportInfo info = this.db.import_device(this.devName);
            DeviceProxy ds = new DeviceProxy("dserver/" + info.server);
            CommandInfo[] cmds = ds.command_list_query();
            boolean found = false;
            int i = 0;
            while (!found && i < cmds.length) {
                found = cmds[i].cmd_name.equalsIgnoreCase("ZmqEventSubscriptionChange");
                if (found) continue;
                ++i;
            }
            return found;
        }
        catch (DevFailed e) {
            return false;
        }
    }

    public void restartDevice() {
        try {
            DbDevImportInfo info = this.db.import_device(this.devName);
            DeviceProxy ds = new DeviceProxy("dserver/" + info.server);
            DeviceData in = new DeviceData();
            in.insert(this.devName);
            ds.command_inout("DevRestart", in);
        }
        catch (DevFailed e) {
            JiveUtils.showTangoError(e);
        }
    }

    private String reformat(String s) {
        if (s.equalsIgnoreCase("Not specified") || s.equalsIgnoreCase("No standard unit") || s.equalsIgnoreCase("No unit") || s.equalsIgnoreCase("No description") || s.equalsIgnoreCase("No display unit")) {
            return "None";
        }
        return s;
    }

    class AttInfo {
        String name;
        String min_alarm;
        String max_alarm;
        String min_warning;
        String max_warning;
        String delta_t;
        String delta_val;
        String unit;
        String display_unit;
        String standard_unit;
        String min;
        String max;
        String format;
        String label;
        String descr;

        AttInfo() {
        }
    }
}

