/*
 * Decompiled with CFR 0.152.
 */
package jive3;

import fr.esrf.Tango.DevFailed;
import fr.esrf.TangoApi.Database;
import fr.esrf.TangoApi.DbDatum;
import fr.esrf.tangoatk.widget.util.ATKConstant;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.table.DefaultTableModel;
import jive.JiveUtils;
import jive.MultiLineCellEditor;
import jive.MultiLineCellRenderer;
import jive3.MultiLineInputDlg;
import jive3.PItem;

public class SelectionDlg
extends JFrame
implements ActionListener {
    Database db = null;
    String[] colName = new String[]{"Name", "Value"};
    private MultiLineCellEditor editor;
    JTextField selectionText;
    JLabel selectionLabel;
    JButton searchButton;
    JButton applyAllButton;
    JButton applyButton;
    JButton dismissButton;
    JLabel infoLabel;
    DefaultTableModel dm;
    JTable theTable;
    String selectText;
    Vector<PItem> items;

    public SelectionDlg() {
        this.initComponents();
    }

    public void setDatabase(Database db) {
        this.db = db;
    }

    public void clear() {
        this.items.clear();
        this.infoLabel.setText(this.items.size() + " item(s)");
        Object[][] prop = new String[0][2];
        this.dm.setDataVector(prop, this.colName);
        this.editor.updateRows();
        this.theTable.getColumnModel().getColumn(1).setPreferredWidth(250);
        this.theTable.validate();
        ((JPanel)this.getContentPane()).revalidate();
    }

    void initComponents() {
        this.getContentPane().setLayout(new BorderLayout());
        JPanel innerPanel = new JPanel();
        innerPanel.setLayout(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.weightx = 0.0;
        gbc.fill = 3;
        JLabel selectionLabel = new JLabel(" Selection ");
        selectionLabel.setFont(ATKConstant.labelFont);
        innerPanel.add((Component)selectionLabel, gbc);
        gbc.gridx = 1;
        gbc.gridy = 0;
        gbc.weightx = 1.0;
        gbc.fill = 1;
        this.selectionText = new JTextField();
        this.selectionText.addActionListener(this);
        this.selectionText.setFont(ATKConstant.labelFont);
        innerPanel.add((Component)this.selectionText, gbc);
        gbc.gridx = 2;
        gbc.gridy = 0;
        gbc.weightx = 0.0;
        gbc.fill = 3;
        this.searchButton = new JButton("Search");
        this.searchButton.addActionListener(this);
        innerPanel.add((Component)this.searchButton, gbc);
        JPanel innerPanel2 = new JPanel();
        innerPanel2.setLayout(new FlowLayout(2));
        this.infoLabel = new JLabel("0 item(s)");
        this.infoLabel.setFont(ATKConstant.labelFont);
        innerPanel2.add(this.infoLabel);
        this.applyAllButton = new JButton("Apply to all ...");
        this.applyAllButton.setToolTipText("Ask for a value and apply it to the current selection");
        this.applyAllButton.addActionListener(this);
        innerPanel2.add(this.applyAllButton);
        this.applyButton = new JButton("Apply");
        this.applyButton.setToolTipText("Apply change to the database");
        this.applyButton.addActionListener(this);
        this.applyButton.setEnabled(false);
        innerPanel2.add(this.applyButton);
        this.dismissButton = new JButton("Dismiss");
        this.dismissButton.addActionListener(this);
        innerPanel2.add(this.dismissButton);
        this.getContentPane().add((Component)innerPanel, "North");
        this.getContentPane().add((Component)innerPanel2, "South");
        this.dm = new DefaultTableModel(){

            public Class getColumnClass(int columnIndex) {
                return String.class;
            }

            @Override
            public boolean isCellEditable(int row, int column) {
                return column == 1;
            }

            @Override
            public void setValueAt(Object aValue, int row, int column) {
                if (!aValue.equals(this.getValueAt(row, column))) {
                    super.setValueAt(aValue, row, column);
                    SelectionDlg.this.items.get((int)row).value = JiveUtils.makeStringArray((String)aValue);
                    SelectionDlg.this.items.get((int)row).updated = true;
                    SelectionDlg.this.applyButton.setEnabled(true);
                }
            }
        };
        this.theTable = new JTable(this.dm);
        this.editor = new MultiLineCellEditor(this.theTable);
        this.theTable.setDefaultEditor(String.class, this.editor);
        MultiLineCellRenderer renderer = new MultiLineCellRenderer(false, false, false);
        this.theTable.setDefaultRenderer(String.class, renderer);
        this.theTable.setSelectionMode(0);
        JScrollPane textView = new JScrollPane(this.theTable);
        this.getContentPane().add((Component)textView, "Center");
        this.setTitle("Multiple selection");
        this.setPreferredSize(new Dimension(800, 600));
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                SelectionDlg.this.exitDlg();
                super.windowClosing(e);
            }
        });
        this.items = new Vector();
        this.clear();
    }

    private void selectProperty() {
        this.refresh();
    }

    private void refresh() {
        String selectText = this.selectionText.getText();
        int slashCount = 0;
        for (int i = 0; i < selectText.length(); ++i) {
            if (selectText.charAt(i) != '/') continue;
            ++slashCount;
        }
        if (slashCount != 3) {
            JiveUtils.showJiveError("Invalid selection pattern, 4 slash separated fields expected");
            return;
        }
        try {
            int idx = selectText.lastIndexOf(47);
            String devName = selectText.substring(0, idx);
            String propName = selectText.substring(idx + 1);
            this.items.clear();
            String[] devNames = this.db.get_device_list(devName);
            for (int i = 0; i < devNames.length; ++i) {
                String[] pList = this.db.get_device_property_list(devNames[i], propName);
                for (int j = 0; j < pList.length; ++j) {
                    PItem pi = new PItem();
                    pi.devName = devNames[i];
                    pi.pName = pList[j];
                    pi.updated = false;
                    DbDatum dbd = this.db.get_device_property(pi.devName, pi.pName);
                    pi.value = dbd.extractStringArray();
                    this.items.add(pi);
                }
            }
            if (this.items.size() == 0) {
                JOptionPane.showMessageDialog(this, "No property found");
            }
            this.infoLabel.setText(this.items.size() + " item(s)");
            this.refreshTable();
        }
        catch (DevFailed e) {
            JiveUtils.showTangoError(e);
        }
    }

    private void refreshTable() {
        Object[][] prop = new String[this.items.size()][2];
        for (int i = 0; i < this.items.size(); ++i) {
            prop[i][0] = this.items.get((int)i).devName + "/" + this.items.get((int)i).pName;
            prop[i][1] = this.items.get(i).toString();
        }
        this.dm.setDataVector(prop, this.colName);
        this.editor.updateRows();
        this.theTable.getColumnModel().getColumn(1).setPreferredWidth(250);
        this.theTable.validate();
        ((JPanel)this.getContentPane()).revalidate();
    }

    private void applyAll() {
        if (this.items.size() == 0) {
            JOptionPane.showMessageDialog(this, "No selection");
            return;
        }
        String[] newValue = MultiLineInputDlg.getInputText(this, "Apply to all", "Apply to " + this.items.size() + " item(s)", this.items.get((int)0).value);
        if (newValue != null) {
            for (int i = 0; i < this.items.size(); ++i) {
                this.items.get((int)i).value = newValue;
                this.items.get((int)i).updated = true;
            }
            this.apply();
            this.refreshTable();
        }
    }

    private void apply() {
        try {
            for (int i = 0; i < this.items.size(); ++i) {
                PItem pi = this.items.get(i);
                if (pi.updated) {
                    DbDatum[] ds = new DbDatum[1];
                    DbDatum d = new DbDatum(pi.pName);
                    d.insert(pi.value);
                    ds[0] = d;
                    this.db.put_device_property(pi.devName, ds);
                }
                pi.updated = false;
            }
        }
        catch (DevFailed e) {
            JiveUtils.showTangoError(e);
        }
        this.applyButton.setEnabled(false);
    }

    public boolean hasChanged() {
        boolean hasChanged = false;
        int i = 0;
        while (!hasChanged && i < this.items.size()) {
            hasChanged = this.items.get((int)i).updated;
            if (hasChanged) continue;
            ++i;
        }
        return hasChanged;
    }

    private void exitDlg() {
        int ok;
        if (this.hasChanged() && (ok = JOptionPane.showConfirmDialog(this, "Some properties have changed\nDo you want to update the database ?", "Confirmation", 0)) == 0) {
            this.apply();
        }
    }

    @Override
    public void actionPerformed(ActionEvent evt) {
        Object src = evt.getSource();
        if (src == this.searchButton || src == this.selectionText) {
            this.selectProperty();
        } else if (src == this.dismissButton) {
            this.exitDlg();
            this.setVisible(false);
        } else if (src == this.applyButton) {
            this.apply();
        } else if (src == this.applyAllButton) {
            this.applyAll();
        }
    }
}

