/*
 * Decompiled with CFR 0.152.
 */
package jive3;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import javax.swing.tree.TreePath;
import jive.JiveUtils;
import jive3.ComboItem;
import jive3.NavigationListener;

public class NavigationBar
extends JPanel
implements ActionListener,
KeyListener {
    private static final Insets nullInsets = new Insets(0, 0, 0, 0);
    private JButton backBtn;
    private JButton forwardBtn;
    private JComboBox searchText;
    private JButton searchBtn;
    private JButton refreshBtn;
    private Vector<NavigationListener> listeners;
    private JButton upBtn;
    private JButton downBtn;
    private boolean isUpdating;

    NavigationBar() {
        this.setLayout(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        this.backBtn = new JButton();
        this.backBtn.setDisabledIcon(new ImageIcon(NavigationBar.class.getResource("/jive/bw_btn_disa.gif")));
        this.backBtn.setPressedIcon(new ImageIcon(NavigationBar.class.getResource("/jive/bw_btn_pressed.gif")));
        this.backBtn.setIcon(new ImageIcon(NavigationBar.class.getResource("/jive/bw_btn.gif")));
        this.backBtn.setMargin(nullInsets);
        this.backBtn.addActionListener(this);
        this.backBtn.setToolTipText("Go back");
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.weightx = 0.0;
        gbc.fill = 3;
        this.add((Component)this.backBtn, gbc);
        this.forwardBtn = new JButton();
        this.forwardBtn.setDisabledIcon(new ImageIcon(NavigationBar.class.getResource("/jive/fw_btn_disa.gif")));
        this.forwardBtn.setPressedIcon(new ImageIcon(NavigationBar.class.getResource("/jive/fw_btn_pressed.gif")));
        this.forwardBtn.setIcon(new ImageIcon(NavigationBar.class.getResource("/jive/fw_btn.gif")));
        this.forwardBtn.setMargin(nullInsets);
        this.forwardBtn.addActionListener(this);
        this.forwardBtn.setToolTipText("Go forward");
        gbc.gridx = 1;
        gbc.gridy = 0;
        gbc.weightx = 0.0;
        gbc.fill = 3;
        this.add((Component)this.forwardBtn, gbc);
        this.refreshBtn = new JButton();
        this.refreshBtn.setPressedIcon(new ImageIcon(NavigationBar.class.getResource("/jive/refresh_btn_pressed.gif")));
        this.refreshBtn.setIcon(new ImageIcon(NavigationBar.class.getResource("/jive/refresh_btn.gif")));
        this.refreshBtn.setMargin(nullInsets);
        this.refreshBtn.addActionListener(this);
        this.refreshBtn.setToolTipText("Refresh the tree");
        gbc.gridx = 2;
        gbc.gridy = 0;
        gbc.weightx = 0.0;
        gbc.fill = 3;
        this.add((Component)this.refreshBtn, gbc);
        this.isUpdating = true;
        this.searchText = new JComboBox();
        this.searchText.setEditable(true);
        this.searchText.getEditor().getEditorComponent().addKeyListener(this);
        this.searchText.addActionListener(this);
        gbc.gridx = 3;
        gbc.gridy = 0;
        gbc.weightx = 1.0;
        gbc.fill = 1;
        this.add((Component)this.searchText, gbc);
        this.isUpdating = false;
        this.downBtn = new JButton();
        this.downBtn.setPressedIcon(new ImageIcon(NavigationBar.class.getResource("/jive/down_btn_pressed.gif")));
        this.downBtn.setIcon(new ImageIcon(NavigationBar.class.getResource("/jive/down_btn.gif")));
        this.downBtn.setDisabledIcon(new ImageIcon(NavigationBar.class.getResource("/jive/down_btn_disa.gif")));
        this.downBtn.setMargin(nullInsets);
        this.downBtn.addActionListener(this);
        this.downBtn.setToolTipText("Next occurence");
        gbc.gridx = 4;
        gbc.gridy = 0;
        gbc.weightx = 0.0;
        gbc.fill = 3;
        this.add((Component)this.downBtn, gbc);
        this.searchBtn = new JButton();
        this.searchBtn.setPressedIcon(new ImageIcon(NavigationBar.class.getResource("/jive/search_btn_pressed.gif")));
        this.searchBtn.setIcon(new ImageIcon(NavigationBar.class.getResource("/jive/search_btn.gif")));
        this.searchBtn.setMargin(nullInsets);
        this.searchBtn.addActionListener(this);
        this.searchBtn.setToolTipText("Search");
        gbc.gridx = 5;
        gbc.gridy = 0;
        gbc.weightx = 0.0;
        gbc.fill = 3;
        this.add((Component)this.searchBtn, gbc);
        this.listeners = new Vector();
    }

    public void addNavigationListener(NavigationListener l) {
        this.listeners.add(l);
    }

    public void removeNavigationListener(NavigationListener l) {
        this.listeners.remove(l);
    }

    public String getSearchText() {
        return this.searchText.getEditor().getItem().toString();
    }

    public TreePath getSelectedItemPath() {
        Object selectedItem = this.searchText.getSelectedItem();
        if (selectedItem instanceof ComboItem) {
            ComboItem item = (ComboItem)selectedItem;
            return item.path;
        }
        return null;
    }

    public void addLink(TreePath path) {
        this.isUpdating = true;
        int idx = this.addSearchText(JiveUtils.getPathAsText(path), path);
        this.searchText.setSelectedIndex(idx);
        this.isUpdating = false;
    }

    public void enableBack(boolean enable) {
        this.backBtn.setEnabled(enable);
    }

    public void enableForward(boolean enable) {
        this.forwardBtn.setEnabled(enable);
    }

    public void enableNextOcc(boolean enable) {
        this.downBtn.setEnabled(enable);
    }

    public void enablePreviousOcc(boolean enable) {
    }

    @Override
    public void actionPerformed(ActionEvent evt) {
        block8: {
            TreePath path;
            Object src;
            block12: {
                block11: {
                    block10: {
                        block9: {
                            block7: {
                                src = evt.getSource();
                                if (src != this.backBtn) break block7;
                                for (int i = 0; i < this.listeners.size(); ++i) {
                                    this.listeners.get(i).backAction(this);
                                }
                                break block8;
                            }
                            if (src != this.forwardBtn) break block9;
                            for (int i = 0; i < this.listeners.size(); ++i) {
                                this.listeners.get(i).forwardAction(this);
                            }
                            break block8;
                        }
                        if (src != this.refreshBtn) break block10;
                        for (int i = 0; i < this.listeners.size(); ++i) {
                            this.listeners.get(i).refreshAction(this);
                        }
                        break block8;
                    }
                    if (src != this.downBtn) break block11;
                    for (int i = 0; i < this.listeners.size(); ++i) {
                        this.listeners.get(i).nextOccAction(this);
                    }
                    break block8;
                }
                if (src != this.searchBtn) break block12;
                TreePath path2 = this.getSelectedItemPath();
                for (int i = 0; i < this.listeners.size(); ++i) {
                    this.listeners.get(i).searchAction(this, path2);
                }
                if (path2 != null) break block8;
                this.isUpdating = true;
                this.addSearchText(this.getSearchText(), null);
                this.isUpdating = false;
                break block8;
            }
            if (src == this.searchText && !this.isUpdating && (path = this.getSelectedItemPath()) != null) {
                for (int i = 0; i < this.listeners.size(); ++i) {
                    this.listeners.get(i).searchAction(this, path);
                }
            }
        }
    }

    @Override
    public void keyTyped(KeyEvent e) {
    }

    @Override
    public void keyPressed(KeyEvent e) {
    }

    @Override
    public void keyReleased(KeyEvent e) {
        if (e.getKeyCode() == 10) {
            TreePath path = this.getSelectedItemPath();
            for (int i = 0; i < this.listeners.size(); ++i) {
                this.listeners.get(i).searchAction(this, path);
            }
            this.isUpdating = true;
            this.addSearchText(this.getSearchText(), null);
            this.isUpdating = false;
        }
    }

    private int addSearchText(String text, TreePath path) {
        boolean found = false;
        boolean alreadyThere = false;
        int i = 0;
        while (i < this.searchText.getItemCount() && !found) {
            int cmp = text.compareToIgnoreCase(this.searchText.getItemAt(i).toString());
            alreadyThere = cmp == 0;
            found = cmp <= 0;
            if (found) continue;
            ++i;
        }
        ComboItem item = new ComboItem();
        item.text = text;
        item.path = path;
        if (!alreadyThere) {
            this.searchText.insertItemAt(item, i);
        }
        return i;
    }
}

