/*
 * Decompiled with CFR 0.152.
 */
package jive3;

import fr.esrf.tangoatk.widget.util.ATKConstant;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableModel;
import jive.JiveUtils;
import jive3.MultiChangeConfirmDlg;
import jive3.ProgressFrame;
import jive3.TaskPollingNode;

public class DevicePollingPanel
extends JPanel
implements MouseListener,
ActionListener {
    private JTabbedPane tabPane;
    private JTable cmdTable;
    private DefaultTableModel cmdModel;
    private JTable attTable;
    private DefaultTableModel attModel;
    private JTable adminTable;
    private DefaultTableModel adminModel;
    private JButton refreshButton;
    private JButton applyButton;
    private JButton resetButton;
    private JPopupMenu tableMenu;
    private JMenuItem enablePollingMenuItem;
    private JMenuItem disablePollingMenuItem;
    private JMenuItem setPeriodMenuItem;
    private JTable selectedTable;
    private int[] selectedRows;
    private TaskPollingNode[] source = null;

    DevicePollingPanel() {
        this.setLayout(new BorderLayout());
        this.cmdModel = new DefaultTableModel(){

            public Class getColumnClass(int columnIndex) {
                if (columnIndex == 1) {
                    return Boolean.class;
                }
                return String.class;
            }

            @Override
            public boolean isCellEditable(int row, int column) {
                return column != 0 && !JiveUtils.readOnly;
            }

            @Override
            public void setValueAt(Object aValue, int row, int column) {
                if (!aValue.equals(this.getValueAt(row, column))) {
                    super.setValueAt(aValue, row, column);
                    String name = (String)DevicePollingPanel.this.cmdModel.getValueAt(row, 0);
                    boolean polled = (Boolean)DevicePollingPanel.this.cmdModel.getValueAt(row, 1);
                    String period = (String)DevicePollingPanel.this.cmdModel.getValueAt(row, 2);
                    if (column == 2) {
                        polled = true;
                    }
                    int nb = DevicePollingPanel.this.source.length;
                    int k = 0;
                    if (DevicePollingPanel.this.source.length > 1) {
                        Vector<String> propChange = new Vector<String>();
                        propChange.add("IsPolled");
                        propChange.add(Boolean.toString(polled));
                        propChange.add("Period");
                        propChange.add(period);
                        if (!MultiChangeConfirmDlg.confirmChange(propChange, DevicePollingPanel.this.source.length, " for command " + name)) {
                            DevicePollingPanel.this.refreshValue();
                            return;
                        }
                    }
                    if (nb > 1) {
                        ProgressFrame.displayProgress("Updating polling");
                    }
                    for (int i = 0; i < DevicePollingPanel.this.source.length; ++i) {
                        ProgressFrame.setProgress("Updating " + DevicePollingPanel.this.source[i].getName() + "/" + name, ++k * 100 / nb);
                        DevicePollingPanel.this.source[i].updateCommandPolling(name, polled, period);
                    }
                    ProgressFrame.hideProgress();
                    DevicePollingPanel.this.refreshValue();
                }
            }
        };
        this.cmdTable = new JTable(this.cmdModel);
        this.cmdTable.addMouseListener(this);
        JScrollPane cmdView = new JScrollPane(this.cmdTable);
        this.attModel = new DefaultTableModel(){

            public Class getColumnClass(int columnIndex) {
                if (columnIndex == 1) {
                    return Boolean.class;
                }
                return String.class;
            }

            @Override
            public boolean isCellEditable(int row, int column) {
                return column != 0 && !JiveUtils.readOnly;
            }

            @Override
            public void setValueAt(Object aValue, int row, int column) {
                if (!aValue.equals(this.getValueAt(row, column))) {
                    super.setValueAt(aValue, row, column);
                    String name = (String)DevicePollingPanel.this.attModel.getValueAt(row, 0);
                    boolean polled = (Boolean)DevicePollingPanel.this.attModel.getValueAt(row, 1);
                    String period = (String)DevicePollingPanel.this.attModel.getValueAt(row, 2);
                    if (column == 2) {
                        polled = true;
                    }
                    int nb = DevicePollingPanel.this.source.length;
                    int k = 0;
                    if (DevicePollingPanel.this.source.length > 1) {
                        Vector<String> propChange = new Vector<String>();
                        propChange.add("IsPolled");
                        propChange.add(Boolean.toString(polled));
                        propChange.add("Period");
                        propChange.add(period);
                        if (!MultiChangeConfirmDlg.confirmChange(propChange, DevicePollingPanel.this.source.length, " for attribute " + name)) {
                            DevicePollingPanel.this.refreshValue();
                            return;
                        }
                    }
                    if (nb > 1) {
                        ProgressFrame.displayProgress("Updating polling");
                    }
                    for (int i = 0; i < DevicePollingPanel.this.source.length; ++i) {
                        ProgressFrame.setProgress("Updating " + DevicePollingPanel.this.source[i].getName() + "/" + name, ++k * 100 / nb);
                        DevicePollingPanel.this.source[i].updateAttributePolling(name, polled, period);
                    }
                    ProgressFrame.hideProgress();
                    DevicePollingPanel.this.refreshValue();
                }
            }
        };
        this.attTable = new JTable(this.attModel);
        this.attTable.addMouseListener(this);
        JScrollPane attView = new JScrollPane(this.attTable);
        this.adminModel = new DefaultTableModel(){

            public Class getColumnClass(int columnIndex) {
                return String.class;
            }

            @Override
            public boolean isCellEditable(int row, int column) {
                return column != 0 && !JiveUtils.readOnly;
            }

            @Override
            public void setValueAt(Object aValue, int row, int column) {
                if (!aValue.equals(this.getValueAt(row, column))) {
                    super.setValueAt(aValue, row, column);
                    int nb = DevicePollingPanel.this.source.length;
                    int k = 0;
                    if (DevicePollingPanel.this.source.length > 1) {
                        Vector<String> propChange = new Vector<String>();
                        if (row == 0) {
                            propChange.add("PollOldFactor");
                            propChange.add((String)aValue);
                        } else {
                            propChange.add("PollRingDepth");
                            propChange.add((String)aValue);
                        }
                        if (!MultiChangeConfirmDlg.confirmChange(propChange, DevicePollingPanel.this.source.length)) {
                            DevicePollingPanel.this.refreshValue();
                            return;
                        }
                    }
                    if (nb > 1) {
                        ProgressFrame.displayProgress("Updating polling");
                    }
                    if (row == 0) {
                        for (int i = 0; i < DevicePollingPanel.this.source.length; ++i) {
                            ProgressFrame.setProgress("Updating " + DevicePollingPanel.this.source[i].getName() + "/PollOldFactor", ++k * 100 / nb);
                            DevicePollingPanel.this.source[i].setPollOldFactor((String)aValue);
                        }
                    } else {
                        for (int i = 0; i < DevicePollingPanel.this.source.length; ++i) {
                            ProgressFrame.setProgress("Updating " + DevicePollingPanel.this.source[i].getName() + "/PollRingDepth", ++k * 100 / nb);
                            DevicePollingPanel.this.source[i].setPollRingDepth((String)aValue);
                        }
                    }
                    ProgressFrame.hideProgress();
                    DevicePollingPanel.this.refreshValue();
                }
            }
        };
        this.adminTable = new JTable(this.adminModel);
        this.adminTable.addMouseListener(this);
        JScrollPane adminView = new JScrollPane(this.adminTable);
        this.tabPane = new JTabbedPane();
        this.tabPane.setFont(ATKConstant.labelFont);
        this.tabPane.add("Command", cmdView);
        this.tabPane.add("Attribute", attView);
        this.tabPane.add("Settings", adminView);
        TitledBorder b = BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "...");
        this.tabPane.setBorder(b);
        this.add((Component)this.tabPane, "Center");
        JPanel btnPanel = new JPanel(new FlowLayout(0));
        this.refreshButton = new JButton("Refresh");
        this.refreshButton.addActionListener(this);
        btnPanel.add(this.refreshButton);
        this.applyButton = new JButton("Apply");
        this.applyButton.setEnabled(!JiveUtils.readOnly);
        this.applyButton.addActionListener(this);
        btnPanel.add(this.applyButton);
        this.resetButton = new JButton("Reset");
        this.resetButton.setEnabled(!JiveUtils.readOnly);
        this.resetButton.addActionListener(this);
        btnPanel.add(this.resetButton);
        this.add((Component)btnPanel, "South");
        this.tableMenu = new JPopupMenu();
        this.enablePollingMenuItem = new JMenuItem("Enable polling");
        this.enablePollingMenuItem.addActionListener(this);
        this.disablePollingMenuItem = new JMenuItem("Disable polling");
        this.disablePollingMenuItem.addActionListener(this);
        this.setPeriodMenuItem = new JMenuItem("Set period");
        this.setPeriodMenuItem.addActionListener(this);
        this.tableMenu.add(this.enablePollingMenuItem);
        this.tableMenu.add(this.disablePollingMenuItem);
        this.tableMenu.add(this.setPeriodMenuItem);
    }

    @Override
    public void mousePressed(MouseEvent e) {
        int row;
        this.selectedTable = (JTable)e.getSource();
        if (!(e.getButton() != 3 || e.getClickCount() != 1 || JiveUtils.readOnly || this.selectedTable != this.attTable && this.selectedTable != this.cmdTable || (row = this.getRowForLocation(e.getY())) == -1)) {
            this.selectedTable.addRowSelectionInterval(row, row);
            this.selectedTable.setColumnSelectionInterval(0, 1);
            this.selectedRows = this.selectedTable.getSelectedRows();
            this.tableMenu.show(this.selectedTable, e.getX(), e.getY());
        }
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object src = e.getSource();
        if (src == this.refreshButton) {
            this.refreshValue();
        } else if (src == this.applyButton) {
            String t;
            if (this.cmdTable.isEditing()) {
                t = ((JTextField)this.cmdTable.getEditorComponent()).getText();
                this.cmdModel.setValueAt(t, this.cmdTable.getEditingRow(), this.cmdTable.getEditingColumn());
            }
            if (this.attTable.isEditing()) {
                t = ((JTextField)this.attTable.getEditorComponent()).getText();
                this.attModel.setValueAt(t, this.attTable.getEditingRow(), this.attTable.getEditingColumn());
            }
            if (this.adminTable.isEditing()) {
                t = ((JTextField)this.adminTable.getEditorComponent()).getText();
                this.adminModel.setValueAt(t, this.adminTable.getEditingRow(), this.adminTable.getEditingColumn());
            }
        } else if (src == this.resetButton) {
            int ok = JOptionPane.showConfirmDialog(null, "This will reset polling configuration for all\nattributes and commands.\nReset configuration ?", "Confirm reset", 0);
            if (ok == 0) {
                int nb = this.source.length;
                int k = 0;
                if (nb > 1) {
                    ProgressFrame.displayProgress("Reseting config");
                }
                for (int i = 0; i < this.source.length; ++i) {
                    ProgressFrame.setProgress("Reseting " + this.source[i].getName(), ++k * 100 / nb);
                    this.source[i].resetConfig();
                }
                ProgressFrame.hideProgress();
                JOptionPane.showMessageDialog(null, "The polling configuration has been succesfully reset.\nThe server needs to be restarted to take change into account.");
            }
        } else if (src == this.enablePollingMenuItem) {
            int nb = this.selectedRows.length * this.source.length;
            int k = 0;
            if (nb > 1) {
                ProgressFrame.displayProgress("Enabling polling");
            }
            TableModel model = this.selectedTable.getModel();
            for (int j = 0; j < this.source.length; ++j) {
                for (int i = 0; i < this.selectedRows.length; ++i) {
                    ProgressFrame.setProgress("Enabling " + this.source[j].getName() + "/" + model.getValueAt(this.selectedRows[i], 0), ++k * 100 / nb);
                    if (this.selectedTable == this.attTable) {
                        this.source[j].updateAttributePolling((String)model.getValueAt(this.selectedRows[i], 0), true, (String)model.getValueAt(this.selectedRows[i], 2));
                        continue;
                    }
                    if (this.selectedTable != this.cmdTable) continue;
                    this.source[j].updateCommandPolling((String)model.getValueAt(this.selectedRows[i], 0), true, (String)model.getValueAt(this.selectedRows[i], 2));
                }
            }
            ProgressFrame.hideProgress();
            this.refreshValue();
        } else if (src == this.disablePollingMenuItem) {
            int nb = this.selectedRows.length * this.source.length;
            int k = 0;
            if (nb > 1) {
                ProgressFrame.displayProgress("Disabling polling");
            }
            TableModel model = this.selectedTable.getModel();
            for (int j = 0; j < this.source.length; ++j) {
                for (int i = 0; i < this.selectedRows.length; ++i) {
                    ProgressFrame.setProgress("Disabling " + this.source[j].getName() + "/" + model.getValueAt(this.selectedRows[i], 0), ++k * 100 / nb);
                    if (this.selectedTable == this.attTable) {
                        this.source[j].updateAttributePolling((String)model.getValueAt(this.selectedRows[i], 0), false, (String)model.getValueAt(this.selectedRows[i], 2));
                        continue;
                    }
                    if (this.selectedTable != this.cmdTable) continue;
                    this.source[j].updateCommandPolling((String)model.getValueAt(this.selectedRows[i], 0), false, (String)model.getValueAt(this.selectedRows[i], 2));
                }
            }
            ProgressFrame.hideProgress();
            this.refreshValue();
        } else if (src == this.setPeriodMenuItem) {
            String period = JOptionPane.showInputDialog(null, "Enter polling period (ms)", "3000");
            if (period == null) {
                return;
            }
            int nb = this.selectedRows.length * this.source.length;
            int k = 0;
            if (nb > 1) {
                ProgressFrame.displayProgress("Updating polling period");
            }
            TableModel model = this.selectedTable.getModel();
            for (int j = 0; j < this.source.length; ++j) {
                for (int i = 0; i < this.selectedRows.length; ++i) {
                    ProgressFrame.setProgress("Setting " + this.source[j].getName() + "/" + model.getValueAt(this.selectedRows[i], 0), ++k * 100 / nb);
                    if (this.selectedTable == this.attTable) {
                        this.source[j].updateAttributePolling((String)model.getValueAt(this.selectedRows[i], 0), true, period);
                        continue;
                    }
                    if (this.selectedTable != this.cmdTable) continue;
                    this.source[j].updateCommandPolling((String)model.getValueAt(this.selectedRows[i], 0), true, period);
                }
            }
            ProgressFrame.hideProgress();
            this.refreshValue();
        }
    }

    void setSource(TaskPollingNode[] src) {
        this.source = src;
        this.refreshValue();
    }

    private int getRowForLocation(int y) {
        boolean found = false;
        int i = 0;
        int h = 0;
        while (i < this.selectedTable.getRowCount() && !found) {
            found = y >= h && y <= h + this.selectedTable.getRowHeight(i);
            if (found) continue;
            h += this.selectedTable.getRowHeight(i);
            ++i;
        }
        if (found) {
            return i;
        }
        return -1;
    }

    private void refreshValue() {
        if (this.source != null) {
            this.source[0].browsePollingStatus();
            Object[] cmdColName = new String[]{"Command name", "Polled", "Period (ms)"};
            Object[][] cmdInfo = new Object[this.source[0].getCommandNumber()][3];
            for (int i = 0; i < this.source[0].getCommandNumber(); ++i) {
                cmdInfo[i][0] = this.source[0].getCommandName(i);
                cmdInfo[i][1] = new Boolean(this.source[0].isCommandPolled(i));
                cmdInfo[i][2] = this.source[0].getCommandPollingPeriod(i);
            }
            this.cmdModel.setDataVector(cmdInfo, cmdColName);
            this.cmdTable.getColumnModel().getColumn(0).setPreferredWidth(200);
            Object[] attColName = new String[]{"Attribute name", "Polled", "Period (ms)"};
            Object[][] attInfo = new Object[this.source[0].getAttributeNumber()][3];
            for (int i = 0; i < this.source[0].getAttributeNumber(); ++i) {
                attInfo[i][0] = this.source[0].getAttributeName(i);
                attInfo[i][1] = new Boolean(this.source[0].isAttributePolled(i));
                attInfo[i][2] = this.source[0].getAttributePollingPeriod(i);
            }
            this.attModel.setDataVector(attInfo, attColName);
            this.attTable.getColumnModel().getColumn(0).setPreferredWidth(200);
            Object[] adminColName = new String[]{"Parameters name", "Value"};
            Object[][] adminInfo = new Object[2][2];
            adminInfo[0][0] = "Poll old factor";
            adminInfo[0][1] = this.source[0].getPollOldFactor();
            adminInfo[1][0] = "Poll ring depth";
            adminInfo[1][1] = this.source[0].getPollRingDepth();
            this.adminModel.setDataVector(adminInfo, adminColName);
            this.adminTable.getColumnModel().getColumn(0).setPreferredWidth(200);
            String title = this.source[0].getTitle();
            title = this.source.length == 1 ? title + " [" + this.source[0].getName() + "]" : title + " [" + this.source.length + " devices selected]";
            TitledBorder b = BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), title);
            this.tabPane.setBorder(b);
        }
    }
}

