/*
 * Decompiled with CFR 0.152.
 */
package jive3;

import fr.esrf.tangoatk.widget.util.ATKConstant;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;
import javax.swing.table.DefaultTableModel;
import jive.JiveUtils;
import jive3.MultiChangeConfirmDlg;
import jive3.ProgressFrame;
import jive3.TaskEventNode;

public class DeviceEventPanel
extends JPanel
implements MouseListener,
ActionListener {
    private JTabbedPane tabPane;
    private JTable changeTable;
    private DefaultTableModel changeModel;
    private JTable archTable;
    private DefaultTableModel archModel;
    private JTable perTable;
    private DefaultTableModel perModel;
    private JButton refreshButton;
    private JButton applyButton;
    private JTable selectedTable;
    private int[] selectedRows;
    private JPopupMenu tableMenu;
    private JMenuItem resetMenuItem;
    private JMenuItem resetLMenuItem;
    private JMenuItem resetULMenuItem;
    private JMenuItem resetCULMenuItem;
    private JMenuItem setAbsMenuItem;
    private JMenuItem setRelMenuItem;
    private JMenuItem setPeriodMenuItem;
    private TaskEventNode[] source = null;

    DeviceEventPanel() {
        this.setLayout(new BorderLayout());
        this.changeModel = new DefaultTableModel(){

            public Class getColumnClass(int columnIndex) {
                return String.class;
            }

            @Override
            public boolean isCellEditable(int row, int column) {
                return column != 0 && !JiveUtils.readOnly;
            }

            @Override
            public void setValueAt(Object aValue, int row, int column) {
                if (!aValue.equals(this.getValueAt(row, column))) {
                    super.setValueAt(aValue, row, column);
                    int nb = DeviceEventPanel.this.source.length;
                    int k = 0;
                    if (DeviceEventPanel.this.source.length > 1) {
                        String name = (String)DeviceEventPanel.this.changeModel.getValueAt(row, 0);
                        Vector<String> propChange = new Vector<String>();
                        switch (column) {
                            case 1: {
                                propChange.add("abs_change");
                                break;
                            }
                            case 2: {
                                propChange.add("rel_change");
                            }
                        }
                        propChange.add((String)aValue);
                        if (!MultiChangeConfirmDlg.confirmChange(propChange, DeviceEventPanel.this.source.length, " for attribute " + name)) {
                            DeviceEventPanel.this.refreshValue();
                            return;
                        }
                    }
                    switch (column) {
                        case 1: {
                            if (nb > 1) {
                                ProgressFrame.displayProgress("Updating event config");
                            }
                            for (int i = 0; i < DeviceEventPanel.this.source.length; ++i) {
                                ProgressFrame.setProgress("Updating " + DeviceEventPanel.this.source[i].getName() + "/abs_change", ++k * 100 / nb);
                                DeviceEventPanel.this.source[i].setAbsChange(row, (String)aValue);
                            }
                            ProgressFrame.hideProgress();
                            DeviceEventPanel.this.refreshValue();
                            break;
                        }
                        case 2: {
                            if (nb > 1) {
                                ProgressFrame.displayProgress("Updating event config");
                            }
                            for (int i = 0; i < DeviceEventPanel.this.source.length; ++i) {
                                ProgressFrame.setProgress("Updating " + DeviceEventPanel.this.source[i].getName() + "/rel_change", ++k * 100 / nb);
                                DeviceEventPanel.this.source[i].setRelChange(row, (String)aValue);
                            }
                            ProgressFrame.hideProgress();
                            DeviceEventPanel.this.refreshValue();
                        }
                    }
                }
            }
        };
        this.changeTable = new JTable(this.changeModel);
        this.changeTable.addMouseListener(this);
        JScrollPane changeView = new JScrollPane(this.changeTable);
        this.archModel = new DefaultTableModel(){

            public Class getColumnClass(int columnIndex) {
                return String.class;
            }

            @Override
            public boolean isCellEditable(int row, int column) {
                return column != 0 && !JiveUtils.readOnly;
            }

            @Override
            public void setValueAt(Object aValue, int row, int column) {
                if (!aValue.equals(this.getValueAt(row, column))) {
                    super.setValueAt(aValue, row, column);
                    int nb = DeviceEventPanel.this.source.length;
                    int k = 0;
                    if (DeviceEventPanel.this.source.length > 1) {
                        String name = (String)DeviceEventPanel.this.archModel.getValueAt(row, 0);
                        Vector<String> propChange = new Vector<String>();
                        switch (column) {
                            case 1: {
                                propChange.add("arch_abs_change");
                                break;
                            }
                            case 2: {
                                propChange.add("arch_rel_change");
                                break;
                            }
                            case 3: {
                                propChange.add("arch_period");
                            }
                        }
                        propChange.add((String)aValue);
                        if (!MultiChangeConfirmDlg.confirmChange(propChange, DeviceEventPanel.this.source.length, " for attribute " + name)) {
                            DeviceEventPanel.this.refreshValue();
                            return;
                        }
                    }
                    switch (column) {
                        case 1: {
                            if (nb > 1) {
                                ProgressFrame.displayProgress("Updating event config");
                            }
                            for (int i = 0; i < DeviceEventPanel.this.source.length; ++i) {
                                ProgressFrame.setProgress("Updating " + DeviceEventPanel.this.source[i].getName() + "/arch_abs_change", ++k * 100 / nb);
                                DeviceEventPanel.this.source[i].setArchAbsChange(row, (String)aValue);
                            }
                            ProgressFrame.hideProgress();
                            DeviceEventPanel.this.refreshValue();
                            break;
                        }
                        case 2: {
                            if (nb > 1) {
                                ProgressFrame.displayProgress("Updating event config");
                            }
                            for (int i = 0; i < DeviceEventPanel.this.source.length; ++i) {
                                ProgressFrame.setProgress("Updating " + DeviceEventPanel.this.source[i].getName() + "/arch_rel_change", ++k * 100 / nb);
                                DeviceEventPanel.this.source[i].setArchRelChange(row, (String)aValue);
                            }
                            ProgressFrame.hideProgress();
                            DeviceEventPanel.this.refreshValue();
                            break;
                        }
                        case 3: {
                            if (nb > 1) {
                                ProgressFrame.displayProgress("Updating event config");
                            }
                            for (int i = 0; i < DeviceEventPanel.this.source.length; ++i) {
                                ProgressFrame.setProgress("Updating " + DeviceEventPanel.this.source[i].getName() + "/arch_period", ++k * 100 / nb);
                                DeviceEventPanel.this.source[i].setArchPeriod(row, (String)aValue);
                            }
                            ProgressFrame.hideProgress();
                            DeviceEventPanel.this.refreshValue();
                        }
                    }
                }
            }
        };
        this.archTable = new JTable(this.archModel);
        this.archTable.addMouseListener(this);
        JScrollPane archView = new JScrollPane(this.archTable);
        this.perModel = new DefaultTableModel(){

            public Class getColumnClass(int columnIndex) {
                return String.class;
            }

            @Override
            public boolean isCellEditable(int row, int column) {
                return column != 0 && !JiveUtils.readOnly;
            }

            @Override
            public void setValueAt(Object aValue, int row, int column) {
                if (!aValue.equals(this.getValueAt(row, column))) {
                    super.setValueAt(aValue, row, column);
                    int nb = DeviceEventPanel.this.source.length;
                    int k = 0;
                    if (DeviceEventPanel.this.source.length > 1) {
                        String name = (String)DeviceEventPanel.this.perModel.getValueAt(row, 0);
                        Vector<String> propChange = new Vector<String>();
                        switch (column) {
                            case 1: {
                                propChange.add("period");
                            }
                        }
                        propChange.add((String)aValue);
                        if (!MultiChangeConfirmDlg.confirmChange(propChange, DeviceEventPanel.this.source.length, " for attribute " + name)) {
                            DeviceEventPanel.this.refreshValue();
                            return;
                        }
                    }
                    switch (column) {
                        case 1: {
                            if (nb > 1) {
                                ProgressFrame.displayProgress("Updating event config");
                            }
                            for (int i = 0; i < DeviceEventPanel.this.source.length; ++i) {
                                ProgressFrame.setProgress("Updating " + DeviceEventPanel.this.source[i].getName() + "/period", ++k * 100 / nb);
                                DeviceEventPanel.this.source[i].setPeriodic(row, (String)aValue);
                            }
                            ProgressFrame.hideProgress();
                            DeviceEventPanel.this.refreshValue();
                        }
                    }
                }
            }
        };
        this.perTable = new JTable(this.perModel);
        this.perTable.addMouseListener(this);
        JScrollPane perView = new JScrollPane(this.perTable);
        this.tabPane = new JTabbedPane();
        this.tabPane.setFont(ATKConstant.labelFont);
        this.tabPane.add("Change event", changeView);
        this.tabPane.add("Archive event", archView);
        this.tabPane.add("Periodic event", perView);
        TitledBorder b = BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "...");
        this.tabPane.setBorder(b);
        this.add((Component)this.tabPane, "Center");
        JPanel btnPanel = new JPanel(new FlowLayout(0));
        this.refreshButton = new JButton("Refresh");
        this.refreshButton.addActionListener(this);
        btnPanel.add(this.refreshButton);
        this.applyButton = new JButton("Apply");
        this.applyButton.setEnabled(!JiveUtils.readOnly);
        this.applyButton.addActionListener(this);
        btnPanel.add(this.applyButton);
        this.add((Component)btnPanel, "South");
        this.tableMenu = new JPopupMenu();
        this.resetMenuItem = new JMenuItem("Reset to default value");
        this.resetMenuItem.addActionListener(this);
        this.tableMenu.add(this.resetMenuItem);
        this.resetLMenuItem = new JMenuItem("Return to lib default value");
        this.resetLMenuItem.addActionListener(this);
        this.tableMenu.add(this.resetLMenuItem);
        this.resetULMenuItem = new JMenuItem("Return to code/lib default value");
        this.resetULMenuItem.addActionListener(this);
        this.tableMenu.add(this.resetULMenuItem);
        this.resetCULMenuItem = new JMenuItem("Return to class/code/lib default value");
        this.resetCULMenuItem.addActionListener(this);
        this.tableMenu.add(this.resetCULMenuItem);
        this.setAbsMenuItem = new JMenuItem("Set absolute change");
        this.setAbsMenuItem.addActionListener(this);
        this.tableMenu.add(this.setAbsMenuItem);
        this.setRelMenuItem = new JMenuItem("Set relative change");
        this.setRelMenuItem.addActionListener(this);
        this.tableMenu.add(this.setRelMenuItem);
        this.setPeriodMenuItem = new JMenuItem("Set period");
        this.setPeriodMenuItem.addActionListener(this);
        this.tableMenu.add(this.setPeriodMenuItem);
    }

    @Override
    public void mousePressed(MouseEvent e) {
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        this.selectedTable = (JTable)e.getSource();
        if (e.getButton() == 3 && e.getClickCount() == 1 && !JiveUtils.readOnly) {
            int row = this.getRowForLocation(e.getY());
            if (row != -1) {
                this.selectedTable.addRowSelectionInterval(row, row);
                this.selectedTable.setColumnSelectionInterval(0, this.selectedTable.getColumnCount() - 1);
                this.selectedRows = this.selectedTable.getSelectedRows();
                if (this.selectedTable == this.changeTable) {
                    this.setAbsMenuItem.setVisible(true);
                    this.setRelMenuItem.setVisible(true);
                    this.setPeriodMenuItem.setVisible(false);
                } else if (this.selectedTable == this.archTable) {
                    this.setAbsMenuItem.setVisible(true);
                    this.setRelMenuItem.setVisible(true);
                    this.setPeriodMenuItem.setVisible(true);
                } else {
                    this.setAbsMenuItem.setVisible(false);
                    this.setRelMenuItem.setVisible(false);
                    this.setPeriodMenuItem.setVisible(true);
                }
                boolean isTango8 = true;
                for (int i = 0; isTango8 && i < this.source.length; ++i) {
                    isTango8 = this.source[i].isTango8();
                }
                if (isTango8) {
                    this.resetLMenuItem.setVisible(true);
                    this.resetULMenuItem.setVisible(true);
                    this.resetCULMenuItem.setVisible(true);
                } else {
                    this.resetLMenuItem.setVisible(false);
                    this.resetULMenuItem.setVisible(false);
                    this.resetCULMenuItem.setVisible(false);
                }
                this.tableMenu.show(this.selectedTable, e.getX(), e.getY());
            } else {
                this.selectedTable = null;
            }
        }
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object src = e.getSource();
        if (src == this.refreshButton) {
            this.refreshValue();
        } else if (src == this.resetMenuItem) {
            int i;
            String message;
            int result;
            int nb = this.selectedRows.length * this.source.length;
            int k = 0;
            if (this.source.length > 1 && (result = JOptionPane.showConfirmDialog(this, message = "You are going to reset event configuration for " + this.source.length + " device(s) and " + this.selectedRows.length + " attribute(s).\nDo you want to proceed ?", "Confirmation", 0, 2)) == 1) {
                return;
            }
            if (nb > 1) {
                ProgressFrame.displayProgress("Reseting event config");
            }
            if (this.selectedTable == this.changeTable) {
                for (int j = 0; j < this.source.length; ++j) {
                    for (i = 0; i < this.selectedRows.length; ++i) {
                        ProgressFrame.setProgress("Reseting " + this.source[j].getName() + "/" + this.changeModel.getValueAt(this.selectedRows[i], 0), ++k * 100 / nb);
                        this.source[j].resetChangeEvent(this.selectedRows[i]);
                    }
                    this.source[j].restartDevice();
                }
            } else if (this.selectedTable == this.archTable) {
                for (int j = 0; j < this.source.length; ++j) {
                    for (i = 0; i < this.selectedRows.length; ++i) {
                        ProgressFrame.setProgress("Reseting " + this.source[j].getName() + "/" + this.archModel.getValueAt(this.selectedRows[i], 0), ++k * 100 / nb);
                        this.source[j].resetArchEvent(this.selectedRows[i]);
                    }
                    this.source[j].restartDevice();
                }
            } else if (this.selectedTable == this.perTable) {
                for (int j = 0; j < this.source.length; ++j) {
                    for (i = 0; i < this.selectedRows.length; ++i) {
                        ProgressFrame.setProgress("Reseting " + this.source[j].getName() + "/" + this.perModel.getValueAt(this.selectedRows[i], 0), ++k * 100 / nb);
                        this.source[j].resetPeriodicEvent(this.selectedRows[i]);
                    }
                    this.source[j].restartDevice();
                }
            }
            ProgressFrame.hideProgress();
            this.refreshValue();
        } else if (src == this.resetLMenuItem) {
            int i;
            String message;
            int result;
            int nb = this.selectedRows.length * this.source.length;
            int k = 0;
            if (this.source.length > 1 && (result = JOptionPane.showConfirmDialog(this, message = "You are going to reset event configuration to library value for " + this.source.length + " device(s) and " + this.selectedRows.length + " attribute(s).\nDo you want to proceed ?", "Confirmation", 0, 2)) == 1) {
                return;
            }
            if (nb > 1) {
                ProgressFrame.displayProgress("Reseting event config");
            }
            if (this.selectedTable == this.changeTable) {
                for (int j = 0; j < this.source.length; ++j) {
                    for (i = 0; i < this.selectedRows.length; ++i) {
                        ProgressFrame.setProgress("Reseting " + this.source[j].getName() + "/" + this.changeModel.getValueAt(this.selectedRows[i], 0), ++k * 100 / nb);
                        this.source[j].resetLChangeEvent(this.selectedRows[i]);
                    }
                }
            } else if (this.selectedTable == this.archTable) {
                for (int j = 0; j < this.source.length; ++j) {
                    for (i = 0; i < this.selectedRows.length; ++i) {
                        ProgressFrame.setProgress("Reseting " + this.source[j].getName() + "/" + this.archModel.getValueAt(this.selectedRows[i], 0), ++k * 100 / nb);
                        this.source[j].resetLArchEvent(this.selectedRows[i]);
                    }
                }
            } else if (this.selectedTable == this.perTable) {
                for (int j = 0; j < this.source.length; ++j) {
                    for (i = 0; i < this.selectedRows.length; ++i) {
                        ProgressFrame.setProgress("Reseting " + this.source[j].getName() + "/" + this.perModel.getValueAt(this.selectedRows[i], 0), ++k * 100 / nb);
                        this.source[j].resetLPeriodicEvent(this.selectedRows[i]);
                    }
                }
            }
            ProgressFrame.hideProgress();
            this.refreshValue();
        } else if (src == this.resetULMenuItem) {
            int i;
            String message;
            int result;
            int nb = this.selectedRows.length * this.source.length;
            int k = 0;
            if (this.source.length > 1 && (result = JOptionPane.showConfirmDialog(this, message = "You are going to reset event configuration to code/library value for " + this.source.length + " device(s) and " + this.selectedRows.length + " attribute(s).\nDo you want to proceed ?", "Confirmation", 0, 2)) == 1) {
                return;
            }
            if (nb > 1) {
                ProgressFrame.displayProgress("Reseting event config");
            }
            if (this.selectedTable == this.changeTable) {
                for (int j = 0; j < this.source.length; ++j) {
                    for (i = 0; i < this.selectedRows.length; ++i) {
                        ProgressFrame.setProgress("Reseting " + this.source[j].getName() + "/" + this.changeModel.getValueAt(this.selectedRows[i], 0), ++k * 100 / nb);
                        this.source[j].resetULChangeEvent(this.selectedRows[i]);
                    }
                }
            } else if (this.selectedTable == this.archTable) {
                for (int j = 0; j < this.source.length; ++j) {
                    for (i = 0; i < this.selectedRows.length; ++i) {
                        ProgressFrame.setProgress("Reseting " + this.source[j].getName() + "/" + this.archModel.getValueAt(this.selectedRows[i], 0), ++k * 100 / nb);
                        this.source[j].resetULArchEvent(this.selectedRows[i]);
                    }
                }
            } else if (this.selectedTable == this.perTable) {
                for (int j = 0; j < this.source.length; ++j) {
                    for (i = 0; i < this.selectedRows.length; ++i) {
                        ProgressFrame.setProgress("Reseting " + this.source[j].getName() + "/" + this.perModel.getValueAt(this.selectedRows[i], 0), ++k * 100 / nb);
                        this.source[j].resetULPeriodicEvent(this.selectedRows[i]);
                    }
                }
            }
            ProgressFrame.hideProgress();
            this.refreshValue();
        } else if (src == this.resetCULMenuItem) {
            int i;
            String message;
            int result;
            int nb = this.selectedRows.length * this.source.length;
            int k = 0;
            if (this.source.length > 1 && (result = JOptionPane.showConfirmDialog(this, message = "You are going to reset event configuration to class/code/library value for " + this.source.length + " device(s) and " + this.selectedRows.length + " attribute(s).\nDo you want to proceed ?", "Confirmation", 0, 2)) == 1) {
                return;
            }
            if (nb > 1) {
                ProgressFrame.displayProgress("Reseting event config");
            }
            if (this.selectedTable == this.changeTable) {
                for (int j = 0; j < this.source.length; ++j) {
                    for (i = 0; i < this.selectedRows.length; ++i) {
                        ProgressFrame.setProgress("Reseting " + this.source[j].getName() + "/" + this.changeModel.getValueAt(this.selectedRows[i], 0), ++k * 100 / nb);
                        this.source[j].resetCULChangeEvent(this.selectedRows[i]);
                    }
                }
            } else if (this.selectedTable == this.archTable) {
                for (int j = 0; j < this.source.length; ++j) {
                    for (i = 0; i < this.selectedRows.length; ++i) {
                        ProgressFrame.setProgress("Reseting " + this.source[j].getName() + "/" + this.archModel.getValueAt(this.selectedRows[i], 0), ++k * 100 / nb);
                        this.source[j].resetCULArchEvent(this.selectedRows[i]);
                    }
                }
            } else if (this.selectedTable == this.perTable) {
                for (int j = 0; j < this.source.length; ++j) {
                    for (i = 0; i < this.selectedRows.length; ++i) {
                        ProgressFrame.setProgress("Reseting " + this.source[j].getName() + "/" + this.perModel.getValueAt(this.selectedRows[i], 0), ++k * 100 / nb);
                        this.source[j].resetCULPeriodicEvent(this.selectedRows[i]);
                    }
                }
            }
            ProgressFrame.hideProgress();
            this.refreshValue();
        } else if (src == this.setAbsMenuItem) {
            String abs = JOptionPane.showInputDialog(null, "Enter absolute change value", "");
            if (abs == null) {
                return;
            }
            int nb = this.selectedRows.length * this.source.length;
            int k = 0;
            if (this.source.length > 1) {
                Vector<String> propChange = new Vector<String>();
                if (this.selectedTable == this.changeTable) {
                    propChange.add("abs_change");
                } else {
                    propChange.add("arch_abs_change");
                }
                propChange.add(abs);
                if (!MultiChangeConfirmDlg.confirmChange(propChange, this.source.length, " and " + this.selectedRows.length + " attribute(s)")) {
                    return;
                }
            }
            if (nb > 1) {
                ProgressFrame.displayProgress("Updating abs change");
            }
            if (this.selectedTable == this.changeTable) {
                for (int j = 0; j < this.source.length; ++j) {
                    for (int i = 0; i < this.selectedRows.length; ++i) {
                        ProgressFrame.setProgress("Updating " + this.source[j].getName() + "/" + this.changeModel.getValueAt(this.selectedRows[i], 0), ++k * 100 / nb);
                        this.source[j].setAbsChange(this.selectedRows[i], abs);
                    }
                }
            } else if (this.selectedTable == this.archTable) {
                for (int j = 0; j < this.source.length; ++j) {
                    for (int i = 0; i < this.selectedRows.length; ++i) {
                        ProgressFrame.setProgress("Updating " + this.source[j].getName() + "/" + this.archModel.getValueAt(this.selectedRows[i], 0), ++k * 100 / nb);
                        this.source[j].setArchAbsChange(this.selectedRows[i], abs);
                    }
                }
            }
            ProgressFrame.hideProgress();
            this.refreshValue();
        } else if (src == this.setRelMenuItem) {
            String rel = JOptionPane.showInputDialog(null, "Enter relative change value", "");
            if (rel == null) {
                return;
            }
            int nb = this.selectedRows.length * this.source.length;
            int k = 0;
            if (this.source.length > 1) {
                Vector<String> propChange = new Vector<String>();
                if (this.selectedTable == this.changeTable) {
                    propChange.add("rel_change");
                } else {
                    propChange.add("arch_rel_change");
                }
                propChange.add(rel);
                if (!MultiChangeConfirmDlg.confirmChange(propChange, this.source.length, " and " + this.selectedRows.length + " attribute(s)")) {
                    return;
                }
            }
            if (nb > 1) {
                ProgressFrame.displayProgress("Updating rel change");
            }
            if (this.selectedTable == this.changeTable) {
                for (int j = 0; j < this.source.length; ++j) {
                    for (int i = 0; i < this.selectedRows.length; ++i) {
                        ProgressFrame.setProgress("Updating " + this.source[j].getName() + "/" + this.changeModel.getValueAt(this.selectedRows[i], 0), ++k * 100 / nb);
                        this.source[j].setRelChange(this.selectedRows[i], rel);
                    }
                }
            } else if (this.selectedTable == this.archTable) {
                for (int j = 0; j < this.source.length; ++j) {
                    for (int i = 0; i < this.selectedRows.length; ++i) {
                        ProgressFrame.setProgress("Updating " + this.source[j].getName() + "/" + this.archModel.getValueAt(this.selectedRows[i], 0), ++k * 100 / nb);
                        this.source[j].setArchRelChange(this.selectedRows[i], rel);
                    }
                }
            }
            ProgressFrame.hideProgress();
            this.refreshValue();
        } else if (src == this.setPeriodMenuItem) {
            String per = JOptionPane.showInputDialog(null, "Enter period value (ms)", "");
            if (per == null) {
                return;
            }
            int nb = this.selectedRows.length * this.source.length;
            int k = 0;
            if (this.source.length > 1) {
                Vector<String> propChange = new Vector<String>();
                if (this.selectedTable == this.archTable) {
                    propChange.add("arch_period");
                } else {
                    propChange.add("period");
                }
                propChange.add(per);
                if (!MultiChangeConfirmDlg.confirmChange(propChange, this.source.length, " and " + this.selectedRows.length + " attribute(s)")) {
                    return;
                }
            }
            if (nb > 1) {
                ProgressFrame.displayProgress("Updating period");
            }
            if (this.selectedTable == this.archTable) {
                for (int j = 0; j < this.source.length; ++j) {
                    for (int i = 0; i < this.selectedRows.length; ++i) {
                        ProgressFrame.setProgress("Updating " + this.source[j].getName() + "/" + this.changeModel.getValueAt(this.selectedRows[i], 0), ++k * 100 / nb);
                        this.source[j].setArchPeriod(this.selectedRows[i], per);
                    }
                }
            } else if (this.selectedTable == this.perTable) {
                for (int j = 0; j < this.source.length; ++j) {
                    for (int i = 0; i < this.selectedRows.length; ++i) {
                        ProgressFrame.setProgress("Updating " + this.source[j].getName() + "/" + this.archModel.getValueAt(this.selectedRows[i], 0), ++k * 100 / nb);
                        this.source[j].setPeriodic(this.selectedRows[i], per);
                    }
                }
            }
            ProgressFrame.hideProgress();
            this.refreshValue();
        } else if (src == this.applyButton) {
            String t;
            if (this.changeTable.isEditing()) {
                t = ((JTextField)this.changeTable.getEditorComponent()).getText();
                this.changeModel.setValueAt(t, this.changeTable.getEditingRow(), this.changeTable.getEditingColumn());
            }
            if (this.archTable.isEditing()) {
                t = ((JTextField)this.archTable.getEditorComponent()).getText();
                this.archModel.setValueAt(t, this.archTable.getEditingRow(), this.archTable.getEditingColumn());
            }
            if (this.perTable.isEditing()) {
                t = ((JTextField)this.perTable.getEditorComponent()).getText();
                this.perModel.setValueAt(t, this.perTable.getEditingRow(), this.perTable.getEditingColumn());
            }
        }
    }

    void setSource(TaskEventNode[] src) {
        this.source = src;
        this.refreshValue();
    }

    private int getRowForLocation(int y) {
        boolean found = false;
        int i = 0;
        int h = 0;
        while (i < this.selectedTable.getRowCount() && !found) {
            found = y >= h && y <= h + this.selectedTable.getRowHeight(i);
            if (found) continue;
            h += this.selectedTable.getRowHeight(i);
            ++i;
        }
        if (found) {
            return i;
        }
        return -1;
    }

    private void refreshValue() {
        if (this.source != null) {
            this.source[0].browseEventInfo();
            Object[] changeColName = new String[]{"Attribute name", "Absolute", "Relative"};
            Object[][] changeInfo = new Object[this.source[0].getAttributeNumber()][3];
            for (int i = 0; i < this.source[0].getAttributeNumber(); ++i) {
                changeInfo[i][0] = this.source[0].getAttName(i);
                changeInfo[i][1] = this.source[0].getAbsChange(i);
                changeInfo[i][2] = this.source[0].getRelChange(i);
            }
            this.changeModel.setDataVector(changeInfo, changeColName);
            this.changeTable.getColumnModel().getColumn(0).setPreferredWidth(200);
            Object[] archColName = new String[]{"Attribute name", "Absolute", "Relative", "Period"};
            Object[][] archInfo = new Object[this.source[0].getAttributeNumber()][4];
            for (int i = 0; i < this.source[0].getAttributeNumber(); ++i) {
                archInfo[i][0] = this.source[0].getAttName(i);
                archInfo[i][1] = this.source[0].getArchAbsChange(i);
                archInfo[i][2] = this.source[0].getArchRelChange(i);
                archInfo[i][3] = this.source[0].getArchPeriod(i);
            }
            this.archModel.setDataVector(archInfo, archColName);
            this.archTable.getColumnModel().getColumn(0).setPreferredWidth(200);
            Object[] perColName = new String[]{"Attribute name", "Period"};
            Object[][] perInfo = new Object[this.source[0].getAttributeNumber()][2];
            for (int i = 0; i < this.source[0].getAttributeNumber(); ++i) {
                perInfo[i][0] = this.source[0].getAttName(i);
                perInfo[i][1] = this.source[0].getPeriodic(i);
            }
            this.perModel.setDataVector(perInfo, perColName);
            this.perTable.getColumnModel().getColumn(0).setPreferredWidth(200);
            String title = this.source[0].getTitle();
            title = this.source.length == 1 ? title + " [" + this.source[0].getName() + "]" : title + " [" + this.source.length + " devices selected]";
            TitledBorder b = BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), title);
            this.tabPane.setBorder(b);
        }
    }
}

