/*
 * Decompiled with CFR 0.152.
 */
package jive3;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JEditorPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.border.TitledBorder;
import jive3.TangoNode;

class DefaultPanel
extends JPanel
implements ActionListener {
    private JEditorPane value;
    private JScrollPane valueView;
    private JPanel btnPanel;
    private JButton refreshButton;
    private TangoNode src = null;
    private int size;

    DefaultPanel() {
        this.setLayout(new BorderLayout());
        this.value = new JEditorPane();
        this.value.setEditable(false);
        this.value.setDragEnabled(true);
        this.value.setBorder(BorderFactory.createLoweredBevelBorder());
        this.value.setContentType("text/html");
        this.valueView = new JScrollPane(this.value);
        TitledBorder b = BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "...");
        this.valueView.setBorder(b);
        this.add((Component)this.valueView, "Center");
        this.btnPanel = new JPanel(new FlowLayout(0));
        this.refreshButton = new JButton("Refresh");
        this.refreshButton.addActionListener(this);
        this.btnPanel.add(this.refreshButton);
        this.add((Component)this.btnPanel, "South");
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object src = e.getSource();
        if (src == this.refreshButton) {
            this.refreshValue();
        }
    }

    void setSource(TangoNode src, int size) {
        this.src = src;
        this.size = size;
        this.refreshValue();
    }

    public void setText(String str) {
        StringBuffer strBuff = new StringBuffer();
        strBuff.append("<html><body>\n<div style='white-space:nowrap; font-family:\"Monospaced\"; font-size:9px;'><pre>\n");
        strBuff.append(str);
        strBuff.append("</pre></div></body></html>\n");
        this.value.setText(strBuff.toString());
    }

    private void refreshValue() {
        if (this.src != null) {
            this.setText(this.src.getValue());
            this.value.setCaretPosition(0);
            String title = this.src.getTitle();
            if (this.size > 1) {
                title = title + " [" + this.size + " items]";
            }
            TitledBorder b = BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), title);
            this.valueView.setBorder(b);
        } else {
            this.setText("");
            this.value.setCaretPosition(0);
            TitledBorder b = BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "...");
            this.valueView.setBorder(b);
        }
    }
}

