/*
 * Decompiled with CFR 0.152.
 */
package jive;

import java.awt.Component;
import java.awt.Font;
import javax.swing.ImageIcon;
import javax.swing.JTree;
import javax.swing.tree.DefaultTreeCellRenderer;
import jive.TangoTreeNode;

class TangoTreeNodeRenderer
extends DefaultTreeCellRenderer {
    ImageIcon hosticon = new ImageIcon(this.getClass().getResource("/jive/host_big.gif"));
    ImageIcon devicon = new ImageIcon(this.getClass().getResource("/jive/device.gif"));
    ImageIcon deviconbig = new ImageIcon(this.getClass().getResource("/jive/device_big.gif"));
    ImageIcon propiconbig = new ImageIcon(this.getClass().getResource("/jive/property_big.gif"));
    ImageIcon aliasiconbig = new ImageIcon(this.getClass().getResource("/jive/alias_big.gif"));
    ImageIcon srvicon = new ImageIcon(this.getClass().getResource("/jive/server.gif"));
    ImageIcon srviconbig = new ImageIcon(this.getClass().getResource("/jive/server_big.gif"));
    ImageIcon classicon = new ImageIcon(this.getClass().getResource("/jive/class.gif"));
    ImageIcon uclassicon = new ImageIcon(this.getClass().getResource("/jive/uclass.gif"));
    ImageIcon classiconbig = new ImageIcon(this.getClass().getResource("/jive/class_big.gif"));
    ImageIcon leaficon = new ImageIcon(this.getClass().getResource("/jive/leaf.gif"));
    ImageIcon uleaficon = new ImageIcon(this.getClass().getResource("/jive/uleaf.gif"));
    ImageIcon leafcfgicon = new ImageIcon(this.getClass().getResource("/jive/leafcfg.gif"));
    ImageIcon leaflogicon = new ImageIcon(this.getClass().getResource("/jive/logleaf.gif"));
    ImageIcon cmdicon = new ImageIcon(this.getClass().getResource("/jive/command.gif"));
    ImageIcon atticon = new ImageIcon(this.getClass().getResource("/jive/attribute.gif"));
    ImageIcon attcfgicon = new ImageIcon(this.getClass().getResource("/jive/attleaf.gif"));
    ImageIcon uattcfgicon = new ImageIcon(this.getClass().getResource("/jive/uattleaf.gif"));
    ImageIcon hdbcfgicon = new ImageIcon(this.getClass().getResource("/jive/hdbleaf.gif"));
    ImageIcon alarmicon = new ImageIcon(this.getClass().getResource("/jive/alarms.gif"));
    ImageIcon eventicon = new ImageIcon(this.getClass().getResource("/jive/event.gif"));
    Font bigFont = new Font("Dialog", 1, 16);
    Font defFont = this.getFont();

    @Override
    public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        super.getTreeCellRendererComponent(tree, value, sel, expanded, leaf, row, hasFocus);
        TangoTreeNode n = (TangoTreeNode)value;
        this.setToolTipText(n.help);
        if (n.level <= 1) {
            this.setFont(this.bigFont);
            if (n.level == 1) {
                switch (n.type) {
                    case 1: {
                        this.setIcon(this.classiconbig);
                        break;
                    }
                    case 2: {
                        this.setIcon(this.srviconbig);
                        break;
                    }
                    case 3: {
                        this.setIcon(this.deviconbig);
                        break;
                    }
                    case 4: {
                        this.setIcon(this.propiconbig);
                        break;
                    }
                    case 5: {
                        this.setIcon(this.aliasiconbig);
                    }
                }
            } else {
                this.setIcon(this.hosticon);
            }
            return this;
        }
        this.setFont(this.defFont);
        if (n.level == 4 && n.type == 3) {
            this.setIcon(this.devicon);
            return this;
        }
        if (n.level == 2 && n.type == 5) {
            this.setIcon(this.devicon);
            return this;
        }
        if (n.level == 5 && n.type == 2) {
            this.setIcon(this.devicon);
            return this;
        }
        if (n.level == 4 && n.type == 2) {
            if (n.isValid()) {
                this.setIcon(this.classicon);
            } else {
                this.setIcon(this.uclassicon);
            }
            return this;
        }
        if (n.level == 2 && n.type == 1) {
            this.setIcon(this.classicon);
            return this;
        }
        if ((n.level == 2 || n.level == 3) && n.type == 2) {
            this.setIcon(this.srvicon);
            return this;
        }
        if (n.level == 6 && n.getParent().toString().equals("COMMAND")) {
            this.setIcon(this.cmdicon);
            return this;
        }
        if (n.level == 6 && n.getParent().toString().equals("ATTRIBUTE")) {
            this.setIcon(this.atticon);
            return this;
        }
        if (n.isAlarmCfgItem() && n.level == 7 && n.getParent().getParent().toString().equals("ATTRIBUTE")) {
            this.setIcon(this.alarmicon);
            return this;
        }
        if (n.isEventCfgItem() && n.level == 7 && n.getParent().getParent().toString().equals("ATTRIBUTE")) {
            this.setIcon(this.eventicon);
            return this;
        }
        if (n.isLeaf()) {
            boolean isAtt;
            if (n.isPollCfgItem()) {
                this.setIcon(this.leafcfgicon);
                return this;
            }
            if (n.isLogCfgItem()) {
                this.setIcon(this.leaflogicon);
                return this;
            }
            if (n.isSystemItem()) {
                this.setIcon(this.uleaficon);
                return this;
            }
            boolean bl = isAtt = n.level == 7 && n.getParent().getParent().toString().equals("ATTRIBUTE") || n.level == 8 && n.getParent().getParent().getParent().toString().equals("ATTRIBUTE");
            if (n.isAttCfgItem() && isAtt) {
                if (n.isValid()) {
                    this.setIcon(this.attcfgicon);
                } else {
                    this.setIcon(this.uattcfgicon);
                }
                return this;
            }
            this.setIcon(this.leaficon);
        }
        return this;
    }
}

