/*
 * Decompiled with CFR 0.152.
 */
package jive;

import fr.esrf.Tango.DevFailed;
import fr.esrf.TangoApi.DeviceProxy;
import javax.swing.ImageIcon;
import jive.ClassPanel;
import jive.DevWizard;
import jive.JiveUtils;
import jive.WizardPanel;

class StartingPanel
extends WizardPanel {
    String serverName;

    public StartingPanel(DevWizard parent, String srvName) {
        this.setLayout(null);
        this.panelIcon = new ImageIcon(this.getClass().getResource("/jive/server_wz.gif"));
        this.parent = parent;
        this.serverName = srvName;
    }

    @Override
    public String getTitle() {
        return "Start the server";
    }

    @Override
    public String getDescription() {
        return "The server \"" + this.serverName + "\" has been successfully registered. You have to start it now.\n" + "When done, click [Next] to continue or [Back] to register a new server.";
    }

    @Override
    public boolean getNextState() {
        return true;
    }

    @Override
    public boolean next() {
        String dName = "dserver/" + this.serverName;
        try {
            DeviceProxy admin = new DeviceProxy(dName);
            this.removeNextPanel();
            this.parent.addPanel(new ClassPanel(this.parent, this.serverName, admin));
        }
        catch (DevFailed e) {
            JiveUtils.showJiveError("Failed to contact the admin server of " + this.serverName + "\nCheck that " + this.serverName + " is running.\n" + "\nThe wizard cannot continue....\n" + e.errors[0].desc);
            return false;
        }
        return true;
    }

    @Override
    public boolean back() {
        return true;
    }
}

