/*
 * Decompiled with CFR 0.152.
 */
package jive;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import jive.JiveUtils;
import jive3.IServerAction;
import jive3.JTextTips;

public class ServerDlg
extends JFrame {
    private JTextTips serverText;
    private JTextTips classText;
    private JTextArea deviceText;
    private JScrollPane deviceView;
    private JButton ok;
    private JButton cancel;
    private JPanel jp;
    private static final Color backColor = new Color(240, 240, 240);
    private final IServerAction okAction;

    public ServerDlg(IServerAction action) {
        this.okAction = action;
        this.getContentPane().setLayout(null);
        this.getContentPane().setPreferredSize(new Dimension(400, 280));
        this.setTitle("Create/Edit a server");
        this.jp = new JPanel(null);
        this.jp.setBackground(backColor);
        this.jp.setBorder(BorderFactory.createLoweredBevelBorder());
        this.getContentPane().add(this.jp);
        this.serverText = new JTextTips();
        this.serverText.setEditable(true);
        this.serverText.setBackground(backColor);
        this.serverText.setBorder(BorderFactory.createTitledBorder("Server  (ServerName/Instance)"));
        this.classText = new JTextTips();
        this.classText.setEditable(true);
        this.classText.setBackground(backColor);
        this.classText.setBorder(BorderFactory.createTitledBorder("Class"));
        this.deviceText = new JTextArea();
        this.deviceText.setEditable(true);
        this.deviceText.setBackground(backColor);
        this.deviceView = new JScrollPane(this.deviceText);
        this.deviceView.setBorder(BorderFactory.createTitledBorder("Devices"));
        this.deviceView.setBackground(backColor);
        this.ok = new JButton();
        this.ok.setText("Register server");
        this.getContentPane().add(this.ok);
        this.cancel = new JButton();
        this.cancel.setText("Cancel");
        this.getContentPane().add(this.cancel);
        this.jp.add(this.serverText);
        this.jp.add(this.classText);
        this.jp.add(this.deviceView);
        this.serverText.setBounds(5, 5, 380, 40);
        this.classText.setBounds(5, 45, 380, 40);
        this.deviceView.setBounds(5, 85, 380, 145);
        this.jp.setBounds(5, 8, 389, 234);
        this.ok.setBounds(5, 248, 150, 27);
        this.cancel.setBounds(315, 248, 80, 27);
        this.cancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ServerDlg.this.setVisible(false);
                ServerDlg.this.dispose();
            }
        });
        this.ok.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String serverName = ServerDlg.this.serverText.getText();
                if (serverName.indexOf(47) == -1) {
                    JiveUtils.showJiveError("Server name must be entered as Name/Instance");
                    return;
                }
                if (serverName.indexOf(47) != serverName.lastIndexOf(47)) {
                    JiveUtils.showJiveError("Server name must be entered as Name/Instance");
                    return;
                }
                ServerDlg.this.okAction.doJob(serverName, ServerDlg.this.getClassName(), ServerDlg.this.getDeviceNames());
                ServerDlg.this.setVisible(false);
                ServerDlg.this.dispose();
            }
        });
    }

    public void setServerList(String[] list) {
        this.serverText.setTips(list);
    }

    public void setClassList(String[] list) {
        this.classText.setTips(list);
    }

    public void setValidFields(boolean s, boolean c) {
        this.serverText.setEditable(s);
        this.classText.setEditable(c);
    }

    public void setDefaults(String s, String c) {
        this.serverText.setTextInternal(s);
        this.classText.setTextInternal(c);
    }

    public String getServerName() {
        return this.serverText.getText();
    }

    public String getClassName() {
        return this.classText.getText();
    }

    public String[] getDeviceNames() {
        int i;
        String value = this.deviceText.getText();
        String[] splitted = value.split("\n");
        int j = 0;
        for (i = 0; i < splitted.length; ++i) {
            if (splitted[i].length() <= 0) continue;
            ++j;
        }
        String[] ret = new String[j];
        j = 0;
        for (i = 0; i < splitted.length; ++i) {
            if (splitted[i].length() <= 0) continue;
            ret[j] = splitted[i];
            ++j;
        }
        return ret;
    }
}

