/*
 * Decompiled with CFR 0.152.
 */
package jive;

import fr.esrf.Tango.DevFailed;
import fr.esrf.Tango.DevInfo;
import fr.esrf.Tango.DevSource;
import fr.esrf.TangoApi.DeviceData;
import fr.esrf.TangoApi.DeviceProxy;
import fr.esrf.tangoatk.widget.util.ATKConstant;
import fr.esrf.tangoatk.widget.util.ErrorPane;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import jive.ConsolePanel;
import jive.JiveUtils;

class CommonPanel
extends JPanel
implements ActionListener {
    private DeviceProxy device = null;
    private DeviceProxy deviceAdm = null;
    private ConsolePanel console;
    private int answerLimitMin = 0;
    private int answerLimitMax = 1024;
    private JLabel sourceLabel;
    private JComboBox sourceCombo;
    private JLabel timeoutLabel;
    private JTextField timeoutText;
    private JLabel blackBoxLabel;
    private JTextField blackBoxText;
    private JLabel limitMinLabel;
    private JTextField limitMinText;
    private JLabel limitLengthLabel;
    private JTextField limitLengthText;
    private JButton restartBtn;
    private JButton pollStatusBtn;
    private JButton infoBtn;
    private JButton pingBtn;
    private JButton setTimeoutBtn;
    private JButton blackBoxBtn;
    private JButton limitMinBtn;
    private JButton limitLengthBtn;

    CommonPanel(DeviceProxy ds, ConsolePanel console) throws DevFailed {
        this.device = ds;
        this.console = console;
        this.setLayout(null);
        this.sourceLabel = new JLabel("Source");
        this.sourceLabel.setFont(ATKConstant.labelFont);
        this.add(this.sourceLabel);
        this.sourceCombo = new JComboBox();
        this.sourceCombo.addItem("CACHE");
        this.sourceCombo.addItem("CACHE_DEVICE");
        this.sourceCombo.addItem("DEVICE");
        this.sourceCombo.setFont(ATKConstant.labelFont);
        this.sourceCombo.setSelectedIndex(1);
        this.sourceCombo.addActionListener(this);
        this.add(this.sourceCombo);
        this.timeoutLabel = new JLabel("Timeout (ms)");
        this.timeoutLabel.setFont(ATKConstant.labelFont);
        this.add(this.timeoutLabel);
        this.timeoutText = new JTextField();
        this.timeoutText.setText(Integer.toString(ds.get_timeout_millis()));
        this.timeoutText.setFont(ATKConstant.labelFont);
        this.timeoutText.setMargin(JiveUtils.noMargin);
        this.add(this.timeoutText);
        this.setTimeoutBtn = new JButton("Apply");
        this.setTimeoutBtn.setFont(ATKConstant.labelFont);
        this.setTimeoutBtn.addActionListener(this);
        this.add(this.setTimeoutBtn);
        this.blackBoxLabel = new JLabel("BlackBox (nb cmd)");
        this.blackBoxLabel.setFont(ATKConstant.labelFont);
        this.add(this.blackBoxLabel);
        this.blackBoxText = new JTextField();
        this.blackBoxText.setText("10");
        this.blackBoxText.setFont(ATKConstant.labelFont);
        this.blackBoxText.setMargin(JiveUtils.noMargin);
        this.add(this.blackBoxText);
        this.blackBoxBtn = new JButton("Execute");
        this.blackBoxBtn.setFont(ATKConstant.labelFont);
        this.blackBoxBtn.addActionListener(this);
        this.add(this.blackBoxBtn);
        this.limitMinLabel = new JLabel("Answer limit (min)");
        this.limitMinLabel.setFont(ATKConstant.labelFont);
        this.add(this.limitMinLabel);
        this.limitMinText = new JTextField();
        this.limitMinText.setText("0");
        this.limitMinText.setFont(ATKConstant.labelFont);
        this.limitMinText.setMargin(JiveUtils.noMargin);
        this.add(this.limitMinText);
        this.limitMinBtn = new JButton("Apply");
        this.limitMinBtn.setFont(ATKConstant.labelFont);
        this.limitMinBtn.addActionListener(this);
        this.add(this.limitMinBtn);
        this.limitLengthLabel = new JLabel("Answer limit (length)");
        this.limitLengthLabel.setFont(ATKConstant.labelFont);
        this.add(this.limitLengthLabel);
        this.limitLengthText = new JTextField();
        this.limitLengthText.setText("1024");
        this.limitLengthText.setFont(ATKConstant.labelFont);
        this.limitLengthText.setMargin(JiveUtils.noMargin);
        this.add(this.limitLengthText);
        this.limitLengthBtn = new JButton("Apply");
        this.limitLengthBtn.setFont(ATKConstant.labelFont);
        this.limitLengthBtn.addActionListener(this);
        this.add(this.limitLengthBtn);
        this.infoBtn = new JButton("Device Info");
        this.infoBtn.addActionListener(this);
        this.infoBtn.setFont(ATKConstant.labelFont);
        this.add(this.infoBtn);
        this.pingBtn = new JButton("Ping Device");
        this.pingBtn.setFont(ATKConstant.labelFont);
        this.pingBtn.addActionListener(this);
        this.add(this.pingBtn);
        this.pollStatusBtn = new JButton("Polling status");
        this.pollStatusBtn.setFont(ATKConstant.labelFont);
        this.pollStatusBtn.addActionListener(this);
        this.add(this.pollStatusBtn);
        this.restartBtn = new JButton("Restart");
        this.restartBtn.addActionListener(this);
        this.restartBtn.setFont(ATKConstant.labelFont);
        this.add(this.restartBtn);
        this.addComponentListener(new ComponentListener(){

            @Override
            public void componentHidden(ComponentEvent e) {
            }

            @Override
            public void componentMoved(ComponentEvent e) {
            }

            @Override
            public void componentResized(ComponentEvent e) {
                CommonPanel.this.placeComponents(CommonPanel.this.getSize());
            }

            @Override
            public void componentShown(ComponentEvent e) {
                CommonPanel.this.placeComponents(CommonPanel.this.getSize());
            }
        });
        try {
            ds.ping();
            this.deviceAdm = ds.get_adm_dev();
        }
        catch (DevFailed e) {
            this.pingBtn.setEnabled(false);
            this.pollStatusBtn.setEnabled(false);
            this.restartBtn.setEnabled(false);
        }
    }

    private void placeComponents(Dimension dim) {
        this.sourceLabel.setBounds(10, 10, 120, 25);
        this.sourceCombo.setBounds(130, 10, 150, 25);
        this.timeoutLabel.setBounds(10, 40, 120, 25);
        this.timeoutText.setBounds(130, 40, 60, 25);
        this.setTimeoutBtn.setBounds(190, 40, 90, 25);
        this.blackBoxLabel.setBounds(10, 70, 120, 25);
        this.blackBoxText.setBounds(130, 70, 60, 25);
        this.blackBoxBtn.setBounds(190, 70, 90, 25);
        this.limitMinLabel.setBounds(10, 100, 120, 25);
        this.limitMinText.setBounds(130, 100, 60, 25);
        this.limitMinBtn.setBounds(190, 100, 90, 25);
        this.limitLengthLabel.setBounds(10, 130, 120, 25);
        this.limitLengthText.setBounds(130, 130, 60, 25);
        this.limitLengthBtn.setBounds(190, 130, 90, 25);
        this.infoBtn.setBounds(300, 10, 110, 25);
        this.pingBtn.setBounds(300, 40, 110, 25);
        this.pollStatusBtn.setBounds(300, 70, 110, 25);
        this.restartBtn.setBounds(300, 100, 110, 25);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object src = e.getSource();
        if (src == this.limitMinBtn) {
            try {
                this.answerLimitMin = Integer.parseInt(this.limitMinText.getText());
            }
            catch (NumberFormatException ex) {
                JOptionPane.showMessageDialog(this, "Invalid answer limit\n" + ex.getMessage());
            }
        } else if (src == this.limitLengthBtn) {
            try {
                this.answerLimitMax = Integer.parseInt(this.limitLengthText.getText()) + this.answerLimitMin;
            }
            catch (NumberFormatException ex) {
                JOptionPane.showMessageDialog(this, "Invalid answer lenght\n" + ex.getMessage());
            }
        } else if (src == this.blackBoxBtn) {
            try {
                int nbCmd = Integer.parseInt(this.blackBoxText.getText());
                long t0 = System.currentTimeMillis();
                String[] out = this.device.black_box(nbCmd);
                long t1 = System.currentTimeMillis();
                this.console.print("------------------------------------------\n");
                this.console.print("Command: " + this.device.name() + "/BlackBox\n");
                this.console.print("Duration: " + (t1 - t0) + " msec\n\n");
                for (int i = 0; i < out.length; ++i) {
                    this.console.print("[" + i + "]\t " + out[i] + "\n");
                }
            }
            catch (NumberFormatException e1) {
                JOptionPane.showMessageDialog(this, "Invalid command number\n" + e1.getMessage());
            }
            catch (DevFailed e2) {
                ErrorPane.showErrorMessage((Component)this, (String)this.device.name(), (DevFailed)e2);
            }
        } else if (src == this.infoBtn) {
            try {
                long t0 = System.currentTimeMillis();
                DevInfo out = this.device.info();
                long t1 = System.currentTimeMillis();
                this.console.print("----------------------------------------------------\n");
                this.console.print("Command: " + this.device.name() + "/Info\n");
                this.console.print("Duration: " + (t1 - t0) + " msec\n\n");
                this.console.print("Server: " + out.server_id + "\n");
                this.console.print("Server host: " + out.server_host + "\n");
                this.console.print("Server version: " + out.server_version + "\n");
                this.console.print("Class: " + out.dev_class + "\n");
                this.console.print(out.doc_url + "\n");
            }
            catch (DevFailed e1) {
                ErrorPane.showErrorMessage((Component)this, (String)this.device.name(), (DevFailed)e1);
            }
        } else if (src == this.pingBtn) {
            try {
                long t0 = System.currentTimeMillis();
                this.device.ping();
                long t1 = System.currentTimeMillis();
                this.console.print("------------------------------------------\n");
                this.console.print("Command: " + this.device.name() + "/Ping\n");
                this.console.print("Duration: " + (t1 - t0) + " msec\n\n");
                this.console.print("Device is alive\n");
            }
            catch (DevFailed e1) {
                ErrorPane.showErrorMessage((Component)this, (String)this.device.name(), (DevFailed)e1);
            }
        } else if (src == this.pollStatusBtn) {
            try {
                DeviceData argin = new DeviceData();
                argin.insert(this.device.name());
                DeviceData argout = this.deviceAdm.command_inout("DevPollStatus", argin);
                String[] pollStatus = argout.extractStringArray();
                this.console.print("----------------------------------------------------\n");
                for (int i = 0; i < pollStatus.length; ++i) {
                    this.console.print(pollStatus[i] + "\n\n");
                }
            }
            catch (DevFailed e1) {
                ErrorPane.showErrorMessage((Component)this, (String)this.device.name(), (DevFailed)e1);
            }
        } else if (src == this.restartBtn) {
            try {
                DeviceData argin = new DeviceData();
                argin.insert(this.device.name());
                this.deviceAdm.command_inout("DevRestart", argin);
                this.console.print("----------------------------------------------------\n");
                this.console.print("Restart OK\n\n");
            }
            catch (DevFailed e1) {
                ErrorPane.showErrorMessage((Component)this, (String)this.device.name(), (DevFailed)e1);
            }
        } else if (src == this.setTimeoutBtn) {
            try {
                int timeout = Integer.parseInt(this.timeoutText.getText());
                this.device.set_timeout_millis(timeout);
            }
            catch (NumberFormatException e1) {
                JOptionPane.showMessageDialog(this, "Invalid timeout value\n" + e1.getMessage());
            }
            catch (DevFailed e2) {
                ErrorPane.showErrorMessage((Component)this, (String)this.device.name(), (DevFailed)e2);
            }
        } else if (src == this.sourceCombo) {
            try {
                int idx = this.sourceCombo.getSelectedIndex();
                switch (idx) {
                    case 0: {
                        this.device.set_source(DevSource.CACHE);
                        break;
                    }
                    case 1: {
                        this.device.set_source(DevSource.CACHE_DEV);
                        break;
                    }
                    case 2: {
                        this.device.set_source(DevSource.DEV);
                    }
                }
            }
            catch (DevFailed e1) {
                ErrorPane.showErrorMessage((Component)this, (String)this.device.name(), (DevFailed)e1);
            }
        }
    }

    public int getAnswerLimitMin() {
        return this.answerLimitMin;
    }

    public int getAnswerLimitMax() {
        return this.answerLimitMax;
    }

    @Override
    public Dimension getPreferredSize() {
        return this.getMinimunSize();
    }

    public Dimension getMinimunSize() {
        return new Dimension(470, 135);
    }
}

