/*
 * Decompiled with CFR 0.152.
 */
package fr.esrf.tangoatk.core.command;

import fr.esrf.TangoApi.DeviceData;
import fr.esrf.tangoatk.core.command.ACommand;
import fr.esrf.tangoatk.core.command.ACommandHelper;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.List;
import java.util.Vector;

class ArrayCommandHelper
extends ACommandHelper {
    ArrayCommandHelper(ACommand aCommand) {
        super(aCommand);
    }

    @Override
    protected DeviceData setInput(List list) {
        int n = list.size();
        switch (this.getInType()) {
            case 10: {
                short[] sArray = new short[n];
                for (int i = 0; i < n; ++i) {
                    sArray[i] = Short.parseShort((String)list.get(i));
                }
                this.data.insert(sArray);
                break;
            }
            case 12: {
                float[] fArray = new float[n];
                for (int i = 0; i < n; ++i) {
                    fArray[i] = Float.parseFloat((String)list.get(i));
                }
                this.data.insert(fArray);
                break;
            }
            case 13: {
                double[] dArray = new double[n];
                for (int i = 0; i < n; ++i) {
                    dArray[i] = Double.parseDouble((String)list.get(i));
                }
                this.data.insert(dArray);
                break;
            }
            case 14: {
                int[] nArray = new int[n];
                for (int i = 0; i < n; ++i) {
                    nArray[i] = Integer.parseInt((String)list.get(i));
                }
                this.data.insert_us(nArray);
                break;
            }
            case 15: {
                long[] lArray = new long[n];
                for (int i = 0; i < n; ++i) {
                    lArray[i] = Long.parseLong((String)list.get(i));
                }
                this.data.insert_ul(lArray);
                break;
            }
            case 11: {
                int[] nArray = new int[n];
                for (int i = 0; i < n; ++i) {
                    nArray[i] = Integer.parseInt((String)list.get(i));
                }
                this.data.insert(nArray);
                break;
            }
            case 16: {
                String[] stringArray = new String[n];
                for (int i = 0; i < n; ++i) {
                    stringArray[i] = (String)list.get(i);
                }
                this.data.insert(stringArray);
                break;
            }
            case 9: {
                byte[] byArray = new byte[n];
                for (int i = 0; i < n; ++i) {
                    byArray[i] = Byte.parseByte((String)list.get(i));
                }
                this.data.insert(byArray);
            }
        }
        return this.data;
    }

    @Override
    protected List<String> extractOutput(DeviceData deviceData) {
        Vector<String> vector = new Vector<String>();
        switch (this.getOutType()) {
            case 10: {
                short[] sArray = deviceData.extractShortArray();
                for (int i = 0; i < sArray.length; ++i) {
                    vector.add(Short.toString(sArray[i]));
                }
                break;
            }
            case 12: {
                float[] fArray = deviceData.extractFloatArray();
                for (int i = 0; i < fArray.length; ++i) {
                    vector.add(Float.toString(fArray[i]));
                }
                break;
            }
            case 13: {
                double[] dArray = deviceData.extractDoubleArray();
                for (int i = 0; i < dArray.length; ++i) {
                    vector.add(Double.toString(dArray[i]));
                }
                break;
            }
            case 11: {
                long[] lArray = deviceData.extractULongArray();
                for (int i = 0; i < lArray.length; ++i) {
                    vector.add(Long.toString(lArray[i]));
                }
                break;
            }
            case 14: {
                int[] nArray = deviceData.extractUShortArray();
                for (int i = 0; i < nArray.length; ++i) {
                    vector.add(Integer.toString(nArray[i]));
                }
                break;
            }
            case 15: {
                long[] lArray = deviceData.extractULongArray();
                for (int i = 0; i < lArray.length; ++i) {
                    vector.add(Long.toString(lArray[i]));
                }
                break;
            }
            case 16: {
                String[] stringArray = deviceData.extractStringArray();
                for (int i = 0; i < stringArray.length; ++i) {
                    vector.add(stringArray[i]);
                }
                break;
            }
            case 9: {
                byte[] byArray = deviceData.extractByteArray();
                for (int i = 0; i < byArray.length; ++i) {
                    vector.add(Byte.toString(byArray[i]));
                }
                break;
            }
        }
        return vector;
    }

    @Override
    public String getVersion() {
        return "$Id: ArrayCommandHelper.java 14675 2010-06-10 15:11:55Z poncet $";
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        try {
            this.serializeInit();
        }
        catch (Exception exception) {
            throw new IOException(exception.getMessage());
        }
    }
}

