/*
 * Decompiled with CFR 0.152.
 */
package fr.esrf.tangoatk.core.attribute;

import fr.esrf.Tango.DevFailed;
import fr.esrf.TangoApi.DeviceAttribute;
import fr.esrf.TangoApi.events.TangoChangeEvent;
import fr.esrf.TangoApi.events.TangoPeriodicEvent;
import fr.esrf.tangoatk.core.AttributeReadException;
import fr.esrf.tangoatk.core.AttributeSetException;
import fr.esrf.tangoatk.core.DeviceFactory;
import fr.esrf.tangoatk.core.IRawImage;
import fr.esrf.tangoatk.core.IRawImageListener;
import fr.esrf.tangoatk.core.attribute.AAttribute;
import fr.esrf.tangoatk.core.attribute.RawImageHelper;
import java.io.IOException;
import java.io.ObjectInputStream;

public class RawImage
extends AAttribute
implements IRawImage {
    RawImageHelper imageHelper = new RawImageHelper(this);
    byte[] imageValue = null;
    String encFormat;

    @Override
    public String getType() {
        return "RawImage";
    }

    @Override
    public byte[] getValue() {
        return this.imageValue;
    }

    @Override
    public String getEncodedFormat() {
        return this.encFormat;
    }

    @Override
    public void setValue(String string, byte[] byArray) {
        this.setAttError("Couldn't set value of RawImage", new AttributeSetException("RawImage writting not supported"));
    }

    @Override
    public void refresh() {
        DeviceAttribute deviceAttribute = null;
        ++this.refreshCount;
        try {
            try {
                deviceAttribute = this.readValueFromNetwork();
                if (deviceAttribute == null) {
                    return;
                }
                this.imageValue = this.imageHelper.getRawImageValue(deviceAttribute);
                this.encFormat = this.imageHelper.getRawImageFormat();
                this.fireValueChanged(this.encFormat, this.imageValue);
            }
            catch (DevFailed devFailed) {
                this.readAttError(devFailed.getMessage(), new AttributeReadException(devFailed));
            }
        }
        catch (Exception exception) {
            System.out.println("RawImage.refresh() Exception caught ------------------------------");
            exception.printStackTrace();
            System.out.println("RawImage.refresh()------------------------------------------------");
        }
    }

    @Override
    public void dispatch(DeviceAttribute deviceAttribute) {
        ++this.refreshCount;
        try {
            try {
                if (deviceAttribute == null) {
                    return;
                }
                this.attribute = deviceAttribute;
                this.setState(deviceAttribute);
                this.timeStamp = deviceAttribute.getTimeValMillisSec();
                this.imageValue = this.imageHelper.getRawImageValue(deviceAttribute);
                this.encFormat = this.imageHelper.getRawImageFormat();
                this.fireValueChanged(this.encFormat, this.imageValue);
            }
            catch (DevFailed devFailed) {
                this.dispatchError(devFailed);
            }
        }
        catch (Exception exception) {
            System.out.println("RawImage.dispatch() Exception caught ------------------------------");
            exception.printStackTrace();
            System.out.println("RawImage.dispatch()------------------------------------------------");
        }
    }

    @Override
    public void dispatchError(DevFailed devFailed) {
        this.imageValue = null;
        this.readAttError(devFailed.getMessage(), new AttributeReadException(devFailed));
    }

    @Override
    public boolean isWritable() {
        return super.isWritable();
    }

    protected void fireValueChanged(String string, byte[] byArray) {
        this.imageHelper.fireRawImageValueChanged(this.encFormat, byArray, this.timeStamp);
    }

    @Override
    public void addRawImageListener(IRawImageListener iRawImageListener) {
        this.imageHelper.addRawImageListener(iRawImageListener);
        this.addStateListener(iRawImageListener);
    }

    @Override
    public void removeRawImageListener(IRawImageListener iRawImageListener) {
        this.imageHelper.removeRawImageListener(iRawImageListener);
        this.removeStateListener(iRawImageListener);
    }

    public void periodic(TangoPeriodicEvent tangoPeriodicEvent) {
        ++this.periodicCount;
        this.eventType = tangoPeriodicEvent.isZmqEvent() ? 2 : 1;
        DeviceAttribute deviceAttribute = null;
        long l = System.currentTimeMillis();
        this.trace(128, "RawImage.periodic method called for " + this.getName(), l);
        try {
            deviceAttribute = tangoPeriodicEvent.getValue();
            this.trace(128, "RawImage.periodicEvt.getValue(" + this.getName() + ") success", l);
        }
        catch (DevFailed devFailed) {
            this.trace(128, "RawImage.periodicEvt.getValue(" + this.getName() + ") failed, caught DevFailed", l);
            if (devFailed.errors[0].reason.equals("API_EventTimeout")) {
                this.trace(128, "RawImage.periodicEvt.getValue(" + this.getName() + ") failed, got heartbeat error", l);
                this.readAttError(devFailed.getMessage(), new AttributeReadException(devFailed));
            } else {
                this.trace(128, "RawImage.periodicEvt.getValue(" + this.getName() + ") failed, got other error", l);
                this.readAttError(devFailed.getMessage(), new AttributeReadException(devFailed));
            }
            return;
        }
        catch (Exception exception) {
            this.trace(128, "RawImage.periodicEvt.getValue(" + this.getName() + ") failed, caught Exception, code failure", l);
            System.out.println("RawImage.periodic.getValue() Exception caught ------------------------------");
            exception.printStackTrace();
            System.out.println("RawImage.periodic.getValue()------------------------------------------------");
            return;
        }
        if (deviceAttribute != null) {
            try {
                this.setState(deviceAttribute);
                this.attribute = deviceAttribute;
                this.timeStamp = deviceAttribute.getTimeValMillisSec();
                this.imageValue = this.imageHelper.getRawImageValue(deviceAttribute);
                this.encFormat = this.imageHelper.getRawImageFormat();
                this.fireValueChanged(this.encFormat, this.imageValue);
            }
            catch (DevFailed devFailed) {
                this.readAttError(devFailed.getMessage(), new AttributeReadException(devFailed));
            }
            catch (Exception exception) {
                System.out.println("RawImage.periodic.extractCharArray() Exception caught ------------------------------");
                exception.printStackTrace();
                System.out.println("RawImage.periodic.extractCharArray()------------------------------------------------");
            }
        }
    }

    public void change(TangoChangeEvent tangoChangeEvent) {
        ++this.changeCount;
        this.eventType = tangoChangeEvent.isZmqEvent() ? 2 : 1;
        DeviceAttribute deviceAttribute = null;
        long l = System.currentTimeMillis();
        this.trace(32, "RawImage.change method called for " + this.getName(), l);
        try {
            deviceAttribute = tangoChangeEvent.getValue();
            this.trace(32, "RawImage.changeEvt.getValue(" + this.getName() + ") success", l);
        }
        catch (DevFailed devFailed) {
            this.trace(32, "RawImage.changeEvt.getValue(" + this.getName() + ") failed, caught DevFailed", l);
            if (devFailed.errors[0].reason.equals("API_EventTimeout")) {
                this.trace(32, "RawImage.changeEvt.getValue(" + this.getName() + ") failed, got heartbeat error", l);
                this.readAttError(devFailed.getMessage(), new AttributeReadException(devFailed));
            } else {
                this.trace(32, "RawImage.changeEvt.getValue(" + this.getName() + ") failed, got other error", l);
                this.readAttError(devFailed.getMessage(), new AttributeReadException(devFailed));
            }
            return;
        }
        catch (Exception exception) {
            this.trace(32, "RawImage.changeEvt.getValue(" + this.getName() + ") failed, caught Exception, code failure", l);
            System.out.println("RawImage.change.getValue() Exception caught ------------------------------");
            exception.printStackTrace();
            System.out.println("RawImage.change.getValue()------------------------------------------------");
            return;
        }
        if (deviceAttribute != null) {
            try {
                this.setState(deviceAttribute);
                this.attribute = deviceAttribute;
                this.timeStamp = deviceAttribute.getTimeValMillisSec();
                this.imageValue = this.imageHelper.getRawImageValue(deviceAttribute);
                this.encFormat = this.imageHelper.getRawImageFormat();
                this.fireValueChanged(this.encFormat, this.imageValue);
            }
            catch (DevFailed devFailed) {
                this.readAttError(devFailed.getMessage(), new AttributeReadException(devFailed));
            }
            catch (Exception exception) {
                System.out.println("RawImage.change.extractCharArray() Exception caught ------------------------------");
                exception.printStackTrace();
                System.out.println("RawImage.change.extractCharArray()------------------------------------------------");
            }
        }
    }

    private void trace(int n, String string, long l) {
        DeviceFactory.getInstance().trace(n, string, l);
    }

    @Override
    public String getVersion() {
        return "$Id: RawImage.java 28694 2015-11-09 16:19:57Z poncet $";
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        System.out.print("Loading attribute ");
        objectInputStream.defaultReadObject();
        this.serializeInit();
    }
}

