/*
 * Decompiled with CFR 0.152.
 */
package JSSHTerminal;

import JSSHTerminal.MainPanel;
import JSSHTerminal.TerminalEvent;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.font.FontRenderContext;
import java.awt.font.LineMetrics;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;

public class TextTerminal
extends TerminalEvent {
    private static BufferedImage dummyImg = null;
    private static FontRenderContext frc = null;
    private static Font plainFont;
    private static Font boldFont;
    private int fontAscent;
    private char[] charBuffer;
    public static final char[] C0;

    public TextTerminal(MainPanel parent, int width, int height) {
        this.setBorder(null);
        this.setOpaque(false);
        this.setDoubleBuffered(false);
        this.setFocusable(true);
        this.setFocusTraversalKeysEnabled(false);
        plainFont = new Font("Monospaced", 0, 14);
        boldFont = plainFont.deriveFont(1);
        int[] dim = TextTerminal.measureString(plainFont, "W");
        this.init(parent, width, height, dim[0], dim[1]);
        this.fontAscent = dim[2];
    }

    @Override
    public void dispose() {
        dummyImg = null;
    }

    @Override
    public void sizeComponent(int width, int height) {
        this.charBuffer = new char[width];
    }

    @Override
    public synchronized void drawComponent(Graphics g) {
        Graphics2D g2 = (Graphics2D)g;
        g.setColor(Color.BLACK);
        g.drawRect(0, 0, this.termWidth * this.charWidth, this.termHeight * this.charHeight);
        g.setFont(plainFont);
        int[] scr = this.terminal.getScreen(this.scrollPos);
        int i = 0;
        for (int y = 0; y < this.termHeight; ++y) {
            for (int x = 0; x < this.termWidth; ++x) {
                Color fgColor;
                Color bgColor;
                int c = scr[i] & 0xFFFF;
                int sgr = scr[i] >> 16;
                int bg = (sgr & 0x70) >> 4;
                int fg = sgr & 7;
                boolean bold = (sgr & 8) != 0;
                boolean underline = (sgr & 0x80) != 0;
                boolean reverse = (sgr & 0x400) != 0;
                int charSet = (sgr & 0x300) >> 8;
                if (reverse) {
                    bgColor = defaultColors[fg];
                    fgColor = bold ? defaultBrightColors[bg] : defaultColors[bg];
                } else {
                    bgColor = defaultColors[bg];
                    fgColor = bold ? defaultBrightColors[fg] : defaultColors[fg];
                }
                if (i - this.scrollPos * this.termWidth >= this.terminal.getStartSelection() && i - this.scrollPos * this.termWidth <= this.terminal.getEndSelection()) {
                    bgColor = Color.WHITE;
                    fgColor = Color.BLACK;
                }
                if (this.terminal.isCursor(x, y - this.scrollPos)) {
                    bgColor = this.cursorBackground;
                    fgColor = Color.BLACK;
                }
                this.charBuffer[0] = charSet == 2 && c >= 96 && c < 128 ? C0[c - 96] : (char)c;
                if (!bgColor.equals(Color.BLACK)) {
                    g.setColor(bgColor);
                    g.fillRect(x * this.charWidth, y * this.charHeight, this.charWidth, this.charHeight);
                }
                if (c > 32) {
                    g.setColor(fgColor);
                    if (bold) {
                        g.setFont(boldFont);
                    } else {
                        g.setFont(plainFont);
                    }
                    g.drawChars(this.charBuffer, 0, 1, x * this.charWidth, y * this.charHeight + this.fontAscent);
                }
                if (underline) {
                    g.setColor(Color.WHITE);
                    g.drawLine(x * this.charWidth, (y + 1) * this.charHeight - 1, (x + 1) * this.charWidth, (y + 1) * this.charHeight - 1);
                }
                ++i;
            }
        }
    }

    private static int[] measureString(Font f, String s) {
        int[] ret = new int[3];
        if (dummyImg == null) {
            dummyImg = new BufferedImage(8, 8, 1);
            Graphics2D g = (Graphics2D)dummyImg.getGraphics();
            frc = g.getFontRenderContext();
            g.dispose();
        }
        LineMetrics lm = f.getLineMetrics(s, frc);
        Rectangle2D bounds = f.getStringBounds(s, frc);
        ret[0] = (int)(bounds.getWidth() + 0.5);
        ret[1] = (int)(bounds.getHeight() + 0.5);
        ret[2] = (int)((double)lm.getAscent() + 0.5);
        return ret;
    }

    static {
        C0 = new char[]{'\u25c6', '\u2592', '\u2409', '\u240c', '\u240d', '\u240a', '\u00b0', '\u00b1', '\u2424', '\u240b', '\u2518', '\u2510', '\u250c', '\u2514', '\u253c', '\u23ba', '\u23bb', '\u2500', '\u23bc', '\u23bd', '\u251c', '\u2524', '\u2534', '\u252c', '\u2502', '\u2264', '\u2265', '\u03c0', '\u2260', '\u00a3', '\u00b7'};
    }
}

