/*
 * Decompiled with CFR 0.152.
 */
package JSSHTerminal;

import JSSHTerminal.MainPanel;
import JSSHTerminal.SSHSession;
import JSSHTerminal.TerminalEmulator;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.io.IOException;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;

public abstract class TerminalEvent
extends JComponent
implements MouseListener,
MouseMotionListener {
    static final Color[] defaultColors = new Color[]{Color.BLACK, new Color(170, 0, 0), new Color(0, 170, 0), new Color(197, 94, 0), new Color(0, 0, 170), new Color(170, 0, 170), new Color(0, 170, 170), new Color(220, 220, 220)};
    static final Color[] defaultBrightColors = new Color[]{new Color(90, 90, 90), new Color(255, 90, 90), new Color(90, 255, 90), new Color(255, 128, 0), new Color(90, 90, 255), new Color(255, 0, 255), new Color(0, 255, 255), Color.WHITE};
    final Color cursorBackground = new Color(0, 170, 0);
    SSHSession session = null;
    TerminalEmulator terminal = null;
    int charWidth;
    int charHeight;
    int termWidth = 0;
    int termHeight = 0;
    int scrollPos = 0;
    Dimension size;
    MainPanel _parent;
    boolean isDragging;
    MouseEvent startSel = null;
    MouseEvent endSel = null;

    public void init(MainPanel parent, int width, int height, int charWidth, int charHeight) {
        this._parent = parent;
        this.setBorder(null);
        this.setOpaque(false);
        this.setDoubleBuffered(false);
        this.setFocusable(true);
        this.setFocusTraversalKeysEnabled(false);
        this.setCursor(Cursor.getPredefinedCursor(2));
        this.charWidth = charWidth;
        this.charHeight = charHeight;
        this.resizeComponent(width, height);
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                TerminalEvent.this.resize();
            }
        });
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
    }

    private void resize() {
        Dimension d = this.getSize();
        if (d.width % this.charWidth == 0 && d.height % this.charHeight == 0) {
            this.resizeComponent(d.width / this.charWidth, d.height / this.charHeight);
        } else {
            this.setSize(this.charWidth * (d.width / this.charWidth), this.charHeight * (d.height / this.charHeight));
        }
    }

    public abstract void dispose();

    public abstract void sizeComponent(int var1, int var2);

    synchronized void resizeComponent(int width, int height) {
        if (this.termHeight != height || this.termWidth != width) {
            this.termWidth = width;
            this.termHeight = height;
            this.sizeComponent(width, height);
            this.size = new Dimension(this.termWidth * this.charWidth, this.termHeight * this.charHeight);
            this.notifySizeChange();
        }
    }

    public void notifySizeChange() {
        if (this.terminal != null) {
            this.terminal.resize(this.termWidth, this.termHeight);
        }
        if (this.session != null) {
            this.session.resize(this.termWidth, this.termHeight);
        }
    }

    @Override
    public Dimension getPreferredSize() {
        return this.size;
    }

    public void setSession(SSHSession session) {
        this.session = session;
        this.terminal = session.getTerminal();
    }

    public void setScrollPos(int pos) {
        this.scrollPos = this.terminal.getScrollSize() - pos - this.termHeight;
        this.repaint();
    }

    public void moveScroll(int move) {
        this.scrollPos += move;
        if (this.scrollPos < 0) {
            this.scrollPos = 0;
        }
        if (this.scrollPos > this.terminal.getScrollSize() - this.termHeight) {
            this.scrollPos = this.terminal.getScrollSize() - this.termHeight;
        }
        this.repaint();
    }

    public abstract void drawComponent(Graphics var1);

    @Override
    public void paint(Graphics g) {
        this.drawComponent(g);
        if (this.terminal.getTitle().length() > 0) {
            this._parent.setExtraTilte(this.terminal.getTitle());
        }
    }

    @Override
    public void processKeyEvent(KeyEvent e) {
        int id = e.getID();
        if (id == 401 && this.session != null) {
            this.keyPressed(e);
        }
        e.consume();
    }

    public void keyPressed(KeyEvent e) {
        int keycode = e.getKeyCode();
        byte[] code = null;
        switch (keycode) {
            case 16: 
            case 17: 
            case 18: 
            case 20: {
                return;
            }
            case 10: {
                code = TerminalEmulator.getCodeENTER();
                break;
            }
            case 38: {
                code = TerminalEmulator.getCodeUP();
                break;
            }
            case 40: {
                code = TerminalEmulator.getCodeDOWN();
                break;
            }
            case 39: {
                code = TerminalEmulator.getCodeRIGHT();
                break;
            }
            case 37: {
                code = TerminalEmulator.getCodeLEFT();
                break;
            }
            case 112: {
                code = TerminalEmulator.getCodeF1();
                break;
            }
            case 113: {
                code = TerminalEmulator.getCodeF2();
                break;
            }
            case 114: {
                code = TerminalEmulator.getCodeF3();
                break;
            }
            case 115: {
                code = TerminalEmulator.getCodeF4();
                break;
            }
            case 116: {
                code = TerminalEmulator.getCodeF5();
                break;
            }
            case 117: {
                code = TerminalEmulator.getCodeF6();
                break;
            }
            case 118: {
                code = TerminalEmulator.getCodeF7();
                break;
            }
            case 119: {
                code = TerminalEmulator.getCodeF8();
                break;
            }
            case 120: {
                code = TerminalEmulator.getCodeF9();
                break;
            }
            case 121: {
                code = TerminalEmulator.getCodeF10();
                break;
            }
            case 122: {
                code = TerminalEmulator.getCodeF11();
                break;
            }
            case 123: {
                code = TerminalEmulator.getCodeF12();
                break;
            }
            case 9: {
                code = TerminalEmulator.getCodeTAB();
            }
        }
        if (code != null) {
            try {
                this.session.write(code);
            }
            catch (Exception ee) {
                ee.printStackTrace();
            }
            this.scrollPos = 0;
            return;
        }
        char keychar = e.getKeyChar();
        if ((keychar & 0xFF00) == 0) {
            try {
                this.session.write(new byte[]{(byte)e.getKeyChar()});
                this.scrollPos = 0;
            }
            catch (Exception ee) {
                // empty catch block
            }
        }
    }

    private void sendMouseEvent(int x, int y, int b, boolean press) {
        if (b < 1) {
            return;
        }
        char Cx = (char)(x + 33);
        char Cy = (char)(y + 33);
        char Cb = press ? (char)((char)(b + 31)) : (char)'#';
        String seq = "\u001b[M" + Cb + Cx + Cy;
        this.session.write(seq);
    }

    private void copyToClipboard(String s) {
        if (s.length() > 0) {
            StringSelection stringSelection = new StringSelection(s);
            Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
            clipboard.setContents(stringSelection, null);
        }
    }

    private String getFromClipboard() {
        String ret = "";
        Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
        try {
            ret = (String)clipboard.getData(DataFlavor.stringFlavor);
        }
        catch (UnsupportedFlavorException e1) {
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return ret;
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        if (SwingUtilities.isLeftMouseButton(e) && e.getClickCount() == 2) {
            int sX = e.getX() / this.charWidth;
            int sY = e.getY() / this.charHeight - this.scrollPos;
            this.terminal.autoSelect(sX + sY * this.termWidth);
            this.copyToClipboard(this.terminal.getSelectedText());
            this.repaint();
        }
        if (SwingUtilities.isMiddleMouseButton(e) && e.getClickCount() == 1) {
            String s = this.getFromClipboard();
            this.session.write(s);
            this.scrollPos = 0;
        }
    }

    @Override
    public void mousePressed(MouseEvent e) {
        if (SwingUtilities.isLeftMouseButton(e)) {
            this.startSel = e;
            this.endSel = null;
            this.setSelection(this.startSel, this.endSel);
            this.isDragging = false;
            this.repaint();
        }
        if (this.terminal.isMouseEnabled()) {
            int sX = e.getX() / this.charWidth;
            int sY = e.getY() / this.charHeight - this.scrollPos;
            this.sendMouseEvent(sX, sY, e.getButton(), true);
        }
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        if (SwingUtilities.isLeftMouseButton(e) && this.isDragging) {
            this.endSel = e;
            this.setSelection(this.startSel, this.endSel);
            this.copyToClipboard(this.terminal.getSelectedText());
            this.isDragging = false;
            this.repaint();
        }
        if (this.terminal.isMouseEnabled()) {
            int sX = e.getX() / this.charWidth;
            int sY = e.getY() / this.charHeight - this.scrollPos;
            this.sendMouseEvent(sX, sY, e.getButton(), false);
        }
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        if (SwingUtilities.isLeftMouseButton(e)) {
            this.isDragging = true;
            this.endSel = e;
            this.setSelection(this.startSel, this.endSel);
            this.repaint();
        }
    }

    private void setSelection(MouseEvent s, MouseEvent e) {
        int eOff;
        if (s == null || e == null) {
            this.terminal.clearSelection();
            return;
        }
        int sOff = this.getCursorCoordinates(s);
        if (sOff == (eOff = this.getCursorCoordinates(e))) {
            this.terminal.clearSelection();
            return;
        }
        if (sOff > eOff) {
            int swb = sOff;
            sOff = eOff;
            eOff = swb;
        }
        this.terminal.setSelection(sOff, --eOff);
    }

    private int getCursorCoordinates(MouseEvent e) {
        int drift = MainPanel.isWindows ? 2 : 0;
        int sX = (e.getX() + drift + this.charWidth / 2) / this.charWidth;
        int sY = e.getY() / this.charHeight - this.scrollPos;
        int offset = sX + sY * this.termWidth;
        return offset;
    }

    @Override
    public void mouseMoved(MouseEvent e) {
    }
}

