/*
 * Decompiled with CFR 0.152.
 */
package JSSHTerminal;

import java.util.Arrays;

class Screen {
    private static final int EMPTY_CH = 458752;
    private static final char[] WORDC = new char[]{'-', '.', '/', '?', '%', '&', '#', ':', '_', '=', '+', '@', '~'};
    int[] scr;
    int[] scrollScr;
    int scrollSize;
    int scrollFill;
    int width;
    int height;
    int st;
    int sb;
    int cx;
    int cy;
    int cx_bak;
    int cy_bak;
    boolean mouseEna;
    int sgr;
    boolean nextLine;
    boolean showCursor;
    int startSel;
    int endSel;

    Screen(int width, int height, int scroll) {
        this.width = width;
        this.height = height;
        this.scrollSize = scroll;
        this.scrollScr = null;
        this.scrollFill = 0;
        this.scr = null;
        this.scr = new int[width * height];
        if (this.scrollSize > 0) {
            this.scrollScr = new int[width * this.scrollSize];
        }
        this.reset();
    }

    void reset() {
        Arrays.fill(this.scr, 458752);
        if (this.scrollSize != 0) {
            Arrays.fill(this.scrollScr, 458752);
            this.scrollFill = 0;
        }
        this.st = 0;
        this.sb = this.height - 1;
        this.cx = 0;
        this.cx_bak = 0;
        this.cy = 0;
        this.cy_bak = 0;
        this.nextLine = false;
        this.sgr = 458752;
        this.showCursor = true;
        this.clearSelection();
        this.mouseEna = false;
    }

    public void setSelection(int start, int end) {
        if (end < start) {
            int swp = end;
            end = start;
            start = swp;
        }
        if (start < -(this.scrollSize * this.width - 1)) {
            start = -(this.scrollSize * this.width - 1);
        }
        if (end > this.scr.length - 1) {
            end = this.scr.length - 1;
        }
        if (this.getCharAt(start) == 0) {
            while (start > -(this.scrollSize * this.width - 1) && this.getCharAt(start - 1) == 0) {
                --start;
            }
        }
        if (this.getCharAt(end) == 0) {
            while (end < this.scr.length - 2 && this.getCharAt(end + 1) == 0) {
                ++end;
            }
        }
        this.startSel = start;
        this.endSel = end;
    }

    public void clearSelection() {
        this.startSel = Integer.MIN_VALUE;
        this.endSel = Integer.MIN_VALUE;
    }

    private boolean isWordChar(int c) {
        if (c >= 65 && c <= 90) {
            return true;
        }
        if (c >= 97 && c <= 122) {
            return true;
        }
        if (c >= 48 && c <= 57) {
            return true;
        }
        int i = 0;
        boolean found = false;
        while (!found && i < WORDC.length) {
            found = WORDC[i] == c;
            if (found) continue;
            ++i;
        }
        return found;
    }

    public void autoSelect(int offset) {
        if (this.getCharAt(offset) <= 32) {
            this.clearSelection();
        } else {
            this.startSel = offset;
            this.endSel = offset;
            while (this.startSel > -(this.scrollSize * this.width - 1) && this.isWordChar(this.getCharAt(this.startSel - 1))) {
                --this.startSel;
            }
            while (this.endSel < this.scr.length - 1 && this.isWordChar(this.getCharAt(this.endSel + 1))) {
                ++this.endSel;
            }
        }
    }

    public boolean isValidSelection() {
        return this.startSel != Integer.MIN_VALUE && this.endSel != Integer.MIN_VALUE;
    }

    public String getSelectedText() {
        if (!this.isValidSelection()) {
            return "";
        }
        StringBuffer str = new StringBuffer();
        int sX = this.startSel % this.width;
        int sY = this.startSel / this.width;
        for (int i = this.startSel; i <= this.endSel; ++i) {
            int c = this.getCharAt(i);
            if (c != 0) {
                str.append((char)c);
            }
            if (++sX < this.width) continue;
            if (this.getCharAt(i) == 0) {
                str.append("\n");
            }
            sX = 0;
            ++sY;
        }
        return str.toString();
    }

    public void resize(int nWidth, int nHeight, int nScroll) {
        if (nWidth == this.width && nHeight == this.height && nScroll == this.scrollSize) {
            return;
        }
        int[] nScr = new int[nWidth * nHeight];
        Arrays.fill(nScr, 458752);
        int i = 0;
        for (int y = 0; y < nHeight; ++y) {
            for (int x = 0; x < nWidth; ++x) {
                nScr[i] = this.getAt(x, y);
                ++i;
            }
        }
        int[] nScrollScr = null;
        if (nScroll > 0) {
            nScrollScr = new int[nWidth * nScroll];
            Arrays.fill(nScrollScr, 458752);
            i = 0;
            for (int y = 0; y < nScroll; ++y) {
                for (int x = 0; x < nWidth; ++x) {
                    nScrollScr[i] = this.getAtScroll(x, y);
                    ++i;
                }
            }
        }
        this.width = nWidth;
        this.height = nHeight;
        this.scr = nScr;
        this.scrollScr = nScrollScr;
        if (this.cx >= this.width) {
            this.cx = this.width - 1;
        }
        if (this.cy >= this.height) {
            this.cy = this.height - 1;
        }
        this.st = 0;
        this.sb = this.height - 1;
        this.cx_bak = this.cx;
        this.cy_bak = this.cy;
        this.nextLine = false;
        this.sgr = 458752;
        this.showCursor = true;
    }

    private int $(int y, int x) {
        return y * this.width + x;
    }

    public int getCharAt(int offset) {
        if (offset >= 0) {
            return this.scr[offset] & 0xFFFF;
        }
        if ((offset = this.scrollSize * this.width + offset) >= 0 && this.scrollScr != null) {
            return this.scrollScr[offset] & 0xFFFF;
        }
        return 0;
    }

    public int getAt(int x, int y) {
        if (x < this.width && y < this.height) {
            return this.scr[this.$(y, x)];
        }
        return 458752;
    }

    public int getAtScroll(int x, int y) {
        if (this.scrollScr != null && x < this.width && y < this.scrollSize) {
            return this.scrollScr[y * this.width + x];
        }
        return 458752;
    }

    public int[] peek(int y1, int y2) {
        return this.peek(y1, 0, y2, this.width);
    }

    public int[] peek(int y1, int x1, int y2, int x2) {
        int start = this.$(y1, x1);
        int stop = this.$(y2, x2);
        int length = stop - start;
        int[] ret = new int[length];
        for (int i = 0; i < length; ++i) {
            ret[i] = this.scr[start + i];
        }
        return ret;
    }

    public void poke(int y, int x, int[] s, int off) {
        int destPos = this.$(y, x);
        System.arraycopy(s, off, this.scr, destPos, Math.min(s.length, this.scr.length - destPos) - off);
    }

    public void poke(int y, int x, int[] s) {
        int destPos = this.$(y, x);
        System.arraycopy(s, 0, this.scr, destPos, Math.min(s.length, this.scr.length - destPos));
    }

    public void poke(int y, int[] s) {
        this.poke(y, 0, s);
    }

    public void zero(int y1, int x1, int y2, int x2) {
        int e = this.$(y2, x2);
        for (int i = this.$(y1, x1); i < e; ++i) {
            this.scr[i] = this.sgr;
        }
    }

    public void zero(int y1, int y2) {
        this.zero(y1, 0, y2, this.width);
    }

    public void scrollUp(int y1, int y2) {
        if (y1 == 0 && this.scrollScr != null) {
            int[] line = this.peek(0, 0);
            System.arraycopy(this.scrollScr, this.width, this.scrollScr, 0, (this.scrollSize - 1) * this.width);
            System.arraycopy(line, 0, this.scrollScr, (this.scrollSize - 1) * this.width, line.length);
            this.startSel -= this.width;
            this.endSel -= this.width;
            if (this.scrollFill < this.scrollSize) {
                ++this.scrollFill;
            }
        } else {
            this.clearSelection();
        }
        this.poke(y1, this.peek(y1 + 1, y2));
        this.zero(y2, y2);
    }

    public void scrollDown(int y1, int y2) {
        this.poke(y1 + 1, this.peek(y1, y2 - 1));
        this.zero(y1, y1);
        this.clearSelection();
    }

    public void scrollRight(int y, int x) {
        this.poke(y, x + 1, this.peek(y, x, y, this.width));
        this.zero(y, x, y, x);
    }

    public void cursorDown() {
        if (this.cy >= this.st && this.cy <= this.sb) {
            this.nextLine = false;
            int q = (this.cy + 1) / (this.sb + 1);
            if (q != 0) {
                this.scrollUp(this.st, this.sb);
                this.cy = this.sb;
            } else {
                this.cy = (this.cy + 1) % (this.sb + 1);
            }
        }
    }

    public void cursorRight() {
        if (this.cx + 1 >= this.width) {
            this.nextLine = true;
        } else {
            this.cx = (this.cx + 1) % this.width;
        }
    }

    public void echo(char c) {
        if (this.nextLine) {
            this.cursorDown();
            this.cx = 0;
        }
        this.scr[this.$((int)this.cy, (int)this.cx)] = this.sgr | c & 0xFFFF;
        this.cursorRight();
    }

    void setSgr(int pos, int bits, int value) {
        int mask = (1 << bits) - 1 << pos;
        this.sgr &= ~mask;
        this.sgr |= (value <<= pos);
    }

    void backspace() {
        this.cx = Math.max(0, this.cx - 1);
    }

    void tab() {
        this.cx = (this.cx / 8 + 1) * 8 % this.width;
    }

    void carriage_return() {
        this.nextLine = false;
        this.cx = 0;
    }

    void selectCharSet(int charSet) {
        this.sgr = 458752;
        this.setSgr(24, 2, charSet);
    }

    public void saveCursor() {
        this.cx_bak = this.cx;
        this.cy_bak = this.cy;
    }

    public void restoreCursor() {
        this.cx = this.cx_bak;
        this.cy = this.cy_bak;
    }

    private int defaultsTo(int[] args, int defaultValue) {
        return args.length == 0 ? defaultValue : args[0];
    }

    public void escRi() {
        this.cy = Math.max(this.st, this.cy - 1);
        if (this.cy == this.st) {
            this.scrollDown(this.st, this.sb);
        }
    }

    public void csi_A(int[] i) {
        this.cy = Math.max(this.st, this.cy - this.defaultsTo(i, 1));
    }

    public void csi_B(int[] i) {
        this.cy = Math.min(this.sb, this.cy + this.defaultsTo(i, 1));
    }

    public void csi_C(int[] i) {
        this.cx = Math.min(this.width - 1, this.cx + this.defaultsTo(i, 1));
        this.nextLine = false;
    }

    public void csi_D(int[] i) {
        this.cx = Math.max(0, this.cx - this.defaultsTo(i, 1));
        this.nextLine = false;
    }

    public void csi_E(int[] i) {
        this.csi_B(i);
        this.cx = 0;
        this.nextLine = false;
    }

    public void csi_F(int[] i) {
        this.csi_A(i);
        this.cx = 0;
        this.nextLine = false;
    }

    public void csi_G(int[] i) {
        this.cx = Math.min(this.width, i[0]) - 1;
    }

    public void csi_H(int[] i) {
        if (i.length < 2) {
            i = new int[]{1, 1};
        }
        this.cx = Math.min(this.width, i[1]) - 1;
        this.cy = Math.min(this.height, i[0]) - 1;
        this.nextLine = false;
    }

    public void csi_J(int[] i) {
        switch (this.defaultsTo(i, 0)) {
            case 0: {
                this.zero(this.cy, this.cx, this.height, 0);
                return;
            }
            case 1: {
                this.zero(0, 0, this.cx, this.cy);
                return;
            }
            case 2: {
                this.zero(0, 0, this.height, 0);
                return;
            }
        }
    }

    public void csi_K(int ... i) {
        switch (this.defaultsTo(i, 0)) {
            case 0: {
                this.zero(this.cy, this.cx, this.cy, this.width);
                return;
            }
            case 1: {
                this.zero(this.cy, 0, this.cy, this.cx);
                return;
            }
            case 2: {
                this.zero(this.cy, 0, this.cy, this.width);
                return;
            }
        }
    }

    public void csi_L(int[] args) {
        for (int i = 0; i < this.defaultsTo(args, 1); ++i) {
            if (this.cy >= this.sb) continue;
            this.scrollDown(this.cy, this.sb);
        }
    }

    public void csi_M(int[] args) {
        if (this.cy >= this.st && this.cy <= this.sb) {
            for (int i = 0; i < this.defaultsTo(args, 1); ++i) {
                this.scrollUp(this.cy, this.sb);
            }
        }
    }

    public void csi_S(int[] args) {
        for (int i = 0; i < this.defaultsTo(args, 1); ++i) {
            this.scrollUp(this.st, this.sb);
        }
    }

    public void csi_T(int[] args) {
        for (int i = 0; i < this.defaultsTo(args, 1); ++i) {
            this.scrollDown(this.st, this.sb);
        }
    }

    public void csi_P(int[] args) {
        int _cy = this.cy;
        int _cx = this.cx;
        int[] end = this.peek(this.cy, this.cx, this.cy, this.width);
        this.csi_K(0);
        this.poke(_cy, _cx, end, this.defaultsTo(args, 1));
    }

    public void csi_X(int[] args) {
        this.zero(this.cy, this.cx, this.cy, this.cx + args[0]);
    }

    public void csi_a(int[] args) {
        this.csi_C(args);
    }

    public void csi_c(int[] args) {
    }

    public void csi_d(int[] args) {
        this.cy = Math.min(this.height, args[0]) - 1;
    }

    public void csi_e(int[] args) {
        this.csi_B(args);
    }

    public void csi_f(int[] args) {
        this.csi_H(args);
    }

    public void csi_m(int[] args) {
        if (args.length == 0) {
            this.sgr &= 0x3000000;
            this.sgr |= 0x70000;
            return;
        }
        for (int n : args) {
            if (n == 0) {
                this.sgr &= 0x3000000;
                this.sgr |= 0x70000;
                continue;
            }
            if (n == 1) {
                this.setSgr(19, 1, 1);
                continue;
            }
            if (n == 2) {
                this.setSgr(19, 1, 0);
                continue;
            }
            if (n == 4) {
                this.setSgr(23, 1, 1);
                continue;
            }
            if (n == 24) {
                this.setSgr(23, 1, 0);
                continue;
            }
            if (n == 27) {
                this.setSgr(26, 1, 0);
                continue;
            }
            if (n == 7) {
                this.setSgr(26, 1, 1);
                continue;
            }
            if (n >= 30 && n <= 37) {
                this.setSgr(16, 3, n - 30);
                continue;
            }
            if (n == 39) {
                this.setSgr(16, 3, 7);
                continue;
            }
            if (n >= 40 && n <= 47) {
                this.setSgr(20, 3, n - 40);
                continue;
            }
            if (n == 49) {
                this.setSgr(20, 3, 0);
                continue;
            }
            System.out.println("Warning: unhandled escape sequence ESC[" + n + "...m");
        }
    }

    public void csi_r(int[] args) {
        if (args.length < 2) {
            args = new int[]{0, this.height};
        }
        this.st = Math.min(this.height, args[0]) - 1;
        this.sb = Math.min(this.height, args[1]) - 1;
        this.sb = Math.max(this.sb, this.st);
    }

    public void csi_s(int[] args) {
        this.sb = Math.max(this.sb, this.st);
        this.saveCursor();
    }

    public void csi_u(int[] args) {
        this.restoreCursor();
    }

    public int getScrollSize() {
        return this.height + this.scrollFill;
    }
}

