/*
 * Decompiled with CFR 0.152.
 */
package JSSHTerminal;

import JSSHTerminal.JSchSession;
import JSSHTerminal.MainPanel;
import JSSHTerminal.TerminalEmulator;
import com.jcraft.jsch.ChannelShell;
import com.jcraft.jsch.JSch;
import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.UserInfo;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;

public final class SSHSession
implements UserInfo {
    private static final int NAGLE_PERIOD = 50;
    private TerminalEmulator terminal = null;
    private JSchSession jschsession = null;
    private JTextField passwordField = new JPasswordField(20);
    private String _password = null;
    private String _command = null;
    private MainPanel _parent;
    private Reader in = null;
    private Writer out = null;
    private ChannelShell channel = null;
    private Thread pumpThread;
    private Thread nagleThread;
    private final char[] inBuffer = new char[65536];
    private int inBufferPos = 0;
    private boolean answerYes = false;
    private boolean x11forwarding = false;
    private int retryCount;
    private int sshPort = 22;

    public SSHSession(MainPanel parent, int width, int height, int scrollSize) {
        this._parent = parent;
        this.terminal = new TerminalEmulator(width, height, scrollSize);
        this.terminal.reset();
        this._parent.repaint();
        this.retryCount = 0;
        String defaultSSHDir = System.getProperty("user.home") + "/.ssh";
        JSch jSch = JSchSession.getJSch();
        try {
            jSch.setKnownHosts(defaultSSHDir + "/known_hosts");
        }
        catch (JSchException e) {
            System.out.println("Warning, jSch.setKnownHosts() failed " + e.getMessage());
        }
        File f = new File(defaultSSHDir + "/id_dsa");
        if (f.exists()) {
            try {
                jSch.addIdentity(f.getAbsolutePath());
            }
            catch (JSchException e) {
                System.out.println("addIdentity(~/.ssh/id_dsa) " + e.getMessage());
            }
        }
        if ((f = new File(defaultSSHDir + "/id_rsa")).exists()) {
            try {
                jSch.addIdentity(f.getAbsolutePath());
            }
            catch (JSchException e) {
                System.out.println("addIdentity(~/.ssh/id_rsa) " + e.getMessage());
            }
        }
    }

    public void setSshPort(int port) {
        this.sshPort = port;
    }

    public void setAnswerYes(boolean enable) {
        this.answerYes = enable;
    }

    public void setX11Forwarding(boolean enable) {
        this.x11forwarding = enable;
    }

    public void execCommand(String cmd) throws IOException {
        this.write(cmd);
        this.write(TerminalEmulator.getCodeENTER());
    }

    public void connect(String host, String user, String password) throws IOException {
        this._password = password;
        try {
            this.jschsession = JSchSession.getSession(user, null, host, this.sshPort, this, null);
            this.channel = (ChannelShell)this.jschsession.getSession().openChannel("shell");
            if (this.x11forwarding) {
                this.channel.setXForwarding(true);
                Object[] di = this.getDisplayInfo();
                String x11Host = di[1].toString();
                int x11Port = (Integer)di[2];
                this.setCookieFromXauth(di);
                this.jschsession.getSession().setX11Host(x11Host);
                this.jschsession.getSession().setX11Port(x11Port);
            }
            this.out = new OutputStreamWriter(this.channel.getOutputStream());
            this.in = new InputStreamReader(this.channel.getInputStream());
            this.channel.setPtyType("xterm");
            this.channel.connect();
        }
        catch (JSchException e) {
            throw new IOException(e.getMessage());
        }
        this.pumpThread = new Thread(new Runnable(){

            @Override
            public void run() {
                SSHSession.this.pump();
            }
        });
        this.pumpThread.start();
        this.nagleThread = new Thread(new Runnable(){

            @Override
            public void run() {
                SSHSession.this.naggle();
            }
        });
        this.nagleThread.start();
    }

    Object[] getDisplayInfo() {
        String display = System.getenv("DISPLAY");
        if (display == null) {
            return new Object[]{"localhost:0.0", "127.0.0.1", 6000};
        }
        String x11Host = "127.0.0.1";
        int x11Port = 6000;
        int commaIdx = display.indexOf(58);
        if (commaIdx >= 0) {
            int pointIdx;
            if (commaIdx != 0) {
                x11Host = display.substring(0, commaIdx);
            }
            if ((pointIdx = display.lastIndexOf(46)) == -1) {
                pointIdx = display.length();
            }
            String pStr = display.substring(commaIdx + 1, pointIdx);
            try {
                x11Port = 6000 + Integer.parseInt(pStr);
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
        }
        return new Object[]{display, x11Host, x11Port};
    }

    void setCookieFromXauth(Object[] di) {
        if ((Integer)di[2] == 6000) {
            return;
        }
        try {
            String display = di[0].toString();
            String arg = display.startsWith(":") ? di[1].toString() + display : display;
            Process p = Runtime.getRuntime().exec("xauth list " + arg);
            p.waitFor();
            StringBuffer output = new StringBuffer();
            BufferedReader reader = new BufferedReader(new InputStreamReader(p.getInputStream()));
            String line = reader.readLine();
            if (line != null) {
                String[] lines = line.split("  ");
                if (lines.length != 3) {
                    System.out.println("Warning, no xauth data :" + line);
                    return;
                }
                this.jschsession.getSession().setX11Cookie(lines[2]);
            } else {
                System.out.println("Warning, no xauth data");
            }
        }
        catch (IOException e1) {
            System.out.println("Warning, no xauth data : :" + e1.getMessage());
        }
        catch (InterruptedException e2) {
            System.out.println("Warning, no xauth data : :" + e2.getMessage());
        }
    }

    public boolean isConnected() {
        return this.jschsession != null;
    }

    public void close() {
        if (this.jschsession != null) {
            this.jschsession.dispose();
            try {
                if (this.pumpThread != null) {
                    this.pumpThread.join();
                }
                if (this.nagleThread != null) {
                    this.nagleThread.join();
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            this.jschsession = null;
        }
    }

    void write(byte[] buff) throws IOException {
        int len = buff.length;
        char[] cout = new char[len];
        for (int i = 0; i < len; ++i) {
            cout[i] = (char)buff[i];
        }
        this.out.write(cout, 0, len);
        this.out.flush();
    }

    public void write(String k) {
        if (k != null && k.length() != 0) {
            try {
                this.out.write(k);
                this.out.flush();
            }
            catch (IOException e) {
                System.out.println(e.getMessage());
            }
        }
    }

    public TerminalEmulator getTerminal() {
        return this.terminal;
    }

    void resize(int width, int height) {
        if (this.channel != null) {
            this.channel.setPtySize(width, height, width * 8, height * 16);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    private void naggle() {
        while (this.isConnected()) {
            char[] cArray = this.inBuffer;
            // MONITORENTER : this.inBuffer
            if (this.inBufferPos > 0) {
                this.terminal.write(this.inBuffer, this.inBufferPos);
                this.inBufferPos = 0;
                this.write(this.terminal.read());
                this._parent.repaint();
                this._parent.updateScrollBar();
            }
            // MONITOREXIT : cArray
            try {
                Thread.sleep(50L);
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    private void pump() {
        block13: {
            block12: {
                buf = new char[1024];
                try {
                    ** try [egrp 1[TRYBLOCK] [2, 3 : 6->125)] { 
lbl4:
                    // 1 sources

                    break block12;
lbl5:
                    // 1 sources

                    catch (IOException e) {
                        System.out.println(e.getMessage());
                    }
                }
                catch (Throwable e) {
                    e.printStackTrace();
                }
                break block13;
            }
            while ((len = this.in.read(buf)) >= 0) {
                var3_3 = this.inBuffer;
                // MONITORENTER : this.inBuffer
                if (this.inBufferPos + len > this.inBuffer.length) {
                    this.terminal.write(this.inBuffer, this.inBufferPos);
                    this.terminal.write(buf, len);
                    this.inBufferPos = 0;
                    this._parent.updateScrollBar();
                    this._parent.repaint();
                } else {
                    System.arraycopy(buf, 0, this.inBuffer, this.inBufferPos, len);
                    this.inBufferPos += len;
                }
                // MONITOREXIT : var3_3
            }
            break block13;
lbl27:
            // 1 sources

            finally {
                this.closeQuietly(this.in);
                this.closeQuietly(this.out);
            }
        }
        this.jschsession = null;
        this._parent.exitFrame();
    }

    private void closeQuietly(Closeable c) {
        try {
            if (c != null) {
                c.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Override
    public String getPassphrase() {
        return null;
    }

    @Override
    public String getPassword() {
        ++this.retryCount;
        return this._password;
    }

    @Override
    public boolean promptPassword(String message) {
        if (this._password != null && this.retryCount == 0) {
            return true;
        }
        JPanel panel = new JPanel();
        panel.add(this.passwordField);
        this.passwordField.requestFocusInWindow();
        JOptionPane pane = new JOptionPane(panel, 3, 2){

            @Override
            public void selectInitialValue() {
            }
        };
        JDialog dialog = pane.createDialog(this._parent, message);
        dialog.setDefaultCloseOperation(2);
        dialog.setVisible(true);
        Object o = pane.getValue();
        if (o != null && (Integer)o == 0) {
            this._password = this.passwordField.getText();
            return true;
        }
        return false;
    }

    @Override
    public boolean promptPassphrase(String s) {
        return true;
    }

    @Override
    public boolean promptYesNo(String str) {
        if (this.answerYes) {
            return true;
        }
        Object[] options = new Object[]{"Yes", "No"};
        int ok = JOptionPane.showOptionDialog(this._parent, str, "Warning", -1, 2, null, options, options[0]);
        return ok == 0;
    }

    @Override
    public void showMessage(String s) {
        JOptionPane.showMessageDialog(this._parent, s, "Message", 1);
    }
}

