/*
 * Decompiled with CFR 0.152.
 */
package JSSHTerminal;

import JSSHTerminal.MainPanel;
import JSSHTerminal.TerminalEvent;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.image.BufferedImage;
import java.io.IOException;
import javax.imageio.ImageIO;

public class GraphicTerminal
extends TerminalEvent {
    private BufferedImage charSetA;
    private BufferedImage charSetB;
    private BufferedImage charSet0;
    private BufferedImage screen;
    private BufferedImage tmpImg;
    private int[] tmpBuffer;
    private int lastChx = -1;
    private int lastChy = -1;
    private int lastBg = -1;
    private int lastFg = -1;
    private int lastCharSet = -1;
    private Graphics tmpImgG;

    public GraphicTerminal(MainPanel parent, int width, int height) {
        this.setBorder(null);
        this.setOpaque(false);
        this.setDoubleBuffered(false);
        this.setFocusable(true);
        this.setFocusTraversalKeysEnabled(false);
        this.init(parent, width, height, 8, 16);
        this.tmpImg = new BufferedImage(this.charWidth, this.charHeight, 1);
        this.tmpImgG = this.tmpImg.getGraphics();
        this.tmpBuffer = new int[this.charWidth * this.charHeight];
        this.loadFont();
    }

    private void loadFont() {
        try {
            this.charSetA = ImageIO.read(this.getClass().getClassLoader().getResource("JSSHTerminal/fontPA.png"));
            this.charSetB = ImageIO.read(this.getClass().getClassLoader().getResource("JSSHTerminal/fontPB.png"));
            this.charSet0 = ImageIO.read(this.getClass().getClassLoader().getResource("JSSHTerminal/fontP0.png"));
        }
        catch (IOException e) {
            System.out.println("Cannot load font " + e.getMessage());
        }
    }

    @Override
    public void dispose() {
        this.tmpImgG.dispose();
        this.tmpImg = null;
        this.screen = null;
        this.terminal = null;
    }

    @Override
    public void sizeComponent(int width, int height) {
        this.screen = new BufferedImage(this.termWidth * this.charWidth, this.termHeight * this.charHeight, 1);
    }

    @Override
    public synchronized void drawComponent(Graphics g) {
        if (this.terminal == null) {
            g.setColor(Color.BLACK);
            g.drawRect(0, 0, this.termWidth * this.charWidth, this.termHeight * this.charHeight);
            return;
        }
        Graphics scrG = this.screen.getGraphics();
        this.paintTo(scrG);
        scrG.dispose();
        g.drawImage(this.screen, 0, 0, null);
    }

    public void paintTo(Graphics g) {
        int[] scr = this.terminal.getScreen(this.scrollPos);
        int i = 0;
        for (int y = 0; y < this.termHeight; ++y) {
            for (int x = 0; x < this.termWidth; ++x) {
                Color fgColor;
                Color bgColor;
                boolean isDefault;
                int c = scr[i] & 0xFFFF;
                int sgr = scr[i] >> 16;
                int bg = (sgr & 0x70) >> 4;
                int fg = sgr & 7;
                boolean bold = (sgr & 8) != 0;
                boolean underline = (sgr & 0x80) != 0;
                boolean reverse = (sgr & 0x400) != 0;
                int charSet = (sgr & 0x300) >> 8;
                boolean bl = isDefault = fg == 7 && bg == 0 && !reverse;
                if (reverse) {
                    bgColor = defaultColors[fg];
                    fgColor = bold ? defaultBrightColors[bg] : defaultColors[bg];
                } else {
                    bgColor = defaultColors[bg];
                    fgColor = bold ? defaultBrightColors[fg] : defaultColors[fg];
                }
                if (i - this.scrollPos * this.termWidth >= this.terminal.getStartSelection() && i - this.scrollPos * this.termWidth <= this.terminal.getEndSelection()) {
                    bgColor = Color.WHITE;
                    fgColor = Color.BLACK;
                    isDefault = false;
                }
                if (this.terminal.isCursor(x, y - this.scrollPos)) {
                    bgColor = this.cursorBackground;
                    fgColor = Color.BLACK;
                    isDefault = false;
                }
                if (c < 256) {
                    this.getChar(c, fgColor, bgColor, charSet, bold, isDefault);
                } else {
                    switch (c) {
                        case 9472: {
                            c = 113;
                            charSet = 2;
                            break;
                        }
                        case 9474: {
                            c = 120;
                            charSet = 2;
                            break;
                        }
                        case 9484: {
                            c = 108;
                            charSet = 2;
                            break;
                        }
                        case 9488: {
                            c = 107;
                            charSet = 2;
                            break;
                        }
                        case 9492: {
                            c = 109;
                            charSet = 2;
                            break;
                        }
                        case 9496: {
                            c = 106;
                            charSet = 2;
                            break;
                        }
                        case 9508: {
                            c = 117;
                            charSet = 2;
                            break;
                        }
                        case 9500: {
                            c = 116;
                            charSet = 2;
                            break;
                        }
                        case 9618: {
                            c = 97;
                            charSet = 2;
                            break;
                        }
                        case 8208: {
                            c = 45;
                            break;
                        }
                        default: {
                            System.out.println("Warning, unhandled unicode " + String.format("%04X", c));
                            c = 0;
                        }
                    }
                }
                this.getChar(c, fgColor, bgColor, charSet, bold, isDefault);
                g.drawImage(this.tmpImg, x * this.charWidth, y * this.charHeight, this.charWidth * (x + 1), this.charHeight * (y + 1), 0, 0, this.charWidth, this.charHeight, null);
                if (underline) {
                    g.setColor(Color.WHITE);
                    g.drawLine(x * this.charWidth, (y + 1) * this.charHeight - 1, (x + 1) * this.charWidth, (y + 1) * this.charHeight - 1);
                }
                ++i;
            }
        }
    }

    BufferedImage getChar(int c, Color fgColor, Color bgColor, int charSet, boolean isBold, boolean isDefault) {
        BufferedImage src;
        int chx = 0;
        int chy = 0;
        if (c >= 32 && c < 127) {
            chx = c % 16;
            chy = c / 16 - 2;
            if (isBold) {
                chy += 6;
            }
        }
        int bg = bgColor.getRGB();
        int fg = fgColor.getRGB();
        if (this.lastBg == bg && this.lastFg == fg && this.lastChx == chx && this.lastChy == chy && this.lastCharSet == charSet) {
            return this.tmpImg;
        }
        this.lastBg = bg;
        this.lastFg = fg;
        this.lastChx = chx;
        this.lastChy = chy;
        this.lastCharSet = charSet;
        switch (charSet) {
            case 1: {
                src = this.charSetA;
                break;
            }
            case 2: {
                src = this.charSet0;
                break;
            }
            default: {
                src = this.charSetB;
            }
        }
        if (isDefault) {
            this.tmpImgG.drawImage(src, 0, 0, this.charWidth, this.charHeight, chx * this.charWidth, chy * this.charHeight, this.charWidth * (chx + 1), this.charHeight * (chy + 1), null);
        } else if (c <= 32) {
            this.tmpImgG.setColor(bgColor);
            this.tmpImgG.fillRect(0, 0, this.charWidth, this.charHeight);
        } else {
            double bgR = bgColor.getRed();
            double bgG = bgColor.getGreen();
            double bgB = bgColor.getBlue();
            double fgR = fgColor.getRed();
            double fgG = fgColor.getGreen();
            double fgB = fgColor.getBlue();
            double i255 = 0.00392156862745098;
            src.getRGB(chx * this.charWidth, chy * this.charHeight, this.charWidth, this.charHeight, this.tmpBuffer, 0, this.charWidth);
            for (int i = 0; i < this.tmpBuffer.length; ++i) {
                if ((this.tmpBuffer[i] & 0xFFFFFF) == 0) {
                    this.tmpBuffer[i] = bg;
                    continue;
                }
                if (this.tmpBuffer[i] == 0xFFFFFF) {
                    this.tmpBuffer[i] = fg;
                    continue;
                }
                double factor = (double)(this.tmpBuffer[i] & 0xFF) * i255;
                double ofactor = 1.0 - factor;
                int nRed = (int)(factor * fgR + ofactor * bgR) << 16;
                int nGreen = (int)(factor * fgG + ofactor * bgG) << 8;
                int nBlue = (int)(factor * fgB + ofactor * bgB);
                this.tmpBuffer[i] = nRed | nGreen | nBlue;
            }
            this.tmpImg.setRGB(0, 0, this.charWidth, this.charHeight, this.tmpBuffer, 0, this.charWidth);
        }
        return this.tmpImg;
    }
}

