/*
 * Decompiled with CFR 0.152.
 */
package admin.astor.tools;

import fr.esrf.tangoatk.core.ATKException;
import fr.esrf.tangoatk.widget.util.ErrorPane;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Image;
import java.awt.Point;
import java.awt.Toolkit;
import java.net.URL;
import javax.swing.ImageIcon;
import javax.swing.JOptionPane;

public class Utils {
    private static Utils instance = null;
    public static final String img_path = "/admin/astor/images/";

    private Utils() {
    }

    public static Utils getInstance() {
        if (instance == null) {
            instance = new Utils();
        }
        return instance;
    }

    public ImageIcon getIcon(String fileName) {
        URL url = this.getImageUrl(fileName);
        if (url == null) {
            System.err.println("WARNING:  /admin/astor/images/" + fileName + " : File not found");
            return new ImageIcon();
        }
        return new ImageIcon(url);
    }

    public Cursor getCursor(String fileName) {
        URL url = this.getImageUrl(fileName);
        Image image = Toolkit.getDefaultToolkit().getImage(url);
        return Toolkit.getDefaultToolkit().createCustomCursor(image, new Point(0, 0), fileName);
    }

    public URL getImageUrl(String filename) {
        return this.getClass().getResource(img_path + filename);
    }

    public ImageIcon getIcon(String filename, double ratio) {
        ImageIcon icon = this.getIcon(filename);
        return this.getIcon(icon, ratio);
    }

    public ImageIcon getIcon(ImageIcon icon, double ratio) {
        if (icon != null) {
            int width = icon.getIconWidth();
            int height = icon.getIconHeight();
            width = (int)(ratio * (double)width);
            height = (int)(ratio * (double)height);
            icon = new ImageIcon(icon.getImage().getScaledInstance(width, height, 4));
        }
        return icon;
    }

    public static void popupMessage(Component c, String message, String filename) {
        ImageIcon icon = Utils.getInstance().getIcon(filename);
        JOptionPane.showMessageDialog(c, message, "Info Window", 1, icon);
    }

    public static void popupMessage(Component c, String message) {
        JOptionPane.showMessageDialog(c, message, "Info Window", 1);
    }

    public static void popupError(Component c, String message, Exception e) {
        ErrorPane.showErrorMessage((Component)c, (String)message, (Exception)e);
    }

    public static void popupError(Component c, String message) {
        ErrorPane.showErrorMessage((Component)c, null, (ATKException)new ATKException(message));
    }
}

