/*
 * Decompiled with CFR 0.152.
 */
package admin.astor.tools;

import admin.astor.AstorUtil;
import admin.astor.tools.PingHosts;
import fr.esrf.Tango.DevFailed;
import fr.esrf.TangoApi.ApiUtil;
import fr.esrf.TangoApi.DbDatum;
import fr.esrf.TangoApi.DbServer;
import fr.esrf.TangoApi.DeviceData;
import fr.esrf.TangoApi.DeviceProxy;
import fr.esrf.tangoatk.widget.util.ATKGraphicsUtils;
import fr.esrf.tangoatk.widget.util.ErrorPane;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTextArea;

public class UnAvailableHostsDialog
extends JDialog {
    private JFrame parent;
    private List<StoppedHost> stoppedHosts;
    private String[] lastCollections;
    private JPanel centerPanel;
    private JButton criticalBtn;
    private JButton notCriticalBtn;
    private JLabel titleLabel;

    public UnAvailableHostsDialog(JFrame parent) throws DevFailed {
        super((Frame)parent, true);
        this.parent = parent;
        this.initComponents();
        this.notCriticalBtn.setBackground(Color.orange);
        this.criticalBtn.setBackground(Color.red);
        this.criticalBtn.setForeground(Color.white);
        AstorUtil.startSplash("Pinging crates.....");
        AstorUtil.increaseSplashProgress(0.3, "Get host list from database");
        String[] ctrlHosts = AstorUtil.getInstance().getHostControlledList();
        this.lastCollections = AstorUtil.getInstance().getLastCollectionList();
        AstorUtil.increaseSplashProgress(0.6, "Checking " + ctrlHosts.length + " hosts");
        PingHosts pg = new PingHosts(ctrlHosts);
        AstorUtil.increaseSplashProgress(0.8, "Building stopped host list");
        this.stoppedHosts = this.buildStoppedHosts(pg.getStoppedList());
        int x = 0;
        int y = 0;
        int modulo = (int)Math.sqrt(this.stoppedHosts.size());
        for (StoppedHost host : this.stoppedHosts) {
            JButton btn = new JButton(host.name);
            if (host.inLastCollections) {
                btn.setBackground(Color.orange);
                btn.setForeground(Color.black);
            } else {
                btn.setBackground(Color.red);
                btn.setForeground(Color.white);
            }
            btn.setToolTipText(host.collection);
            btn.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    UnAvailableHostsDialog.this.hostBtnActionPerformed(evt);
                }
            });
            GridBagConstraints gbc = new GridBagConstraints();
            gbc.gridx = x++;
            gbc.gridy = y++;
            gbc.fill = 2;
            gbc.insets = new Insets(10, 10, 10, 10);
            this.centerPanel.add((Component)btn, gbc);
            if (x != modulo) continue;
            x = 0;
        }
        this.titleLabel.setText(this.stoppedHosts.size() + " Unreachable Hosts");
        this.pack();
        ATKGraphicsUtils.centerDialog((Dialog)this);
        AstorUtil.stopSplash();
    }

    private List<StoppedHost> buildStoppedHosts(List<String> hostNames) {
        ArrayList<StoppedHost> list = new ArrayList<StoppedHost>();
        for (String hostName : hostNames) {
            list.add(new StoppedHost(hostName));
        }
        return list;
    }

    private void initComponents() {
        this.centerPanel = new JPanel();
        JPanel bottomPanel = new JPanel();
        JButton updateBtn = new JButton();
        JButton unexportAllBtn = new JButton();
        JButton cancelBtn = new JButton();
        JPanel topPanel = new JPanel();
        JPanel topTopPanel = new JPanel();
        this.criticalBtn = new JButton();
        JLabel jLabel2 = new JLabel();
        this.titleLabel = new JLabel();
        JLabel jLabel1 = new JLabel();
        this.notCriticalBtn = new JButton();
        JSeparator jSeparator1 = new JSeparator();
        JLabel jLabel3 = new JLabel();
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                UnAvailableHostsDialog.this.closeDialog(evt);
            }
        });
        this.centerPanel.setLayout(new GridBagLayout());
        this.getContentPane().add((Component)this.centerPanel, "Center");
        bottomPanel.setLayout(new FlowLayout(1, 50, 5));
        updateBtn.setText("Update List");
        updateBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                UnAvailableHostsDialog.this.updateBtnActionPerformed(evt);
            }
        });
        bottomPanel.add(updateBtn);
        unexportAllBtn.setText("Unexport All ");
        unexportAllBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                UnAvailableHostsDialog.this.unExportAllBtnActionPerformed(evt);
            }
        });
        bottomPanel.add(unexportAllBtn);
        cancelBtn.setText("Cancel");
        cancelBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                UnAvailableHostsDialog.this.cancelBtnActionPerformed(evt);
            }
        });
        bottomPanel.add(cancelBtn);
        this.getContentPane().add((Component)bottomPanel, "South");
        topPanel.setLayout(new BorderLayout());
        this.criticalBtn.setFont(new Font("Tahoma", 0, 10));
        this.criticalBtn.setText("   Critical   ");
        topTopPanel.add(this.criticalBtn);
        jLabel2.setText("           ");
        topTopPanel.add(jLabel2);
        this.titleLabel.setFont(new Font("Dialog", 1, 18));
        this.titleLabel.setText("Unreachable Hosts");
        topTopPanel.add(this.titleLabel);
        jLabel1.setText("           ");
        topTopPanel.add(jLabel1);
        this.notCriticalBtn.setFont(new Font("Tahoma", 0, 10));
        this.notCriticalBtn.setText(" Not Critical ");
        topTopPanel.add(this.notCriticalBtn);
        topPanel.add((Component)topTopPanel, "North");
        topPanel.add((Component)jSeparator1, "Center");
        jLabel3.setFont(new Font("Tahoma", 0, 18));
        jLabel3.setText("           ");
        topPanel.add((Component)jLabel3, "Last");
        this.getContentPane().add((Component)topPanel, "North");
        this.pack();
    }

    private void hostBtnActionPerformed(ActionEvent evt) {
        JButton btn = (JButton)evt.getSource();
        String hostName = btn.getText();
        try {
            this.setCursor(new Cursor(3));
            OneHost host = new OneHost(hostName);
            new PopupText(this, host).setVisible(true);
            this.setCursor(new Cursor(0));
        }
        catch (DevFailed e) {
            this.setCursor(new Cursor(0));
            ErrorPane.showErrorMessage((Component)this, null, (DevFailed)e);
        }
    }

    private void cancelBtnActionPerformed(ActionEvent evt) {
        this.doClose();
    }

    private void closeDialog(WindowEvent evt) {
        this.doClose();
    }

    private void unExportAllBtnActionPerformed(ActionEvent evt) {
        if (this.stoppedHosts.size() > 0 && JOptionPane.showConfirmDialog(this.parent, "Unexport all devices registered on " + this.stoppedHosts.size() + " hosts ?", "Confirm Dialog", 0) == 0) {
            AstorUtil.startSplash("Un export");
            int ratio = 100 / this.stoppedHosts.size();
            for (StoppedHost host : this.stoppedHosts) {
                AstorUtil.increaseSplashProgress(ratio, "un export devices for " + host.name);
                try {
                    this.setCursor(new Cursor(3));
                    OneHost oneHost = new OneHost(host.name);
                    oneHost.unExportDevices();
                    this.setCursor(new Cursor(0));
                }
                catch (DevFailed e) {
                    AstorUtil.stopSplash();
                    this.setCursor(new Cursor(0));
                    ErrorPane.showErrorMessage((Component)this, null, (DevFailed)e);
                }
            }
            AstorUtil.stopSplash();
        }
    }

    private void updateBtnActionPerformed(ActionEvent evt) {
        this.setVisible(false);
        this.dispose();
        try {
            new UnAvailableHostsDialog(this.parent).setVisible(true);
        }
        catch (DevFailed e) {
            ErrorPane.showErrorMessage((Component)this, null, (DevFailed)e);
            this.doClose();
        }
    }

    private void doClose() {
        this.setVisible(false);
        this.dispose();
        if (this.parent == null) {
            System.exit(0);
        }
    }

    public static void main(String[] args) {
        try {
            new UnAvailableHostsDialog(null).setVisible(true);
        }
        catch (DevFailed e) {
            AstorUtil.stopSplash();
            ErrorPane.showErrorMessage((Component)new Frame(), null, (DevFailed)e);
        }
    }

    public class PopupText
    extends JDialog {
        private OneHost host;
        private JScrollPane jScrollPane1;
        private JTextArea textArea;

        public PopupText(JDialog parent, OneHost host) {
            super((Dialog)parent, true);
            this.host = host;
            this.initComponents();
            this.textArea.setText(host.toString());
            this.pack();
            ATKGraphicsUtils.centerDialog((Dialog)this);
        }

        private void initComponents() {
            this.jScrollPane1 = new JScrollPane();
            this.textArea = new JTextArea();
            this.textArea.setFont(new Font("monospaced", 1, 12));
            this.addWindowListener(new WindowAdapter(){

                @Override
                public void windowClosing(WindowEvent evt) {
                    PopupText.this.closeDialog(evt);
                }
            });
            JButton unexportButton = new JButton("UnExport devices");
            unexportButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    PopupText.this.unexportButtonActionPerformed(evt);
                }
            });
            JButton cancelButton = new JButton("Cancel");
            cancelButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    PopupText.this.cancelButtonActionPerformed(evt);
                }
            });
            JPanel buttonPanel = new JPanel();
            buttonPanel.setLayout(new FlowLayout(2, 5, 5));
            buttonPanel.add(unexportButton);
            buttonPanel.add(cancelButton);
            this.getContentPane().add((Component)buttonPanel, "South");
            this.jScrollPane1.setViewportView(this.textArea);
            this.getContentPane().add((Component)this.jScrollPane1, "Center");
        }

        @Override
        public void setFont(Font font) {
            this.textArea.setFont(font);
        }

        private void unexportButtonActionPerformed(ActionEvent evt) {
            System.out.println("UnExport devices for " + this.host.name);
            try {
                this.setCursor(new Cursor(3));
                this.host.unExportDevices();
                this.setCursor(new Cursor(0));
            }
            catch (DevFailed e) {
                this.setCursor(new Cursor(0));
                ErrorPane.showErrorMessage((Component)this, null, (DevFailed)e);
            }
            this.doClose();
        }

        private void cancelButtonActionPerformed(ActionEvent evt) {
            this.doClose();
        }

        private void closeDialog(WindowEvent evt) {
            this.doClose();
        }

        private void doClose() {
            this.setVisible(false);
            this.dispose();
        }
    }

    private class OneServer
    extends ArrayList<DeviceProxy> {
        private String name;

        private OneServer(String name) throws DevFailed {
            this.name = name;
            DbServer dbServer = new DbServer(name);
            String[] devClasses = dbServer.get_device_class_list();
            for (int i = 0; i < devClasses.length; ++i) {
                if (i % 2 != 0) continue;
                this.add(new DeviceProxy(devClasses[i]));
            }
        }

        private void unExportDeices() throws DevFailed {
            for (DeviceProxy deviceProxy : this) {
                deviceProxy.unexport_device();
            }
        }

        @Override
        public String toString() {
            StringBuilder sb = new StringBuilder(this.name + ":\n");
            for (DeviceProxy deviceProxy : this) {
                sb.append("\t").append(deviceProxy.name()).append("\n");
            }
            return sb.toString();
        }
    }

    private class OneHost
    extends ArrayList<OneServer> {
        private String name;

        private OneHost(String name) throws DevFailed {
            this.name = name;
            DeviceProxy dbDev = new DeviceProxy(ApiUtil.get_db_obj().get_name());
            DeviceData argIn = new DeviceData();
            argIn.insert(name);
            DeviceData argOut = dbDev.command_inout("DbGetHostServersInfo", argIn);
            String[] servers = argOut.extractStringArray();
            for (int i = 0; i < servers.length; ++i) {
                if (i % 3 != 0) continue;
                this.add(new OneServer(servers[i]));
            }
        }

        private void unExportDevices() throws DevFailed {
            for (OneServer server : this) {
                server.unExportDeices();
            }
        }

        @Override
        public String toString() {
            StringBuilder sb = new StringBuilder(this.name + ":\n");
            for (OneServer server : this) {
                sb.append(server).append("\n");
            }
            return sb.toString();
        }
    }

    private class StoppedHost {
        String name;
        String collection = "Not Defined";
        boolean inLastCollections = true;

        private StoppedHost(String name) {
            this.name = name;
            try {
                DbDatum datum = new DeviceProxy(AstorUtil.getStarterDeviceHeader() + name).get_property("HostCollection");
                if (!datum.is_empty()) {
                    this.collection = datum.extractString();
                    boolean found = false;
                    for (String s : UnAvailableHostsDialog.this.lastCollections) {
                        if (!s.equals(this.collection)) continue;
                        found = true;
                    }
                    this.inLastCollections = found;
                }
            }
            catch (DevFailed devFailed) {
                // empty catch block
            }
        }
    }
}

