/*
 * Decompiled with CFR 0.152.
 */
package admin.astor.tools;

import admin.astor.tools.Utils;
import fr.esrf.TangoDs.TangoConst;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JEditorPane;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;

public class PopupHtml
extends JDialog
implements TangoConst {
    protected JFrame parent;
    protected List<URL> history;
    protected JEditorPane pane;
    private boolean deleteFileAtExit = false;
    private JButton backBtn;
    private JTextArea urlText;
    protected static final boolean back = false;
    protected static final boolean forward = true;
    private String header = "http://www";

    public PopupHtml(JFrame parent) {
        super((Frame)parent, true);
        this.initComponents();
        this.parent = parent;
        this.history = new ArrayList<URL>();
        this.pack();
        if (parent != null && parent.isVisible() && parent.getWidth() > 0) {
            Point p = parent.getLocationOnScreen();
            p.x += 10;
            p.y += 10;
            this.setLocation(p);
        }
    }

    public PopupHtml(JFrame parent, boolean deleteFile) {
        this(parent);
        this.deleteFileAtExit = deleteFile;
    }

    private void initComponents() {
        JPanel jPanel1 = new JPanel();
        JPanel jPanel2 = new JPanel();
        JLabel jLabel1 = new JLabel();
        JButton cancelBtn = new JButton();
        this.backBtn = new JButton();
        this.urlText = new JTextArea();
        this.setBackground(new Color(198, 178, 168));
        this.setTitle("");
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                PopupHtml.this.closeDialog(evt);
            }
        });
        jPanel1.setLayout(new FlowLayout(2, 5, 5));
        jLabel1.setText("                     ");
        jPanel1.add(jLabel1);
        cancelBtn.setText("Dismiss");
        cancelBtn.setHorizontalAlignment(2);
        cancelBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PopupHtml.this.dismissBtnActionPerformed(evt);
            }
        });
        jPanel1.add(cancelBtn);
        this.getContentPane().add((Component)jPanel1, "South");
        this.backBtn.setText("<<  Back");
        this.backBtn.setForeground(Color.black);
        this.backBtn.setHorizontalAlignment(0);
        this.backBtn.setEnabled(false);
        this.backBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PopupHtml.this.backBtnActionPerformed(evt);
            }
        });
        jPanel2.add(this.backBtn);
        jPanel2.add(new JLabel("  "));
        this.urlText.setText("");
        this.urlText.setForeground(Color.black);
        this.urlText.setEditable(false);
        jPanel2.add(this.urlText);
        jPanel2.setLayout(new FlowLayout(0));
        this.getContentPane().add((Component)jPanel2, "North");
    }

    private void backBtnActionPerformed(ActionEvent evt) {
        if (this.history.size() > 1) {
            int last = this.history.size() - 2;
            URL prev_url = this.history.get(last);
            this.setPage(prev_url, false);
        }
    }

    public void hyperlinkUpdateClicked(HyperlinkEvent evt) {
        if (evt.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
            URL new_url = evt.getURL();
            this.setPage(new_url, true);
        }
    }

    private void arm_timeout(long millis) {
        new Timeout(Thread.currentThread(), millis).start();
    }

    private boolean isTheSameWebServer(String new_url, String prev_url) {
        int start = this.header.length();
        int end = prev_url.indexOf("/", start = prev_url.indexOf(".", start));
        String prev_host = end < 0 ? prev_url.substring(start) : prev_url.substring(start, end);
        return new_url.indexOf(prev_host) > 0;
    }

    protected synchronized void setPage(URL url, boolean way) {
        block10: {
            URL prev_url = null;
            try {
                this.arm_timeout(5000L);
                prev_url = this.pane.getPage();
                if (prev_url != null && url.toString().startsWith(this.header) && prev_url.toString().startsWith(this.header) && !this.isTheSameWebServer(url.toString(), prev_url.toString())) {
                    Utils.popupError(this.parent, "This application does not manage proxies.\nPlease use a web browser to read this url.\n" + url.toString());
                    return;
                }
                this.pane.setCursor(new Cursor(3));
                this.pane.setPage(url);
                if (url.toString().startsWith(this.header)) {
                    this.urlText.setText(url.toString());
                } else {
                    this.urlText.setText("");
                }
                if (!way) {
                    URL url0 = this.history.get(this.history.size() - 1);
                    if (url0 != url) {
                        this.history.remove(this.history.size() - 1);
                    }
                } else {
                    this.history.add(url);
                }
                if (this.history.size() > 1) {
                    this.backBtn.setEnabled(true);
                } else {
                    this.backBtn.setEnabled(false);
                }
            }
            catch (IOException e) {
                String str = "Cannot read:\n" + url.toString() + "\n\n";
                str = url.toString().startsWith("file:") ? str + e.toString() : str + "If it is a remote web site, the proxies are not set...\n";
                System.out.println(str);
                Utils.popupError(this.parent, str);
                if (prev_url == null) break block10;
                this.setPage(prev_url, false);
            }
        }
        this.pane.setCursor(new Cursor(0));
    }

    public void show(URL url) {
        this.show(url.toString(), 700, 750);
    }

    public void show(URL url, int width, int height) {
        this.show(url.toString(), width, height);
    }

    public void show(String strurl) {
        this.show(strurl, 700, 750);
    }

    public void show(String strurl, int width, int height) {
        try {
            this.pane = new JEditorPane();
            this.pane.setEditable(false);
            this.pane.addHyperlinkListener(new HyperlinkListener(){

                @Override
                public void hyperlinkUpdate(HyperlinkEvent evt) {
                    PopupHtml.this.hyperlinkUpdateClicked(evt);
                }
            });
            this.getContentPane().add((Component)new JScrollPane(this.pane), "Center");
            this.setSize(width, height);
            URL url = new URL(strurl);
            this.setPage(url, true);
        }
        catch (MalformedURLException e) {
            try {
                URL url = new URL(this.buildTmpFile(strurl));
                this.setPage(url, true);
            }
            catch (IOException ex) {
                ex.printStackTrace(System.err);
                return;
            }
        }
        this.setVisible(true);
    }

    private String buildTmpFile(String code) {
        String urlstr = null;
        try {
            int random_value = new Random().nextInt(30000);
            String tmpdir = System.getProperty("java.io.tmpdir");
            String filename = tmpdir + "/html." + random_value;
            FileOutputStream fidout = new FileOutputStream(filename);
            fidout.write(code.getBytes());
            fidout.close();
            urlstr = "file:" + filename;
            this.deleteFileAtExit = true;
        }
        catch (Exception e) {
            Utils.popupError(this.parent, null, e);
            e.printStackTrace();
        }
        return urlstr;
    }

    private void closeDialog(WindowEvent evt) {
        this.doClose();
    }

    private void dismissBtnActionPerformed(ActionEvent evt) {
        this.doClose();
    }

    private void doClose() {
        this.setVisible(false);
        if (this.deleteFileAtExit) {
            try {
                URL url = this.history.get(0);
                String urlstr = url.toString();
                if (urlstr.startsWith("file:")) {
                    urlstr = urlstr.substring("file:".length());
                }
                if (!new File(urlstr).delete()) {
                    System.err.println("Cannot delete " + urlstr);
                }
            }
            catch (Exception e) {
                System.err.println(e.toString());
            }
        }
        this.dispose();
    }

    public static void main(String[] args) {
        String index = "http://www.esrf.fr/computing/cs/tango/tango_doc/ds_doc/index.html";
        if (args.length > 0) {
            index = args[0];
        }
        new PopupHtml(null).show(index);
    }

    private class Timeout
    extends Thread {
        Thread parent;
        long millis;

        public Timeout(Thread parent, long millis) {
            this.parent = parent;
            this.millis = millis;
        }

        @Override
        public synchronized void run() {
            try {
                this.wait(this.millis);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

