/*
 * Decompiled with CFR 0.152.
 */
package admin.astor.tools;

import fr.esrf.Tango.DevState;
import fr.esrf.TangoApi.ApiUtil;
import java.util.ArrayList;
import java.util.StringTokenizer;

public class PolledElement {
    String deviceName = "unknown";
    String name = "unknown";
    String type;
    int period = -1;
    int buffer_depth = -1;
    double reading_time = -1.0;
    int last_update = -1;
    int[] realPeriods = new int[0];
    DevState state;
    String status;
    String last_update_str = "";
    private static final String equal = " = ";
    private static final String since = " since ";
    private static final String externalyStr = "Polling externally triggered";
    boolean polled = true;
    private String[] info;

    public PolledElement(String deviceName, String status) {
        this.deviceName = deviceName;
        this.status = status;
        this.parsePollingStatus(status);
        this.state = this.period < 0 || this.buffer_depth < 0 || this.reading_time < 0.0 || this.realPeriods.length == 0 ? DevState.FAULT : ((double)this.realPeriods[0] > 1.5 * (double)this.period || this.reading_time > (double)this.period ? DevState.FAULT : DevState.ON);
    }

    private void parsePeriod(String line) {
        if (line.startsWith(externalyStr)) {
            this.polled = false;
            return;
        }
        int idx = line.indexOf(equal);
        if (idx > 0) {
            String str = line.substring(idx + equal.length());
            try {
                this.period = Integer.parseInt(str);
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
        }
    }

    private void parseBufferDepth(String line) {
        int idx = line.indexOf(equal);
        if (idx > 0) {
            String str = line.substring(idx + equal.length());
            try {
                this.buffer_depth = Integer.parseInt(str);
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
        }
    }

    private void parseName(String line) {
        int idx = line.indexOf(equal);
        if (idx > 0) {
            this.name = line.substring(idx + equal.length());
        }
        this.type = line.indexOf("attribute") > 0 ? "attribute" : "command";
    }

    private void parseDuration(String line) {
        int idx = line.indexOf(equal);
        if (idx > 0) {
            String str = line.substring(idx + equal.length());
            try {
                this.reading_time = Double.parseDouble(str);
            }
            catch (NumberFormatException e) {}
        } else {
            this.reading_time = 0.0;
        }
    }

    private void parseRealPeriod(String line) {
        int idx = line.indexOf(equal);
        if (idx > 0) {
            String str = line.substring(idx + equal.length());
            StringTokenizer stk = new StringTokenizer(str, ", ");
            ArrayList<String> tokens = new ArrayList<String>();
            while (stk.hasMoreTokens()) {
                tokens.add(stk.nextToken());
            }
            this.realPeriods = new int[tokens.size()];
            int i = 0;
            for (String token : tokens) {
                try {
                    this.realPeriods[i++] = Integer.parseInt(token);
                }
                catch (NumberFormatException e) {}
            }
        }
    }

    private void parseLastUpdate(String line) {
        int idx = line.indexOf(since);
        if (idx > 0) {
            String str;
            this.last_update_str = str = line.substring(idx + since.length());
            str = str.substring(0, str.indexOf("mS"));
            StringTokenizer stk = new StringTokenizer(str, " S and ");
            ArrayList<String> tokens = new ArrayList<String>();
            while (stk.hasMoreTokens()) {
                tokens.add(stk.nextToken());
            }
            switch (tokens.size()) {
                case 1: {
                    try {
                        this.last_update = Integer.parseInt((String)tokens.get(0));
                    }
                    catch (NumberFormatException e) {
                        this.last_update = 1000;
                    }
                    break;
                }
                case 2: {
                    try {
                        this.last_update = Integer.parseInt((String)tokens.get(1));
                        this.last_update += 1000 * Integer.parseInt((String)tokens.get(0));
                    }
                    catch (NumberFormatException e) {
                        this.last_update += 60000;
                    }
                    break;
                }
                default: {
                    if (tokens.size() <= 1) break;
                    try {
                        this.last_update = 60000 * Integer.parseInt((String)tokens.get(0));
                        this.last_update += Integer.parseInt((String)tokens.get(3));
                        this.last_update += 1000 * Integer.parseInt((String)tokens.get(2));
                        break;
                    }
                    catch (NumberFormatException e) {
                        this.last_update += 60000;
                    }
                }
            }
        }
    }

    private void parsePollingStatus(String status) {
        ArrayList<String> lines = new ArrayList<String>();
        StringTokenizer stk = new StringTokenizer(status, "\n");
        int i = 0;
        while (stk.hasMoreTokens()) {
            String line = stk.nextToken();
            lines.add(line);
            switch (i) {
                case 0: {
                    this.parseName(line);
                    break;
                }
                case 1: {
                    this.parsePeriod(line);
                    break;
                }
                case 2: {
                    this.parseBufferDepth(line);
                    break;
                }
                case 3: {
                    this.parseDuration(line);
                    break;
                }
                case 4: {
                    this.parseLastUpdate(line);
                    break;
                }
                case 5: {
                    this.parseRealPeriod(line);
                }
            }
            ++i;
        }
        this.info = new String[lines.size()];
        for (i = 0; i < lines.size(); ++i) {
            this.info[i] = (String)lines.get(i);
        }
    }

    public String toString() {
        return this.name;
    }

    public String info() {
        String str = this.type + " " + this.name + ":\t" + this.period + " -> " + this.reading_time;
        str = str + "  (since " + this.last_update + ")\t";
        for (int realPeriod : this.realPeriods) {
            str = str + realPeriod + ", ";
        }
        str = str + "\t" + ApiUtil.stateName((DevState)this.state);
        return str;
    }

    public String[] getInfo() {
        ArrayList<String> lines = new ArrayList<String>();
        if (this.polled) {
            lines.add(this.type + "  " + this.name);
            lines.add("Polling period = " + this.period + "ms");
            lines.add("Last record takes " + this.reading_time + " ms");
            if (this.info.length > 4) {
                lines.add(this.info[4]);
            }
            if (this.info.length > 5) {
                lines.add(this.info[5]);
            }
            lines.add("");
            String str = "Drifts (ms):   ";
            for (int realPeriod : this.realPeriods) {
                str = str + "" + (realPeriod - this.period) + ", ";
            }
            lines.add(str);
        } else {
            StringTokenizer stk = new StringTokenizer(this.status, "\n");
            while (stk.hasMoreTokens()) {
                lines.add(stk.nextToken());
            }
        }
        return lines.toArray(new String[lines.size()]);
    }
}

