/*
 * Decompiled with CFR 0.152.
 */
package admin.astor.tango_release;

import admin.astor.AstorUtil;
import admin.astor.tango_release.TangoClassRelease;
import admin.astor.tango_release.TangoServerRelease;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

public class TangoServerReleaseList
extends ArrayList<TangoServerRelease> {
    private List<TangoServerRelease> onErrors = new ArrayList<TangoServerRelease>();
    private static final int idlMin = 2;
    private static final int idlMax = 10;

    public TangoServerReleaseList(List<String> serverNames) {
        Collections.sort(serverNames, new StringComparator());
        int counter = 0;
        for (String serverName : serverNames) {
            double ratio = (double)counter / (double)serverNames.size();
            AstorUtil.increaseSplashProgress(ratio, "Check " + ++counter + "/" + serverNames.size() + " - " + serverName);
            TangoServerRelease serverRelease = new TangoServerRelease(serverName);
            if (serverRelease.releaseNumber > 0.0) {
                this.add(serverRelease);
            } else {
                this.onErrors.add(serverRelease);
            }
            if (!AstorUtil.osIsUnix() || counter % 920 != 0) continue;
            for (int i = 180; i > 0; --i) {
                AstorUtil.setSplashMessage("Waiting " + i + " sec.");
                try {
                    Thread.sleep(1000L);
                    continue;
                }
                catch (InterruptedException e) {
                    // empty catch block
                }
            }
        }
    }

    public int nbClasses() {
        int nb = 0;
        for (int idl = 2; idl <= 10; ++idl) {
            List<TangoClassRelease> classReleases = this.getClassesForIdlRelease(idl);
            nb += classReleases.size();
        }
        return nb;
    }

    public List<TangoServerRelease> getServersForTangoRelease(double tangoRelease) {
        ArrayList<TangoServerRelease> list = new ArrayList<TangoServerRelease>();
        for (TangoServerRelease serverRelease : this) {
            int release1 = (int)(100.0 * serverRelease.releaseNumber);
            int release2 = (int)(100.0 * tangoRelease);
            if (release1 != release2) continue;
            list.add(serverRelease);
        }
        return list;
    }

    public List<TangoServerRelease> getServersForIdlRelease(int idl) {
        ArrayList<TangoServerRelease> list = new ArrayList<TangoServerRelease>();
        for (TangoServerRelease serverRelease : this) {
            if (!serverRelease.hasIDL(idl)) continue;
            list.add(serverRelease);
        }
        return list;
    }

    public List<TangoClassRelease> getClassesForIdlRelease(int idl) {
        ArrayList<TangoClassRelease> list = new ArrayList<TangoClassRelease>();
        for (TangoServerRelease serverRelease : this) {
            List<TangoClassRelease> classes = serverRelease.getIdlClasses(idl);
            for (TangoClassRelease class_ : classes) {
                boolean found = false;
                for (TangoClassRelease classRelease : list) {
                    if (!classRelease.className.equals(class_.className)) continue;
                    found = true;
                }
                if (found) continue;
                list.add(class_);
            }
        }
        Collections.sort(list, new ClassComparator());
        return list;
    }

    public List<TangoServerRelease> getServersOnError() {
        return this.onErrors;
    }

    public String toString(List<TangoServerRelease> list) {
        StringBuilder sb = new StringBuilder();
        for (TangoServerRelease serverRelease : list) {
            sb.append(serverRelease.toStringFull()).append("\n");
        }
        return sb.toString();
    }

    public String toString(double tangoRelease) {
        return this.toString(this.getServersForTangoRelease(tangoRelease));
    }

    public String toString(int idl) {
        StringBuilder sb = new StringBuilder();
        List<TangoClassRelease> classReleases = this.getClassesForIdlRelease(idl);
        for (TangoClassRelease classRelease : classReleases) {
            sb.append(classRelease).append("\n");
        }
        return sb.toString();
    }

    @Override
    public String toString() {
        return this.toString(this);
    }

    class StringComparator
    implements Comparator<String> {
        StringComparator() {
        }

        @Override
        public int compare(String s1, String s2) {
            return s1.compareTo(s2);
        }
    }

    class ClassComparator
    implements Comparator<TangoClassRelease> {
        ClassComparator() {
        }

        @Override
        public int compare(TangoClassRelease class1, TangoClassRelease class2) {
            return class1.className.compareTo(class2.className);
        }
    }

    class ServerComparator
    implements Comparator<TangoServerRelease> {
        ServerComparator() {
        }

        @Override
        public int compare(TangoServerRelease server1, TangoServerRelease server2) {
            return server1.name.compareTo(server2.name);
        }
    }
}

