/*
 * Decompiled with CFR 0.152.
 */
package admin.astor;

import admin.astor.Astor;
import admin.astor.AstorDefs;
import admin.astor.AstorTree;
import admin.astor.AstorUtil;
import admin.astor.DbaseObject;
import admin.astor.RemoteLoginThread;
import admin.astor.ServerCmdThread;
import admin.astor.TangoHost;
import admin.astor.statistics.StarterStatTable;
import admin.astor.tango_release.TangoReleaseDialog;
import fr.esrf.Tango.DevFailed;
import fr.esrf.tangoatk.widget.util.ErrorPane;
import java.awt.Component;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.util.List;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreePath;

public class TreePopupMenu
extends JPopupMenu
implements AstorDefs {
    private Astor astor;
    private AstorTree parent;
    private TangoHost host;
    private String collec_name;
    private TangoHost[] collec_hosts;
    private static String[] menuLabels = new String[]{"Open control Panel", "Remote Login", "Starter info", "Starter test", "Host info", "Branch  info", "Start all Servers", "Stop  all Servers", "Reset Statistics", "Clone", "Change branch", "Edit Properties", "Remove", "Black Box", "Starter Logs", "Starter Statistics", "Tango Version for Servers", "Up-time for Servers", "Force Update", "Change Name"};
    private static final int OFFSET = 2;
    private static final int OPEN_PANEL = 0;
    private static final int REM_LOGIN = 1;
    private static final int STARTER_INFO = 2;
    private static final int STARTER_TEST = 3;
    private static final int HOST_INFO = 4;
    private static final int COLLEC_INFO = 5;
    private static final int START_SERVERS = 6;
    private static final int STOP_SERVERS = 7;
    private static final int RESET_STAT = 8;
    private static final int CLONE_HOST = 9;
    private static final int CHANGE_BRANCH = 10;
    private static final int EDIT_PROP = 11;
    private static final int REMOVE_HOST = 12;
    private static final int BLACK_BOX = 13;
    private static final int STARTER_LOGS = 14;
    private static final int STARTER_STAT = 15;
    private static final int SERVER_VERSIONS = 16;
    private static final int UPTIME_SERVERS = 17;
    private static final int UPDATE = 18;
    private static final int CHANGE_NAME = 19;

    public TreePopupMenu(Astor astor, AstorTree parent) {
        this.astor = astor;
        this.parent = parent;
        this.buildBtnPopupMenu();
    }

    public TreePopupMenu(AstorTree parent) {
        this.astor = null;
        this.parent = parent;
        this.buildBtnPopupMenu();
    }

    private void buildBtnPopupMenu() {
        JLabel title = new JLabel("Host Control :");
        title.setFont(new Font("Dialog", 1, 16));
        this.add(title);
        this.add(new JPopupMenu.Separator());
        for (String menuLabel : menuLabels) {
            JMenuItem btn = new JMenuItem(menuLabel);
            btn.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    TreePopupMenu.this.hostActionPerformed(evt);
                }
            });
            this.add(btn);
        }
    }

    private boolean getSelectedObject() {
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)this.parent.getLastSelectedPathComponent();
        if (node == null) {
            return false;
        }
        Object obj = node.getUserObject();
        if (obj instanceof DbaseObject) {
            return false;
        }
        if (obj instanceof TangoHost) {
            this.host = (TangoHost)((Object)obj);
            this.collec_name = null;
        } else {
            this.host = null;
            int nb = node.getChildCount();
            this.collec_hosts = new TangoHost[nb];
            for (int i = 0; i < nb; ++i) {
                Object o = (node = node.getNextNode()).getUserObject();
                if (!(o instanceof TangoHost)) {
                    return false;
                }
                this.collec_hosts[i] = (TangoHost)((Object)o);
            }
            this.collec_name = (String)obj;
        }
        return true;
    }

    public void showMenu(MouseEvent evt) {
        TreePath selectedPath = this.parent.getPathForLocation(evt.getX(), evt.getY());
        if (selectedPath == null) {
            return;
        }
        this.parent.setSelectionPath(selectedPath);
        if (!this.getSelectedObject()) {
            return;
        }
        for (int i = 2; i < this.getComponentCount(); ++i) {
            this.getComponent(i).setVisible(true);
        }
        if (this.host != null) {
            JLabel lbl = (JLabel)this.getComponent(0);
            lbl.setText("  " + this.host.getName() + "  :");
            this.getComponent(7).setVisible(false);
            this.getComponent(8).setVisible(false);
            this.getComponent(9).setVisible(false);
            this.getComponent(10).setVisible(false);
            this.getComponent(21).setVisible(false);
            this.getComponent(3).setVisible(true);
            this.getComponent(12).setEnabled(true);
            this.getComponent(13).setEnabled(true);
            this.getComponent(11).setEnabled(true);
            boolean can_test = this.host.state == 4 || this.host.state == 3 || this.host.state == 2 || this.host.state == 5;
            this.getComponent(5).setEnabled(can_test);
            this.getComponent(16).setEnabled(can_test);
            this.getComponent(17).setEnabled(can_test);
            this.getComponent(18).setEnabled(can_test);
            this.getComponent(19).setVisible(true);
            this.getComponent(14).setEnabled(!can_test);
            this.getComponent(20).setEnabled(can_test);
            this.getComponent(15).setVisible(this.host.state != 1);
            this.getComponent(6).setVisible(!this.host.hostName().startsWith("w-") && !AstorUtil.getHostInfoClassName().isEmpty());
            if (Astor.rwMode == 2) {
                this.getComponent(5).setVisible(false);
            }
            if (Astor.rwMode != 0) {
                this.getComponent(11).setVisible(false);
                this.getComponent(12).setVisible(false);
                this.getComponent(14).setVisible(false);
                this.getComponent(13).setVisible(false);
            }
        } else if (this.collec_name != null) {
            JLabel lbl = (JLabel)this.getComponent(0);
            lbl.setText("  " + this.collec_name + "  :");
            this.getComponent(2).setVisible(false);
            this.getComponent(3).setVisible(false);
            this.getComponent(4).setVisible(false);
            this.getComponent(5).setVisible(false);
            this.getComponent(16).setVisible(false);
            this.getComponent(17).setVisible(false);
            this.getComponent(18).setVisible(false);
            this.getComponent(19).setVisible(false);
            this.getComponent(20).setVisible(false);
            this.getComponent(11).setEnabled(false);
            this.getComponent(12).setEnabled(false);
            this.getComponent(13).setEnabled(false);
            this.getComponent(14).setEnabled(false);
            this.getComponent(15).setVisible(false);
            this.getComponent(6).setVisible(!AstorUtil.getHostInfoClassName().isEmpty());
            this.getComponent(10).setVisible(AstorUtil.getInstance().isSuperTango());
            if (Astor.rwMode == 2) {
                this.getComponent(8).setVisible(false);
                this.getComponent(9).setVisible(false);
            }
            if (Astor.rwMode != 0) {
                this.getComponent(21).setVisible(false);
            }
        }
        this.show(this.parent, evt.getX(), evt.getY());
    }

    private void hostActionPerformed(ActionEvent evt) {
        Object obj = evt.getSource();
        int commandIndex = 0;
        for (int i = 0; i < menuLabels.length; ++i) {
            if (this.getComponent(2 + i) != obj) continue;
            commandIndex = i;
        }
        switch (commandIndex) {
            case 0: {
                this.parent.displayHostInfo();
                break;
            }
            case 4: {
                this.parent.startHostInfo();
                break;
            }
            case 3: {
                this.host.testStarter(this.astor);
                break;
            }
            case 14: {
                this.host.displayLogging(this.astor);
                break;
            }
            case 15: {
                try {
                    new StarterStatTable(this.astor, this.host.hostName()).setVisible(true);
                }
                catch (DevFailed e) {
                    ErrorPane.showErrorMessage((Component)this.astor, null, (DevFailed)e);
                }
                break;
            }
            case 16: {
                List<String> serverNames = this.host.getServerNames();
                serverNames.add("Starter/" + this.host.hostName());
                new TangoReleaseDialog(this.astor, this.host.hostName(), serverNames).setVisible(true);
                break;
            }
            case 17: {
                this.host.displayUptimes(this.astor);
                break;
            }
            case 2: {
                this.host.displayInfo(this.parent);
                break;
            }
            case 1: {
                try {
                    new RemoteLoginThread(this.host.getName()).start();
                }
                catch (DevFailed e) {
                    ErrorPane.showErrorMessage((Component)this, null, (DevFailed)e);
                }
                break;
            }
            case 9: {
                this.astor.addNewHost(this.host);
                break;
            }
            case 11: {
                this.astor.editHostProperties(this.host);
                break;
            }
            case 10: {
                this.parent.moveNode();
                break;
            }
            case 12: {
                this.astor.removeHost(this.host.getName());
                break;
            }
            case 13: {
                this.host.displayBlackBox(this.astor);
                break;
            }
            case 5: {
                this.parent.displayBranchInfo();
                break;
            }
            case 6: {
                new ServerCmdThread(this.astor, this.collec_hosts, 0).start();
                break;
            }
            case 7: {
                new ServerCmdThread(this.astor, this.collec_hosts, 1).start();
                break;
            }
            case 8: {
                this.parent.resetCollectionStatistics();
                break;
            }
            case 18: {
                this.host.updateServersList(this.astor);
                break;
            }
            case 19: {
                this.parent.changeNodeName();
            }
        }
    }
}

