/*
 * Decompiled with CFR 0.152.
 */
package admin.astor;

import admin.astor.AstorUtil;
import admin.astor.HostInfoDialog;
import admin.astor.HostStateThread;
import admin.astor.TangoServer;
import admin.astor.tools.BlackBoxTable;
import admin.astor.tools.PopupTable;
import admin.astor.tools.PopupText;
import admin.astor.tools.Utils;
import fr.esrf.Tango.DevFailed;
import fr.esrf.TangoApi.ApiUtil;
import fr.esrf.TangoApi.Database;
import fr.esrf.TangoApi.DbDatum;
import fr.esrf.TangoApi.DbDevExportInfo;
import fr.esrf.TangoApi.DbDevImportInfo;
import fr.esrf.TangoApi.DbServInfo;
import fr.esrf.TangoApi.DeviceAttribute;
import fr.esrf.TangoApi.DeviceData;
import fr.esrf.TangoApi.DeviceProxy;
import fr.esrf.TangoApi.IORdump;
import fr.esrf.TangoApi.events.TangoEventsAdapter;
import fr.esrf.TangoDs.Except;
import fr.esrf.tangoatk.widget.util.ErrorPane;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JOptionPane;

public class TangoHost
extends DeviceProxy {
    private TangoServer starter = null;
    private String name;
    private List<TangoServer> servers = new ArrayList<TangoServer>();
    public String usage = null;
    public int state;
    public DevFailed except;
    public boolean poll_serv_lists = false;
    public String collection = null;
    public HostStateThread thread = null;
    public int notifydState;
    public boolean onEvents = true;
    public boolean manageNotifd;
    public HostInfoDialog info_dialog = null;
    public TangoEventsAdapter supplier = null;
    public String eventSource = "";
    private String adm_name;

    public TangoHost(String name, boolean get_prop) throws DevFailed {
        super(AstorUtil.getStarterDeviceHeader() + name);
        this.adm_name = "dserver/starter/" + name;
        this.set_transparency_reconnection(true);
        this.notifydState = 0;
        int i = name.indexOf(".");
        this.name = i < 0 ? name : name.substring(0, i);
        if (get_prop) {
            DbDatum prop;
            DbDatum data = this.get_property("HostCollection");
            if (!data.is_empty()) {
                this.collection = data.extractString();
            }
            if (!(prop = this.get_property("HostUsage")).is_empty()) {
                this.usage = prop.extractString();
                if (this.usage.length() == 0) {
                    this.usage = null;
                }
            }
            this.manageNotifd = false;
            try {
                data = this.get_property("UseEvents");
                if (!data.is_empty()) {
                    this.manageNotifd = data.extractShort() != 0;
                }
            }
            catch (DevFailed e) {
                // empty catch block
            }
        }
    }

    static String controlMethod(boolean onEvt) {
        return onEvt ? "on events" : "on polling";
    }

    public TangoHost(DbDevImportInfo deviceInfo, DbDevImportInfo adminInfo) throws DevFailed {
        super(deviceInfo);
        this.adm_name = adminInfo.name;
        this.set_transparency_reconnection(true);
        this.notifydState = 0;
        int i = deviceInfo.name.indexOf(".");
        this.name = i < 0 ? deviceInfo.name : deviceInfo.name.substring(0, i);
        int idx = this.name.indexOf(47);
        if (idx > 0) {
            idx = this.name.indexOf(47, idx + 1);
        }
        if (idx > 0) {
            this.name = this.name.substring(idx + 1);
        }
    }

    public void addServer(TangoServer ts) {
        this.servers.add(ts);
    }

    public TangoServer getServer(String servname) {
        servname = servname.trim();
        for (int i = 0; i < this.nbServers(); ++i) {
            TangoServer server = this.getServer(i);
            if (!server.getName().equals(servname)) continue;
            return server;
        }
        return null;
    }

    public TangoServer getServer(int idx) {
        return this.servers.get(idx);
    }

    public List<String> getServerNames() {
        ArrayList<String> controlledServers = new ArrayList<String>();
        try {
            String[] lines;
            DeviceAttribute attribute = this.read_attribute("Servers");
            for (String line : lines = attribute.extractStringArray()) {
                StringTokenizer stringTokenizer = new StringTokenizer(line);
                String serverName = stringTokenizer.nextToken();
                controlledServers.add(serverName);
            }
        }
        catch (DevFailed devFailed) {
            // empty catch block
        }
        return controlledServers;
    }

    public void removeServer(int idx) {
        this.servers.remove(idx);
    }

    public void removeServer(String servname) {
        for (int i = 0; i < this.nbServers(); ++i) {
            TangoServer server = this.getServer(i);
            if (!server.getName().equals(servname)) continue;
            this.removeServer(i);
            return;
        }
    }

    public int nbServers() {
        if (this.servers == null) {
            return 0;
        }
        return this.servers.size();
    }

    public String[] getServerAttribute() {
        try {
            DeviceAttribute att = this.read_attribute("Servers");
            return att.extractStringArray();
        }
        catch (DevFailed e) {
            System.out.println(this.name);
            Except.print_exception((Exception)((Object)e));
            return new String[0];
        }
    }

    public String readLogFile(String servname) throws DevFailed {
        DeviceData argin = new DeviceData();
        argin.insert(servname);
        DeviceData argout = this.command_inout("DevReadLog", argin);
        return argout.extractString();
    }

    public void registerServer(String servname) throws DevFailed {
        String devname = "dserver/" + servname;
        boolean running = false;
        try {
            DeviceProxy dev = new DeviceProxy(devname);
            dev.ping();
            running = true;
        }
        catch (DevFailed e) {
            // empty catch block
        }
        if (running) {
            IORdump d = new IORdump(devname);
            Except.throw_exception((String)"StartServerFailed", (String)(servname + " is already running on " + d.get_host()), (String)"DevWizard.startServer()");
        }
        DbDevExportInfo info = new DbDevExportInfo(devname, "null", this.name, "null");
        ApiUtil.get_db_obj().export_device(info);
        ApiUtil.get_db_obj().unexport_device(devname);
    }

    public void startOneServer(String servname) throws DevFailed {
        DeviceData argin = new DeviceData();
        argin.insert(servname);
        System.out.println("command_inout(DevStart, " + servname + ") on " + this.get_name());
        this.command_inout("DevStart", argin);
    }

    public void startServer(String servname) throws DevFailed {
        DeviceData argin = new DeviceData();
        argin.insert(servname);
        this.command_inout("DevStart", argin);
    }

    public void stopServer(String servname) throws DevFailed {
        DeviceData argin = new DeviceData();
        argin.insert(servname);
        this.command_inout("DevStop", argin);
    }

    public void hardKillServer(String servname) throws DevFailed {
        DeviceData argin = new DeviceData();
        argin.insert(servname);
        this.command_inout("HardKillServer", argin);
    }

    public void startServers(int level) throws DevFailed {
        DeviceData argin = new DeviceData();
        argin.insert((short)level);
        this.command_inout("DevStartAll", argin);
    }

    public void stopServers(int level) throws DevFailed {
        DeviceData argin = new DeviceData();
        argin.insert((short)level);
        this.command_inout("DevStopAll", argin);
    }

    public void displayUptimes(JFrame parent) {
        try {
            Database db = ApiUtil.get_db_obj();
            DeviceData argIn = new DeviceData();
            argIn.insert(this.name);
            DeviceData argOut = db.command_inout("DbGetHostServerList", argIn);
            String[] serverNames = argOut.extractStringArray();
            ArrayList<String[]> lines = new ArrayList<String[]>();
            for (String severName : serverNames) {
                String[] exportedStr = new TangoServer("dserver/" + severName).getServerUptime();
                lines.add(new String[]{severName, exportedStr[0], exportedStr[1]});
            }
            String[] columns = new String[]{"Server", "Last   exported", "Last unexported"};
            PopupTable ppt = new PopupTable(parent, this.name, columns, lines, new Dimension(650, 250));
            ppt.setVisible(true);
        }
        catch (DevFailed e) {
            ErrorPane.showErrorMessage((Component)parent, null, (DevFailed)e);
        }
    }

    public void displayLogging(JFrame parent) {
        this.displayLogging(parent, null);
    }

    public void displayLogging(Component parent, String filter) {
        try {
            DeviceData argIn = new DeviceData();
            argIn.insert("Starter");
            DeviceData argOut = this.command_inout("DevReadLog", argIn);
            String str = argOut.extractString();
            String[] array = AstorUtil.string2array(str, "\n");
            ArrayList<String[]> lines = new ArrayList<String[]>();
            String prev_date = null;
            for (String line : array) {
                String[] words = AstorUtil.string2array(line);
                String server = words[2];
                words[2] = words[3];
                words[3] = server;
                if (filter != null && !server.equals(filter)) continue;
                if (prev_date != null && !words[0].equals(prev_date)) {
                    lines.add(new String[]{"-", "-", "-", "-"});
                }
                prev_date = words[0];
                lines.add(words);
            }
            if (lines.size() > 0) {
                String[] columnNames = new String[]{"Date", "Time", "Action", "Server"};
                PopupTable table = parent instanceof JFrame ? new PopupTable((JFrame)parent, "Starter on " + this.name, columnNames, lines) : new PopupTable((JDialog)parent, "Starter on " + this.name, columnNames, lines);
                table.setColumnWidth(new int[]{70, 70, 70, 250});
                table.setSortAvailable(false);
                table.setVisible(true);
            } else {
                String desc = "no record found";
                if (filter != null) {
                    desc = desc + "  for  " + filter;
                }
                Except.throw_exception((String)"", (String)desc, (String)"");
            }
        }
        catch (DevFailed e) {
            Utils.popupError(parent, e.errors[0].desc);
        }
    }

    public void displayInfo(Component parent) {
        String str = "";
        try {
            String[] servnames;
            if (this.starter == null) {
                this.starter = new TangoServer(this.adm_name);
            }
            str = str + this.starter.getServerInfo(parent, this.state == 4);
            str = str + "\n\n----------- Controlled servers -----------\n";
            Database db = ApiUtil.get_db_obj();
            DeviceData argin = new DeviceData();
            argin.insert(this.name);
            DeviceData argout = db.command_inout("DbGetHostServerList", argin);
            for (String servname : servnames = argout.extractStringArray()) {
                DbServInfo s = db.get_server_info(servname);
                if (!s.controlled) continue;
                str = str + s.name + "\n";
            }
        }
        catch (DevFailed e) {
            str = str + e.errors[0].desc;
            ErrorPane.showErrorMessage((Component)parent, (String)str, (DevFailed)e);
            return;
        }
        str = str + "\n\n";
        Utils.popupMessage(parent, str);
    }

    public void testStarter(Component parent) {
        try {
            if (this.starter == null) {
                this.starter = new TangoServer(this.adm_name);
            }
            this.starter.testDevice(parent);
        }
        catch (DevFailed e) {
            ErrorPane.showErrorMessage((Component)parent, (String)"", (DevFailed)e);
        }
    }

    public void unExportStarter(Component parent) {
        try {
            DbDevImportInfo info = this.import_device();
            if (!info.exported) {
                Utils.popupError(parent, this.get_name() + "  NOT  exported !");
                return;
            }
            this.unexport_device();
            String adm = "dserver/Starter/" + this.name;
            new DeviceProxy(adm).unexport_device();
            Utils.popupMessage(parent, adm + "   and    " + this.get_name() + "\n\n       have been unexported !");
        }
        catch (DevFailed e) {
            ErrorPane.showErrorMessage((Component)parent, (String)"", (DevFailed)e);
        }
    }

    public void setCollection(String new_collec) throws DevFailed {
        DbDatum[] prop = new DbDatum[]{new DbDatum("HostCollection", new_collec)};
        this.put_property(prop);
        this.collection = new_collec;
    }

    public String getName() {
        return this.name;
    }

    public void startServer(Component parent, String servname) {
        try {
            this.startServer(servname);
        }
        catch (DevFailed e) {
            ErrorPane.showErrorMessage((Component)parent, (String)"", (DevFailed)e);
        }
    }

    void readStdErrorFile(Frame parent, String servname) {
        try {
            String logStr = this.readLogFile(servname);
            PopupText dialog = new PopupText(parent, true);
            dialog.show(logStr, 700, 500);
        }
        catch (DevFailed e) {
            ErrorPane.showErrorMessage((Component)parent, (String)"", (DevFailed)e);
        }
        catch (Exception e) {
            ErrorPane.showErrorMessage((Component)parent, (String)"", (Exception)e);
            e.printStackTrace();
        }
    }

    void updateServersList(JFrame parent) {
        try {
            this.command_inout("UpdateServersInfo");
        }
        catch (DevFailed e) {
            ErrorPane.showErrorMessage((Component)parent, (String)"", (DevFailed)e);
        }
    }

    void updateData() {
        this.thread.updateData();
    }

    void stopThread() {
        this.thread.stop_it = true;
        this.thread.updateData();
    }

    String[] getPath() {
        String[] path = new String[]{""};
        try {
            DbDatum datum = this.get_property("StartDsPath");
            if (!datum.is_empty()) {
                path = datum.extractStringArray();
            }
        }
        catch (DevFailed e) {
            Except.print_exception((Exception)((Object)e));
        }
        return path;
    }

    String getFamily() {
        String family = "";
        try {
            DbDatum datum = this.get_property("HostCollection");
            if (!datum.is_empty()) {
                family = datum.extractString();
            }
        }
        catch (DevFailed e) {
            Except.print_exception((Exception)((Object)e));
        }
        return family;
    }

    public void displayBlackBox(JFrame parent) {
        Object[] devices = new String[]{this.get_name(), this.adm_name};
        String choice = (String)JOptionPane.showInputDialog(parent, "Device selection :", "", 1, null, devices, devices[0]);
        if (choice != null) {
            try {
                new BlackBoxTable(parent, choice).setVisible(true);
            }
            catch (DevFailed e) {
                ErrorPane.showErrorMessage((Component)parent, null, (DevFailed)e);
            }
        }
    }

    public String hostStatus() {
        String str = this.name + ":";
        try {
            if (this.state == 1) {
                str = str + "     is faulty\n";
            } else {
                DeviceAttribute att = this.read_attribute("Servers");
                if (att.hasFailed()) {
                    str = str + "     " + att.getErrStack()[0].desc + "\n";
                } else {
                    String[] list;
                    str = str + "\n";
                    ArrayList<String> running = new ArrayList<String>();
                    ArrayList<String> moving = new ArrayList<String>();
                    ArrayList<String> stopped = new ArrayList<String>();
                    block10: for (String line : list = att.extractStringArray()) {
                        StringTokenizer stk = new StringTokenizer(line);
                        String name = stk.nextToken();
                        String st = stk.nextToken();
                        String str_ctrl = stk.nextToken();
                        if (!str_ctrl.equals("1")) continue;
                        switch (st) {
                            case "FAULT": {
                                stopped.add(name);
                                continue block10;
                            }
                            case "MOVING": {
                                moving.add(name);
                                continue block10;
                            }
                            default: {
                                running.add(name);
                            }
                        }
                    }
                    if (stopped.size() > 0) {
                        str = str + "     " + stopped.size() + "  servers stopped\n";
                    }
                    if (moving.size() > 0) {
                        str = str + "     " + moving.size() + " servers moving\n";
                    }
                    if (running.size() > 0) {
                        str = str + "     " + running.size() + " servers running\n";
                    }
                }
            }
        }
        catch (DevFailed e) {
            str = str + "     " + e.errors[0].desc;
        }
        return str;
    }

    public String hostName() {
        return this.name;
    }

    public String toString() {
        if (this.usage == null || this.usage.length() == 0) {
            return this.name;
        }
        return this.name + "  ( " + this.usage + " )";
    }
}

