/*
 * Decompiled with CFR 0.152.
 */
package admin.astor;

import admin.astor.AstorDefs;
import admin.astor.AstorUtil;
import admin.astor.Monitor;
import admin.astor.TangoHost;
import admin.astor.tools.Utils;
import fr.esrf.Tango.DevFailed;
import fr.esrf.tangoatk.widget.util.ATKGraphicsUtils;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;

public class ServerCmdThread
extends Thread
implements AstorDefs {
    private Component parent;
    private TangoHost[] hosts;
    private int cmd;
    private Monitor monitor;
    private boolean[] levelUsed;
    private short nbStartupLevels;
    private String monitor_title;
    private boolean confirm = true;
    private boolean fromList;
    private List<Integer> levels;

    public ServerCmdThread(JFrame parent, TangoHost[] hosts, int cmd) {
        this.parent = parent;
        this.hosts = hosts;
        this.cmd = cmd;
        this.monitor_title = " on all controlled hosts   ";
        this.nbStartupLevels = AstorUtil.getStarterNbStartupLevels();
        this.levelUsed = new boolean[this.nbStartupLevels];
        for (int i = 0; i < this.nbStartupLevels; ++i) {
            this.levelUsed[i] = true;
        }
        this.fromList = false;
    }

    public ServerCmdThread(JDialog parent, TangoHost host, int cmd, List<Integer> levels) {
        this(parent, host, cmd, levels, true);
    }

    public ServerCmdThread(JDialog parent, TangoHost host, int cmd, List<Integer> levels, boolean confirm) {
        this.parent = parent;
        this.hosts = new TangoHost[1];
        this.hosts[0] = host;
        this.cmd = cmd;
        this.levels = levels;
        this.confirm = confirm;
        this.monitor_title = " on " + (Object)((Object)host) + "   ";
        this.nbStartupLevels = AstorUtil.getStarterNbStartupLevels();
        this.fromList = true;
    }

    private void updateProgressMonitor(int level, int hostIndex, double ratio) {
        String message;
        if (this.monitor == null) {
            message = cmdStr[this.cmd] + this.monitor_title;
            if (this.parent instanceof JDialog) {
                this.monitor = new Monitor((JDialog)this.parent, message, cmdStr[this.cmd]);
            } else if (this.parent instanceof JFrame) {
                this.monitor = new Monitor((JFrame)this.parent, message, cmdStr[this.cmd]);
            }
        }
        message = cmdStr[this.cmd] + "Servers on " + this.hosts[hostIndex].getName() + " for level " + level;
        this.monitor.setProgressValue(ratio, message);
    }

    @Override
    public void run() {
        AstorUtil.getStarterNbStartupLevels();
        this.updateProgressMonitor(0, 0, 0.05);
        StartStopDialog startStopDialog = this.parent instanceof JDialog ? new StartStopDialog((JDialog)this.parent, this.levels.size() > 1) : new StartStopDialog((JFrame)this.parent, this.levels.size() > 1);
        startStopDialog.setForAllLevels(!this.confirm);
        if (this.fromList) {
            for (int level : this.levels) {
                if (startStopDialog.doItForAllLevels()) {
                    this.executeCommand(this.hosts, level);
                    continue;
                }
                switch (startStopDialog.showDialog(cmdStr[this.cmd] + " for level " + level + " ?  ")) {
                    case 2: {
                        this.monitor.setProgressValue(100.0);
                        return;
                    }
                    case 0: {
                        this.executeCommand(this.hosts, level);
                        break;
                    }
                }
            }
        } else {
            switch (this.cmd) {
                case 0: {
                    block17: for (int level = 1; !this.monitor.isCanceled() && level <= this.nbStartupLevels; ++level) {
                        if (!this.levelUsed[level - 1]) continue;
                        if (startStopDialog.doItForAllLevels()) {
                            this.executeCommand(this.hosts, level);
                            continue;
                        }
                        switch (startStopDialog.showDialog(cmdStr[this.cmd] + " for level " + level + " ?  ")) {
                            case 2: {
                                level = this.nbStartupLevels;
                                continue block17;
                            }
                            case 0: {
                                this.executeCommand(this.hosts, level);
                                continue block17;
                            }
                        }
                    }
                    break;
                }
                case 1: {
                    block18: for (int level = this.nbStartupLevels; !this.monitor.isCanceled() && level > 0; --level) {
                        if (!this.levelUsed[level - 1]) continue;
                        if (startStopDialog.doItForAllLevels()) {
                            this.executeCommand(this.hosts, level);
                            continue;
                        }
                        switch (startStopDialog.showDialog(cmdStr[this.cmd] + " for level " + level)) {
                            case 2: {
                                level = 0;
                                continue block18;
                            }
                            case 0: {
                                this.executeCommand(this.hosts, level);
                                continue block18;
                            }
                        }
                    }
                    break;
                }
            }
        }
        this.monitor.setProgressValue(100.0);
    }

    private void executeCommand(TangoHost[] hosts, int level) {
        for (int i = 0; !this.monitor.isCanceled() && i < hosts.length; ++i) {
            TangoHost host = hosts[i];
            try {
                switch (this.cmd) {
                    case 0: {
                        double ratio = ((double)(level + 1) * (double)hosts.length + (double)i) / (double)(hosts.length * (this.nbStartupLevels + 2));
                        this.updateProgressMonitor(level, i, ratio);
                        host.startServers(level);
                        try {
                            ServerCmdThread.sleep(500L);
                        }
                        catch (Exception e) {}
                        break;
                    }
                    case 1: {
                        double ratio = ((double)(this.nbStartupLevels - level + 1) * (double)hosts.length + (double)i) / (double)(hosts.length * (this.nbStartupLevels + 2));
                        this.updateProgressMonitor(level, i, ratio);
                        host.stopServers(level);
                        try {
                            ServerCmdThread.sleep(50L);
                            break;
                        }
                        catch (Exception e) {
                            // empty catch block
                        }
                    }
                }
            }
            catch (DevFailed e) {
                // empty catch block
            }
            host.updateData();
        }
    }

    private class StartStopDialog
    extends JDialog {
        private JPanel centerPanel;
        private JLabel titleLabel;
        private JRadioButton forAllLevelsBtn;
        private int returnValue;

        private StartStopDialog(JDialog parent, boolean allLevelAvailable) {
            super((Dialog)parent, true);
            this.returnValue = 0;
            this.initComponents(allLevelAvailable);
        }

        private StartStopDialog(JFrame parent, boolean allLevelAvailable) {
            super((Frame)parent, true);
            this.returnValue = 0;
            this.initComponents(allLevelAvailable);
        }

        private boolean doItForAllLevels() {
            return this.forAllLevelsBtn != null && this.forAllLevelsBtn.isSelected();
        }

        public void setForAllLevels(boolean b) {
            this.forAllLevelsBtn.setSelected(b);
        }

        private void initComponents(boolean allLevelAvailable) {
            GridBagConstraints gridBagConstraints;
            JPanel topPanel = new JPanel();
            this.titleLabel = new JLabel();
            this.centerPanel = new JPanel();
            JPanel bottomPanel = new JPanel();
            this.forAllLevelsBtn = new JRadioButton();
            JButton yesBtn = new JButton();
            JButton noBtn = new JButton();
            JButton cancelBtn = new JButton();
            this.addWindowListener(new WindowAdapter(){

                @Override
                public void windowClosing(WindowEvent evt) {
                    StartStopDialog.this.closeDialog();
                }
            });
            this.titleLabel.setFont(new Font("Dialog", 1, 18));
            this.titleLabel.setText("Dialog Title");
            this.titleLabel.setIcon(Utils.getInstance().getIcon("TangoClass.gif", 0.25));
            topPanel.add(this.titleLabel);
            this.getContentPane().add((Component)topPanel, "North");
            this.centerPanel.setLayout(new GridBagLayout());
            this.getContentPane().add((Component)this.centerPanel, "Center");
            bottomPanel.setLayout(new GridBagLayout());
            if (allLevelAvailable) {
                this.forAllLevelsBtn.setText("Do it for all levels");
                gridBagConstraints = new GridBagConstraints();
                gridBagConstraints.gridx = 0;
                gridBagConstraints.gridy = 0;
                gridBagConstraints.gridwidth = 2;
                gridBagConstraints.insets = new Insets(10, 10, 0, 0);
                bottomPanel.add((Component)this.forAllLevelsBtn, gridBagConstraints);
            }
            yesBtn.setText("Yes");
            yesBtn.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    StartStopDialog.this.yesBtnActionPerformed();
                }
            });
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 1;
            gridBagConstraints.insets = new Insets(10, 10, 10, 10);
            bottomPanel.add((Component)yesBtn, gridBagConstraints);
            noBtn.setText("No");
            noBtn.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    StartStopDialog.this.noBtnActionPerformed();
                }
            });
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 1;
            gridBagConstraints.gridy = 1;
            gridBagConstraints.insets = new Insets(10, 10, 10, 10);
            bottomPanel.add((Component)noBtn, gridBagConstraints);
            cancelBtn.setText("Cancel");
            cancelBtn.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    StartStopDialog.this.cancelBtnActionPerformed();
                }
            });
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 2;
            gridBagConstraints.gridy = 1;
            gridBagConstraints.insets = new Insets(10, 10, 10, 10);
            bottomPanel.add((Component)cancelBtn, gridBagConstraints);
            this.getContentPane().add((Component)bottomPanel, "South");
            this.pack();
            ATKGraphicsUtils.centerDialog((Dialog)this);
        }

        private void yesBtnActionPerformed() {
            this.returnValue = 0;
            this.doClose();
        }

        private void noBtnActionPerformed() {
            this.returnValue = 1;
            this.doClose();
        }

        private void cancelBtnActionPerformed() {
            this.returnValue = 2;
            this.doClose();
        }

        private void closeDialog() {
            this.returnValue = 2;
            this.doClose();
        }

        private void doClose() {
            this.setVisible(false);
            this.dispose();
        }

        public int showDialog(String title) {
            this.titleLabel.setText(title);
            this.setVisible(true);
            return this.returnValue;
        }
    }
}

