/*
 * Decompiled with CFR 0.152.
 */
package admin.astor;

import java.awt.Component;
import java.awt.Font;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class Selector
extends JDialog {
    private String retVal = "";
    private List<String> values = new ArrayList<String>();
    private JComboBox<String> comboBox;
    private JLabel titleLabel;

    public Selector(JFrame parent, String title, List<String> values, String def_val) {
        super((Frame)parent, true);
        this.initComponents();
        this.values = values;
        this.comboBox.addItem("");
        for (int i = 0; values != null && i < values.size(); ++i) {
            this.comboBox.addItem(values.get(i));
            if (!values.get(i).equals(def_val)) continue;
            this.comboBox.setSelectedIndex(i + 1);
        }
        this.comboBox.setEditable(true);
        this.titleLabel.setText(title);
        this.pack();
    }

    public Selector(JFrame parent, String title, String[] values, String def_val) {
        super((Frame)parent, true);
        this.initComponents();
        this.comboBox.addItem("");
        for (int i = 0; values != null && i < values.length; ++i) {
            this.comboBox.addItem(values[i]);
            this.values.add(values[i]);
            if (!values[i].equals(def_val)) continue;
            this.comboBox.setSelectedIndex(i + 1);
        }
        this.comboBox.setEditable(true);
        this.titleLabel.setText(title);
        this.pack();
    }

    private void initComponents() {
        JPanel topPanel = new JPanel();
        this.titleLabel = new JLabel();
        this.comboBox = new JComboBox();
        JPanel bottomPanel = new JPanel();
        JButton okBtn = new JButton();
        JButton cancelBtn = new JButton();
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                Selector.this.closeDialog(evt);
            }
        });
        this.titleLabel.setFont(new Font("Dialog", 1, 18));
        this.titleLabel.setText("Dialog Title");
        topPanel.add(this.titleLabel);
        this.getContentPane().add((Component)topPanel, "North");
        this.comboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Selector.this.comboBoxActionPerformed(evt);
            }
        });
        this.getContentPane().add(this.comboBox, "Center");
        okBtn.setText("OK");
        okBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Selector.this.okBtnActionPerformed(evt);
            }
        });
        bottomPanel.add(okBtn);
        cancelBtn.setText("Cancel");
        cancelBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Selector.this.cancelBtnActionPerformed(evt);
            }
        });
        bottomPanel.add(cancelBtn);
        this.getContentPane().add((Component)bottomPanel, "South");
        this.pack();
    }

    private void comboBoxActionPerformed(ActionEvent evt) {
    }

    private void okBtnActionPerformed(ActionEvent evt) {
        this.retVal = (String)this.comboBox.getSelectedItem();
        boolean found = false;
        for (String value : this.values) {
            if (!value.equals(this.retVal)) continue;
            found = true;
        }
        if (!found) {
            this.comboBox.addItem(this.retVal);
        }
        this.comboBox.removeItemAt(0);
        this.comboBox.insertItemAt("", 0);
        this.doClose();
    }

    private void cancelBtnActionPerformed(ActionEvent evt) {
        this.retVal = null;
        this.doClose();
    }

    private void closeDialog(WindowEvent evt) {
        this.retVal = null;
        this.doClose();
    }

    private void doClose() {
        this.setVisible(false);
    }

    public String showDialog() {
        this.setVisible(true);
        return this.retVal;
    }

    public static void main(String[] args) {
        String title = "TANGO_HOST ?";
        String[] tgh = new String[]{"corvus:10000", "orion:10000"};
        ArrayList<String> v = new ArrayList<String>();
        v.add(tgh[0]);
        v.add(tgh[1]);
        Selector sel = new Selector(new JFrame(), title, v, "orion:10000");
        String th = sel.showDialog();
        if (th != null) {
            System.out.println(th);
        }
        if ((th = sel.showDialog()) != null) {
            System.out.println(th);
        }
        System.exit(0);
    }
}

