/*
 * Decompiled with CFR 0.152.
 */
package admin.astor;

import admin.astor.AstorUtil;
import admin.astor.TangoServer;
import admin.astor.tools.PopupTable;
import fr.esrf.Tango.DevFailed;
import fr.esrf.TangoApi.ApiUtil;
import fr.esrf.TangoApi.DeviceAttribute;
import fr.esrf.TangoApi.DeviceData;
import fr.esrf.TangoApi.DeviceInfo;
import fr.esrf.TangoApi.DeviceProxy;
import fr.esrf.TangoDs.Except;
import fr.esrf.tangoatk.widget.util.ATKGraphicsUtils;
import fr.esrf.tangoatk.widget.util.ErrorPane;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;

public class MultiServerCommand
extends JDialog {
    private static String str_filter = "*";
    private static String[] commands = new String[]{"", "Start", "Stop", "Status", "Uptime"};
    private JComboBox<String> comboBox;
    private JTextField filterTxt;
    private JList<String> jList;
    private long delayBetweenServers = 1000L;

    public MultiServerCommand(JFrame parent) throws DevFailed {
        super((Frame)parent, false);
        this.initComponents();
        this.filterTxt.setText(str_filter);
        MouseAdapter mouseListener = new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                MultiServerCommand.this.listSelectionPerformed(e);
            }
        };
        this.jList.addMouseListener(mouseListener);
        for (String cmd : commands) {
            this.comboBox.addItem(cmd);
        }
        this.setList();
        this.pack();
        ATKGraphicsUtils.centerDialog((Dialog)this);
    }

    private void setList() throws DevFailed {
        str_filter = this.filterTxt.getText();
        String[] serverList = ApiUtil.get_db_obj().get_server_list(str_filter);
        this.jList.setListData((String[])serverList);
    }

    private void initComponents() {
        JPanel topPanel = new JPanel();
        JLabel filterLabel = new JLabel();
        this.filterTxt = new JTextField();
        JScrollPane scrollPane = new JScrollPane();
        this.jList = new JList();
        JPanel bottomPanel = new JPanel();
        JPanel jPanel1 = new JPanel();
        JLabel jLabel1 = new JLabel();
        this.comboBox = new JComboBox();
        JButton sendCmdBtn = new JButton();
        JButton cancelBtn = new JButton();
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                MultiServerCommand.this.closeDialog(evt);
            }
        });
        filterLabel.setText("Filter :  ");
        topPanel.add(filterLabel);
        this.filterTxt.setColumns(20);
        this.filterTxt.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MultiServerCommand.this.filterTxtActionPerformed(evt);
            }
        });
        topPanel.add(this.filterTxt);
        this.getContentPane().add((Component)topPanel, "North");
        scrollPane.setPreferredSize(new Dimension(200, 300));
        scrollPane.setViewportView(this.jList);
        this.getContentPane().add((Component)scrollPane, "Center");
        bottomPanel.setLayout(new GridBagLayout());
        jLabel1.setText("Command:");
        jPanel1.add(jLabel1);
        jPanel1.add(this.comboBox);
        sendCmdBtn.setText("Send");
        sendCmdBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MultiServerCommand.this.sendCmdBtnActionPerformed(evt);
            }
        });
        jPanel1.add(sendCmdBtn);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(0, 0, 0, 50);
        bottomPanel.add((Component)jPanel1, gridBagConstraints);
        cancelBtn.setText("Dismiss");
        cancelBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MultiServerCommand.this.cancelBtnActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(0, 50, 0, 0);
        bottomPanel.add((Component)cancelBtn, gridBagConstraints);
        this.getContentPane().add((Component)bottomPanel, "South");
    }

    private void listSelectionPerformed(MouseEvent evt) {
    }

    private void filterTxtActionPerformed(ActionEvent evt) {
        try {
            this.setList();
        }
        catch (DevFailed e) {
            ErrorPane.showErrorMessage((Component)this, (String)"", (DevFailed)e);
        }
    }

    private void cancelBtnActionPerformed(ActionEvent evt) {
        this.setVisible(false);
        this.dispose();
    }

    private void closeDialog(WindowEvent evt) {
        this.setVisible(false);
        this.dispose();
    }

    private void sendCmdBtnActionPerformed(ActionEvent evt) {
        List<String> selections = this.jList.getSelectedValuesList();
        if (selections.size() == 0) {
            MultiServerCommand.displayError(this, "No server selected !", "MultiServerCommand.sendCmdBtnActionPerformed()");
            return;
        }
        String command = (String)this.comboBox.getSelectedItem();
        if (command.length() == 0) {
            MultiServerCommand.displayError(this, "No command selected !", "MultiServerCommand.sendCmdBtnActionPerformed()");
            return;
        }
        if (command.toLowerCase().equals("uptime")) {
            this.displayServerUpTimes(selections);
        } else if (command.toLowerCase().equals("status")) {
            this.displayServerStatus(selections);
        } else {
            this.starterCommandForServers(command, selections);
        }
    }

    public static void displayError(Component component, String desc, String orig) {
        try {
            Except.throw_exception((String)"ERROR", (String)desc, (String)orig);
        }
        catch (DevFailed e) {
            ErrorPane.showErrorMessage((Component)component, (String)"", (DevFailed)e);
        }
    }

    public static void main(String[] args) {
        try {
            MultiServerCommand msc = new MultiServerCommand(new JFrame());
            msc.setVisible(true);
        }
        catch (DevFailed e) {
            ErrorPane.showErrorMessage((Component)new JFrame(), (String)"", (DevFailed)e);
        }
    }

    private static String getHostnameWithoutFQDN(String hostname) {
        int pos = hostname.indexOf(46);
        if (pos < 0) {
            return hostname;
        }
        return hostname.substring(0, pos);
    }

    private DeviceProxy getStarterInstanceForServer(String serverName) throws DevFailed {
        String devName = "dserver/" + serverName;
        DeviceProxy dev = new DeviceProxy(devName);
        DeviceInfo info = dev.get_info();
        String hostname = MultiServerCommand.getHostnameWithoutFQDN(info.hostname);
        String starterDeviceName = AstorUtil.getStarterDeviceHeader() + hostname;
        return new DeviceProxy(starterDeviceName);
    }

    private long getDelayBetweenServers(String message, long defaultValue) {
        long t = -1L;
        while (t < 0L) {
            String strVal = (String)JOptionPane.showInputDialog(this, message + "\nDelay between servers (ms) ?", "Input Dialog", 1, null, null, defaultValue);
            if (strVal == null) {
                return -1L;
            }
            try {
                t = Long.parseLong(strVal);
            }
            catch (NumberFormatException e) {
                ErrorPane.showErrorMessage((Component)this, null, (Exception)e);
            }
        }
        if (t == 0L) {
            t = 10L;
        }
        return t;
    }

    private void displayServerUpTimes(List<String> serverNames) {
        ArrayList<String[]> lines = new ArrayList<String[]>();
        try {
            for (String serverName : serverNames) {
                String[] exportedStr = new TangoServer("dserver/" + serverName).getServerUptime();
                lines.add(new String[]{serverName, exportedStr[0], exportedStr[1]});
            }
            String[] columns = new String[]{"Server", "Last   exported", "Last unexported"};
            PopupTable ppt = new PopupTable((JDialog)this, "", columns, lines, new Dimension(650, 250));
            ppt.setVisible(true);
        }
        catch (DevFailed e) {
            ErrorPane.showErrorMessage((Component)this, null, (DevFailed)e);
        }
    }

    private static String convertStatus(String status) {
        switch (status) {
            case "ON": {
                return "Running";
            }
            case "FAULT": {
                return "Stopped";
            }
            case "MOVING": {
                return "Running but NOT responding";
            }
        }
        return status;
    }

    private void displayServerStatus(List<String> serverNames) {
        ArrayList<String[]> statusList = new ArrayList<String[]>();
        for (String serverName : serverNames) {
            try {
                String[] serverStates;
                DeviceProxy starter = this.getStarterInstanceForServer(serverName);
                DeviceAttribute argout = starter.read_attribute("Servers");
                for (String line : serverStates = argout.extractStringArray()) {
                    StringTokenizer stk = new StringTokenizer(line);
                    String server = stk.nextToken();
                    String status = MultiServerCommand.convertStatus(stk.nextToken());
                    if (!server.toLowerCase().equals(serverName.toLowerCase())) continue;
                    statusList.add(new String[]{server, status});
                }
            }
            catch (DevFailed e) {
                statusList.add(new String[]{serverName, e.errors[0].desc});
            }
        }
        if (statusList.size() == 0) {
            System.err.println("No data found !");
            return;
        }
        String[] columns = new String[]{"Servers", "Status"};
        try {
            PopupTable ppt = new PopupTable((JDialog)this, "", columns, statusList, new Dimension(650, 250));
            ppt.setVisible(true);
        }
        catch (DevFailed e) {
            ErrorPane.showErrorMessage((Component)this, null, (DevFailed)e);
        }
    }

    private void starterCommandForServers(String command, List<String> servNames) {
        if (command.equals("Start")) {
            command = "DevStart";
        } else if (command.equals("Stop")) {
            command = "DevStop";
        }
        long tmpDelay = this.getDelayBetweenServers("Send " + command + "  on all selected servers:", this.delayBetweenServers);
        if (tmpDelay > 0L) {
            this.delayBetweenServers = tmpDelay;
            new CommandThread(this, command, servNames, this.delayBetweenServers).start();
        }
    }

    private class CommandThread
    extends Thread {
        private Component component;
        private String command;
        private List<String> servNames;
        private long delay;

        private CommandThread(Component component, String command, List<String> servNames, long delay) {
            this.component = component;
            this.command = command;
            this.servNames = servNames;
            this.delay = delay;
        }

        @Override
        public void run() {
            this.component.setCursor(new Cursor(3));
            StringBuilder sb = new StringBuilder();
            for (String servName : this.servNames) {
                try {
                    DeviceProxy starter = MultiServerCommand.this.getStarterInstanceForServer(servName);
                    DeviceData argin = new DeviceData();
                    argin.insert(servName);
                    starter.command_inout(this.command, argin);
                    Thread.sleep(this.delay);
                }
                catch (DevFailed e) {
                    sb.append(e.errors[0].desc).append(" for ").append(servName).append('\n');
                }
                catch (InterruptedException e) {
                    sb.append(e).append(" for ").append(servName).append('\n');
                }
            }
            this.component.setCursor(new Cursor(0));
            if (sb.length() > 0) {
                MultiServerCommand.displayError(this.component, sb.toString(), "MultiServerCommand.starterCommandForServers()");
            }
        }
    }
}

