/*
 * Decompiled with CFR 0.152.
 */
package admin.astor;

import admin.astor.AstorDefs;
import admin.astor.AstorUtil;
import admin.astor.HostInfoDialog;
import admin.astor.PutServerInfoDialog;
import admin.astor.ServerPopupMenu;
import admin.astor.TangoHost;
import admin.astor.TangoServer;
import admin.astor.tools.PopupTable;
import fr.esrf.Tango.DevFailed;
import fr.esrf.Tango.DevState;
import fr.esrf.TangoApi.DbServInfo;
import fr.esrf.TangoApi.DbServer;
import fr.esrf.tangoatk.widget.util.ErrorPane;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import javax.swing.ImageIcon;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JTree;
import javax.swing.ToolTipManager;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeExpansionListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreePath;

class LevelTree
extends JTree
implements AstorDefs {
    private HostInfoDialog parent;
    private DefaultTreeModel treeModel;
    private ServerPopupMenu serverMenu;
    private ServerPopupMenu levelMenu;
    private TangoHost host;
    private Color bg;
    private Level level;
    private DefaultMutableTreeNode root;

    LevelTree(JFrame jFrame, HostInfoDialog parent, TangoHost host, int level_row) {
        this.parent = parent;
        this.host = host;
        this.bg = parent.getBackgroundColor();
        this.setBackground(this.bg);
        this.serverMenu = new ServerPopupMenu(jFrame, parent, host, 0);
        this.levelMenu = new ServerPopupMenu(jFrame, parent, host, 1);
        this.level = new Level(level_row);
        this.initComponent();
        this.manageVisibility();
    }

    boolean hasRunningServer() {
        return this.level.hasRunningServer();
    }

    DevState getState() {
        return this.level.getState();
    }

    int getNbServers() {
        return this.level.size();
    }

    private void manageVisibility() {
        this.setVisible(this.level.size() > 0);
    }

    TangoServer getServer(String servname) {
        return this.level.getServer(servname);
    }

    int getLevelRow() {
        return this.level.row;
    }

    private void initComponent() {
        this.root = new DefaultMutableTreeNode(this.level);
        for (TangoServer server : this.level) {
            this.root.add(new DefaultMutableTreeNode(server));
        }
        this.getSelectionModel().setSelectionMode(1);
        this.treeModel = new DefaultTreeModel(this.root);
        this.setModel(this.treeModel);
        ToolTipManager.sharedInstance().registerComponent(this);
        this.setCellRenderer(new TangoRenderer());
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                LevelTree.this.treeMouseClicked(evt);
            }
        });
        this.addTreeExpansionListener(new TreeExpansionListener(){

            @Override
            public void treeCollapsed(TreeExpansionEvent evt) {
                LevelTree.this.parent.packTheDialog();
            }

            @Override
            public void treeExpanded(TreeExpansionEvent evt) {
                LevelTree.this.parent.packTheDialog();
            }
        });
        this.addTreeSelectionListener(new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent evt) {
                LevelTree.this.selectionChanged(evt);
            }
        });
        if (this.level.row == 0) {
            this.collapseTree();
        }
    }

    private void selectionChanged(TreeSelectionEvent evt) {
    }

    void checkUpdate() {
        this.level.updateServerList();
        this.manageVisibility();
        for (int i = 0; i < this.level.size(); ++i) {
            TangoServer server = (TangoServer)this.level.get(i);
            DefaultMutableTreeNode node = this.root;
            int nb = this.root.getChildCount();
            boolean found = false;
            for (int j = 0; !found && j < nb; ++j) {
                TangoServer ts = (TangoServer)(node = node.getNextNode()).getUserObject();
                found = ts == server;
            }
            if (found) continue;
            node = new DefaultMutableTreeNode(server);
            this.treeModel.insertNodeInto(node, this.root, i);
            this.setSelectionPath(new TreePath(node.getPath()));
            this.expandRow(i);
        }
        for (int i = 0; i < this.root.getChildCount(); ++i) {
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)this.root.getChildAt(i);
            TangoServer server = (TangoServer)node.getUserObject();
            boolean found = false;
            for (int j = 0; !found && j < this.level.size(); ++j) {
                found = server == this.level.get(j);
            }
            if (found) continue;
            this.treeModel.removeNodeFromParent(node);
            --i;
        }
    }

    void changeChangeLevel(int level) {
        try {
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)this.root.getChildAt(0);
            TangoServer server = (TangoServer)node.getUserObject();
            DbServer s1 = new DbServer(server.getName());
            DbServInfo info = s1.get_info();
            PutServerInfoDialog dialog = new PutServerInfoDialog(this.parent, true);
            dialog.setLocation(this.getLocationOnScreen());
            String hostname = info.host;
            if (dialog.showDialog(info, level) == 0) {
                System.out.println("Do it !");
                info = dialog.getSelection();
                if (info != null) {
                    info.host = hostname;
                    for (int i = 0; i < this.root.getChildCount(); ++i) {
                        node = (DefaultMutableTreeNode)this.root.getChildAt(i);
                        server = (TangoServer)node.getUserObject();
                        info.name = server.getName();
                        server.putStartupInfo(info);
                        try {
                            Thread.sleep(20L);
                            continue;
                        }
                        catch (Exception e) {
                            // empty catch block
                        }
                    }
                    this.parent.updateData();
                }
            }
        }
        catch (DevFailed e) {
            ErrorPane.showErrorMessage((Component)this, null, (DevFailed)e);
        }
    }

    void changeServerLevels() {
        ArrayList<TangoServer> servers = new ArrayList<TangoServer>();
        for (int i = 0; i < this.root.getChildCount(); ++i) {
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)this.root.getChildAt(i);
            servers.add((TangoServer)node.getUserObject());
        }
        for (TangoServer server : servers) {
            server.startupLevel(this.parent, this.host.getName(), this.getLocationOnScreen());
        }
        this.parent.updateData();
    }

    void resetSelection() {
        this.manageVisibility();
        this.setSelectionPath(new TreePath(this.root.getPath()));
    }

    void setSelection(TangoServer server) {
        this.manageVisibility();
        for (int i = 0; i < this.root.getChildCount(); ++i) {
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)this.root.getChildAt(i);
            TangoServer ts = (TangoServer)node.getUserObject();
            if (ts != server) continue;
            this.setSelectionPath(new TreePath(node.getPath()));
        }
    }

    void expandTree() {
        this.expandRow(0);
    }

    void collapseTree() {
        this.collapseRow(0);
    }

    void toggleExpandCollapse() {
        if (this.isExpanded(0)) {
            this.collapseTree();
        } else {
            this.expandTree();
        }
    }

    void displayUptime() {
        ArrayList<String[]> v = new ArrayList<String[]>();
        try {
            for (int i = 0; i < this.root.getChildCount(); ++i) {
                DefaultMutableTreeNode node = (DefaultMutableTreeNode)this.root.getChildAt(i);
                TangoServer server = (TangoServer)node.getUserObject();
                String[] exportedStr = server.getServerUptime();
                v.add(new String[]{server.getName(), exportedStr[0], exportedStr[1]});
            }
            String[] columns = new String[]{"Server", "Last   exported", "Last unexported"};
            String[][] table = new String[v.size()][];
            for (int i = 0; i < v.size(); ++i) {
                table[i] = (String[])v.get(i);
            }
            PopupTable ppt = new PopupTable((JDialog)this.parent, this.level.toString(), columns, table, new Dimension(650, 250));
            ppt.setVisible(true);
        }
        catch (DevFailed e) {
            ErrorPane.showErrorMessage((Component)this.parent, null, (DevFailed)e);
        }
    }

    private void treeMouseClicked(MouseEvent evt) {
        if (this.getRowForLocation(evt.getX(), evt.getY()) < 0) {
            return;
        }
        TreePath selectedPath = this.getPathForLocation(evt.getX(), evt.getY());
        if (selectedPath == null) {
            return;
        }
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)selectedPath.getPathComponent(selectedPath.getPathCount() - 1);
        Object uo = node.getUserObject();
        int mask = evt.getModifiers();
        this.parent.fireNewTreeSelection(this);
        if ((mask & 4) != 0) {
            if (uo instanceof TangoServer) {
                this.serverMenu.showMenu(evt, (JTree)this, (TangoServer)uo);
            } else {
                this.levelMenu.showMenu(evt, this, this.isExpanded(0));
            }
        }
    }

    @Override
    public String toString() {
        return this.level.toString();
    }

    private class TangoRenderer
    extends DefaultTreeCellRenderer {
        private Font[] fonts = new Font[3];

        public TangoRenderer() {
            this.fonts[0] = new Font("Dialog", 1, 16);
            this.fonts[1] = new Font("Dialog", 0, 12);
        }

        @Override
        public Component getTreeCellRendererComponent(JTree tree, Object obj, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            super.getTreeCellRendererComponent(tree, obj, sel, expanded, leaf, row, hasFocus);
            this.setBackgroundNonSelectionColor(LevelTree.this.bg);
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)obj;
            Object uo = node.getUserObject();
            this.setFont(this.fonts[node.getLevel()]);
            if (row == 0) {
                this.setIcon(this.getStateIcon(LevelTree.this.level.getState()));
                this.setBackgroundSelectionColor(LevelTree.this.bg);
            } else if (uo instanceof TangoServer) {
                TangoServer server = (TangoServer)uo;
                this.setIcon(this.getStateIcon(server.getState()));
                this.setBackgroundSelectionColor(Color.lightGray);
            }
            return this;
        }

        private ImageIcon getStateIcon(DevState state) {
            int idx = state == DevState.MOVING ? 5 : (state == DevState.ON ? 4 : (state == DevState.ALARM ? 2 : 1));
            return AstorUtil.state_icons[idx];
        }
    }

    private class Level
    extends ArrayList<TangoServer> {
        public int row;

        public Level(int row) {
            this.row = row;
            this.updateServerList();
        }

        private void updateServerList() {
            this.clear();
            for (int i = 0; i < LevelTree.this.host.nbServers(); ++i) {
                try {
                    TangoServer server = LevelTree.this.host.getServer(i);
                    if (server.startup_level != this.row) continue;
                    this.add(server);
                    continue;
                }
                catch (NullPointerException e) {
                    ErrorPane.showErrorMessage((Component)LevelTree.this.parent, null, (Exception)e);
                }
            }
            AstorUtil.getInstance().sortTangoServer(this);
        }

        TangoServer getServer(String servname) {
            for (TangoServer server : this) {
                if (!server.getName().equals(servname)) continue;
                return server;
            }
            return null;
        }

        boolean hasRunningServer() {
            for (TangoServer server : this) {
                if (server.getState() != DevState.ON) continue;
                return true;
            }
            return false;
        }

        DevState getState() {
            boolean is_faulty = false;
            boolean is_alarm = false;
            boolean is_moving = false;
            for (TangoServer server : this) {
                if (server.getState() == DevState.UNKNOWN) {
                    return DevState.UNKNOWN;
                }
                if (server.getState() == DevState.FAULT) {
                    is_faulty = true;
                    continue;
                }
                if (server.getState() == DevState.ALARM) {
                    is_alarm = true;
                    continue;
                }
                if (server.getState() != DevState.MOVING) continue;
                is_moving = true;
            }
            if (is_faulty) {
                return DevState.FAULT;
            }
            if (is_moving) {
                return DevState.MOVING;
            }
            if (is_alarm) {
                return DevState.ALARM;
            }
            return DevState.ON;
        }

        @Override
        public String toString() {
            String str = this.row != 0 ? "Level " + this.row : "Not Controlled";
            return str;
        }
    }
}

