/*
 * Decompiled with CFR 0.152.
 */
package admin.astor;

import admin.astor.Astor;
import admin.astor.AstorDefs;
import admin.astor.AstorUtil;
import admin.astor.LevelTree;
import admin.astor.ListDialog;
import admin.astor.ServerCmdThread;
import admin.astor.ServerPopupMenu;
import admin.astor.TangoHost;
import admin.astor.TangoServer;
import fr.esrf.Tango.DevFailed;
import fr.esrf.Tango.DevState;
import fr.esrf.TangoApi.ApiUtil;
import fr.esrf.TangoApi.DeviceAttribute;
import fr.esrf.TangoApi.DeviceProxy;
import fr.esrf.TangoApi.events.ITangoChangeListener;
import fr.esrf.TangoApi.events.TangoChange;
import fr.esrf.TangoApi.events.TangoChangeEvent;
import fr.esrf.TangoApi.events.TangoEventsAdapter;
import fr.esrf.TangoDs.Except;
import fr.esrf.TangoDs.TangoConst;
import fr.esrf.tangoatk.widget.util.ATKConstant;
import fr.esrf.tangoatk.widget.util.ATKGraphicsUtils;
import fr.esrf.tangoatk.widget.util.ErrorPane;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;

public class HostInfoDialog
extends JDialog
implements AstorDefs,
TangoConst {
    public TangoHost host;
    public String name;
    private JFrame jFrame;
    private Color bg = null;
    private String attribute = "Servers";
    private static final int NO_CHANGE = 0;
    private static final int LIST_CHANGED = 1;
    private static final int STATE_CHANGED = 2;
    private static Dimension preferredSize;
    private JScrollPane scrollPane = null;
    private LevelTree[] trees = null;
    private JPanel levelsPanel = null;
    private JPanel[] treePanels;
    private JPanel notifdPanel;
    private JLabel notifdLabel;
    private ServerPopupMenu notifdMenu;
    private boolean standAlone = false;
    private UpdateThread updateThread;
    private JPanel centerPanel;
    private JRadioButton displayAllBtn;
    private JButton startAllBtn;
    private JButton startNewBtn;
    private JButton stopAllBtn;
    private JLabel titleLabel;
    private JPanel titlePanel;

    public HostInfoDialog(JFrame parent, String hostName, boolean standAlone) throws DevFailed {
        this(parent, new TangoHost(hostName, true));
        this.standAlone = standAlone;
        AstorUtil.getInstance().initIcons();
    }

    public HostInfoDialog(JFrame jFrame, TangoHost host) {
        super((Frame)jFrame, false);
        this.jFrame = jFrame;
        this.host = host;
        this.name = host.getName();
        this.initComponents();
        this.setTitle((Object)((Object)host) + "  Control");
        this.displayAllBtn.setSelected(true);
        preferredSize = AstorUtil.getHostDialogPreferredSize();
        this.scrollPane = new JScrollPane();
        this.updateThread = new UpdateThread();
        this.updateThread.start();
        this.bg = this.titlePanel.getBackground();
        this.titleLabel.setText("Controlled Servers on " + this.name);
        this.notifdMenu = new ServerPopupMenu(jFrame, this, host, 2);
        if (Astor.rwMode == 2) {
            this.startNewBtn.setVisible(false);
            this.startAllBtn.setVisible(false);
            this.stopAllBtn.setVisible(false);
        }
        this.pack();
        ATKGraphicsUtils.centerDialog((Dialog)this);
    }

    public Astor getAstorObject() {
        if (this.jFrame instanceof Astor) {
            return (Astor)this.jFrame;
        }
        return null;
    }

    public void displayHostInfoDialog(String hostname) {
        if (this.jFrame instanceof Astor) {
            ((Astor)this.jFrame).tree.displayHostInfoDialog(hostname);
        }
    }

    void setDialogPreferredSize(Dimension d) {
        preferredSize = d;
        this.packTheDialog();
    }

    void updatePanel(final boolean resizePanel) {
        int i;
        if (this.trees == null) {
            int nbLevels = AstorUtil.getStarterNbStartupLevels();
            ++nbLevels;
            this.levelsPanel = new JPanel();
            this.levelsPanel.setLayout(new GridBagLayout());
            this.centerPanel.add((Component)this.levelsPanel, "Center");
            if (this.host.manageNotifd) {
                this.notifdPanel = new JPanel();
                this.notifdLabel = new JLabel("Event Notify Daemon");
                this.notifdLabel.setFont(new Font("Dialog", 1, 12));
                GridBagConstraints gbc = new GridBagConstraints();
                gbc.gridx = 0;
                gbc.gridy = 0;
                gbc.gridwidth = nbLevels;
                gbc.fill = 2;
                this.notifdPanel.add((Component)this.notifdLabel, gbc);
                this.levelsPanel.add((Component)this.notifdPanel, gbc);
                this.notifdLabel.addMouseListener(new MouseAdapter(){

                    @Override
                    public void mouseClicked(MouseEvent evt) {
                        HostInfoDialog.this.serverBtnMouseClicked(evt);
                    }
                });
            }
            this.treePanels = new JPanel[nbLevels];
            this.trees = new LevelTree[nbLevels];
            for (i = 0; i < nbLevels; ++i) {
                this.trees[i] = new LevelTree(this.jFrame, this, this.host, i);
                this.treePanels[i] = new JPanel();
                this.treePanels[i].add(this.trees[i]);
            }
        } else {
            for (LevelTree tree : this.trees) {
                tree.checkUpdate();
            }
        }
        int nb = 0;
        for (i = 1; i < this.trees.length; ++i) {
            nb += this.trees[i].getNbServers();
        }
        this.titleLabel.setText("" + nb + " Controlled Servers on " + this.name);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                HostInfoDialog.this.checkActiveLevels();
                HostInfoDialog.this.updateHostState();
                if (resizePanel) {
                    HostInfoDialog.this.packTheDialog();
                }
            }
        });
    }

    void packTheDialog() {
        if (!this.isVisible()) {
            return;
        }
        Point p = this.getLocation();
        this.pack();
        int width = this.levelsPanel.getWidth();
        int height = this.levelsPanel.getHeight();
        if (width > HostInfoDialog.preferredSize.width || height > HostInfoDialog.preferredSize.height) {
            int bw = 20;
            this.centerPanel.remove(this.levelsPanel);
            Dimension d = new Dimension(preferredSize);
            if (width < HostInfoDialog.preferredSize.width - bw) {
                d.width = width + bw;
            }
            if (height < HostInfoDialog.preferredSize.height - bw) {
                d.height = height + bw;
            }
            this.scrollPane.setPreferredSize(d);
            this.scrollPane.add(this.levelsPanel);
            this.scrollPane.setViewportView(this.levelsPanel);
            this.centerPanel.add((Component)this.scrollPane, "Center");
        } else {
            this.centerPanel.remove(this.scrollPane);
            this.scrollPane.remove(this.levelsPanel);
            this.centerPanel.add((Component)this.levelsPanel, "Center");
        }
        this.pack();
        this.setLocation(p);
    }

    private void checkActiveLevels() {
        this.levelsPanel.removeAll();
        ArrayList<JPanel> v = new ArrayList<JPanel>();
        for (int i = 1; i < this.trees.length; ++i) {
            if (this.trees[i].getNbServers() <= 0) continue;
            v.add(this.treePanels[i]);
        }
        if (this.trees[0].getNbServers() > 0) {
            v.add(this.treePanels[0]);
        }
        int x = 0;
        int y = 1;
        int x_size = v.size() / 2 - 1;
        if (x_size < 2) {
            x_size = 2;
        }
        for (int i = 0; i < v.size(); ++i) {
            JPanel panel = (JPanel)v.get(i);
            GridBagConstraints gbc = new GridBagConstraints();
            gbc.gridx = x++;
            gbc.gridy = y;
            gbc.insets = new Insets(5, 10, 0, 0);
            gbc.fill = 2;
            gbc.fill = 3;
            gbc.anchor = 17;
            this.levelsPanel.add((Component)panel, gbc);
            if (i != x_size) continue;
            x = 0;
            y += 2;
        }
        if (this.host.manageNotifd) {
            GridBagConstraints gbc = new GridBagConstraints();
            gbc.gridx = 0;
            gbc.gridy = 0;
            gbc.gridwidth = x_size + 1;
            gbc.fill = 2;
            this.levelsPanel.add((Component)this.notifdPanel, gbc);
        }
    }

    Color getBackgroundColor() {
        return this.startNewBtn.getBackground();
    }

    void updateHostState() {
        if (this.host.state == 5) {
            String str_state = ApiUtil.stateName((DevState)DevState.MOVING);
            this.titlePanel.setBackground(ATKConstant.getColor4State((String)str_state));
        } else if (this.host.state == 2) {
            String str_state = ApiUtil.stateName((DevState)DevState.ALARM);
            this.titlePanel.setBackground(ATKConstant.getColor4State((String)str_state));
        } else {
            this.titlePanel.setBackground(this.bg);
        }
        if (this.host.manageNotifd && this.notifdLabel != null) {
            this.notifdLabel.setIcon(AstorUtil.state_icons[this.host.notifydState]);
        }
    }

    private void initComponents() {
        JPanel topPanel = new JPanel();
        this.startNewBtn = new JButton();
        this.startAllBtn = new JButton();
        this.stopAllBtn = new JButton();
        this.displayAllBtn = new JRadioButton();
        this.centerPanel = new JPanel();
        this.titlePanel = new JPanel();
        this.titleLabel = new JLabel();
        JPanel bottomPanel = new JPanel();
        JButton cancelBtn = new JButton();
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                HostInfoDialog.this.closeDialog(evt);
            }
        });
        this.startNewBtn.setText("Start New");
        this.startNewBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                HostInfoDialog.this.startNewBtnActionPerformed(evt);
            }
        });
        topPanel.add(this.startNewBtn);
        this.startAllBtn.setText("Start All");
        this.startAllBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                HostInfoDialog.this.startAllBtnActionPerformed(evt);
            }
        });
        topPanel.add(this.startAllBtn);
        this.stopAllBtn.setText("Stop All");
        this.stopAllBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                HostInfoDialog.this.stopAllBtnActionPerformed(evt);
            }
        });
        topPanel.add(this.stopAllBtn);
        this.displayAllBtn.setText("Display All");
        this.displayAllBtn.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.displayAllBtn.setMargin(new Insets(0, 0, 0, 0));
        this.displayAllBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                HostInfoDialog.this.displayAllBtnActionPerformed(evt);
            }
        });
        topPanel.add(this.displayAllBtn);
        this.getContentPane().add((Component)topPanel, "North");
        this.centerPanel.setLayout(new BorderLayout());
        this.titleLabel.setFont(new Font("Dialog", 1, 18));
        this.titleLabel.setText("Dialog Title");
        this.titlePanel.add(this.titleLabel);
        this.centerPanel.add((Component)this.titlePanel, "North");
        this.getContentPane().add((Component)this.centerPanel, "Center");
        cancelBtn.setText("Dismiss");
        cancelBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                HostInfoDialog.this.cancelBtnActionPerformed(evt);
            }
        });
        bottomPanel.add(cancelBtn);
        this.getContentPane().add((Component)bottomPanel, "South");
        this.pack();
    }

    private void serverBtnMouseClicked(MouseEvent evt) {
        this.notifdMenu.showMenu(evt);
    }

    private void displayAllBtnActionPerformed(ActionEvent evt) {
        boolean b;
        boolean bl = b = this.displayAllBtn.getSelectedObjects() != null;
        if (this.trees != null) {
            for (LevelTree tree : this.trees) {
                if (b) {
                    if (tree.getLevelRow() == 0) continue;
                    tree.expandTree();
                    continue;
                }
                tree.collapseTree();
            }
        }
    }

    private void stopAllBtnActionPerformed(ActionEvent evt) {
        ArrayList<Integer> used = new ArrayList<Integer>();
        for (int i = this.trees.length - 1; i >= 0; --i) {
            int level = this.trees[i].getLevelRow();
            if (level == 0) continue;
            if (this.trees[i].getNbServers() > 0 && this.trees[i].hasRunningServer()) {
                used.add(level);
                continue;
            }
            try {
                this.host.stopServers(level);
                continue;
            }
            catch (DevFailed e) {
                // empty catch block
            }
        }
        new ServerCmdThread(this, this.host, 1, used).start();
    }

    private void startAllBtnActionPerformed(ActionEvent evt) {
        ArrayList<Integer> used = new ArrayList<Integer>();
        for (LevelTree tree : this.trees) {
            int level = tree.getLevelRow();
            if (level == 0 || tree.getNbServers() <= 0 || tree.getState() == DevState.ON) continue;
            used.add(level);
        }
        new ServerCmdThread(this, this.host, 0, used).start();
    }

    private void startNewBtnActionPerformed(ActionEvent evt) {
        ListDialog jlist = new ListDialog(this);
        Point p = this.getLocationOnScreen();
        p.translate(50, 50);
        jlist.setLocation(p);
        jlist.showDialog();
        List<String> serverNames = jlist.getSelectedItems();
        if (serverNames == null) {
            return;
        }
        for (String serverName : serverNames) {
            if (serverName == null) continue;
            try {
                this.host.registerServer(serverName);
                this.host.startOneServer(serverName);
                TangoServer ts = new TangoServer(serverName, DevState.OFF);
                ts.startupLevel(this, this.host.getName(), p);
            }
            catch (DevFailed e) {
                ErrorPane.showErrorMessage((Component)this.jFrame, null, (DevFailed)e);
            }
        }
        this.host.updateServersList(this.jFrame);
        try {
            DeviceAttribute attribute = this.host.read_attribute("Servers");
            this.manageServersAttribute(attribute);
        }
        catch (DevFailed e) {
            // empty catch block
        }
    }

    private void cancelBtnActionPerformed(ActionEvent evt) {
        this.doClose();
    }

    private void closeDialog(WindowEvent evt) {
        this.doClose();
    }

    void doClose() {
        if (this.jFrame instanceof Astor || !this.standAlone) {
            this.setVisible(false);
            this.dispose();
        } else {
            this.updateThread.stopThread();
            System.exit(0);
        }
    }

    void fireNewTreeSelection(LevelTree tree) {
        for (LevelTree tree1 : this.trees) {
            if (tree1 == tree) continue;
            tree1.clearSelection();
        }
    }

    void stopLevel(int level) {
        ArrayList<Integer> levels = new ArrayList<Integer>();
        levels.add(level);
        new ServerCmdThread(this, this.host, 1, levels).start();
    }

    void startLevel(int level) {
        ArrayList<Integer> levels = new ArrayList<Integer>();
        levels.add(level);
        new ServerCmdThread(this, this.host, 0, levels, false).start();
    }

    private void manageServersAttribute(DeviceAttribute att) {
        ArrayList<Server> servers = new ArrayList<Server>();
        try {
            if (!att.hasFailed()) {
                String[] lines;
                for (String line : lines = att.extractStringArray()) {
                    Server server = new Server(line);
                    servers.add(server);
                }
            }
        }
        catch (DevFailed e) {
            System.err.println(this.name);
            Except.print_exception((Exception)((Object)e));
        }
        switch (this.updateHost(servers)) {
            case 2: {
                this.updatePanel(false);
                break;
            }
            case 1: {
                this.updatePanel(true);
                break;
            }
            case 0: {
                return;
            }
        }
        for (LevelTree tree : this.trees) {
            tree.repaint();
        }
    }

    private int updateHost(List<Server> newServers) {
        boolean state_changed = false;
        boolean list_changed = false;
        for (Server newServer : newServers) {
            TangoServer server = this.host.getServer(newServer.name);
            if (server == null) {
                try {
                    server = new TangoServer(newServer.name, newServer.state);
                }
                catch (DevFailed e) {
                    System.err.println(this.name);
                    Except.print_exception((Exception)((Object)e));
                }
                this.host.addServer(server);
                list_changed = true;
            }
            if (server == null) continue;
            if (newServer.state != server.getState()) {
                server.setState(newServer.state);
                state_changed = true;
            }
            if (!(newServer.controlled != server.controlled | newServer.level != server.startup_level)) continue;
            server.controlled = newServer.controlled;
            server.startup_level = newServer.level;
            list_changed = true;
        }
        for (int i = 0; i < this.host.nbServers(); ++i) {
            TangoServer server = this.host.getServer(i);
            boolean found = false;
            for (int j = 0; !found && j < newServers.size(); ++j) {
                Server newServer = newServers.get(j);
                found = newServer.name.equals(server.getName());
            }
            if (found) continue;
            this.host.removeServer(server.getName());
            list_changed = true;
        }
        if (list_changed) {
            return 1;
        }
        if (state_changed) {
            return 2;
        }
        return 0;
    }

    private DevState string2state(String str) {
        for (int i = 0; i < Tango_DevStateName.length; ++i) {
            if (!str.equals(Tango_DevStateName[i])) continue;
            return DevState.from_int((int)i);
        }
        return DevState.UNKNOWN;
    }

    void setSelection(String serverName) {
        if (this.trees != null) {
            for (LevelTree tree : this.trees) {
                TangoServer server = tree.getServer(serverName);
                if (server != null) {
                    tree.expandTree();
                    tree.setSelection(server);
                    continue;
                }
                tree.resetSelection();
            }
        }
    }

    void updateData() {
        this.updatePanel(true);
    }

    public static void main(String[] args) {
        try {
            String hostname;
            if (args.length > 0) {
                hostname = args[0];
            } else {
                hostname = (String)JOptionPane.showInputDialog(new JFrame(), "Host Name ?", "Input Dialog", 1, null, null, "");
                if (hostname == null) {
                    System.exit(0);
                }
            }
            new HostInfoDialog(new JFrame(), hostname, true).setVisible(true);
        }
        catch (DevFailed e) {
            ErrorPane.showErrorMessage((Component)new JFrame(), null, (DevFailed)e);
        }
    }

    private void subscribeChangeEvent() {
        try {
            if (this.host.supplier == null) {
                this.host.supplier = new TangoEventsAdapter((DeviceProxy)this.host);
            }
        }
        catch (DevFailed e) {
            this.host.onEvents = false;
            System.err.println("subscribeChangeServerEvent() for " + this.host.get_name() + " FAILED !");
            Except.print_exception((Exception)((Object)e));
            return;
        }
        catch (Exception e) {
            this.host.onEvents = false;
            System.err.println("subscribeChangeServerEvent() for " + this.host.get_name() + " FAILED !");
            System.err.println(e.toString());
            return;
        }
        try {
            ServerEventListener serverListener = new ServerEventListener();
            this.host.supplier.addTangoChangeListener((ITangoChangeListener)serverListener, this.attribute, false);
            System.out.println("subscribeChangeServerEvent() for " + this.host.get_name() + "/" + this.attribute + " OK!");
        }
        catch (DevFailed e) {
            this.host.onEvents = false;
            System.err.println("subscribeChangeServerEvent() for " + this.host.get_name() + " FAILED !");
            Except.print_exception((Exception)((Object)e));
        }
        catch (Exception e) {
            this.host.onEvents = false;
            System.err.println("subscribeChangeServerEvent() for " + this.host.get_name() + " FAILED !");
            System.err.println(e.toString());
        }
    }

    private class ServerEventListener
    implements ITangoChangeListener {
        private ServerEventListener() {
        }

        public void change(TangoChangeEvent event) {
            TangoChange tc = (TangoChange)event.getSource();
            String deviceName = tc.getEventSupplier().get_name();
            try {
                DeviceAttribute att = event.getValue();
                HostInfoDialog.this.manageServersAttribute(att);
            }
            catch (DevFailed e) {
                System.out.println(HostInfoDialog.this.name);
                if (e.errors[0].reason.equals("API_EventTimeout")) {
                    System.err.println("HostStataThread.ServerEventListener" + deviceName + " : API_EventTimeout");
                } else {
                    Except.print_exception((Exception)((Object)e));
                }
            }
            catch (Exception e) {
                System.err.println(HostInfoDialog.this.name);
                System.err.println("AstorEvent." + deviceName);
                System.err.println(e.toString());
                System.err.println("HostStateThread.ServerEventListener : could not extract data!");
            }
        }
    }

    private class UpdateThread
    extends Thread {
        private int readInfoPeriod = 1000;
        private boolean stopIt = false;

        private UpdateThread() {
        }

        private synchronized void stopThread() {
            this.stopIt = true;
            this.notify();
        }

        @Override
        public void run() {
            if (HostInfoDialog.this.host.onEvents) {
                HostInfoDialog.this.subscribeChangeEvent();
            }
            while (!this.stopIt) {
                long t0 = System.currentTimeMillis();
                this.waitNextLoop(t0);
                if (this.stopIt) continue;
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        if (!HostInfoDialog.this.host.onEvents) {
                            UpdateThread.this.manageSynchronous();
                        }
                        if (!(HostInfoDialog.this.jFrame instanceof Astor)) {
                            UpdateThread.this.manageNotifd();
                            HostInfoDialog.this.updateHostState();
                        }
                    }
                });
            }
        }

        private void manageNotifd() {
            try {
                DeviceAttribute deviceAttribute = HostInfoDialog.this.host.read_attribute("NotifdState");
                DevState devState = deviceAttribute.extractDevState();
                if (devState == DevState.ON) {
                    HostInfoDialog.this.host.notifydState = 4;
                } else if (devState == DevState.FAULT) {
                    HostInfoDialog.this.host.notifydState = 1;
                }
            }
            catch (DevFailed e) {
                HostInfoDialog.this.host.notifydState = 0;
            }
        }

        private synchronized void waitNextLoop(long t0) {
            try {
                long t1 = System.currentTimeMillis();
                long time_to_sleep = (long)this.readInfoPeriod - (t1 - t0);
                if (time_to_sleep <= 0L) {
                    time_to_sleep = 100L;
                }
                this.wait(time_to_sleep);
            }
            catch (InterruptedException e) {
                System.out.println(e.toString());
            }
        }

        private void manageSynchronous() {
            try {
                DeviceAttribute att = HostInfoDialog.this.host.read_attribute(HostInfoDialog.this.attribute);
                HostInfoDialog.this.manageServersAttribute(att);
            }
            catch (DevFailed devFailed) {
                // empty catch block
            }
        }
    }

    class Server {
        String name;
        DevState state;
        boolean controlled = false;
        int level = 0;

        public Server(String line) {
            StringTokenizer stk = new StringTokenizer(line);
            ArrayList<String> items = new ArrayList<String>();
            while (stk.hasMoreTokens()) {
                items.add(stk.nextToken());
            }
            if (items.size() > 0) {
                this.name = (String)items.get(0);
            }
            if (items.size() > 1) {
                this.state = HostInfoDialog.this.string2state((String)items.get(1));
            }
            if (items.size() > 2) {
                this.controlled = ((String)items.get(2)).equals("1");
            }
            if (items.size() > 3) {
                String s = (String)items.get(3);
                try {
                    this.level = Integer.parseInt(s);
                }
                catch (NumberFormatException e) {
                    // empty catch block
                }
            }
        }

        public String toString() {
            return this.name + " -> " + ApiUtil.stateName((DevState)this.state) + "\t- " + (this.controlled ? "" : "not ") + "Controlled \tlevel " + this.level;
        }
    }
}

