/*
 * Decompiled with CFR 0.152.
 */
package admin.astor;

import admin.astor.Astor;
import admin.astor.AstorDefs;
import admin.astor.AstorUtil;
import admin.astor.DbaseObject;
import admin.astor.HostInfoDialog;
import admin.astor.HostInfoDialogVector;
import admin.astor.HostStateThread;
import admin.astor.RemoteLoginThread;
import admin.astor.RenameDialog;
import admin.astor.TACobject;
import admin.astor.TangoHost;
import admin.astor.TangoServer;
import admin.astor.TreePopupMenu;
import admin.astor.access.TangoAccess;
import admin.astor.statistics.ResetStatistics;
import admin.astor.tools.PopupText;
import admin.astor.tools.Utils;
import fr.esrf.Tango.DevFailed;
import fr.esrf.TangoApi.DeviceProxy;
import fr.esrf.TangoApi.IORdump;
import fr.esrf.TangoDs.Except;
import fr.esrf.tangoatk.widget.util.ErrorPane;
import fr.esrf.tangoatk.widget.util.Splash;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.StringTokenizer;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.ToolTipManager;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeExpansionListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreePath;
import jive3.MainPanel;

public class AstorTree
extends JTree
implements AstorDefs {
    private JFrame parent;
    public TangoHost[] hosts;
    private TangoHost selectedHost = null;
    private DbaseObject selected_db = null;
    private DbaseObject[] dbase;
    private DefaultTreeModel treeModel;
    private Timer watchDogTimer;
    private TACobject accessControl;
    private TangoAccess tangoAccessPanel = null;
    private MainPanel jive3 = null;
    private TreePopupMenu pMenu;
    private DbPopupMenu dbMenu;
    private TacPopupMenu tacMenu;
    HostInfoDialogVector hostDialogs = new HostInfoDialogVector();
    private static List<String> collecNames = new ArrayList<String>();
    private static DefaultMutableTreeNode root;
    private static int hostSubscribed;
    private static final Color background;
    private List<String> subscribeError = new ArrayList<String>();
    private UpdateSplashThread updateSplashThread = null;
    PopupText subscribeErrWindow = null;
    private long startSubscribeTime;
    private Splash splash;
    private boolean jive_is_read_only = false;

    public AstorTree(JFrame parent, Splash splash) throws DevFailed {
        this.parent = parent;
        this.splash = splash;
        this.initComponent();
        this.setBackground(background);
        hostSubscribed = 0;
        this.updateSplashThread = new UpdateSplashThread(this.hosts.length);
        this.updateSplashThread.start();
        int cnt = 0;
        for (TangoHost host : this.hosts) {
            this.updateSplashThread.wakeUp(cnt++, "Creating  " + (Object)((Object)host) + "  object");
            host.thread = new HostStateThread(this, host);
            host.thread.start();
        }
        this.updateSplashThread.stopThread();
        if (hostSubscribed == 0) {
            this.updateSplashThread = new UpdateSplashThread(this.hosts.length);
            this.updateSplashThread.start();
            this.startSubscribeTime = System.currentTimeMillis();
            new subscribeThread().start();
            this.updateMonitor(null);
        }
        this.pMenu = parent instanceof Astor ? new TreePopupMenu((Astor)parent, this) : new TreePopupMenu(this);
        this.dbMenu = new DbPopupMenu(this);
        if (this.isAccessControlled()) {
            this.tacMenu = new TacPopupMenu(this);
        }
        this.expandRow(1);
        int delay = 10000;
        ActionListener taskPerformer = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
            }
        };
        this.watchDogTimer = new Timer(delay, taskPerformer);
        this.watchDogTimer.start();
    }

    void updateMonitor(String strerror) {
        if (strerror != null) {
            this.subscribeError.add(strerror);
        }
        if (hostSubscribed < this.hosts.length) {
            if (this.updateSplashThread != null) {
                TangoHost host = this.hosts[hostSubscribed];
                String message = "Subscribing for  " + host.getName() + "  (" + (hostSubscribed + 1) + "/" + this.hosts.length + ")";
                this.updateSplashThread.wakeUp(AstorTree.hostSubscribed, message);
                ++hostSubscribed;
            }
        } else {
            long t1 = System.currentTimeMillis();
            System.out.println("Total time to subscribe on " + hostSubscribed + " hosts : " + (t1 - this.startSubscribeTime) + " ms");
            System.out.println("Total time to start Astor " + (t1 - Astor.t0) + " ms");
            if (this.updateSplashThread != null) {
                this.updateSplashThread.stopThread();
            }
            this.splash.setVisible(false);
            if (this.subscribeError.size() > 0) {
                StringBuilder sb = new StringBuilder();
                for (int i = 0; i < this.subscribeError.size(); ++i) {
                    sb.append(this.subscribeError.get(i));
                    if (i >= this.subscribeError.size() - 1) continue;
                    sb.append("\n\n");
                }
                String title = new Date().toString() + " - Subscribe events on " + this.subscribeError.size() + "/" + hostSubscribed;
                title = this.subscribeError.size() == 1 ? title + " host has failed" : title + " hosts have failed";
                int height = 50 + this.subscribeError.size() * 75;
                if (height > 560) {
                    height = 560;
                }
                this.subscribeErrWindow = new PopupText((Frame)this.parent, true);
                this.subscribeErrWindow.setTitle(title);
                this.subscribeErrWindow.addText(sb.toString());
                this.subscribeErrWindow.setSize(900, height);
            }
        }
    }

    void stopThreads() {
        this.watchDogTimer.stop();
        for (TangoHost host : this.hosts) {
            host.stopThread();
        }
    }

    void expand(boolean expand) {
        if (expand) {
            for (int i = 0; i < this.hosts.length + collecNames.size() + 1; ++i) {
                this.expandRow(i);
            }
        } else {
            for (int i = 1; i <= collecNames.size(); ++i) {
                this.collapseRow(i);
            }
        }
    }

    boolean isAccessControlled() {
        return this.accessControl != null;
    }

    private void initComponent() throws DevFailed {
        root = new DefaultMutableTreeNode("Control System");
        this.initTangoObjects();
        this.createNodes(root);
        this.getSelectionModel().setSelectionMode(1);
        this.treeModel = new DefaultTreeModel(root);
        this.setModel(this.treeModel);
        ToolTipManager.sharedInstance().registerComponent(this);
        this.setCellRenderer(new TangoRenderer());
        this.addTreeSelectionListener(new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent e) {
                AstorTree.this.hostSelectionPerformed();
            }
        });
        this.addTreeExpansionListener(new TreeExpansionListener(){

            @Override
            public void treeCollapsed(TreeExpansionEvent e) {
                AstorTree.this.collapsedPerformed(e);
            }

            @Override
            public void treeExpanded(TreeExpansionEvent e) {
            }
        });
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                AstorTree.this.treeMouseClicked(evt);
            }
        });
        this.setExpandsSelectedPaths(true);
    }

    private void initTangoObjects() throws DevFailed {
        String tango_hosts = AstorUtil.getTangoHost();
        if (tango_hosts == null || tango_hosts.length() == 0) {
            Except.throw_connection_failed((String)"TangoApi_TANGO_HOST_NOT_SET", (String)"TANGO_HOST is not set", (String)"AstorTree.initTangoObjects()");
        } else {
            StringTokenizer stk = tango_hosts.contains(",") ? new StringTokenizer(tango_hosts, ",") : new StringTokenizer(tango_hosts);
            ArrayList<String> list = new ArrayList<String>();
            while (stk.hasMoreTokens()) {
                list.add(stk.nextToken());
            }
            this.dbase = new DbaseObject[list.size()];
            for (int i = 0; i < list.size(); ++i) {
                this.dbase[i] = new DbaseObject(this, (String)list.get(i));
            }
            AstorUtil au = AstorUtil.getInstance();
            this.hosts = au.getTangoHostList();
            collecNames = au.getCollectionList(this.hosts);
            String accessControlDeviceName = AstorUtil.getAccessControlDeviceName();
            if (accessControlDeviceName != null) {
                this.accessControl = new TACobject(this, accessControlDeviceName);
            }
        }
    }

    private void createNodes(DefaultMutableTreeNode root) {
        this.updateSplashThread = new UpdateSplashThread(this.hosts.length);
        this.updateSplashThread.start();
        ArrayList<DefaultMutableTreeNode> collections = new ArrayList<DefaultMutableTreeNode>();
        for (String collectionName : collecNames) {
            DefaultMutableTreeNode node = new DefaultMutableTreeNode(collectionName);
            collections.add(node);
            root.add(node);
        }
        for (DbaseObject db : this.dbase) {
            ((DefaultMutableTreeNode)collections.get(0)).add(new DefaultMutableTreeNode(db));
        }
        if (this.accessControl != null) {
            ((DefaultMutableTreeNode)collections.get(0)).add(new DefaultMutableTreeNode(this.accessControl));
        }
        int cnt = 0;
        for (TangoHost host : this.hosts) {
            this.updateSplashThread.wakeUp(cnt++, "Creating " + (Object)((Object)host) + " node");
            DefaultMutableTreeNode host_node = new DefaultMutableTreeNode((Object)host);
            host.state = 0;
            int idx = this.getHostCollection(host);
            ((DefaultMutableTreeNode)collections.get(idx)).add(host_node);
        }
        this.updateSplashThread.stopThread();
    }

    List<String> getCollectionList() {
        return collecNames;
    }

    private int getHostCollection(TangoHost host) {
        for (int i = 0; i < collecNames.size(); ++i) {
            if (host.collection == null) {
                return collecNames.size() - 1;
            }
            if (!host.collection.equals(collecNames.get(i))) continue;
            return i;
        }
        return collecNames.size() - 1;
    }

    private void collapsedPerformed(TreeExpansionEvent e) {
        TreePath path = e.getPath();
        if (path.getPathCount() > 2) {
            return;
        }
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)path.getPathComponent(path.getPathCount() - 1);
        boolean is_db_collec = ((DefaultMutableTreeNode)node.getChildAt(0)).getUserObject() instanceof DbaseObject;
        if (path.getPathCount() == 1 || is_db_collec) {
            DefaultMutableTreeNode leaf = (DefaultMutableTreeNode)node.getChildAt(0);
            Object[] leaf_path = leaf.getPath();
            this.setExpandedState(new TreePath(leaf_path), true);
            if (path.getPathCount() == 1) {
                String message = "TANGO Control System\n\n";
                message = message + this.hosts.length + " hosts controlled.\n";
                int nb_on_events = 0;
                for (TangoHost host : this.hosts) {
                    if (!host.onEvents) continue;
                    ++nb_on_events;
                }
                if (nb_on_events == this.hosts.length) {
                    message = message + "All are controlled on events.";
                } else if (nb_on_events > 0) {
                    message = message + nb_on_events + " are controlled on events.";
                }
                Utils.popupMessage(this.parent, message, "TangoClass.gif");
            }
        }
    }

    private Rectangle computeBounds(TreePath selPath) {
        this.scrollPathToVisible(selPath);
        Rectangle r = this.getPathBounds(selPath);
        if (r != null) {
            Point p = r.getLocation();
            SwingUtilities.convertPointToScreen(p, this);
            r.setLocation(p);
            r.width += 20;
            r.height += 2;
        }
        return r;
    }

    private Object getSelectedObject() {
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)this.getLastSelectedPathComponent();
        return node.getUserObject();
    }

    void startHostInfo() {
        Object object = this.getSelectedObject();
        if (object instanceof TangoHost) {
            TangoHost host = (TangoHost)((Object)object);
            String className = AstorUtil.getHostInfoClassName();
            System.out.println(className + "  for " + host.hostName());
            try {
                AstorUtil.getInstance().startExternalApplication(className, host.hostName());
            }
            catch (DevFailed e) {
                ErrorPane.showErrorMessage((Component)new JFrame(), null, (DevFailed)e);
            }
        }
        if (object instanceof String) {
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)this.getLastSelectedPathComponent();
            int nbHosts = node.getChildCount();
            String[] hostNames = new String[nbHosts];
            for (int i = 0; i < nbHosts; ++i) {
                node = node.getNextNode();
                hostNames[i] = ((TangoHost)((Object)node.getUserObject())).hostName();
            }
            String className = AstorUtil.getHostInfoClassName();
            try {
                AstorUtil.getInstance().startExternalApplication(className, hostNames);
            }
            catch (DevFailed e) {
                ErrorPane.showErrorMessage((Component)new JFrame(), null, (DevFailed)e);
            }
        }
    }

    void changeNodeName() {
        Rectangle r = this.computeBounds(this.getSelectionPath());
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)this.getLastSelectedPathComponent();
        RenameDialog dlg = new RenameDialog((Frame)this.parent, node.toString(), r);
        if (dlg.showDlg()) {
            String new_name = dlg.getNewName();
            try {
                DefaultMutableTreeNode n2 = node;
                int nb = n2.getChildCount();
                for (int i = 0; i < nb; ++i) {
                    n2 = n2.getNextNode();
                    TangoHost th = (TangoHost)((Object)n2.getUserObject());
                    th.setCollection(new_name);
                }
            }
            catch (DevFailed e) {
                ErrorPane.showErrorMessage((Component)this.parent, null, (DevFailed)e);
                return;
            }
            node.setUserObject(new_name);
        }
    }

    void addBranch(String name) {
        DefaultMutableTreeNode node = new DefaultMutableTreeNode(name);
        DefaultTreeModel model = (DefaultTreeModel)this.getModel();
        DefaultMutableTreeNode root = (DefaultMutableTreeNode)model.getRoot();
        model.insertNodeInto(node, root, root.getChildCount());
        collecNames.add(name);
    }

    void moveNode() {
        DefaultMutableTreeNode hostNode = (DefaultMutableTreeNode)this.getLastSelectedPathComponent();
        DefaultMutableTreeNode parentNode = (DefaultMutableTreeNode)hostNode.getParent();
        Object[] targetNames = new String[collecNames.size() - 1];
        int idx = 0;
        for (int i = 1; i < collecNames.size(); ++i) {
            if (collecNames.get(i).equals(parentNode.toString())) continue;
            targetNames[idx++] = collecNames.get(i);
        }
        targetNames[idx] = "New Branch";
        String targetName = (String)JOptionPane.showInputDialog(this, "Move " + hostNode + "  to :", "", 1, null, targetNames, targetNames[0]);
        if (targetName != null) {
            if (targetName.equals(targetNames[idx])) {
                targetName = (String)JOptionPane.showInputDialog(this, "New Branch Name", "Input Dialog", 1, null, null, "");
                if (targetName == null) {
                    return;
                }
                this.addBranch(targetName);
            }
            for (int i = 0; i < root.getChildCount(); ++i) {
                DefaultMutableTreeNode collecNode = (DefaultMutableTreeNode)root.getChildAt(i);
                if (!collecNode.toString().equals(targetName)) continue;
                try {
                    TangoHost host = (TangoHost)((Object)hostNode.getUserObject());
                    host.setCollection(targetName);
                }
                catch (DevFailed e) {
                    ErrorPane.showErrorMessage((Component)this.parent, null, (DevFailed)e);
                    return;
                }
                DefaultTreeModel model = (DefaultTreeModel)this.getModel();
                model.removeNodeFromParent(hostNode);
                model.insertNodeInto(hostNode, collecNode, 0);
                if (parentNode.getChildCount() == 0) {
                    model.removeNodeFromParent(parentNode);
                    collecNames.remove(parentNode.toString());
                }
                this.scrollPathToVisible(new TreePath(hostNode.getPath()));
                Object[] path = hostNode.getPath();
                this.setSelectionPath(new TreePath(path));
            }
        }
    }

    private void hostSelectionPerformed() {
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)this.getLastSelectedPathComponent();
        if (node == null) {
            return;
        }
        Object obj = node.getUserObject();
        if (node.isLeaf()) {
            if (obj instanceof TangoHost) {
                this.selectedHost = (TangoHost)((Object)obj);
                this.selected_db = null;
            } else if (obj instanceof DbaseObject) {
                this.selectedHost = null;
                this.selected_db = (DbaseObject)obj;
            } else {
                this.selectedHost = null;
                this.selected_db = null;
            }
        } else {
            this.selectedHost = null;
            this.selected_db = null;
        }
    }

    private void treeMouseClicked(MouseEvent evt) {
        if (this.getRowForLocation(evt.getX(), evt.getY()) < 1) {
            return;
        }
        TreePath selectedPath = this.getPathForLocation(evt.getX(), evt.getY());
        if (selectedPath == null) {
            return;
        }
        this.setSelectionPath(selectedPath);
        int mask = evt.getModifiers();
        if (evt.getClickCount() == 2) {
            if ((mask & 0x10) != 0) {
                if (this.selectedHost != null) {
                    this.displayHostInfo();
                } else {
                    DefaultMutableTreeNode node = (DefaultMutableTreeNode)this.getLastSelectedPathComponent();
                    Object o = node.getUserObject();
                    if (this.selected_db != null || o.toString().equals(collecNames.get(0))) {
                        this.displayJiveAppli();
                    }
                }
            }
        } else {
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)this.getLastSelectedPathComponent();
            Object obj = node.getUserObject();
            if ((mask & 4) != 0) {
                if (obj instanceof DbaseObject) {
                    this.dbMenu.showMenu(evt);
                } else if (obj instanceof TACobject) {
                    this.tacMenu.showMenu(evt);
                } else {
                    this.pMenu.showMenu(evt);
                }
            }
        }
    }

    void setSelectionRoot() {
        this.setSelectionPath(new TreePath(root.getPath()));
    }

    public void setSelectionPath(String hostname) throws DevFailed {
        boolean found = false;
        for (int i = 0; i < root.getChildCount(); ++i) {
            DefaultMutableTreeNode collec = (DefaultMutableTreeNode)root.getChildAt(i);
            for (int j = 0; j < collec.getChildCount(); ++j) {
                DefaultMutableTreeNode node = (DefaultMutableTreeNode)collec.getChildAt(j);
                Object obj = node.getUserObject();
                if (!(obj instanceof TangoHost)) continue;
                String name = node.toString();
                int idx = name.indexOf(40);
                if (idx > 0) {
                    name = name.substring(0, idx).trim();
                }
                if (!name.equals(hostname)) continue;
                this.setSelectionPath(new TreePath(node.getPath()));
                found = true;
            }
        }
        if (!found) {
            Except.throw_exception((String)"HOST_NOT_FOUND", (String)(hostname + "  is not controlled by Astor !"), (String)"AstorTree.setSelectionPath()");
        }
    }

    void displayJiveAppli() {
        if (this.selected_db != null && this.selected_db.state == 1) {
            ErrorPane.showErrorMessage((Component)this.parent, null, (DevFailed)this.selected_db.except);
        } else {
            boolean read_only = AstorUtil.getInstance().jiveIsReadOnly();
            if (Astor.rwMode != 0) {
                read_only = true;
            }
            if (this.jive_is_read_only != read_only || this.jive3 == null) {
                this.jive3 = new MainPanel(false, read_only);
            }
            this.jive3.setVisible(true);
            this.jive3.toFront();
            this.jive_is_read_only = read_only;
        }
    }

    void showJive(TangoServer server) {
        this.displayJiveAppli();
        this.jive3.goToServerNode(server.getName());
    }

    void changeHostNode(TangoHost h) {
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)this.getLastSelectedPathComponent();
        DefaultMutableTreeNode parent_node = (DefaultMutableTreeNode)node.getParent();
        int pos = 0;
        for (int i = 0; i < parent_node.getChildCount(); ++i) {
            if (!parent_node.getChildAt(i).equals(node)) continue;
            pos = i;
        }
        DefaultMutableTreeNode new_node = new DefaultMutableTreeNode((Object)h);
        this.treeModel.insertNodeInto(new_node, parent_node, pos);
        this.treeModel.removeNodeFromParent(node);
        Object[] path = new_node.getPath();
        this.setSelectionPath(new TreePath(path));
    }

    public void displayHostInfoDialog(String hostname) {
        try {
            StringTokenizer st = new StringTokenizer(hostname);
            hostname = st.nextToken();
            st = new StringTokenizer(hostname, ".");
            hostname = st.nextToken();
            this.parent.setVisible(true);
            this.setSelectionPath(new TreePath(root.getPath()));
            this.setSelectionPath(hostname);
            this.displayHostInfo();
        }
        catch (DevFailed e) {
            ErrorPane.showErrorMessage((Component)this, null, (DevFailed)e);
        }
    }

    public void displayHostInfo(String devname) {
        try {
            String hostname = new IORdump(devname).get_host();
            if (hostname == null) {
                Except.throw_exception((String)"UNKNOWN_HOST", (String)"May be this device has never been exported !", (String)"");
            } else {
                StringTokenizer st = new StringTokenizer(hostname);
                hostname = st.nextToken();
                st = new StringTokenizer(hostname, ".");
                hostname = st.nextToken();
                this.parent.setVisible(true);
                this.setSelectionPath(new TreePath(root.getPath()));
                this.setSelectionPath(hostname);
                this.displayHostInfo();
                String servname = new DeviceProxy(devname).adm_name();
                servname = servname.substring(servname.indexOf(47) + 1);
                HostInfoDialog dlg = this.hostDialogs.getByHostName(this.selectedHost);
                if (dlg != null) {
                    dlg.setSelection(servname);
                }
            }
        }
        catch (DevFailed e) {
            ErrorPane.showErrorMessage((Component)this.parent, null, (DevFailed)e);
        }
    }

    void displayHostInfo() {
        if (this.selectedHost == null) {
            Utils.popupError(this, "this Host is not controlled by Astor !");
            return;
        }
        this.selectedHost.updateData();
        try {
            Thread.sleep(1000L);
        }
        catch (InterruptedException e) {
            // empty catch block
        }
        if (this.selectedHost.state == 1 && this.selectedHost.except != null) {
            String reason = this.selectedHost.except.errors[0].reason;
            String desc = this.selectedHost.except.errors[0].desc;
            if (reason.equals("TangoApi_DEVICE_NOT_EXPORTED") || desc.indexOf("CORBA.TRANSIENT: Retries exceeded,") > 0) {
                if (AstorUtil.osIsUnix()) {
                    if (JOptionPane.showConfirmDialog(this.parent, "Starter is not running on " + (Object)((Object)this.selectedHost) + "\n\n\n" + "Do you want a ssh login to start it ?", "Dialog", 0) == 0) {
                        try {
                            new RemoteLoginThread(this.selectedHost.getName()).start();
                        }
                        catch (DevFailed e) {
                            ErrorPane.showErrorMessage((Component)this, null, (DevFailed)e);
                        }
                    }
                } else {
                    Utils.popupError(this.parent, "Starter is not running on " + (Object)((Object)this.selectedHost) + " !!!");
                }
            } else {
                ErrorPane.showErrorMessage((Component)this.parent, (String)("Starter on " + (Object)((Object)this.selectedHost)), (DevFailed)this.selectedHost.except);
            }
        } else if (this.selectedHost.state == 0) {
            Utils.popupMessage(this.parent, "Connection with Starter device server is blocked !");
        } else if (this.parent instanceof Astor) {
            this.hostDialogs.add((Astor)this.parent, this.selectedHost);
        }
    }

    void resetCollectionStatistics() {
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)this.getLastSelectedPathComponent();
        ArrayList<String> hostList = new ArrayList<String>();
        int nb = node.getChildCount();
        for (int i = 0; i < nb; ++i) {
            node = node.getNextNode();
            TangoHost host = (TangoHost)((Object)node.getUserObject());
            hostList.add(host.name());
        }
        if (JOptionPane.showConfirmDialog(this.parent, "Do you want to reset statistics on " + hostList.size() + " hosts  ?", "Dialog", 0) == 0) {
            new ResetStatistics(this.parent);
        }
    }

    void displayBranchInfo() {
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)this.getLastSelectedPathComponent();
        String str = node + ":\n\n";
        int nb = node.getChildCount();
        for (int i = 0; i < nb; ++i) {
            node = node.getNextNode();
            TangoHost host = (TangoHost)((Object)node.getUserObject());
            str = str + host.hostStatus();
        }
        Utils.popupMessage(this.parent, str);
    }

    void startTACpanel() {
        try {
            if (this.tangoAccessPanel == null || !this.tangoAccessPanel.isVisible()) {
                if (TangoAccess.checkPassword(this.parent) == 0) {
                    this.tangoAccessPanel = new TangoAccess(this.parent);
                } else {
                    return;
                }
            }
            this.tangoAccessPanel.setVisible(true);
        }
        catch (DevFailed e) {
            ErrorPane.showErrorMessage((Component)this, (String)"Cannot start TangoAccess class", (DevFailed)e);
        }
    }

    void updateState() {
        this.repaint();
        if (this.hostDialogs != null && this.hosts != null) {
            for (TangoHost host : this.hosts) {
                if (host.state != 1) continue;
                this.hostDialogs.close(host);
            }
        }
    }

    static {
        hostSubscribed = 0;
        background = new Color(240, 240, 240);
    }

    private class TacPopupMenu
    extends JPopupMenu {
        private JTree tree;
        private final String[] menuLabels = new String[]{"Server Info", "Black  Box", "Manager Panel"};
        private final int OFFSET = 2;
        private final int SERVER_INFO = 0;
        private final int BLACKBOX = 1;
        private final int MANAGER_PANEL = 2;

        private TacPopupMenu(JTree tree) {
            this.tree = tree;
            JLabel title = new JLabel("Access Control Server :");
            title.setFont(new Font("Dialog", 1, 16));
            this.add(title);
            this.add(new JPopupMenu.Separator());
            for (String menuLabel : this.menuLabels) {
                JMenuItem btn = new JMenuItem(menuLabel);
                btn.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent evt) {
                        TacPopupMenu.this.treeActionPerformed(evt);
                    }
                });
                this.add(btn);
            }
        }

        public void showMenu(MouseEvent evt) {
            Object obj = AstorTree.this.getSelectedObject();
            JLabel lbl = (JLabel)this.getComponent(0);
            lbl.setText(obj.toString() + "  :");
            this.show(this.tree, evt.getX(), evt.getY());
            this.getComponent(4).setEnabled(Astor.rwMode == 0);
        }

        private void treeActionPerformed(ActionEvent evt) {
            Object src = evt.getSource();
            int cmdidx = 0;
            for (int i = 0; i < this.menuLabels.length; ++i) {
                if (this.getComponent(2 + i) != src) continue;
                cmdidx = i;
            }
            TACobject tac = (TACobject)AstorTree.this.getSelectedObject();
            PopupText ppt = new PopupText((Frame)AstorTree.this.parent, true);
            try {
                switch (cmdidx) {
                    case 0: {
                        ppt.show(tac.getServerInfo());
                        break;
                    }
                    case 1: {
                        tac.blackbox(AstorTree.this.parent);
                        break;
                    }
                    case 2: {
                        AstorTree.this.startTACpanel();
                    }
                }
            }
            catch (DevFailed e) {
                ErrorPane.showErrorMessage((Component)this, null, (DevFailed)e);
            }
        }
    }

    private class DbPopupMenu
    extends JPopupMenu {
        private JTree tree;
        private final String[] menuLabels = new String[]{"Server Info", "Database Info", "Database Black Box", "Database Monitoring", "Browse Database (Jive)"};
        private final int OFFSET = 2;
        private final int SERVER_INFO = 0;
        private final int DATABASE_INFO = 1;
        private final int DATABASE_BLACKBOX = 2;
        private final int DATABASE_MONITOR = 3;
        private final int BROWSE_DATABASE = 4;

        private DbPopupMenu(JTree tree) {
            this.tree = tree;
            JLabel title = new JLabel("Datbase Server :");
            title.setFont(new Font("Dialog", 1, 16));
            this.add(title);
            this.add(new JPopupMenu.Separator());
            for (String menuLabel : this.menuLabels) {
                JMenuItem btn = new JMenuItem(menuLabel);
                btn.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent evt) {
                        DbPopupMenu.this.treeActionPerformed(evt);
                    }
                });
                this.add(btn);
            }
        }

        private void showMenu(MouseEvent evt) {
            Object obj = AstorTree.this.getSelectedObject();
            JLabel lbl = (JLabel)this.getComponent(0);
            lbl.setText(obj.toString() + "  :");
            this.show(this.tree, evt.getX(), evt.getY());
        }

        private void treeActionPerformed(ActionEvent evt) {
            Object src = evt.getSource();
            int cmdidx = 0;
            for (int i = 0; i < this.menuLabels.length; ++i) {
                if (this.getComponent(2 + i) != src) continue;
                cmdidx = i;
            }
            try {
                switch (cmdidx) {
                    case 4: {
                        AstorTree.this.displayJiveAppli();
                        break;
                    }
                    default: {
                        this.manageOneDataBaseOption(cmdidx);
                        break;
                    }
                }
            }
            catch (DevFailed e) {
                ErrorPane.showErrorMessage((Component)this, null, (DevFailed)e);
            }
        }

        private void manageOneDataBaseOption(int action) throws DevFailed {
            DbaseObject db = (DbaseObject)AstorTree.this.getSelectedObject();
            switch (action) {
                case 0: {
                    new PopupText((Frame)AstorTree.this.parent, true).show(db.getServerInfo());
                    break;
                }
                case 1: {
                    new PopupText((Frame)AstorTree.this.parent, true).show(db.getInfo());
                    break;
                }
                case 2: {
                    db.showBlackBox(AstorTree.this.parent);
                    break;
                }
                case 3: {
                    db.monitor();
                }
            }
        }
    }

    private class subscribeThread
    extends Thread {
        private subscribeThread() {
        }

        @Override
        public void run() {
            for (TangoHost host : AstorTree.this.hosts) {
                if (!host.onEvents) continue;
                host.thread.subscribeChangeStateEvent();
            }
        }
    }

    private class TangoRenderer
    extends DefaultTreeCellRenderer {
        private ImageIcon tangoIcon;
        private ImageIcon dbIcon = Utils.getInstance().getIcon("MySql.gif");
        private Font[] fonts;
        private Font rootFont;

        public TangoRenderer() {
            this.tangoIcon = Utils.getInstance().getIcon("TransparentTango.gif", 0.25);
            this.fonts = new Font[2];
            this.rootFont = new Font("helvetica", 1, 24);
            this.fonts[0] = new Font("helvetica", 1, 18);
            this.fonts[1] = new Font("helvetica", 0, 12);
        }

        @Override
        public Component getTreeCellRendererComponent(JTree tree, Object obj, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            super.getTreeCellRendererComponent(tree, obj, sel, expanded, leaf, row, hasFocus);
            this.setBackgroundNonSelectionColor(background);
            this.setForeground(Color.black);
            if (row == 0) {
                this.setBackgroundSelectionColor(background);
                this.setIcon(this.tangoIcon);
                this.setFont(this.rootFont);
            } else if (this.isDatabase(obj)) {
                if (leaf) {
                    this.setBackgroundSelectionColor(Color.lightGray);
                    DbaseObject db = this.getDbase(obj);
                    this.setIcon(AstorUtil.state_icons[db.state]);
                    this.setFont(this.fonts[1]);
                } else {
                    this.setBackgroundSelectionColor(background);
                    int state = 4;
                    for (DbaseObject db : AstorTree.this.dbase) {
                        if (db.state != 1) continue;
                        state = 1;
                    }
                    if (state == 1) {
                        this.setForeground(Color.red);
                    }
                    this.setIcon(this.dbIcon);
                    this.setFont(this.fonts[0]);
                }
            } else if (this.isTAC(obj)) {
                this.setBackgroundSelectionColor(Color.lightGray);
                TACobject tac = this.getTACobject(obj);
                this.setIcon(AstorUtil.state_icons[tac.state]);
                this.setFont(this.fonts[1]);
            } else if (this.isHost(obj)) {
                this.setBackgroundSelectionColor(Color.lightGray);
                this.setFont(this.fonts[1]);
                this.setBackgroundNonSelectionColor(background);
                TangoHost host = this.getHost(obj);
                int state = host.state;
                if (state == 0) {
                    state = 6;
                }
                this.setIcon(AstorUtil.state_icons[state]);
            } else {
                this.setBackgroundSelectionColor(Color.lightGray);
                this.setFont(this.fonts[0]);
                int state = this.branchState(obj);
                this.setIcon(AstorUtil.state_icons[state]);
            }
            return this;
        }

        int branchState(Object tree_node) {
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)tree_node;
            int nb = node.getChildCount();
            TangoHost[] tangoHosts = new TangoHost[nb];
            for (int i = 0; i < nb; ++i) {
                node = node.getNextNode();
                tangoHosts[i] = (TangoHost)((Object)node.getUserObject());
            }
            boolean is_faulty = false;
            boolean is_alarm = false;
            boolean is_moving = false;
            int nb_off = 0;
            int nb_ok = 0;
            for (int i = 0; i < nb; ++i) {
                if (tangoHosts[i].state == 0) {
                    return 0;
                }
                if (tangoHosts[i].state == 1) {
                    is_faulty = true;
                    continue;
                }
                if (tangoHosts[i].state == 2) {
                    is_alarm = true;
                    continue;
                }
                if (tangoHosts[i].state == 5) {
                    is_moving = true;
                    continue;
                }
                if (tangoHosts[i].state == 3) {
                    ++nb_off;
                    continue;
                }
                if (tangoHosts[i].state != 4) continue;
                ++nb_ok;
            }
            int state = is_faulty ? 1 : (is_moving ? 5 : (is_alarm ? 2 : (nb_off == nb ? 3 : (nb_ok == nb ? 4 : 2))));
            return state;
        }

        boolean isHost(Object tree_node) {
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)tree_node;
            Object obj = node.getUserObject();
            return obj instanceof TangoHost;
        }

        TangoHost getHost(Object tree_node) {
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)tree_node;
            Object obj = node.getUserObject();
            if (obj instanceof TangoHost) {
                return (TangoHost)((Object)obj);
            }
            return null;
        }

        DbaseObject getDbase(Object tree_node) {
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)tree_node;
            Object obj = node.getUserObject();
            if (obj instanceof DbaseObject) {
                return (DbaseObject)obj;
            }
            return null;
        }

        boolean isDatabase(Object tree_node) {
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)tree_node;
            Object obj = node.getUserObject();
            if (obj instanceof DbaseObject) {
                return true;
            }
            if (obj instanceof String) {
                String str = (String)obj;
                return str.equals(collecNames.get(0));
            }
            return false;
        }

        TACobject getTACobject(Object tree_node) {
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)tree_node;
            Object obj = node.getUserObject();
            if (obj instanceof TACobject) {
                return (TACobject)obj;
            }
            return null;
        }

        boolean isTAC(Object tree_node) {
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)tree_node;
            Object obj = node.getUserObject();
            return obj instanceof TACobject;
        }
    }

    private class UpdateSplashThread
    extends Thread {
        private String message = "";
        private int ratio;
        private boolean stop = false;

        private UpdateSplashThread(int maxValue) {
            AstorTree.this.splash.setAlwaysOnTop(true);
            AstorTree.this.splash.setVisible(true);
            AstorTree.this.splash.setMaxProgress(maxValue);
        }

        @Override
        public void run() {
            while (!this.stop) {
                AstorTree.this.splash.progress(this.ratio);
                AstorTree.this.splash.setMessage(this.message);
                this.doSleep();
            }
        }

        private synchronized void doSleep() {
            try {
                this.wait(500L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }

        private synchronized void wakeUp(int ratio, String message) {
            this.ratio = ratio;
            this.message = message;
            this.notify();
        }

        private synchronized void stopThread() {
            this.stop = true;
            this.notify();
        }
    }
}

