/*
 * Decompiled with CFR 0.152.
 */
package dbbench;

import com.jcraft.jsch.ChannelExec;
import com.jcraft.jsch.JSch;
import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.Session;
import dbbench.StatFrame;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Properties;

public class StatInfo
implements Comparable {
    static SimpleDateFormat dfrm = new SimpleDateFormat("dd/MM/yyyy HH:mm:ss:SSS");
    private static JSch jsch = new JSch();
    String name;
    String host;
    String pid;
    String cmdLine = null;
    int count;
    long lastEvent;

    public boolean equals(StatInfo anOther) {
        return this.name.equals(anOther.name) && this.host.equals(anOther.host) && this.pid.equals(anOther.pid);
    }

    public void clear() {
        this.name = "";
        this.host = "";
        this.pid = "";
    }

    public String toString() {
        return this.name + ", " + this.host + ", " + this.pid + ", " + dfrm.format(new Date(this.lastEvent));
    }

    public int compareTo(Object o) {
        StatInfo si = (StatInfo)o;
        return si.count - this.count;
    }

    public String extractPID() {
        int idx;
        for (idx = this.pid.length() - 1; idx >= 0 && this.pid.charAt(idx) >= '0' && this.pid.charAt(idx) <= '9'; --idx) {
        }
        if (++idx < 0) {
            return null;
        }
        return this.pid.substring(idx);
    }

    public String getCmdLine() {
        if (this.cmdLine == null) {
            final String PID = this.extractPID();
            if (PID == null) {
                this.cmdLine = "Failed to get PID";
                return this.cmdLine;
            }
            this.cmdLine = PID + " Waiting...";
            new Thread(new Runnable(){

                @Override
                public void run() {
                    StatInfo.this.cmdLine = PID + "  " + StatInfo.this.execCommand(StatInfo.this.host, "xargs -0 < /proc/" + StatInfo.this.extractPID() + "/cmdline");
                }
            }).start();
        }
        return this.cmdLine;
    }

    private String execCommand(String host, String command) {
        try {
            Session session = jsch.getSession(StatFrame.defaultUser, host, 22);
            session.setPassword(StatFrame.defaultPassword);
            Properties config = new Properties();
            config.put("StrictHostKeyChecking", "no");
            session.setConfig(config);
            session.connect();
            ChannelExec channel = (ChannelExec)session.openChannel("exec");
            BufferedReader in = new BufferedReader(new InputStreamReader(channel.getInputStream()));
            channel.setCommand(command + ";");
            channel.connect();
            String msg = null;
            StringBuffer ret = new StringBuffer();
            while ((msg = in.readLine()) != null) {
                ret.append(msg);
                ret.append("\n");
            }
            channel.disconnect();
            session.disconnect();
            return ret.toString();
        }
        catch (IOException e1) {
            return "Cannot get process name";
        }
        catch (JSchException e2) {
            return "Cannot get process name";
        }
    }
}

