/*
 * Decompiled with CFR 0.152.
 */
package dbbench;

import JSSHTerminal.MainPanel;
import dbbench.StatInfo;
import fr.esrf.Tango.DevFailed;
import fr.esrf.TangoApi.ApiUtil;
import fr.esrf.TangoApi.Database;
import fr.esrf.TangoApi.DbDatum;
import fr.esrf.tangoatk.widget.util.ATKConstant;
import fr.esrf.tangoatk.widget.util.ATKGraphicsUtils;
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellRenderer;

public class StatFrame
extends JFrame
implements MouseListener {
    static String defaultUser = null;
    static String defaultPassword = null;
    private JTable table;
    private DefaultTableModel model;
    private JCheckBox update;
    private ArrayList<StatInfo> calls;
    private StatInfo selected = new StatInfo();
    private Object[][] data = null;
    private boolean showCmdLine = false;

    StatFrame(ArrayList<StatInfo> calls) {
        this.calls = calls;
        this.model = new DefaultTableModel(){

            public Class getColumnClass(int columnIndex) {
                if (columnIndex == 2) {
                    return Button.class;
                }
                return String.class;
            }

            @Override
            public boolean isCellEditable(int row, int column) {
                return false;
            }

            @Override
            public void setValueAt(Object aValue, int row, int column) {
            }
        };
        this.table = new JTable(this.model);
        this.table.setSelectionMode(0);
        this.table.addMouseListener(this);
        this.table.setDefaultRenderer(Button.class, new HostTableRenderer());
        JScrollPane view = new JScrollPane(this.table);
        JPanel btnPanel = new JPanel();
        btnPanel.setLayout(new FlowLayout(2));
        btnPanel.setBorder(BorderFactory.createEtchedBorder());
        JCheckBox processNameBtn = new JCheckBox("Show process name");
        processNameBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (!StatFrame.this.getUser()) {
                    StatFrame.this.showCmdLine = false;
                } else {
                    StatFrame.this.showCmdLine = ((JCheckBox)e.getSource()).isSelected();
                }
            }
        });
        btnPanel.add(processNameBtn);
        this.update = new JCheckBox("Refresh");
        this.update.setSelected(true);
        btnPanel.add(this.update);
        JButton clearStats = new JButton("Clear Stats");
        clearStats.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                StatFrame.this.clearStats();
            }
        });
        btnPanel.add(clearStats);
        JButton dismissBtn = new JButton("Dismiss");
        dismissBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                StatFrame.this.setVisible(false);
            }
        });
        btnPanel.add(dismissBtn);
        JPanel innerPanel = new JPanel();
        innerPanel.setLayout(new BorderLayout());
        innerPanel.add((Component)view, "Center");
        innerPanel.add((Component)btnPanel, "South");
        innerPanel.setPreferredSize(new Dimension(1000, 600));
        this.setContentPane(innerPanel);
        this.setTitle("Database calls");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearStats() {
        ArrayList<StatInfo> arrayList = this.calls;
        synchronized (arrayList) {
            this.calls.clear();
        }
        this.selected.clear();
        this.refresh();
    }

    private boolean getUser() {
        if (defaultUser == null) {
            try {
                Database db = ApiUtil.get_db_obj();
                DbDatum dd = db.get_property("Astor", "RloginUser");
                if (!dd.is_empty()) {
                    defaultUser = dd.extractString();
                }
                if (!(dd = db.get_property("Astor", "RloginPassword")).is_empty()) {
                    defaultPassword = dd.extractString();
                }
            }
            catch (DevFailed devFailed) {
                // empty catch block
            }
        }
        if (defaultUser == null) {
            JOptionPane.showMessageDialog(this, "No username !\nAStor/RloginUser free property not defined.", "Error", 0);
        }
        return defaultUser != null;
    }

    public void launchTerminal(String host, String pid) {
        if (this.getUser()) {
            MainPanel terminal = new MainPanel(host, defaultUser, defaultPassword, 80, 24, 500);
            terminal.setX11Forwarding(true);
            terminal.setExitOnClose(false);
            if (pid != null) {
                terminal.setCommand("ps -ef | grep " + pid);
            }
            ATKGraphicsUtils.centerFrameOnScreen((Frame)terminal);
            terminal.setVisible(true);
        }
    }

    public void refresh() {
        if (!this.update.isSelected()) {
            return;
        }
        SwingUtilities.invokeLater(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                Object[] colName = new String[]{"Name", "ID", "Host", "Count"};
                int toSelect = -1;
                ArrayList arrayList = StatFrame.this.calls;
                synchronized (arrayList) {
                    StatFrame.access$302(StatFrame.this, new Object[StatFrame.this.calls.size()][5]);
                    for (int i = 0; i < StatFrame.this.calls.size(); ++i) {
                        StatInfo si = (StatInfo)StatFrame.this.calls.get(i);
                        ((StatFrame)StatFrame.this).data[i][0] = si.name;
                        ((StatFrame)StatFrame.this).data[i][1] = StatFrame.this.showCmdLine ? si.getCmdLine() : si.pid;
                        ((StatFrame)StatFrame.this).data[i][2] = si.host;
                        ((StatFrame)StatFrame.this).data[i][3] = si.count;
                        if (!si.equals(StatFrame.this.selected)) continue;
                        toSelect = i;
                    }
                }
                StatFrame.this.table.clearSelection();
                StatFrame.this.model.setDataVector(StatFrame.this.data, colName);
                if (toSelect >= 0) {
                    StatFrame.this.table.setRowSelectionInterval(toSelect, toSelect);
                }
                StatFrame.this.table.getColumnModel().getColumn(0).setMinWidth(200);
                StatFrame.this.table.getColumnModel().getColumn(1).setMinWidth(300);
                StatFrame.this.table.getColumnModel().getColumn(2).setMinWidth(200);
                StatFrame.this.table.getColumnModel().getColumn(3).setMinWidth(100);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void mouseClicked(MouseEvent e) {
        if (SwingUtilities.isLeftMouseButton(e)) {
            ArrayList<StatInfo> arrayList = this.calls;
            synchronized (arrayList) {
                this.selected.clear();
                int r = this.getRowForLocation(e.getY());
                if (r >= 0) {
                    this.selected.name = (String)this.data[r][0];
                    this.selected.pid = (String)this.data[r][1];
                    this.selected.host = (String)this.data[r][2];
                    int[] c = this.getColForLocation(e.getX());
                    if (c != null && c[0] == 2 && c[2] - c[1] < 30) {
                        this.launchTerminal(this.selected.host, this.selected.extractPID());
                    }
                }
            }
        }
    }

    @Override
    public void mousePressed(MouseEvent e) {
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    private int[] getColForLocation(int x) {
        boolean found = false;
        int i = 0;
        int h = 0;
        int cw = 0;
        while (i < this.table.getColumnCount() && !found) {
            cw = this.table.getColumnModel().getColumn(i).getWidth();
            found = x >= h && x <= h + cw;
            if (found) continue;
            h += cw;
            ++i;
        }
        if (found) {
            return new int[]{i, x - h, cw};
        }
        return null;
    }

    private int getRowForLocation(int y) {
        boolean found = false;
        int i = 0;
        int h = 0;
        while (i < this.table.getRowCount() && !found) {
            found = y >= h && y <= h + this.table.getRowHeight(i);
            if (found) continue;
            h += this.table.getRowHeight(i);
            ++i;
        }
        if (found) {
            return i;
        }
        return -1;
    }

    static /* synthetic */ Object[][] access$302(StatFrame x0, Object[][] x1) {
        x0.data = x1;
        return x1;
    }

    class HostTableRenderer
    extends JPanel
    implements TableCellRenderer {
        private JButton hostBtn;
        private JLabel hostLabel;

        public HostTableRenderer() {
            this.setOpaque(true);
            this.setLayout(new BorderLayout());
            this.hostBtn = new JButton("...");
            this.hostBtn.setMargin(new Insets(0, 0, 0, 0));
            this.hostLabel = new JLabel();
            this.hostBtn.setFont(ATKConstant.labelFont);
            this.hostLabel.setFont(ATKConstant.labelFont);
            this.hostLabel.setOpaque(true);
            this.add((Component)this.hostBtn, "East");
            this.add((Component)this.hostLabel, "Center");
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            this.hostLabel.setText(value == null ? "" : value.toString());
            if (isSelected) {
                this.hostLabel.setBackground(table.getSelectionBackground());
            } else {
                this.hostLabel.setBackground(table.getBackground());
            }
            return this;
        }
    }
}

