/*
 * Decompiled with CFR 0.152.
 */
package dbbench;

import dbbench.StatFrame;
import dbbench.StatInfo;
import fr.esrf.Tango.DevFailed;
import fr.esrf.TangoApi.DeviceAttribute;
import fr.esrf.TangoApi.DeviceProxy;
import fr.esrf.tangoatk.widget.util.ATKGraphicsUtils;
import fr.esrf.tangoatk.widget.util.ErrorPane;
import fr.esrf.tangoatk.widget.util.chart.JLChart;
import fr.esrf.tangoatk.widget.util.chart.JLDataView;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;

public class DBBench
extends JFrame {
    static SimpleDateFormat dfr = new SimpleDateFormat("dd/MM/yyyy HH:mm:ss");
    private JLChart chart = new JLChart();
    private JLDataView[] dv;
    private String[] dvNames;
    private DeviceProxy ds;
    private double oldTime = -1.0;
    private double[] oldValues;
    private int nbSignal;
    private int refreshPeriod = 1000;
    private ArrayList<StatInfo> allCalls;
    private StatFrame statFrame = null;
    private boolean runningFromShell;
    static final Color[] defaultColor = new Color[]{Color.red, Color.blue, Color.cyan, Color.green, Color.magenta, Color.orange, Color.pink, Color.yellow, Color.black};
    public static final String DEFAULT_VERSION = "-.-";
    public static final String VERSION = DBBench.getVersion();
    private static final int minPeriod = 100;

    public DBBench(String dbName, boolean runningFromShell) {
        this.runningFromShell = runningFromShell;
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                DBBench.this.exitFrame();
            }
        });
        JMenuBar menuBar = new JMenuBar();
        JMenu fileMenu = new JMenu("File");
        menuBar.add(fileMenu);
        JMenuItem exitMenu = new JMenuItem("Exit");
        exitMenu.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DBBench.this.exitFrame();
            }
        });
        fileMenu.add(exitMenu);
        JMenu viewMenu = new JMenu("View");
        menuBar.add(viewMenu);
        JMenuItem statMenu = new JMenuItem("Stats...");
        statMenu.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DBBench.this.viewStats();
            }
        });
        viewMenu.add(statMenu);
        JMenuItem periodMenu = new JMenuItem("Refresh period");
        periodMenu.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DBBench.this.editRefreshPeriod();
            }
        });
        viewMenu.add(periodMenu);
        this.setJMenuBar(menuBar);
        this.chart.setHeaderFont(new Font("Times", 1, 18));
        this.chart.setHeader("DBBench on " + dbName);
        this.chart.setDisplayDuration(300000.0);
        this.chart.getY1Axis().setName("calls/sec");
        this.chart.getY1Axis().setAutoScale(true);
        this.chart.getXAxis().setAutoScale(true);
        this.chart.getXAxis().setName("Time");
        this.chart.setLabelPlacement(2);
        this.chart.setPaintAxisFirst(true);
        try {
            this.ds = new DeviceProxy(dbName);
            DeviceAttribute da = this.ds.read_attribute("Timing_index");
            this.dvNames = da.extractStringArray();
        }
        catch (DevFailed e) {
            ErrorPane.showErrorMessage(null, (String)dbName, (DevFailed)e);
            this.exitFrame();
        }
        this.nbSignal = this.dvNames.length;
        this.dv = new JLDataView[this.nbSignal];
        for (int i = 0; i < this.nbSignal; ++i) {
            this.dv[i] = new JLDataView();
            this.dv[i].setName(this.dvNames[i]);
            this.dv[i].setUnit("calls/sec");
            this.dv[i].setColor(defaultColor[i % defaultColor.length]);
            this.chart.getY1Axis().addDataView(this.dv[i]);
        }
        this.oldValues = new double[this.nbSignal];
        this.allCalls = new ArrayList();
        new Thread(){

            @Override
            public void run() {
                while (true) {
                    if (DBBench.this.isVisible()) {
                        DBBench.this.refresh();
                    }
                    try {
                        Thread.sleep(DBBench.this.refreshPeriod);
                    }
                    catch (InterruptedException interruptedException) {
                    }
                }
            }
        }.start();
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add((Component)this.chart, "Center");
        this.getContentPane().setPreferredSize(new Dimension(800, 480));
        this.setTitle("DBBench " + VERSION);
    }

    private void editRefreshPeriod() {
        String newPeriod = JOptionPane.showInputDialog(this, "Enter refresh period (ms)", this.refreshPeriod);
        if (newPeriod != null) {
            int period = Integer.parseInt(newPeriod);
            if (period < 100) {
                ErrorPane.showErrorMessage((Component)this, (String)"Period to short", (Exception)new Exception("Period must be equal or higher than 100"));
            } else {
                this.refreshPeriod = Integer.parseInt(newPeriod);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void refresh() {
        int i;
        double[] values = null;
        double time = System.currentTimeMillis();
        try {
            DeviceAttribute da = this.ds.read_attribute("Timing_calls");
            values = da.extractDoubleArray();
            if (this.oldTime > 0.0) {
                double t = (time - this.oldTime) / 1000.0;
                for (i = 0; i < this.nbSignal; ++i) {
                    this.chart.addData(this.dv[i], time, (values[i] - this.oldValues[i]) / t);
                }
            }
            String[] histo = this.ds.black_box(50);
            ArrayList<StatInfo> arrayList = this.allCalls;
            synchronized (arrayList) {
                for (i = 0; i < histo.length; ++i) {
                    StatInfo si = this.GetInfo(histo[i]);
                    if (si == null) continue;
                    this.addCall(si);
                }
                Collections.sort(this.allCalls);
            }
        }
        catch (DevFailed e) {
            System.out.println("Tango Error " + e.errors[0].desc);
        }
        if (values != null) {
            this.oldTime = time;
            for (i = 0; i < this.nbSignal; ++i) {
                this.oldValues[i] = values[i];
            }
        } else {
            this.oldTime = -1.0;
        }
        if (this.statFrame != null) {
            this.statFrame.refresh();
        }
    }

    private void exitFrame() {
        if (this.runningFromShell) {
            System.exit(0);
        } else {
            this.setVisible(false);
            this.dispose();
        }
    }

    private void viewStats() {
        if (this.statFrame == null) {
            this.statFrame = new StatFrame(this.allCalls);
            this.statFrame.refresh();
            ATKGraphicsUtils.centerFrameOnScreen((Frame)this.statFrame);
        }
        this.statFrame.setVisible(true);
    }

    private void addCall(StatInfo si) {
        boolean found = false;
        int i = 0;
        while (!found && i < this.allCalls.size()) {
            StatInfo it = this.allCalls.get(i);
            found = it.equals(si);
            if (found) continue;
            ++i;
        }
        if (!found) {
            si.count = 1;
            this.allCalls.add(si);
        } else if (si.lastEvent > this.allCalls.get((int)i).lastEvent) {
            ++this.allCalls.get((int)i).count;
        }
    }

    private StatInfo GetInfo(String v) {
        StatInfo si = new StatInfo();
        int p1Idx = v.lastIndexOf(40);
        int p2Idx = v.lastIndexOf(41);
        if (p1Idx < 0 || p2Idx < 0) {
            return null;
        }
        si.pid = v.substring(p1Idx + 1, p2Idx);
        int sIdx = (v = v.substring(0, p1Idx - 1)).lastIndexOf(32);
        if (sIdx < 0) {
            return null;
        }
        si.host = v.substring(sIdx + 1);
        p1Idx = v.lastIndexOf(40);
        p2Idx = v.lastIndexOf(41);
        if (p1Idx < 0 || p2Idx < 0) {
            return null;
        }
        si.name = v.substring(p1Idx + 1, p2Idx);
        si.count = 0;
        sIdx = (v = v.substring(0, p1Idx - 1)).lastIndexOf(58);
        if (sIdx < 0) {
            return null;
        }
        String date = v.substring(0, sIdx - 4);
        String ms = v.substring(sIdx - 3, sIdx - 1);
        try {
            Date d = dfr.parse(date);
            long millis = Long.parseLong(ms);
            si.lastEvent = d.getTime() + millis * 10L;
        }
        catch (ParseException e) {
            System.out.println(e.getMessage());
            return null;
        }
        return si;
    }

    private static String getVersion() {
        Package p = DBBench.class.getPackage();
        if (p.getImplementationVersion() != null) {
            return p.getImplementationVersion();
        }
        return DEFAULT_VERSION;
    }

    public static void main(String[] args) {
        if (args.length != 1) {
            System.out.println("Usage: dbbench database_name.");
            System.exit(0);
        }
        DBBench f = new DBBench(args[0], true);
        ATKGraphicsUtils.centerFrameOnScreen((Frame)f);
        f.setVisible(true);
    }
}

