/*
 * Decompiled with CFR 0.152.
 */
package fr.esrf.logviewer;

import fr.esrf.logviewer.EventDetails;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import javax.swing.table.AbstractTableModel;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;

public class MyTableModel
extends AbstractTableModel {
    private static final double freeMemoryThreshold = 10.0;
    private static double lastFreeMemory = 0.0;
    private static final long nEventsThreshold = 50000L;
    private static final int filteredEventsUpdatedTimeThreshold = 100;
    private static final int pendingEventsThreshold = 4096;
    private static final double eventsPercent = 0.5;
    private static final Logger LOG = Logger.getLogger(MyTableModel.class);
    private static final String[] COL_NAMES = new String[]{"Trace", "Time", "Level", "Source", "Message"};
    private static final EventDetails[] EMPTY_LIST = new EventDetails[0];
    private final Object mLock = new Object();
    private final List<EventDetails> mAllEvents = new ArrayList<EventDetails>();
    private EventDetails[] mFilteredEvents = EMPTY_LIST;
    private final List<EventDetails> mPendingEvents = new ArrayList<EventDetails>();
    private boolean mPaused = false;
    private String mTimeStampFilter = "";
    private String mThreadFilter = "";
    private String mMessageFilter = "";
    private String mCategoryFilter = "";
    private Level mLevelFilter = Level.DEBUG;

    public MyTableModel() {
        Thread t = new Thread(new Processor());
        t.setDaemon(true);
        t.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getRowCount() {
        Object object = this.mLock;
        synchronized (object) {
            return this.mFilteredEvents.length;
        }
    }

    @Override
    public int getColumnCount() {
        return COL_NAMES.length;
    }

    @Override
    public String getColumnName(int aCol) {
        return COL_NAMES[aCol];
    }

    public Class getColumnClass(int aCol) {
        return Object.class;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object getValueAt(int aRow, int aCol) {
        Object object = this.mLock;
        synchronized (object) {
            EventDetails event = this.mFilteredEvents[aRow];
            switch (aCol) {
                case 0: {
                    return event.getThrowableStrRep() == null ? Boolean.FALSE : Boolean.TRUE;
                }
                case 1: {
                    return event.getRenderedTimeStamp();
                }
                case 2: {
                    return event.getLevel();
                }
                case 3: {
                    return event.getCategoryName();
                }
            }
            return event.getMessage();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setLevelFilter(Level aLevel) {
        Object object = this.mLock;
        synchronized (object) {
            this.mLevelFilter = aLevel;
            this.updateFilteredEvents(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setThreadFilter(String aStr) {
        Object object = this.mLock;
        synchronized (object) {
            this.mThreadFilter = aStr.trim();
            this.updateFilteredEvents(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setMessageFilter(String aStr) {
        Object object = this.mLock;
        synchronized (object) {
            this.mMessageFilter = aStr.trim();
            this.updateFilteredEvents(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setTimeStampFilter(String aStr) {
        Object object = this.mLock;
        synchronized (object) {
            this.mTimeStampFilter = aStr.trim();
            this.updateFilteredEvents(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setCategoryFilter(String aStr) {
        Object object = this.mLock;
        synchronized (object) {
            this.mCategoryFilter = aStr.trim();
            this.updateFilteredEvents(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addEvent(EventDetails aEvent) {
        Object object = this.mLock;
        synchronized (object) {
            this.mPendingEvents.add(aEvent);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        Object object = this.mLock;
        synchronized (object) {
            this.mAllEvents.clear();
            this.mFilteredEvents = new EventDetails[0];
            this.mPendingEvents.clear();
            this.fireTableDataChanged();
        }
    }

    public void clearOldEvents() {
        int i;
        int n = this.mAllEvents.size();
        LOG.debug((Object)("In clearOldEvents: #before:" + n));
        int n_to_clear = (int)((double)n * 0.5);
        if (n_to_clear <= 0) {
            return;
        }
        LOG.debug((Object)("In clearOldEvents: #to-clear:" + n_to_clear));
        Iterator<EventDetails> it = this.mAllEvents.iterator();
        int n_skip = n - n_to_clear;
        for (i = 0; i < n_skip && it.hasNext(); ++i) {
            it.next();
        }
        for (i = 0; i < n_to_clear && it.hasNext(); ++i) {
            EventDetails ed = it.next();
            if (ed.getLevel().isGreaterOrEqual((Priority)Level.WARN)) continue;
            it.remove();
        }
        LOG.debug((Object)("In clearOldEvents: #after:" + this.mAllEvents.size()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void toggle() {
        Object object = this.mLock;
        synchronized (object) {
            this.mPaused = !this.mPaused;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isPaused() {
        Object object = this.mLock;
        synchronized (object) {
            return this.mPaused;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EventDetails getEventDetails(int aRow) {
        Object object = this.mLock;
        synchronized (object) {
            return this.mFilteredEvents[aRow];
        }
    }

    private long updateFilteredEvents(boolean aInsertedToFront) {
        long start = System.currentTimeMillis();
        ArrayList<EventDetails> filtered = new ArrayList<EventDetails>();
        for (EventDetails event : this.mAllEvents) {
            if (!this.matchFilter(event)) continue;
            filtered.add(event);
        }
        EventDetails lastFirst = this.mFilteredEvents.length == 0 ? null : this.mFilteredEvents[0];
        this.mFilteredEvents = new EventDetails[filtered.size()];
        for (int i = 0; i < filtered.size(); ++i) {
            this.mFilteredEvents[i] = (EventDetails)filtered.get(i);
        }
        if (aInsertedToFront && lastFirst != null) {
            int index = filtered.indexOf(lastFirst);
            if (index < 1) {
                LOG.warn((Object)"In strange state");
                this.fireTableDataChanged();
            } else {
                this.fireTableRowsInserted(0, index - 1);
            }
        } else {
            this.fireTableDataChanged();
        }
        long end = System.currentTimeMillis();
        LOG.debug((Object)("# logs: " + this.mAllEvents.size()));
        LOG.debug((Object)("Update time [ms]: " + (end - start)));
        return end - start;
    }

    private boolean matchFilter(EventDetails aEvent) {
        if (aEvent.getLevel().isGreaterOrEqual((Priority)this.mLevelFilter) && aEvent.getCategoryName().contains(this.mCategoryFilter) && aEvent.getRenderedTimeStamp().contains(this.mTimeStampFilter) && aEvent.getThreadName().contains(this.mThreadFilter)) {
            String rm = aEvent.getMessage();
            if (rm == null) {
                return this.mMessageFilter.length() == 0;
            }
            return rm.contains(this.mMessageFilter);
        }
        return false;
    }

    static /* synthetic */ EventDetails[] access$602(MyTableModel x0, EventDetails[] x1) {
        x0.mFilteredEvents = x1;
        return x1;
    }

    private class Processor
    implements Runnable {
        private long lastUpdateTime = 0L;

        private Processor() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            while (true) {
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                Object object = MyTableModel.this.mLock;
                synchronized (object) {
                    if (MyTableModel.this.mPaused && MyTableModel.this.mPendingEvents.size() < 4096) {
                        continue;
                    }
                    boolean needUpdate = false;
                    Runtime rt = Runtime.getRuntime();
                    double freeMemory = 100.0 * (double)rt.freeMemory() / (double)rt.totalMemory();
                    LOG.debug((Object)("Last free memory    [%]: " + lastFreeMemory));
                    LOG.debug((Object)("Current free memory [%]: " + freeMemory));
                    if (this.lastUpdateTime > 100L && (long)MyTableModel.this.mAllEvents.size() > 50000L || freeMemory - lastFreeMemory > 5.0 && freeMemory < 10.0) {
                        MyTableModel.this.clearOldEvents();
                        MyTableModel.access$602(MyTableModel.this, new EventDetails[0]);
                        Runtime.getRuntime().gc();
                        lastFreeMemory = 100.0 * (double)rt.freeMemory() / (double)rt.totalMemory();
                        needUpdate = true;
                    } else {
                        lastFreeMemory = freeMemory;
                    }
                    Iterator it = MyTableModel.this.mPendingEvents.iterator();
                    boolean toHead = true;
                    while (it.hasNext()) {
                        EventDetails event = (EventDetails)it.next();
                        MyTableModel.this.mAllEvents.add(event);
                        toHead = toHead && event == MyTableModel.this.mAllEvents.get(0);
                        needUpdate = needUpdate || MyTableModel.this.matchFilter(event);
                    }
                    MyTableModel.this.mPendingEvents.clear();
                    if (needUpdate) {
                        Collections.sort(MyTableModel.this.mAllEvents, new EventComparator());
                        this.lastUpdateTime = MyTableModel.this.updateFilteredEvents(toHead);
                    }
                }
            }
        }
    }

    private class EventComparator
    implements Comparator<EventDetails> {
        private EventComparator() {
        }

        @Override
        public int compare(EventDetails details1, EventDetails details2) {
            if (details1 == null && details2 == null) {
                return 0;
            }
            if (details1 == null) {
                return -1;
            }
            if (details2 == null) {
                return 1;
            }
            if (details1.getTimeStamp() < details2.getTimeStamp()) {
                return 1;
            }
            if (details1.getTimeStamp() > details2.getTimeStamp()) {
                return -1;
            }
            return 0;
        }
    }
}

