/*
 * Decompiled with CFR 0.152.
 */
package fr.esrf.logviewer;

import fr.esrf.logviewer.EventDetails;
import fr.esrf.logviewer.MyTableModel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.text.MessageFormat;
import javax.swing.BorderFactory;
import javax.swing.JEditorPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class DetailPanel
extends JPanel
implements ListSelectionListener {
    private static final MessageFormat FORMATTER = new MessageFormat("<b>Time:</b> <code>{0}</code>&nbsp;&nbsp;<b>Level:</b> <code>{1}</code>&nbsp;&nbsp;<b>Device:</b> <code>{3}</code>&nbsp;&nbsp;<b>Thread:</b> <code>{2}</code><pre>{4}</pre>");
    private final MyTableModel mModel;
    private final JEditorPane mDetails;

    public DetailPanel(JTable aTable, MyTableModel aModel) {
        this.mModel = aModel;
        this.setLayout(new BorderLayout());
        this.setBorder(BorderFactory.createTitledBorder("Log Details"));
        this.mDetails = new JEditorPane();
        this.mDetails.setEditable(false);
        this.mDetails.setContentType("text/html");
        this.add((Component)new JScrollPane(this.mDetails), "Center");
        ListSelectionModel rowSM = aTable.getSelectionModel();
        rowSM.addListSelectionListener(this);
    }

    @Override
    public void valueChanged(ListSelectionEvent aEvent) {
        if (aEvent.getValueIsAdjusting()) {
            return;
        }
        ListSelectionModel lsm = (ListSelectionModel)aEvent.getSource();
        if (lsm.isSelectionEmpty()) {
            this.mDetails.setText("Nothing selected");
        } else {
            int selectedRow = lsm.getMinSelectionIndex();
            EventDetails e = this.mModel.getEventDetails(selectedRow);
            Object[] args = new Object[]{e.getRenderedTimeStamp(), e.getLevel(), this.escape(e.getThreadName()), this.escape(e.getCategoryName()), this.escape(e.getMessage())};
            this.mDetails.setText(FORMATTER.format(args));
            this.mDetails.setCaretPosition(0);
        }
    }

    private static String getThrowableStrRep(EventDetails aEvent) {
        String[] throwableList = aEvent.getThrowableStrRep();
        if (throwableList == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        for (String str : throwableList) {
            sb.append(str).append("\n");
        }
        return sb.toString();
    }

    private String escape(String aStr) {
        if (aStr == null) {
            return null;
        }
        StringBuilder buf = new StringBuilder();
        block6: for (int i = 0; i < aStr.length(); ++i) {
            char c = aStr.charAt(i);
            switch (c) {
                case '<': {
                    buf.append("&lt;");
                    continue block6;
                }
                case '>': {
                    buf.append("&gt;");
                    continue block6;
                }
                case '\"': {
                    buf.append("&quot;");
                    continue block6;
                }
                case '&': {
                    buf.append("&amp;");
                    continue block6;
                }
                default: {
                    buf.append(c);
                }
            }
        }
        return buf.toString();
    }
}

