/*
 * Decompiled with CFR 0.152.
 */
package tool_panels.atktable;

import fr.esrf.tangoatk.widget.attribute.Trend;
import fr.esrf.tangoatk.widget.util.ATKDiagnostic;
import fr.esrf.tangoatk.widget.util.ErrorPane;
import fr.esrf.tangoatk.widget.util.Splash;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JWindow;
import javax.swing.filechooser.FileFilter;
import tool_panels.atktable.DevBrowser;
import tool_panels.atktable.ScrolledScalarViewer;
import tool_panels.atktable.TableConfig;
import tool_panels.atktable.TablePreference;
import tool_panels.tools.Utils;

public class TableScalarViewer
extends JPanel {
    private static JFileChooser chooser = null;
    private static AtkTableFilter file_filter;
    private static final String[] FileExt;
    static final String AppName = "atktable";
    private boolean editable = true;
    private ScrolledScalarViewer viewer = null;
    private DevBrowser browser = null;
    private JButton errorBtn;
    private JLabel titleLabel;
    public static final int FROM_FILE = 0;
    public static final int FROM_DEVICE = 1;
    private static JDialog atkmoni;
    private static Trend trend;

    public TableScalarViewer() {
        this.initComponents();
        TableConfig config = new TableConfig(null, 3, 2);
        this.initScalarViewer(config);
    }

    public TableScalarViewer(String name, int type) {
        TableConfig config;
        this.initComponents();
        try {
            config = this.readConfig(name, type);
        }
        catch (Exception e) {
            ErrorPane.showErrorMessage((Component)this, null, (Exception)e);
            config = new TableConfig(null, 3, 2);
        }
        if (config != null) {
            this.initScalarViewer(config);
            this.titleLabel.setText(config.title);
        }
    }

    public TableScalarViewer(String[] rownames, String[] colnames, String[][] attnames) {
        this(rownames, colnames, attnames, null);
    }

    public TableScalarViewer(String[] rownames, String[] colnames, String[][] attnames, Dimension d) {
        this.initComponents();
        TableConfig config = new TableConfig(rownames, colnames, attnames);
        if (d != null) {
            config.width = d.width;
            config.height = d.height;
        }
        this.initScalarViewer(config);
        this.titleLabel.setText(config.title);
    }

    private void initComponents() {
        this.setLayout(new BorderLayout());
        this.titleLabel = new JLabel(new TableConfig().title);
        this.titleLabel.setFont(new Font("Dialog", 1, 18));
        this.errorBtn = new JButton("");
        this.errorBtn.setBorderPainted(false);
        this.errorBtn.setContentAreaFilled(false);
        this.errorBtn.setMargin(new Insets(0, 0, 0, 0));
        this.errorBtn.setVisible(false);
        this.errorBtn.setIcon(Utils.getInstance().getIcon("redball.gif"));
        this.errorBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TableScalarViewer.this.errorBtnActionPerformed(evt);
            }
        });
        JPanel panel = new JPanel();
        panel.add(this.titleLabel);
        panel.add(new JLabel("      "));
        panel.add(this.errorBtn);
        this.add((Component)panel, "North");
        this.viewer = new ScrolledScalarViewer(this);
        this.add((Component)this.viewer, "Center");
    }

    public void errorChanged(boolean on_error) {
        this.errorBtn.setVisible(on_error);
    }

    public boolean isEditable() {
        return this.editable;
    }

    public void setEditable(boolean b) {
        this.editable = b;
    }

    public void setPanelTitle(String title) {
        if (this.viewer != null) {
            this.viewer.config.title = title;
            this.titleLabel.setText(title);
        }
    }

    public void setPanelTitleFont(Font font) {
        this.titleLabel.setFont(font);
    }

    public void setPanelTitleVisible(boolean b) {
        this.titleLabel.getParent().setVisible(b);
    }

    @Override
    public void setSize(Dimension d) {
        this.viewer.table.setPreferredScrollableViewportSize(d);
        TableScalarViewer.getMainContainer(this).pack();
    }

    private void initScalarViewer(TableConfig config) {
        this.viewer.initializeViewer(config);
        this.titleLabel.setText(config.title);
    }

    public TableConfig readConfig(String name, int src) {
        try {
            return new TableConfig(name, src);
        }
        catch (Exception e) {
            if (src == 0) {
                ErrorPane.showErrorMessage((Component)this, (String)("Reading " + name), (Exception)e);
            } else {
                ErrorPane.showErrorMessage((Component)this, null, (Exception)e);
            }
            return null;
        }
    }

    public void writeConfig(String filename) {
        try {
            this.viewer.updateConfigSize();
            this.viewer.config.save(filename);
            Utils.popupMessage(this, "Configuration has been saved in \n" + filename);
        }
        catch (Exception e) {
            ErrorPane.showErrorMessage((Component)this, (String)("Writing " + filename), (Exception)e);
        }
    }

    private void errorBtnActionPerformed(ActionEvent evt) {
        this.showErrorHistory();
    }

    private void initChooser() {
        String path = System.getProperty("ATK_TABLE_HOME");
        if (path == null) {
            path = "";
        }
        chooser = new JFileChooser(new File(path).getAbsolutePath());
        file_filter = new AtkTableFilter(FileExt, "AtkTable Files");
        chooser.addChoosableFileFilter(file_filter);
    }

    boolean openConfigFile() {
        String filename;
        TableConfig config;
        File file;
        if (chooser == null) {
            this.initChooser();
        }
        chooser.setFileFilter(file_filter);
        int retval = chooser.showOpenDialog(this);
        if (retval == 0 && (file = chooser.getSelectedFile()) != null && !file.isDirectory() && (config = this.readConfig(filename = file.getAbsolutePath(), 0)) != null) {
            this.initScalarViewer(config);
            TableScalarViewer.getMainContainer(this).pack();
            return true;
        }
        return false;
    }

    void saveConfigFile() {
        File file;
        if (chooser == null) {
            this.initChooser();
        }
        chooser.setFileFilter(file_filter);
        int retval = chooser.showSaveDialog(this);
        if (retval == 0 && (file = chooser.getSelectedFile()) != null) {
            String filename = file.toString();
            if (!filename.endsWith("." + FileExt[0])) {
                filename = filename + "." + FileExt[0];
                file = new File(filename);
            }
            if (file.exists() && JOptionPane.showConfirmDialog(this, "File " + filename + "\nAlready exists !     Overwrite it  ?", "Overwrite ?", 0) != 0) {
                return;
            }
            this.writeConfig(filename);
        }
    }

    static Window getMainContainer(Component c) {
        Container parent = c.getParent();
        while (!(parent instanceof JFrame || parent instanceof JDialog || parent instanceof JWindow)) {
            parent = parent.getParent();
        }
        return (Window)parent;
    }

    boolean newTable() {
        Window parent = TableScalarViewer.getMainContainer(this);
        TablePreference dialog = parent instanceof JFrame ? new TablePreference((JFrame)parent) : new TablePreference((JDialog)parent);
        if (dialog.showDialog() == 0) {
            int nbcol = dialog.getNbCol();
            int nbrows = dialog.getNbRows();
            String title = dialog.getProjectTitle();
            TableConfig config = new TableConfig(title, nbrows, nbcol);
            this.initScalarViewer(config);
            parent.pack();
            return true;
        }
        return false;
    }

    void atkDiagnostic() {
        ATKDiagnostic.showDiagnostic();
    }

    void showErrorHistory() {
        this.viewer.err_history.setVisible(true);
    }

    void changeRowName(int row) {
        String rowname = this.viewer.config.rownames[row];
        if ((rowname = (String)JOptionPane.showInputDialog(this, "New Row Name ?", "", 3, null, null, rowname)) != null) {
            this.viewer.updateRows(row, rowname);
        }
    }

    void changeColumnName(int col) {
        String colname = this.viewer.config.colnames[col - 1];
        if ((colname = (String)JOptionPane.showInputDialog(this, "New Column Name ?", "", 3, null, null, colname)) != null) {
            this.viewer.updateColumns(col, colname);
        }
    }

    void changeAttributeAt(int row, int col) {
        --col;
        if (this.browser == null) {
            this.browser = new DevBrowser(this);
        }
        this.browser.setPosition(row, col, this.viewer.config.rownames[row], this.viewer.config.colnames[col]);
        this.browser.setVisible(true);
    }

    void changeAttributeAt(int row, int col, String attname) {
        this.viewer.changeAttributeAt(row, col, attname);
    }

    void deleteRow(int row) {
        TableConfig config = this.viewer.config;
        if (JOptionPane.showConfirmDialog(this, "Delete row " + config.rownames[row] + "  ?", "Delete ?", 0) == 0) {
            config.deleteRow(row);
            this.initScalarViewer(config);
        }
    }

    void deleteColumn(int col) {
        TableConfig config = this.viewer.config;
        if (JOptionPane.showConfirmDialog(this, "Delete column " + config.colnames[--col] + "  ?", "Delete ?", 0) == 0) {
            config.deleteColumn(col);
            this.initScalarViewer(config);
        }
    }

    void addRow() {
        TableConfig config = this.viewer.config;
        config.addRow();
        this.initScalarViewer(config);
    }

    void addColumn() {
        TableConfig config = this.viewer.config;
        config.addColumn();
        this.initScalarViewer(config);
    }

    public void setColWidth(int title_width, int[] col_width) {
        this.viewer.config.setColWidth(title_width, col_width);
        this.viewer.setColWidth(title_width, col_width);
    }

    public void setColWidth(int[] column_width) {
        int title_width = column_width[0];
        int[] col_width = new int[column_width.length - 1];
        System.arraycopy(column_width, 1, col_width, 0, column_width.length - 1);
        this.setColWidth(title_width, col_width);
    }

    public void setTableFont(Font font) {
        this.viewer.setTableFont(font);
    }

    public void stopTrend() {
        if (trend != null) {
            atkmoni.setVisible(false);
            atkmoni.dispose();
            if (trend.getModel() != null) {
                trend.getModel().stopRefresher();
            }
            trend = null;
            atkmoni = null;
        }
    }

    public void showTrend() {
        if (atkmoni == null) {
            Splash splash = new Splash();
            splash.setTitle("Trend");
            splash.setMessage("Starting....");
            splash.setVisible(true);
            atkmoni = new JDialog((Frame)new JFrame(), false);
            atkmoni.addWindowListener(new WindowAdapter(){

                @Override
                public void windowClosing(WindowEvent evt) {
                    atkmoni.setVisible(false);
                    atkmoni.dispose();
                }
            });
            JButton dismissBtn = new JButton("Dismiss");
            dismissBtn.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    atkmoni.setVisible(false);
                    atkmoni.dispose();
                }
            });
            JPanel panel = new JPanel();
            panel.add(dismissBtn);
            atkmoni.getContentPane().add((Component)panel, "South");
            atkmoni.setTitle("Attributes monitoring");
            trend = new Trend();
            for (int i = 0; i < this.viewer.config.size(); ++i) {
                TableConfig.Attribute att = this.viewer.config.attributeAt(i);
                if (att == null || att.name == null) continue;
                splash.progress(100 * i / this.viewer.config.size());
                splash.setMessage("Adding " + att.name);
                try {
                    trend.addAttribute(att.name);
                    continue;
                }
                catch (ClassCastException e) {
                    System.out.println("Attribute " + att.name + "\n" + e + "  Not Supported !");
                }
            }
            atkmoni.getContentPane().add((Component)trend, "Center");
            atkmoni.setSize(768, 512);
            splash.progress(100);
            splash.setVisible(false);
        }
        atkmoni.setVisible(true);
    }

    static {
        FileExt = new String[]{"atp"};
        atkmoni = null;
        trend = null;
    }

    public class AtkTableFilter
    extends FileFilter {
        private Hashtable filters = new Hashtable();
        private String description = null;
        private String fullDescription = null;
        private boolean useExtensionsInDescription = true;

        public AtkTableFilter() {
        }

        public AtkTableFilter(String extension) {
            this(extension, null);
        }

        public AtkTableFilter(String extension, String description) {
            this();
            if (extension != null) {
                this.addExtension(extension);
            }
            if (description != null) {
                this.setDescription(description);
            }
        }

        public AtkTableFilter(String[] filters) {
            this(filters, null);
        }

        public AtkTableFilter(String[] filters, String description) {
            this();
            for (int i = 0; i < filters.length; ++i) {
                this.addExtension(filters[i]);
            }
            if (description != null) {
                this.setDescription(description);
            }
        }

        @Override
        public boolean accept(File f) {
            if (f != null) {
                if (f.isDirectory()) {
                    return true;
                }
                String extension = this.getExtension(f);
                if (extension != null && this.filters.get(this.getExtension(f)) != null) {
                    return true;
                }
            }
            return false;
        }

        public String getExtension(File f) {
            if (f != null) {
                String filename = f.getName();
                return this.getExtension(filename);
            }
            return null;
        }

        public String getExtension(String filename) {
            int i;
            if (filename != null && (i = filename.lastIndexOf(46)) > 0 && i < filename.length() - 1) {
                return filename.substring(i + 1).toLowerCase();
            }
            return null;
        }

        public void addExtension(String extension) {
            if (this.filters == null) {
                this.filters = new Hashtable(5);
            }
            this.filters.put(extension.toLowerCase(), this);
            this.fullDescription = null;
        }

        @Override
        public String getDescription() {
            if (this.fullDescription == null) {
                if (this.description == null || this.isExtensionListInDescription()) {
                    this.fullDescription = this.description == null ? "(" : this.description + " (";
                    Enumeration extensions = this.filters.keys();
                    if (extensions != null) {
                        this.fullDescription = this.fullDescription + "." + extensions.nextElement();
                        while (extensions.hasMoreElements()) {
                            this.fullDescription = this.fullDescription + ", " + extensions.nextElement();
                        }
                    }
                    this.fullDescription = this.fullDescription + ")";
                } else {
                    this.fullDescription = this.description;
                }
            }
            return this.fullDescription;
        }

        public void setDescription(String description) {
            this.description = description;
            this.fullDescription = null;
        }

        public void setExtensionListInDescription(boolean b) {
            this.useExtensionsInDescription = b;
            this.fullDescription = null;
        }

        public boolean isExtensionListInDescription() {
            return this.useExtensionsInDescription;
        }
    }
}

