/*
 * Decompiled with CFR 0.152.
 */
package fr.esrf.tangoatk.core.attribute;

import fr.esrf.Tango.DevFailed;
import fr.esrf.TangoApi.DeviceAttribute;
import fr.esrf.tangoatk.core.attribute.AAttribute;
import fr.esrf.tangoatk.core.attribute.ANumberImageHelper;
import fr.esrf.tangoatk.core.attribute.NumberAttributeHelper;

class UShortImageHelper
extends ANumberImageHelper {
    public UShortImageHelper(AAttribute aAttribute) {
        this.init(aAttribute);
    }

    @Override
    protected void insert(double[][] dArray) {
        double d = 1.0;
        DeviceAttribute deviceAttribute = this.attribute.getAttribute();
        d = this.attribute.getDisplayUnitFactor();
        double[] dArray2 = NumberAttributeHelper.flatten(dArray);
        int[] nArray = new int[dArray2.length];
        for (int i = 0; i < nArray.length; ++i) {
            nArray[i] = (int)(dArray2[i] / d);
        }
        deviceAttribute.insert_us(nArray, dArray[0].length, dArray.length);
    }

    @Override
    void setMinAlarm(double d) {
        this.setProperty("min_alarm", new Short((short)d));
    }

    @Override
    void setMaxAlarm(double d) {
        this.setProperty("max_alarm", new Short((short)d));
    }

    @Override
    void setMinValue(double d) {
        this.setProperty("min_value", new Short((short)d));
    }

    @Override
    void setMaxValue(double d) {
        this.setProperty("max_value", new Short((short)d));
    }

    @Override
    void setMinWarning(double d) {
        this.setProperty("min_warning", new Short((short)d));
    }

    @Override
    void setMaxWarning(double d) {
        this.setProperty("max_warning", new Short((short)d));
    }

    @Override
    void setDeltaT(double d) {
        this.setProperty("delta_t", new Short((short)d));
    }

    @Override
    void setDeltaVal(double d) {
        this.setProperty("delta_val", new Short((short)d));
    }

    @Override
    void setMinWarning(double d, boolean bl) {
        this.setProperty("min_warning", new Short((short)d), bl);
    }

    @Override
    void setMaxWarning(double d, boolean bl) {
        this.setProperty("max_warning", new Short((short)d), bl);
    }

    @Override
    void setDeltaT(double d, boolean bl) {
        this.setProperty("delta_t", new Short((short)d), bl);
    }

    @Override
    void setDeltaVal(double d, boolean bl) {
        this.setProperty("delta_val", new Short((short)d), bl);
    }

    @Override
    void setMinAlarm(double d, boolean bl) {
        this.setProperty("min_alarm", new Short((short)d), bl);
    }

    @Override
    void setMaxAlarm(double d, boolean bl) {
        this.setProperty("max_alarm", new Short((short)d), bl);
    }

    @Override
    void setMinValue(double d, boolean bl) {
        this.setProperty("min_value", new Short((short)d), bl);
    }

    @Override
    void setMaxValue(double d, boolean bl) {
        this.setProperty("max_value", new Short((short)d), bl);
    }

    @Override
    double[][] getNumberImageValue(DeviceAttribute deviceAttribute) throws DevFailed {
        int n = deviceAttribute.getDimY();
        int n2 = deviceAttribute.getDimX();
        if (n != this.retval.length || n2 != this.retval[0].length) {
            this.retval = new double[n][n2];
        }
        int[] nArray = deviceAttribute.extractUShortArray();
        int n3 = 0;
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n2; ++j) {
                this.retval[i][j] = nArray[n3++];
            }
        }
        return this.retval;
    }

    @Override
    double[][] getNumberImageDisplayValue(DeviceAttribute deviceAttribute) throws DevFailed {
        int[] nArray = deviceAttribute.extractUShortArray();
        double d = this.attribute.getDisplayUnitFactor();
        int n = deviceAttribute.getDimY();
        int n2 = deviceAttribute.getDimX();
        if (n != this.retval.length || n2 != this.retval[0].length) {
            this.retval = new double[n][n2];
        }
        int n3 = 0;
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n2; ++j) {
                this.retval[i][j] = (double)nArray[n3++] * d;
            }
        }
        return this.retval;
    }

    @Override
    String[][] getImageValueAsString(DeviceAttribute deviceAttribute) throws DevFailed {
        int[] nArray = deviceAttribute.extractUShortArray();
        int n = deviceAttribute.getDimY();
        int n2 = deviceAttribute.getDimX();
        String[][] stringArray = new String[n][n2];
        int n3 = 0;
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n2; ++j) {
                stringArray[i][j] = Integer.toString(nArray[n3++]);
            }
        }
        return stringArray;
    }

    @Override
    public String getVersion() {
        return "$Id: UShortImageHelper.java 15105 2010-09-24 13:11:54Z poncet $";
    }
}

