/*
 * Decompiled with CFR 0.152.
 */
package fr.esrf.tangoatk.core.attribute;

import fr.esrf.Tango.AttrQuality;
import fr.esrf.Tango.DevFailed;
import fr.esrf.TangoApi.DeviceAttribute;
import fr.esrf.TangoApi.DeviceDataHistory;
import fr.esrf.tangoatk.core.IAttributeSpectrumHistory;
import fr.esrf.tangoatk.core.INumberSpectrumHistory;
import fr.esrf.tangoatk.core.attribute.AAttribute;
import fr.esrf.tangoatk.core.attribute.ANumberSpectrumHelper;
import fr.esrf.tangoatk.core.attribute.NumberSpectrumHistory;

public class LongSpectrumHelper
extends ANumberSpectrumHelper {
    public LongSpectrumHelper(AAttribute aAttribute) {
        this.init(aAttribute);
    }

    @Override
    void init(AAttribute aAttribute) {
        super.init(aAttribute);
    }

    @Override
    void insert(double[] dArray) {
        double d = 1.0;
        int[] nArray = new int[dArray.length];
        d = this.attribute.getDisplayUnitFactor();
        DeviceAttribute deviceAttribute = this.attribute.getAttribute();
        for (int i = 0; i < nArray.length; ++i) {
            nArray[i] = (int)(dArray[i] / d);
        }
        deviceAttribute.insert(nArray);
    }

    protected INumberSpectrumHistory[] getNumberSpectrumAttHistory(DeviceDataHistory[] deviceDataHistoryArray) {
        INumberSpectrumHistory[] iNumberSpectrumHistoryArray = new NumberSpectrumHistory[deviceDataHistoryArray.length];
        double d = 1.0;
        if (deviceDataHistoryArray.length <= 0) {
            return null;
        }
        d = this.attribute.getDisplayUnitFactor();
        if (d <= 0.0) {
            d = 1.0;
        }
        for (int i = 0; i < deviceDataHistoryArray.length; ++i) {
            NumberSpectrumHistory numberSpectrumHistory = new NumberSpectrumHistory();
            try {
                numberSpectrumHistory.setTimestamp(deviceDataHistoryArray[i].getTime());
            }
            catch (Exception exception) {
                numberSpectrumHistory.setTimestamp(0L);
            }
            try {
                AttrQuality attrQuality = deviceDataHistoryArray[i].getAttrQuality();
                if (0 == attrQuality.value()) {
                    numberSpectrumHistory.setState("VALID");
                } else if (1 == attrQuality.value()) {
                    numberSpectrumHistory.setState("INVALID");
                } else if (2 == attrQuality.value()) {
                    numberSpectrumHistory.setState("ALARM");
                } else if (4 == attrQuality.value()) {
                    numberSpectrumHistory.setState("WARNING");
                } else if (3 == attrQuality.value()) {
                    numberSpectrumHistory.setState("CHANGING");
                } else {
                    numberSpectrumHistory.setState("UNKNOWN");
                }
            }
            catch (Exception exception) {
                numberSpectrumHistory.setState("UNKNOWN");
            }
            try {
                int[] nArray = deviceDataHistoryArray[i].extractLongArray();
                double[] dArray = new double[nArray.length];
                for (int j = 0; j < nArray.length; ++j) {
                    dArray[j] = (double)nArray[j] * d;
                }
                numberSpectrumHistory.setValue(dArray);
            }
            catch (Exception exception) {
                numberSpectrumHistory.setValue(new double[0]);
            }
            iNumberSpectrumHistoryArray[i] = numberSpectrumHistory;
        }
        return iNumberSpectrumHistoryArray;
    }

    protected INumberSpectrumHistory[] getNumberSpectrumDeviceAttHistory(DeviceDataHistory[] deviceDataHistoryArray) {
        INumberSpectrumHistory[] iNumberSpectrumHistoryArray = new NumberSpectrumHistory[deviceDataHistoryArray.length];
        if (deviceDataHistoryArray.length <= 0) {
            return null;
        }
        for (int i = 0; i < deviceDataHistoryArray.length; ++i) {
            NumberSpectrumHistory numberSpectrumHistory = new NumberSpectrumHistory();
            try {
                numberSpectrumHistory.setTimestamp(deviceDataHistoryArray[i].getTime());
            }
            catch (Exception exception) {
                numberSpectrumHistory.setTimestamp(0L);
            }
            try {
                AttrQuality attrQuality = deviceDataHistoryArray[i].getAttrQuality();
                if (0 == attrQuality.value()) {
                    numberSpectrumHistory.setState("VALID");
                } else if (1 == attrQuality.value()) {
                    numberSpectrumHistory.setState("INVALID");
                } else if (2 == attrQuality.value()) {
                    numberSpectrumHistory.setState("ALARM");
                } else if (4 == attrQuality.value()) {
                    numberSpectrumHistory.setState("WARNING");
                } else if (3 == attrQuality.value()) {
                    numberSpectrumHistory.setState("CHANGING");
                } else {
                    numberSpectrumHistory.setState("UNKNOWN");
                }
            }
            catch (Exception exception) {
                numberSpectrumHistory.setState("UNKNOWN");
            }
            try {
                int[] nArray = deviceDataHistoryArray[i].extractLongArray();
                double[] dArray = new double[nArray.length];
                for (int j = 0; j < nArray.length; ++j) {
                    dArray[j] = nArray[j];
                }
                numberSpectrumHistory.setValue(dArray);
            }
            catch (Exception exception) {
                numberSpectrumHistory.setValue(new double[0]);
            }
            iNumberSpectrumHistoryArray[i] = numberSpectrumHistory;
        }
        return iNumberSpectrumHistoryArray;
    }

    @Override
    protected IAttributeSpectrumHistory[] getSpectrumDeviceAttHistory(DeviceDataHistory[] deviceDataHistoryArray) {
        return this.getNumberSpectrumDeviceAttHistory(deviceDataHistoryArray);
    }

    @Override
    protected IAttributeSpectrumHistory[] getSpectrumAttHistory(DeviceDataHistory[] deviceDataHistoryArray) {
        return this.getNumberSpectrumAttHistory(deviceDataHistoryArray);
    }

    @Override
    void setMinAlarm(double d) {
        this.setProperty("min_alarm", new Long((long)d));
    }

    @Override
    void setMaxAlarm(double d) {
        this.setProperty("max_alarm", new Long((long)d));
    }

    @Override
    void setMinValue(double d) {
        this.setProperty("min_value", new Long((long)d));
    }

    @Override
    void setMaxValue(double d) {
        this.setProperty("max_value", new Long((long)d));
    }

    @Override
    void setMinWarning(double d) {
        this.setProperty("min_warning", new Long((long)d));
    }

    @Override
    void setMaxWarning(double d) {
        this.setProperty("max_warning", new Long((long)d));
    }

    @Override
    void setDeltaT(double d) {
        this.setProperty("delta_t", new Long((long)d));
    }

    @Override
    void setDeltaVal(double d) {
        this.setProperty("delta_val", new Long((long)d));
    }

    @Override
    void setMinWarning(double d, boolean bl) {
        this.setProperty("min_warning", new Long((long)d), bl);
    }

    @Override
    void setMaxWarning(double d, boolean bl) {
        this.setProperty("max_warning", new Long((long)d), bl);
    }

    @Override
    void setDeltaT(double d, boolean bl) {
        this.setProperty("delta_t", new Long((long)d), bl);
    }

    @Override
    void setDeltaVal(double d, boolean bl) {
        this.setProperty("delta_val", new Long((long)d), bl);
    }

    @Override
    void setMinAlarm(double d, boolean bl) {
        this.setProperty("min_alarm", new Long((long)d), bl);
    }

    @Override
    void setMaxAlarm(double d, boolean bl) {
        this.setProperty("max_alarm", new Long((long)d), bl);
    }

    @Override
    void setMinValue(double d, boolean bl) {
        this.setProperty("min_value", new Long((long)d), bl);
    }

    @Override
    void setMaxValue(double d, boolean bl) {
        this.setProperty("max_value", new Long((long)d), bl);
    }

    @Override
    double[] getNumberSpectrumValue(DeviceAttribute deviceAttribute) throws DevFailed {
        int[] nArray = deviceAttribute.extractLongArray();
        int n = deviceAttribute.getNbRead();
        double[] dArray = new double[n];
        for (int i = 0; i < n; ++i) {
            dArray[i] = nArray[i];
        }
        return dArray;
    }

    @Override
    double[] getNumberSpectrumSetPoint(DeviceAttribute deviceAttribute) throws DevFailed {
        int n;
        int[] nArray = deviceAttribute.extractLongArray();
        int n2 = nArray.length - (n = deviceAttribute.getNbRead());
        if (n2 <= 0) {
            return this.getNumberSpectrumValue(deviceAttribute);
        }
        double[] dArray = new double[n2];
        int n3 = 0;
        for (int i = n; i < nArray.length; ++i) {
            dArray[n3] = nArray[i];
            ++n3;
        }
        return dArray;
    }

    @Override
    double[] getNumberSpectrumDisplayValue(DeviceAttribute deviceAttribute) throws DevFailed {
        int[] nArray = deviceAttribute.extractLongArray();
        double d = this.attribute.getDisplayUnitFactor();
        int n = deviceAttribute.getNbRead();
        double[] dArray = new double[n];
        for (int i = 0; i < n; ++i) {
            dArray[i] = (double)nArray[i] * d;
        }
        return dArray;
    }

    @Override
    double[] getNumberSpectrumDisplaySetPoint(DeviceAttribute deviceAttribute) throws DevFailed {
        int[] nArray = deviceAttribute.extractLongArray();
        double d = this.attribute.getDisplayUnitFactor();
        int n = deviceAttribute.getNbRead();
        int n2 = nArray.length - n;
        if (n2 <= 0) {
            return this.getNumberSpectrumDisplayValue(deviceAttribute);
        }
        double[] dArray = new double[n2];
        int n3 = 0;
        for (int i = n; i < nArray.length; ++i) {
            dArray[n3] = (double)nArray[i] * d;
            ++n3;
        }
        return dArray;
    }

    @Override
    public String getVersion() {
        return "$Id: LongSpectrumHelper.java 15105 2010-09-24 13:11:54Z poncet $";
    }
}

