/*
 * Decompiled with CFR 0.152.
 */
package fr.esrf.tangoatk.core;

import fr.esrf.Tango.DevFailed;
import fr.esrf.Tango.DevSource;
import fr.esrf.Tango.DevState;
import fr.esrf.TangoApi.AttributeInfoEx;
import fr.esrf.TangoApi.CommandInfo;
import fr.esrf.TangoApi.DbDatum;
import fr.esrf.TangoApi.DeviceAttribute;
import fr.esrf.TangoApi.DeviceData;
import fr.esrf.TangoApi.DeviceProxy;
import fr.esrf.tangoatk.core.AEntityFactory;
import fr.esrf.tangoatk.core.AtkEventListenerList;
import fr.esrf.tangoatk.core.ConnectionException;
import fr.esrf.tangoatk.core.DeviceFactory;
import fr.esrf.tangoatk.core.DeviceProperty;
import fr.esrf.tangoatk.core.EventSupport;
import fr.esrf.tangoatk.core.IDevice;
import fr.esrf.tangoatk.core.IDeviceListener;
import fr.esrf.tangoatk.core.IErrorListener;
import fr.esrf.tangoatk.core.IStateListener;
import fr.esrf.tangoatk.core.IStatusListener;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.swing.JOptionPane;

public class Device
extends DeviceProxy
implements IDevice,
Serializable {
    public static final String OPEN_CLOSE_PROP = "OpenCloseInverted";
    public static final String INSERT_EXTRACT_PROP = "InsertExtractInverted";
    private String name;
    private boolean supportsEvents;
    protected EventSupport propChanges;
    protected transient DeviceProxy proxy;
    private long refreshCount = 0L;
    private int idlVersion = 0;
    private boolean connected = true;
    protected Map<String, DeviceProperty> propertyMap;
    private boolean openCloseInverted = false;
    private boolean insertExtractInverted = false;
    protected boolean devPropertiesLoaded = false;
    private static Map<String, DevState> stringStateMap = new HashMap<String, DevState>();

    public Device(String string) throws DevFailed {
        super(string);
        this.init(string);
    }

    public Device(String string, String string2, String string3) throws DevFailed {
        super(string, string2, string3);
        this.init(string);
    }

    public Device(String string, boolean bl) throws DevFailed {
        super(string);
        long l = System.currentTimeMillis();
        if (!bl) {
            this.init(string);
        } else {
            try {
                this.init(string);
            }
            catch (DevFailed devFailed) {
                this.trace(1, "Device.get_idl_version(" + string + ") failed", l);
                this.setConnected(false);
            }
        }
    }

    protected void init(String string) throws DevFailed {
        long l = System.currentTimeMillis();
        this.propertyMap = new HashMap<String, DeviceProperty>();
        this.propChanges = new EventSupport();
        this.name = string;
        this.supportsEvents = false;
        this.openCloseInverted = false;
        this.insertExtractInverted = false;
        this.idlVersion = this.get_idl_version();
        this.trace(2, "Device.get_idl_version(" + string + ") ok", l);
        if (this.idlVersion >= 3) {
            this.supportsEvents = true;
        }
    }

    public void reconnect() {
        long l = System.currentTimeMillis();
        try {
            this.idlVersion = this.get_idl_version();
            this.setConnected(true);
            this.trace(2, "Device.reconnect get_idl_version(" + this.name + ") ok", l);
            if (this.idlVersion >= 3) {
                this.supportsEvents = true;
            }
        }
        catch (DevFailed devFailed) {
            this.trace(1, "Device.reconnect get_idl_version(" + this.name + ") failed", l);
        }
    }

    public boolean isConnected() {
        return this.connected;
    }

    private void setConnected(boolean bl) {
        this.connected = bl;
    }

    public void addErrorListener(IErrorListener iErrorListener) {
        this.propChanges.addErrorListener(iErrorListener);
    }

    public void removeErrorListener(IErrorListener iErrorListener) {
        this.propChanges.removeErrorListener(iErrorListener);
    }

    @Override
    public void addStatusListener(IStatusListener iStatusListener) {
        this.propChanges.addStatusListener(iStatusListener);
    }

    @Override
    public void removeStatusListener(IStatusListener iStatusListener) {
        this.propChanges.removeStatusListener(iStatusListener);
    }

    @Override
    public void addStateListener(IStateListener iStateListener) {
        this.propChanges.addStateListener(iStateListener);
    }

    @Override
    public void removeStateListener(IStateListener iStateListener) {
        this.propChanges.removeStateListener(iStateListener);
    }

    public void addListener(IDeviceListener iDeviceListener) {
        this.propChanges.addStateListener(iDeviceListener);
        this.propChanges.addStatusListener(iDeviceListener);
    }

    public void removeListener(IDeviceListener iDeviceListener) {
        this.propChanges.removeStateListener(iDeviceListener);
        this.propChanges.removeStatusListener(iDeviceListener);
    }

    public EventSupport getPropChanges() {
        return this.propChanges;
    }

    @Override
    public void refresh() {
        if (!this.isConnected()) {
            this.reconnect();
        }
        if (this.isConnected()) {
            ++this.refreshCount;
            DevState devState = null;
            long l = System.currentTimeMillis();
            try {
                try {
                    devState = this.state(false);
                    this.trace(64, "Device.refresh(State," + this.name + ") success", l);
                    this.propChanges.fireStateEvent(this, Device.toString(devState));
                }
                catch (DevFailed devFailed) {
                    this.trace(64, "Device.refresh(State," + this.name + ") failed", l);
                    ConnectionException connectionException = new ConnectionException(devFailed);
                    this.deviceError("Couldn't read state: ", connectionException);
                    String string = this.getName() + ":\n" + connectionException.getDescription();
                    this.propChanges.fireStateEvent(this, "UNKNOWN");
                    this.propChanges.fireStatusEvent(this, string);
                    return;
                }
                l = System.currentTimeMillis();
                try {
                    String string = this.status(false);
                    this.trace(64, "Device.refresh(Status," + this.name + ") success", l);
                    this.propChanges.fireStatusEvent(this, string);
                }
                catch (DevFailed devFailed) {
                    this.trace(64, "Device.refresh(Status," + this.name + ") failed", l);
                    ConnectionException connectionException = new ConnectionException(devFailed);
                    String string = this.getName() + ":\n" + connectionException.getDescription();
                    this.propChanges.fireStatusEvent(this, string);
                    return;
                }
            }
            catch (Exception exception) {
                System.out.println("-- Device.refresh() : Unexpected exception -----------------------");
                exception.printStackTrace();
                try {
                    ConnectionException connectionException = new ConnectionException(exception);
                    this.propChanges.fireStateEvent(this, "UNKNOWN");
                    this.propChanges.fireStatusEvent(this, "UNKNOWN");
                    this.deviceError("Couldn't read state: ", connectionException);
                }
                catch (Exception exception2) {
                    // empty catch block
                }
            }
        }
    }

    public boolean isAlive() {
        long l = System.currentTimeMillis();
        try {
            this.ping();
            this.trace(2, "Device.ping(" + this.name + ") success", l);
            return true;
        }
        catch (DevFailed devFailed) {
            this.trace(1, "Device.ping(" + this.name + ") failed", l);
            return false;
        }
    }

    public CommandInfo[] getCommandList() throws DevFailed {
        CommandInfo[] commandInfoArray;
        long l = System.currentTimeMillis();
        try {
            commandInfoArray = this.command_list_query();
            this.trace(2, "Device.command_list_query(" + this.name + ") success", l);
        }
        catch (DevFailed devFailed) {
            this.trace(1, "Device.command_list_query(" + this.name + ") failed", l);
            throw devFailed;
        }
        return commandInfoArray;
    }

    public CommandInfo getCommand(String string) throws DevFailed {
        CommandInfo commandInfo;
        long l = System.currentTimeMillis();
        try {
            commandInfo = this.command_query(string);
            this.trace(2, "Device.command_query(" + this.getName() + "/" + string + ") success", l);
        }
        catch (DevFailed devFailed) {
            this.trace(1, "Device.command_query(" + this.getName() + "/" + string + ") failed", l);
            throw devFailed;
        }
        return commandInfo;
    }

    public AttributeInfoEx[] getAttributeInfo(String[] stringArray) throws DevFailed {
        AttributeInfoEx[] attributeInfoExArray;
        long l = System.currentTimeMillis();
        try {
            attributeInfoExArray = stringArray == null ? this.get_attribute_info_ex() : this.get_attribute_info_ex(stringArray);
            this.trace(2, "Device.get_attribute_info_ex(" + stringArray + ") success", l);
        }
        catch (DevFailed devFailed) {
            this.trace(1, "Device.get_attribute_info_ex(" + stringArray + ") failed", l);
            throw devFailed;
        }
        return attributeInfoExArray;
    }

    public AttributeInfoEx getAttributeInfo(String string) throws DevFailed {
        AttributeInfoEx attributeInfoEx;
        long l = System.currentTimeMillis();
        try {
            attributeInfoEx = this.get_attribute_info_ex(AEntityFactory.extractEntityName(string));
            this.trace(2, "Device.get_attribute_config(" + this.getName() + "/" + string + ") success", l);
        }
        catch (DevFailed devFailed) {
            this.trace(1, "Device.get_attribute_info(" + this.getName() + "/" + string + ") failed", l);
            throw devFailed;
        }
        return attributeInfoEx;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getAlias() {
        try {
            String string = this.get_alias();
            return string;
        }
        catch (Exception exception) {
            return null;
        }
    }

    protected void deviceError(String string, Throwable throwable) {
        this.propChanges.fireReadErrorEvent(this, throwable);
    }

    @Override
    public String getState() {
        DevState devState = null;
        long l = System.currentTimeMillis();
        try {
            devState = this.state(false);
            this.trace(2, "Device.state(" + this.name + ") success", l);
        }
        catch (Exception exception) {
            this.trace(1, "Device.state(" + this.name + ") failed", l);
            this.deviceError("Couldn't read state: ", new ConnectionException(exception));
        }
        return Device.toString(devState);
    }

    public static String toString(DevState devState) {
        if (devState == null) {
            return "UNKNOWN";
        }
        switch (devState.value()) {
            case 0: {
                return "ON";
            }
            case 1: {
                return "OFF";
            }
            case 2: {
                return "CLOSE";
            }
            case 3: {
                return "OPEN";
            }
            case 4: {
                return "INSERT";
            }
            case 5: {
                return "EXTRACT";
            }
            case 6: {
                return "MOVING";
            }
            case 7: {
                return "STANDBY";
            }
            case 8: {
                return "FAULT";
            }
            case 9: {
                return "INIT";
            }
            case 10: {
                return "RUNNING";
            }
            case 11: {
                return "ALARM";
            }
            case 12: {
                return "DISABLE";
            }
        }
        return "UNKNOWN";
    }

    public static DevState getStateFromString(String string) {
        if (string == null) {
            return DevState.from_int((int)13);
        }
        if (stringStateMap.containsKey(string)) {
            return stringStateMap.get(string);
        }
        return DevState.from_int((int)13);
    }

    @Override
    public String getStatus() {
        String string = "UNKNOWN";
        long l = System.currentTimeMillis();
        try {
            string = this.status(false);
            this.trace(2, "Device.status(" + this.name + ") success", l);
        }
        catch (Exception exception) {
            this.trace(1, "Device.status(" + this.name + ") failed", l);
            this.deviceError("Couldn't read status: ", new ConnectionException(exception));
        }
        return string;
    }

    public final DeviceAttribute readAttribute(String string) throws DevFailed {
        DeviceAttribute deviceAttribute;
        long l = System.currentTimeMillis();
        try {
            deviceAttribute = this.read_attribute(AEntityFactory.extractEntityName(string));
            this.trace(8, "Device.read_attribute(" + this.getName() + "/" + string + ") success", l);
        }
        catch (DevFailed devFailed) {
            this.trace(8, "Device.read_attribute(" + this.getName() + "/" + string + ") failed", l);
            throw devFailed;
        }
        return deviceAttribute;
    }

    public long getRefreshCount() {
        return this.refreshCount;
    }

    @Override
    public int getIdlVersion() {
        return this.idlVersion;
    }

    public final DeviceAttribute readAttributeFromDevice(String string) throws DevFailed {
        DeviceAttribute deviceAttribute;
        long l = System.currentTimeMillis();
        this.set_source(DevSource.DEV);
        try {
            deviceAttribute = this.read_attribute(AEntityFactory.extractEntityName(string));
            this.trace(8, "Device.read_attribute_from_device(" + this.getName() + "/" + string + ") success", l);
        }
        catch (DevFailed devFailed) {
            this.trace(8, "Device.read_attribute_from_device(" + this.getName() + "/" + string + ") failed", l);
            this.set_source(DevSource.CACHE_DEV);
            throw devFailed;
        }
        this.set_source(DevSource.CACHE_DEV);
        return deviceAttribute;
    }

    public void writeAttribute(DeviceAttribute deviceAttribute) throws DevFailed {
        long l = System.currentTimeMillis();
        try {
            this.write_attribute(deviceAttribute);
            this.trace(8, "Device.write_attribute(" + this.name + ") success", l);
        }
        catch (DevFailed devFailed) {
            this.trace(8, "Device.write_attribute(" + this.name + ") failed", l);
            throw devFailed;
        }
        this.refresh();
    }

    public DeviceData executeCommand(String string, DeviceData deviceData) throws DevFailed {
        DeviceData deviceData2 = null;
        long l = System.currentTimeMillis();
        try {
            deviceData2 = this.command_inout(AEntityFactory.extractEntityName(string), deviceData);
            this.trace(16, "Device.command_inout(" + this.getName() + "/" + this.name + ") success", l);
        }
        catch (DevFailed devFailed) {
            this.trace(16, "Device.command_inout(" + this.getName() + "/" + this.name + ") failed", l);
            throw devFailed;
        }
        return deviceData2;
    }

    public void storeInfo(AttributeInfoEx attributeInfoEx) throws DevFailed {
        AttributeInfoEx[] attributeInfoExArray = new AttributeInfoEx[]{attributeInfoEx};
        long l = System.currentTimeMillis();
        try {
            this.set_attribute_info(attributeInfoExArray);
            this.trace(8, "Device.set_attribute_info(" + this.name + ") success", l);
        }
        catch (DevFailed devFailed) {
            this.trace(8, "Device.set_attribute_info(" + this.name + ") failed", l);
            throw devFailed;
        }
    }

    public String toString() {
        return this.getName();
    }

    @Override
    public boolean doesEvent() {
        return this.supportsEvents;
    }

    public String getVersion() {
        return "$Id: Device.java 15077 2010-09-14 17:22:13Z poncet $";
    }

    private void trace(int n, String string, long l) {
        DeviceFactory.getInstance().trace(n, string, l);
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        System.out.print("Storing device " + this.name + "...");
        objectOutputStream.defaultWriteObject();
        System.out.println("Done");
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        System.out.print("Loading device ");
        objectInputStream.defaultReadObject();
        System.out.print(this.name + "...");
        try {
            this.proxy = new DeviceProxy(this.name);
        }
        catch (Exception exception) {
            throw new IOException(exception.getMessage());
        }
        System.out.println("Done");
    }

    public DeviceProperty getProperty(String string) {
        if (this.propertyMap != null) {
            return this.propertyMap.get(string);
        }
        return null;
    }

    public Map getPropertyMap() {
        return this.propertyMap;
    }

    public void storeProperty(String string) {
        DeviceProperty deviceProperty = this.propertyMap.get(string);
        if (deviceProperty != null) {
            try {
                DbDatum dbDatum = this.get_property(deviceProperty.getName());
                dbDatum.insert(deviceProperty.getValue());
                this.put_property(dbDatum);
            }
            catch (DevFailed devFailed) {
                JOptionPane.showMessageDialog(null, "Could not update property " + deviceProperty.getName(), "Error", 0);
            }
        } else {
            JOptionPane.showMessageDialog(null, "Could not update property " + deviceProperty.getName() + " : \nThis property is not registered", "Error", 0);
        }
    }

    public void refreshPropertyMap() {
        String[] stringArray = null;
        DbDatum[] dbDatumArray = new DbDatum[]{};
        try {
            stringArray = this.get_property_list("*");
            if (stringArray != null && stringArray.length > 0 && (dbDatumArray = this.get_property(stringArray)) == null) {
                dbDatumArray = new DbDatum[]{};
            }
            HashSet<String> hashSet = new HashSet<String>();
            for (int i = 0; i < dbDatumArray.length; ++i) {
                hashSet.add(dbDatumArray[i].name);
                Object object = this.propertyMap.get(dbDatumArray[i].name);
                if (object == null) {
                    object = new DeviceProperty(this, dbDatumArray[i].name, dbDatumArray[i].extractStringArray());
                    this.propertyMap.put(dbDatumArray[i].name, (DeviceProperty)object);
                    continue;
                }
                ((DeviceProperty)object).setValue(dbDatumArray[i].extractStringArray());
            }
            Set<String> set = this.propertyMap.keySet();
            if (set != null) {
                for (String string : set) {
                    if (hashSet.contains(string)) continue;
                    this.propertyMap.remove(string);
                }
            }
        }
        catch (DevFailed devFailed) {
            JOptionPane.showMessageDialog(null, "Failed to update property map", "Error", 0);
        }
    }

    public int getDevTimeout() throws ConnectionException {
        long l = System.currentTimeMillis();
        try {
            int n = this.get_timeout_millis();
            this.trace(2, "Device.getDevTimeout(" + this.name + ") success", l);
            return n;
        }
        catch (DevFailed devFailed) {
            this.trace(1, "Device.getDevTimeout(" + this.name + ") failed", l);
            ConnectionException connectionException = new ConnectionException(devFailed);
            this.deviceError("Couldn't read timeout value : ", connectionException);
            throw connectionException;
        }
        catch (Exception exception) {
            this.trace(1, "Device.getDevTimeout(" + this.name + ") failed", l);
            ConnectionException connectionException = new ConnectionException(exception);
            this.deviceError("Couldn't read timeout value : ", connectionException);
            throw connectionException;
        }
    }

    public synchronized void setDevTimeout(int n) throws ConnectionException {
        long l = System.currentTimeMillis();
        try {
            this.set_timeout_millis(n);
            this.trace(2, "Device.setDevTimeout(" + this.name + ") success", l);
        }
        catch (DevFailed devFailed) {
            this.trace(1, "Device.setDevTimeout(" + this.name + ") failed", l);
            ConnectionException connectionException = new ConnectionException(devFailed);
            this.deviceError("Couldn't set timeout value : ", connectionException);
            throw connectionException;
        }
        catch (Exception exception) {
            this.trace(1, "Device.setDevTimeout(" + this.name + ") failed", l);
            ConnectionException connectionException = new ConnectionException(exception);
            this.deviceError("Couldn't set timeout value : ", connectionException);
            throw connectionException;
        }
    }

    @Override
    public AtkEventListenerList getListenerList() {
        if (this.propChanges == null) {
            return null;
        }
        return this.propChanges.getListenerList();
    }

    @Override
    public boolean getInvertedOpenClose() {
        return this.openCloseInverted;
    }

    @Override
    public boolean getInvertedInsertExtract() {
        return this.insertExtractInverted;
    }

    void setInvertedOpenClose(boolean bl) {
        this.openCloseInverted = bl;
    }

    void setInvertedInsertExtract(boolean bl) {
        this.insertExtractInverted = bl;
    }

    public boolean areDevPropertiesLoaded() {
        return this.devPropertiesLoaded;
    }

    public void loadDevProperties() {
        long l = System.currentTimeMillis();
        String[] stringArray = new String[]{OPEN_CLOSE_PROP, INSERT_EXTRACT_PROP};
        DbDatum[] dbDatumArray = null;
        try {
            this.devPropertiesLoaded = true;
            dbDatumArray = this.get_property(stringArray);
        }
        catch (DevFailed devFailed) {
            this.trace(1, "Device.get_property(OpenCloseInverted, InsertExtractInverted) failed", l);
        }
        if (dbDatumArray == null) {
            return;
        }
        if (dbDatumArray.length != 2) {
            return;
        }
        if (!dbDatumArray[0].is_empty()) {
            this.openCloseInverted = dbDatumArray[0].extractBoolean();
        }
        if (!dbDatumArray[1].is_empty()) {
            this.insertExtractInverted = dbDatumArray[1].extractBoolean();
        }
    }

    static {
        stringStateMap.put("ON", DevState.from_int((int)0));
        stringStateMap.put("OFF", DevState.from_int((int)1));
        stringStateMap.put("CLOSE", DevState.from_int((int)2));
        stringStateMap.put("OPEN", DevState.from_int((int)3));
        stringStateMap.put("INSERT", DevState.from_int((int)4));
        stringStateMap.put("EXTRACT", DevState.from_int((int)5));
        stringStateMap.put("MOVING", DevState.from_int((int)6));
        stringStateMap.put("STANDBY", DevState.from_int((int)7));
        stringStateMap.put("FAULT", DevState.from_int((int)8));
        stringStateMap.put("INIT", DevState.from_int((int)9));
        stringStateMap.put("RUNNING", DevState.from_int((int)10));
        stringStateMap.put("ALARM", DevState.from_int((int)11));
        stringStateMap.put("DISABLE", DevState.from_int((int)12));
        stringStateMap.put("UNKNOWN", DevState.from_int((int)13));
    }
}

