/*
 * Decompiled with CFR 0.152.
 */
package admin.astor.tools;

import admin.astor.Astor;
import admin.astor.tools.WideSearchTree;
import fr.esrf.Tango.DevFailed;
import fr.esrf.TangoDs.Except;
import fr.esrf.tangoatk.widget.util.ATKGraphicsUtils;
import fr.esrf.tangoatk.widget.util.ErrorPane;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;

public class WideSearchDialog
extends JDialog {
    private JFrame parent;
    private JScrollPane scrollPane;
    private JTextArea warningTxt;
    private JTextField wildcardTxt;

    public WideSearchDialog(JFrame parent) {
        super((Frame)parent, false);
        this.parent = parent;
        this.initComponents();
        this.initOwnComponents();
        this.pack();
        ATKGraphicsUtils.centerDialog((Dialog)this);
    }

    private void initOwnComponents() {
        this.scrollPane = new JScrollPane();
        this.scrollPane.setPreferredSize(new Dimension(350, 400));
        this.getContentPane().add((Component)this.scrollPane, "Center");
        this.warningTxt.setVisible(false);
    }

    private void initComponents() {
        JPanel jPanel1 = new JPanel();
        JButton cancelBtn = new JButton();
        JPanel jPanel2 = new JPanel();
        JLabel titleLabel = new JLabel();
        this.wildcardTxt = new JTextField();
        this.warningTxt = new JTextArea();
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                WideSearchDialog.this.closeDialog(evt);
            }
        });
        cancelBtn.setText("Cancel");
        cancelBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                WideSearchDialog.this.cancelBtnActionPerformed(evt);
            }
        });
        jPanel1.add(cancelBtn);
        this.getContentPane().add((Component)jPanel1, "South");
        jPanel2.setLayout(new GridBagLayout());
        titleLabel.setFont(new Font("Lucida Sans", 1, 14));
        titleLabel.setText("Search item :   ");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        jPanel2.add((Component)titleLabel, gridBagConstraints);
        this.wildcardTxt.setColumns(20);
        this.wildcardTxt.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                WideSearchDialog.this.wildcardTxtActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        jPanel2.add((Component)this.wildcardTxt, gridBagConstraints);
        this.warningTxt.setColumns(35);
        this.warningTxt.setFont(new Font("Dialog", 1, 12));
        this.warningTxt.setRows(2);
        this.warningTxt.setText("WARNING:\n   Command missing. TANGO Database server is not up to date !");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.gridheight = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(15, 0, 15, 0);
        jPanel2.add((Component)this.warningTxt, gridBagConstraints);
        this.getContentPane().add((Component)jPanel2, "North");
        this.pack();
    }

    private void cancelBtnActionPerformed(ActionEvent evt) {
        this.doClose();
    }

    private void closeDialog(WindowEvent evt) {
        this.doClose();
    }

    private void wildcardTxtActionPerformed(ActionEvent evt) {
        try {
            String wildcard = this.wildcardTxt.getText();
            if (wildcard.length() == 0 || wildcard.equals("*")) {
                Except.throw_exception((String)"BAD_PARAM", (String)"Filter is empty !", (String)"wildcardTxt.getText()");
            }
            if (!wildcard.startsWith("*")) {
                wildcard = "*" + wildcard;
            }
            if (!wildcard.endsWith("*")) {
                wildcard = wildcard + "*";
            }
            WideSearchTree tree = new WideSearchTree(this, wildcard);
            this.scrollPane.setViewportView(tree);
        }
        catch (DevFailed e) {
            ErrorPane.showErrorMessage((Component)this.parent, null, (DevFailed)e);
        }
    }

    void displayHostPanel(String hostname) {
        if (this.parent instanceof Astor) {
            ((Astor)this.parent).tree.displayHostInfoDialog(hostname);
        }
    }

    void setWarning() {
        this.warningTxt.setVisible(true);
        this.pack();
    }

    private void doClose() {
        if (this.parent.getWidth() > 0) {
            this.setVisible(false);
            this.dispose();
        } else {
            System.exit(0);
        }
    }

    public static void main(String[] args) {
        new WideSearchDialog(new JFrame()).setVisible(true);
    }
}

