/*
 * Decompiled with CFR 0.152.
 */
package admin.astor.tools;

import admin.astor.AstorUtil;
import admin.astor.TangoHost;
import fr.esrf.Tango.DevFailed;
import fr.esrf.Tango.DevVarLongStringArray;
import fr.esrf.TangoApi.ApiUtil;
import fr.esrf.TangoApi.DbDevImportInfo;
import fr.esrf.TangoApi.DeviceData;
import fr.esrf.TangoApi.events.DbEventImportInfo;
import fr.esrf.tangoatk.widget.util.ErrorPane;
import java.awt.Component;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JFrame;

public class MySqlUtil {
    private static MySqlUtil instance = null;

    private MySqlUtil() {
    }

    public static MySqlUtil getInstance() {
        if (instance == null) {
            instance = new MySqlUtil();
        }
        return instance;
    }

    public MySqlData executeMySqlSelect(String command) throws DevFailed {
        DeviceData argIn = new DeviceData();
        argIn.insert(command);
        DeviceData argout = ApiUtil.get_db_obj().command_inout("DbMySqlSelect", argIn);
        return new MySqlData(argout.extractLongStringArray());
    }

    public DbEventImportInfo[] getMultipleEventImportInfo(String deviceName) throws DevFailed {
        String table = "event";
        String[] fields = new String[]{"name", "host", "exported", "ior"};
        String cmd = "";
        for (int i = 0; i < fields.length; ++i) {
            cmd = cmd + fields[i];
            if (i >= fields.length - 1) continue;
            cmd = cmd + ",";
        }
        cmd = cmd + " FROM " + table;
        cmd = cmd + " WHERE name LIKE \"" + deviceName + "\"";
        MySqlData result = this.executeMySqlSelect(cmd);
        DbEventImportInfo[] info = new DbEventImportInfo[result.size()];
        int idx = 0;
        for (MySqlRow row : result) {
            if (row.hasNull()) continue;
            info[idx++] = new DbEventImportInfo(((String)row.get(0)).toLowerCase(), (String)row.get(1), ((String)row.get(2)).equals("1"), (String)row.get(3));
        }
        return info;
    }

    public DbDevImportInfo[] getHostDevImportInfo(String deviceName) throws DevFailed {
        String table = "device";
        String[] fields = new String[]{"name", "exported", "version", "ior", "server", "host", "class"};
        String cmd = "";
        for (int i = 0; i < fields.length; ++i) {
            cmd = cmd + fields[i];
            if (i >= fields.length - 1) continue;
            cmd = cmd + ",";
        }
        cmd = cmd + " FROM " + table;
        cmd = cmd + " WHERE name LIKE \"" + deviceName + "\" ORDER BY name";
        MySqlData result = this.executeMySqlSelect(cmd);
        DbDevImportInfo[] info = new DbDevImportInfo[result.size()];
        int idx = 0;
        for (MySqlRow row : result) {
            if (row.hasNull()) continue;
            info[idx++] = new DbDevImportInfo(((String)row.get(0)).toLowerCase(), ((String)row.get(1)).equals("1"), (String)row.get(2), (String)row.get(3), (String)row.get(4), (String)row.get(5), (String)row.get(6));
        }
        return info;
    }

    public List<String[]> getHostProperty(String deviceName, String propertyName) throws DevFailed {
        String table = "property_device";
        String[] fields = new String[]{"device", "value"};
        String cmd = "";
        for (int i = 0; i < fields.length; ++i) {
            cmd = cmd + fields[i];
            if (i >= fields.length - 1) continue;
            cmd = cmd + ",";
        }
        cmd = cmd + " FROM " + table;
        cmd = cmd + " WHERE device LIKE \"" + deviceName + "\"";
        cmd = cmd + " And name = \"" + propertyName + "\"";
        MySqlData result = this.executeMySqlSelect(cmd);
        ArrayList<String[]> lines = new ArrayList<String[]>();
        for (MySqlRow row : result) {
            if (row.hasNull()) continue;
            lines.add(new String[]{(String)row.get(0), (String)row.get(1)});
        }
        return lines;
    }

    public void manageTangoHostProperties(TangoHost[] hosts) {
        try {
            String starters = AstorUtil.getStarterDeviceHeader() + "%";
            MySqlUtil mysql = MySqlUtil.getInstance();
            List<String[]> collections = mysql.getHostProperty(starters, "HostCollection");
            List<String[]> host_usage = mysql.getHostProperty(starters, "HostUsage");
            List<String[]> use_evt = mysql.getHostProperty(starters, "UseEvents");
            for (TangoHost host : hosts) {
                String devname = host.get_name();
                for (String[] collection : collections) {
                    if (!devname.equals(collection[0])) continue;
                    host.collection = collection[1];
                }
                for (String[] usage : host_usage) {
                    if (!devname.equals(usage[0])) continue;
                    host.usage = usage[1];
                }
                for (String[] use : use_evt) {
                    if (!devname.equals(use[0])) continue;
                    host.manageNotifd = use[1].equals("true") || use[1].equals("1");
                }
            }
        }
        catch (DevFailed e) {
            ErrorPane.showErrorMessage((Component)new JFrame(), null, (DevFailed)e);
        }
    }

    private class MySqlData
    extends ArrayList<MySqlRow> {
        private MySqlData(DevVarLongStringArray lsa) {
            int nbRows = lsa.lvalue[lsa.lvalue.length - 2];
            int nbFields = lsa.lvalue[lsa.lvalue.length - 1];
            int idx = 0;
            for (int i = 0; i < nbRows; ++i) {
                ArrayList<String> row = new ArrayList<String>();
                int j = 0;
                while (j < nbFields) {
                    if (lsa.lvalue[idx] != 0) {
                        row.add(lsa.svalue[idx]);
                    } else {
                        row.add(null);
                    }
                    ++j;
                    ++idx;
                }
                this.add(new MySqlRow(row));
            }
        }
    }

    private class MySqlRow
    extends ArrayList<String> {
        private MySqlRow(List<String> vs) {
            for (String s : vs) {
                this.add(s);
            }
        }

        private boolean hasNull() {
            for (String s : this) {
                if (s != null) continue;
                return true;
            }
            return false;
        }
    }
}

