/*
 * Decompiled with CFR 0.152.
 */
package admin.astor.tools;

import admin.astor.Astor;
import admin.astor.AstorDefs;
import admin.astor.AstorUtil;
import admin.astor.RemoteLoginThread;
import admin.astor.TangoServer;
import admin.astor.tools.DeviceHierarchyDialog;
import admin.astor.tools.Utils;
import fr.esrf.Tango.DevFailed;
import fr.esrf.TangoApi.ApiUtil;
import fr.esrf.TangoApi.DbDatum;
import fr.esrf.TangoApi.DeviceInfo;
import fr.esrf.TangoApi.DeviceProxy;
import fr.esrf.TangoDs.Except;
import fr.esrf.tangoatk.widget.util.ErrorPane;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.StringTokenizer;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JTree;
import javax.swing.ToolTipManager;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeExpansionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public class DeviceHierarchy
extends JTree
implements AstorDefs {
    private static ImageIcon root_icon;
    private Astor astor = null;
    private boolean running = true;
    private ArrayList<Device> devices = null;
    private String rootname = null;
    private DefaultMutableTreeNode root;
    private DeviceHierarchyPopupMenu menu;
    private DeviceHierarchyDialog parent;
    private static final Color background;
    private static final String SUB_DEV_PROP_NAME = "__SubDevices";
    private static final boolean CHECK_SUB = true;
    private static int maxDevices;
    private static final int UPDATE = 0;
    private static final int TEST_DEVICE = 1;
    private static final int HOST_PANEL = 2;
    private static final int REM_LOGIN = 3;
    private static final int OFFSET = 2;
    private static String[] menuLabels;
    private boolean refresh = false;

    public DeviceHierarchy(DeviceHierarchyDialog parent, Astor astor, String name) throws DevFailed {
        this.parent = parent;
        this.astor = astor;
        this.setBackground(background);
        try {
            DbDatum datum = ApiUtil.get_db_obj().get_property("Astor", "DeviceDependenciesMaxDevices");
            if (!datum.is_empty()) {
                maxDevices = datum.extractLong();
            }
        }
        catch (DevFailed e) {
            System.err.println(e.errors[0].desc);
        }
        this.initNames(name);
        this.buildTree();
        this.menu = new DeviceHierarchyPopupMenu(this);
        this.expandChildren(this.root);
        this.setSelectionPath(null);
    }

    private void initNames(String name) throws DevFailed {
        StringTokenizer stk = new StringTokenizer(name, "/");
        ArrayList<String> v = new ArrayList<String>();
        while (stk.hasMoreTokens()) {
            v.add(stk.nextToken());
        }
        String[] deviceNames = new String[]{};
        switch (v.size()) {
            case 2: {
                this.rootname = (String)v.get(0) + "/" + (String)v.get(1);
                String admin = "dserver/" + this.rootname;
                String[] tmp = new TangoServer(admin).queryDeviceFromDb();
                deviceNames = new String[tmp.length + 1];
                System.arraycopy(tmp, 0, deviceNames, 0, tmp.length);
                deviceNames[tmp.length] = admin;
                break;
            }
            case 3: {
                this.rootname = "Device";
                deviceNames = new String[]{(String)v.get(0) + "/" + (String)v.get(1) + "/" + (String)v.get(2)};
                break;
            }
            default: {
                Except.throw_exception((String)"BAD_PARAMETER", (String)"Bad device or server name", (String)"DeviceHierarchy.initNames()");
            }
        }
        this.devices = new ArrayList();
        for (String deviceName : deviceNames) {
            this.devices.add(new Device(null, deviceName, true));
        }
        this.checkToRemoveMultipleDevices();
        new Refresher().start();
    }

    private void checkToRemoveMultipleDevices() {
        ArrayList<Device> deviceListToRemove = new ArrayList<Device>();
        for (int i = 0; i < this.devices.size(); ++i) {
            String rootName = this.devices.get((int)i).name;
            boolean found = false;
            block1: for (int j = 0; !found && j < this.devices.size(); ++j) {
                AstorUtil.increaseSplashProgress(5, "checking if multiple devices for " + rootName);
                if (j == i) continue;
                for (Device sudDevice : this.devices.get(j)) {
                    if (!rootName.equals(sudDevice.name)) continue;
                    deviceListToRemove.add(this.devices.get(i));
                    found = true;
                    continue block1;
                }
            }
        }
        for (Device device : deviceListToRemove) {
            this.devices.remove(device);
        }
    }

    private void buildTree() {
        this.root = new DefaultMutableTreeNode(this.rootname);
        this.createDeviceNodes();
        this.getSelectionModel().setSelectionMode(1);
        DefaultTreeModel treeModel = new DefaultTreeModel(this.root);
        this.setModel(treeModel);
        ToolTipManager.sharedInstance().registerComponent(this);
        TangoRenderer renderer = new TangoRenderer();
        this.setCellRenderer(renderer);
        this.addTreeExpansionListener(new TreeExpansionListener(){

            @Override
            public void treeCollapsed(TreeExpansionEvent e) {
            }

            @Override
            public void treeExpanded(TreeExpansionEvent e) {
            }
        });
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                DeviceHierarchy.this.treeMouseClicked(evt);
            }
        });
    }

    private void treeMouseClicked(MouseEvent evt) {
        TreePath selectedPath = this.getPathForLocation(evt.getX(), evt.getY());
        if (selectedPath == null) {
            return;
        }
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)selectedPath.getPathComponent(selectedPath.getPathCount() - 1);
        Object o = node.getUserObject();
        int mask = evt.getModifiers();
        if (evt.getClickCount() != 2 || (mask & 0x10) == 0) {
            if ((mask & 0x10) != 0) {
                this.deviceInfo();
            } else if ((mask & 4) != 0) {
                if (node == this.root) {
                    this.menu.showMenu(evt, (String)o);
                } else if (o instanceof Device) {
                    this.menu.showMenu(evt, (Device)o);
                }
            }
        }
    }

    private void createDeviceNodes(DefaultMutableTreeNode parent_node, Device device) {
        DefaultMutableTreeNode node = new DefaultMutableTreeNode(device);
        parent_node.add(node);
        for (int i = 0; i < device.size(); ++i) {
            this.createDeviceNodes(node, device.getDevice(i));
        }
    }

    private void createDeviceNodes() {
        for (Device device : this.devices) {
            this.createDeviceNodes(this.root, device);
        }
    }

    private DefaultMutableTreeNode getSelectedNode() {
        return (DefaultMutableTreeNode)this.getLastSelectedPathComponent();
    }

    Object getSelectedObject() {
        DefaultMutableTreeNode node = this.getSelectedNode();
        if (node == null) {
            return null;
        }
        return node.getUserObject();
    }

    private void expandChildren(DefaultMutableTreeNode node) {
        boolean level_done = false;
        for (int i = 0; i < node.getChildCount(); ++i) {
            DefaultMutableTreeNode child = (DefaultMutableTreeNode)node.getChildAt(i);
            if (child.isLeaf()) {
                if (level_done) continue;
                this.expandNode(child);
                level_done = true;
                continue;
            }
            this.expandChildren(child);
        }
    }

    private void expandNode(DefaultMutableTreeNode node) {
        ArrayList<DefaultMutableTreeNode> v = new ArrayList<DefaultMutableTreeNode>();
        v.add(node);
        while (node != this.root) {
            node = (DefaultMutableTreeNode)node.getParent();
            v.add(0, node);
        }
        Object[] tn = new DefaultMutableTreeNode[v.size()];
        for (int i = 0; i < v.size(); ++i) {
            tn[i] = (TreeNode)v.get(i);
        }
        TreePath tp = new TreePath(tn);
        this.setSelectionPath(tp);
        this.scrollPathToVisible(tp);
    }

    private void testDevice() {
        Object obj = this.getSelectedObject();
        if (obj instanceof Device) {
            AstorUtil.testDevice(this.parent, ((Device)obj).name);
        }
    }

    private void deviceInfo() {
        Object obj = this.getSelectedObject();
        if (obj instanceof Device) {
            try {
                String info = ((Device)obj).getInfo();
                this.parent.setText(info);
            }
            catch (DevFailed e) {
                this.parent.setText(Except.str_exception((Exception)((Object)e)));
            }
        }
    }

    private void remoteShell() {
        Object obj = this.getSelectedObject();
        if (obj instanceof Device) {
            try {
                String hostname = ((Device)obj).getHost();
                new RemoteLoginThread(hostname).start();
            }
            catch (DevFailed e) {
                this.parent.setText(Except.str_exception((Exception)((Object)e)));
            }
        }
    }

    private void hostPanel() {
        Object obj = this.getSelectedObject();
        if (obj instanceof Device) {
            try {
                Device device = (Device)obj;
                this.astor.tree.displayHostInfoDialog(device.getHost());
            }
            catch (DevFailed e) {
                ErrorPane.showErrorMessage((Component)this.parent, null, (DevFailed)e);
            }
        }
    }

    void stopThread() {
        this.running = false;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        for (Device dev : this.devices) {
            sb.append(dev.toFullString());
            for (int i = 0; i < dev.size(); ++i) {
                sb.append(dev.getDevice(i).toFullString());
            }
        }
        return sb.toString();
    }

    static {
        background = new Color(240, 240, 240);
        maxDevices = 32;
        menuLabels = new String[]{"Update Dependencies", "Test Device", "Host Panel", "Remote Login"};
    }

    private class Refresher
    extends Thread {
        private Refresher() {
        }

        @Override
        public void run() {
            while (DeviceHierarchy.this.running) {
                if (DeviceHierarchy.this.refresh) {
                    DeviceHierarchy.this.refresh = false;
                    DeviceHierarchy.this.repaint();
                }
                try {
                    Refresher.sleep(2000L);
                }
                catch (InterruptedException interruptedException) {}
            }
        }
    }

    private class Device
    extends ArrayList<Device> {
        String name;
        DeviceProxy proxy;
        DevFailed failed = null;
        boolean too_old = false;
        short state = 0;
        Device parent;
        int tooMuchDevices = 0;

        private Device(Device parent, String name, boolean check_sub) {
            AstorUtil.increaseSplashProgress(1, "checking for " + name);
            try {
                DbDatum datum;
                this.parent = parent;
                this.name = name;
                this.proxy = new DeviceProxy(name);
                if (check_sub && !(datum = this.proxy.get_property(DeviceHierarchy.SUB_DEV_PROP_NAME)).is_empty()) {
                    String[] dependencies = datum.extractStringArray();
                    if (dependencies.length <= maxDevices) {
                        for (String dependency : dependencies) {
                            if (parent == null) {
                                this.add(new Device(this, dependency, true));
                                continue;
                            }
                            boolean exists = parent.alreadyHave(dependency);
                            this.add(new Device(this, dependency, !exists));
                        }
                    } else {
                        this.tooMuchDevices = dependencies.length;
                    }
                }
                new StateManager().start();
            }
            catch (DevFailed e) {
                System.err.println(e.errors[0].desc);
                this.failed = e;
            }
        }

        private boolean alreadyHave(String name) {
            if (this.name.equals(name)) {
                return true;
            }
            return this.parent != null && this.parent.alreadyHave(name);
        }

        private Device getDevice(int i) {
            return (Device)this.get(i);
        }

        private String toFullString() {
            StringBuilder sb = new StringBuilder(this.name);
            sb.append('\n');
            for (int i = 0; i < this.size(); ++i) {
                Device d = this.getDevice(i);
                sb.append('\t').append(d.name).append('\n');
            }
            sb.append("------------------------------------------------");
            return sb.toString();
        }

        private String getHost() throws DevFailed {
            DeviceInfo info = this.proxy.get_info();
            return info.hostname;
        }

        private String getInfo() throws DevFailed {
            if (this.failed != null) {
                return Except.str_exception((Exception)((Object)this.failed));
            }
            StringBuilder sb = new StringBuilder();
            if (this.too_old) {
                sb.append("   WARNING:  Too Old TANGO Release \n").append("             To get dependencies !!!\n").append("\n========================================================\n");
            }
            sb.append(this.proxy.get_info().toString());
            sb.append("\n========================================================\n");
            try {
                String s = this.proxy.status();
                sb.append(s);
            }
            catch (DevFailed e) {
                sb.append(Except.str_exception((Exception)((Object)e)));
            }
            return sb.toString();
        }

        @Override
        public String toString() {
            String str = this.name;
            if (this.tooMuchDevices > 0) {
                str = str + "  (Too Much Devices " + this.tooMuchDevices + ">" + maxDevices + ")";
            }
            return str;
        }

        private class StateManager
        extends Thread {
            private StateManager() {
            }

            @Override
            public void run() {
                while (DeviceHierarchy.this.running) {
                    short previous = Device.this.state;
                    try {
                        Device.this.proxy.ping();
                        Device.this.state = (short)4;
                    }
                    catch (DevFailed e) {
                        Device.this.state = 1;
                    }
                    if (Device.this.state != previous) {
                        DeviceHierarchy.this.refresh = true;
                    }
                    try {
                        StateManager.sleep(2000L);
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
        }
    }

    private class DeviceHierarchyPopupMenu
    extends JPopupMenu {
        private JTree tree;
        private JLabel title;

        private DeviceHierarchyPopupMenu(JTree tree) {
            this.tree = tree;
            this.buildBtnPopupMenu();
        }

        private void buildBtnPopupMenu() {
            this.title = new JLabel();
            this.title.setFont(new Font("Dialog", 1, 16));
            this.add(this.title);
            this.add(new JPopupMenu.Separator());
            for (String menuLabel : menuLabels) {
                if (menuLabel == null) {
                    this.add(new JPopupMenu.Separator());
                    continue;
                }
                JMenuItem btn = new JMenuItem(menuLabel);
                btn.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent evt) {
                        DeviceHierarchyPopupMenu.this.deviceActionPerformed(evt);
                    }
                });
                this.add(btn);
            }
        }

        public void showMenu(MouseEvent evt, String name) {
            TreePath selectedPath = this.tree.getPathForLocation(evt.getX(), evt.getY());
            if (selectedPath == null) {
                return;
            }
            this.tree.setSelectionPath(selectedPath);
            this.title.setText(name);
            for (int i = 0; i < menuLabels.length; ++i) {
                this.getComponent(2 + i).setVisible(false);
            }
            this.getComponent(2).setVisible(true);
            this.show(this.tree, evt.getX(), evt.getY());
        }

        public void showMenu(MouseEvent evt, Device dev) {
            TreePath selectedPath = this.tree.getPathForLocation(evt.getX(), evt.getY());
            if (selectedPath == null) {
                return;
            }
            this.tree.setSelectionPath(selectedPath);
            DeviceHierarchy.this.deviceInfo();
            if (dev.failed == null) {
                this.title.setText(dev.toString());
                this.getComponent(2).setVisible(false);
                for (int i = 3; i < menuLabels.length; ++i) {
                    this.getComponent(2 + i).setEnabled(false);
                }
                this.getComponent(5).setEnabled(AstorUtil.osIsUnix());
                this.getComponent(4).setEnabled(DeviceHierarchy.this.astor != null);
                this.getComponent(3).setEnabled(dev.state == 4);
                if (Astor.rwMode == 2) {
                    this.getComponent(3).setVisible(false);
                }
                this.show(this.tree, evt.getX(), evt.getY());
            }
        }

        private void deviceActionPerformed(ActionEvent evt) {
            Object obj = evt.getSource();
            int cmdidx = 0;
            for (int i = 0; i < menuLabels.length; ++i) {
                if (this.getComponent(2 + i) != obj) continue;
                cmdidx = i;
            }
            switch (cmdidx) {
                case 0: {
                    DeviceHierarchy.this.parent.update();
                    break;
                }
                case 3: {
                    if (!AstorUtil.osIsUnix()) break;
                    DeviceHierarchy.this.remoteShell();
                    break;
                }
                case 2: {
                    DeviceHierarchy.this.hostPanel();
                    break;
                }
                case 1: {
                    DeviceHierarchy.this.testDevice();
                }
            }
        }
    }

    private class TangoRenderer
    extends DefaultTreeCellRenderer {
        private Font[] fonts;
        private final int TITLE = 0;
        private final int COLLEC = 1;
        private final int LEAF = 2;

        public TangoRenderer() {
            Utils utils = Utils.getInstance();
            root_icon = utils.getIcon("TangoClass.gif", 0.33);
            this.fonts = new Font[3];
            this.fonts[0] = new Font("Dialog", 1, 18);
            this.fonts[1] = new Font("Dialog", 1, 12);
            this.fonts[2] = new Font("Dialog", 0, 12);
        }

        @Override
        public Component getTreeCellRendererComponent(JTree tree, Object obj, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            super.getTreeCellRendererComponent(tree, obj, sel, expanded, leaf, row, hasFocus);
            this.setBackgroundNonSelectionColor(background);
            this.setForeground(Color.black);
            this.setBackgroundSelectionColor(Color.lightGray);
            if (row == 0) {
                this.setFont(this.fonts[0]);
                this.setIcon(root_icon);
            } else {
                DefaultMutableTreeNode node = (DefaultMutableTreeNode)obj;
                if (node.getUserObject() instanceof Device) {
                    this.setFont(this.fonts[1]);
                    Device device = (Device)node.getUserObject();
                    this.setIcon(AstorUtil.state_icons[device.state]);
                    if (device.too_old) {
                        this.setBackgroundNonSelectionColor(Color.yellow);
                    }
                }
            }
            return this;
        }
    }
}

